/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.xop.jaxws;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.soap.attachment.ContentHandlerRegistry;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.extensions.xop.jaxws.ByteArrayDataSource;

public class AttachmentMarshallerImpl
extends AttachmentMarshaller {
    private static final Logger log = Logger.getLogger(AttachmentMarshallerImpl.class);

    public String addMtomAttachment(DataHandler data, String elementNamespace, String elementLocalName) {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
        QName xmlName = new QName(elementNamespace, elementLocalName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize: [xmlName=" + xmlName + "]"));
        }
        String cid = soapMessage.getCidGenerator().generateFromName(xmlName.getLocalPart());
        AttachmentPart xopPart = soapMessage.createAttachmentPart(data);
        xopPart.addMimeHeader("Content-Id", '<' + cid + '>');
        soapMessage.addAttachmentPart(xopPart);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created attachment part " + cid + ", with content-type " + xopPart.getContentType()));
        }
        return "cid:" + cid;
    }

    public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String elementNamespace, String elementLocalName) {
        String contentType = mimeType == null ? "application/octet-stream" : mimeType;
        ByteArrayDataSource ds = new ByteArrayDataSource(data, offset, length);
        ds.setContentType(contentType);
        DataHandler dh = new DataHandler((DataSource)ds);
        return this.addMtomAttachment(dh, elementNamespace, elementLocalName);
    }

    public String addSwaRefAttachment(DataHandler dataHandler) {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
        String cid = soapMessage.getCidGenerator().generateFromCount();
        AttachmentPart swaRefPart = soapMessage.createAttachmentPart(dataHandler);
        swaRefPart.addMimeHeader("Content-Id", '<' + cid + '>');
        soapMessage.addAttachmentPart(swaRefPart);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created attachment part " + cid + ", with content-type " + swaRefPart.getContentType()));
        }
        return "cid:" + cid;
    }

    public boolean isXOPPackage() {
        return XOPContext.isXOPMessage();
    }

    static {
        ContentHandlerRegistry.register();
    }
}

