/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.recovery.ExpiryScanner;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.jts.recovery.transactions.AssumedCompleteServerTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.AssumedCompleteTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveringTransaction;
import com.arjuna.ats.jts.common.jtsPropertyManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ExpiredAssumedCompleteScanner
implements ExpiryScanner {
    private String _typeName;
    private ObjectStore _objectStore;
    private static int _expiryTime = 864000;
    private static SimpleDateFormat _timeFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");

    private ExpiredAssumedCompleteScanner() {
    }

    protected ExpiredAssumedCompleteScanner(String typeName, ObjectStore objectStore) {
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(1L, 4L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredAssumedCompleteScanner_1", new Object[]{Integer.toString(_expiryTime)});
        }
        this._objectStore = objectStore;
        this._typeName = typeName;
    }

    @Override
    public void scan() {
        Date oldestSurviving = new Date(new Date().getTime() - (long)(_expiryTime * 1000));
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredAssumedCompleteScanner_2", new Object[]{_timeFormat.format(oldestSurviving)});
        }
        try {
            InputObjectState uids = new InputObjectState();
            if (this._objectStore.allObjUids(this._typeName, uids)) {
                Uid theUid = new Uid(Uid.nullUid());
                boolean endOfUids = false;
                while (!endOfUids) {
                    Date timeLastActive;
                    theUid.unpack(uids);
                    if (theUid.equals(Uid.nullUid())) {
                        endOfUids = true;
                        continue;
                    }
                    Uid newUid = new Uid(theUid);
                    RecoveringTransaction aTransaction = null;
                    if (this._typeName == AssumedCompleteTransaction.typeName()) {
                        aTransaction = new AssumedCompleteTransaction(newUid);
                    } else if (this._typeName == AssumedCompleteServerTransaction.typeName()) {
                        aTransaction = new AssumedCompleteServerTransaction(newUid);
                    }
                    if (aTransaction == null || (timeLastActive = aTransaction.getLastActiveTime()) == null || !timeLastActive.before(oldestSurviving)) continue;
                    if (jtsLogger.loggerI18N.isInfoEnabled()) {
                        jtsLogger.loggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner_3", new Object[]{newUid});
                    }
                    this._objectStore.remove_committed(newUid, this._typeName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean toBeUsed() {
        return _expiryTime != 0;
    }

    static {
        String expiryTimeString = jtsPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.transactionStatusManagerExpiryTime");
        if (expiryTimeString != null) {
            try {
                Integer expiryTimeInteger = new Integer(expiryTimeString);
                _expiryTime = expiryTimeInteger * 60 * 60;
                if (jtsLogger.loggerI18N.isDebugEnabled()) {
                    jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredAssumedCompleteScanner_4", new Object[]{Integer.toString(_expiryTime)});
                }
            }
            catch (NumberFormatException e) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredAssumedCompleteScanner_5", new Object[]{"com.arjuna.ats.arjuna.recovery.transactionStatusManagerExpiryTime", expiryTimeString});
            }
        }
    }
}

