/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.util.ArgCheck;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.spi.graph.Name;
import org.jboss.dna.spi.graph.NamespaceRegistry;
import org.jboss.dna.spi.graph.Path;
import org.jboss.dna.spi.graph.PathFactory;
import org.jboss.dna.spi.graph.ValueFactories;
import org.jboss.dna.spi.sequencers.SequencerOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class SequencerOutputMap
implements SequencerOutput,
Iterable<Entry> {
    private static final String JCR_NAME_PROPERTY_NAME = "jcr:name";
    private final Map<Path, List<PropertyValue>> data;
    private transient boolean valuesSorted = true;
    private final ValueFactories factories;
    private final Name jcrName;

    public SequencerOutputMap(ValueFactories factories) {
        ArgCheck.isNotNull((Object)factories, (String)"factories");
        this.data = new HashMap<Path, List<PropertyValue>>();
        this.factories = factories;
        this.jcrName = (Name)this.factories.getNameFactory().create(JCR_NAME_PROPERTY_NAME);
    }

    public ValueFactories getFactories() {
        return this.factories;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.factories.getNameFactory().getNamespaceRegistry();
    }

    public void setProperty(Path nodePath, Name propertyName, Object ... values) {
        ArgCheck.isNotNull((Object)nodePath, (String)"nodePath");
        ArgCheck.isNotNull((Object)propertyName, (String)"property");
        if (this.jcrName.equals(propertyName)) {
            return;
        }
        List<PropertyValue> properties = this.data.get(nodePath);
        if (properties == null) {
            if (values == null || values.length == 0) {
                return;
            }
            properties = new ArrayList<PropertyValue>();
            this.data.put(nodePath, properties);
        }
        if (values == null || values.length == 0) {
            properties.remove(new PropertyValue(propertyName, null));
        } else {
            Object[] propValue = values.length == 1 ? values[0] : values;
            PropertyValue value = new PropertyValue(propertyName, propValue);
            properties.add(value);
            this.valuesSorted = false;
        }
    }

    public void setProperty(String nodePath, String property, Object ... values) {
        ArgCheck.isNotEmpty((String)nodePath, (String)"nodePath");
        ArgCheck.isNotEmpty((String)property, (String)"property");
        Path path = (Path)this.factories.getPathFactory().create(nodePath);
        Name propertyName = (Name)this.factories.getNameFactory().create(property);
        this.setProperty(path, propertyName, values);
    }

    public void setReference(String nodePath, String propertyName, String ... paths) {
        PathFactory pathFactory = this.factories.getPathFactory();
        Path path = (Path)pathFactory.create(nodePath);
        Name name = (Name)this.factories.getNameFactory().create(propertyName);
        Path[] values = null;
        if (paths != null && paths.length != 0) {
            values = new Path[paths.length];
            int len = paths.length;
            for (int i = 0; i != len; ++i) {
                String pathValue = paths[i];
                values[i] = pathFactory.create(pathValue);
            }
        }
        this.setProperty(path, name, values);
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    protected List<PropertyValue> removeProperties(Path nodePath) {
        return this.data.remove(nodePath);
    }

    protected List<PropertyValue> getProperties(Path nodePath) {
        return this.data.get(nodePath);
    }

    @Override
    public Iterator<Entry> iterator() {
        LinkedList<Path> paths = new LinkedList<Path>(this.data.keySet());
        Collections.sort(paths);
        this.sortValues();
        return new EntryIterator(paths.iterator());
    }

    protected void sortValues() {
        if (!this.valuesSorted) {
            for (List<PropertyValue> values : this.data.values()) {
                if (values.size() <= 1) continue;
                Collections.sort(values);
            }
            this.valuesSorted = true;
        }
    }

    public String toString() {
        return StringUtil.readableString(this.data);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntryIterator
    implements Iterator<Entry> {
        private Path last;
        private final Iterator<Path> iter;

        protected EntryIterator(Iterator<Path> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Entry next() {
            this.last = this.iter.next();
            return new Entry(this.last, SequencerOutputMap.this.getProperties(this.last));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            try {
                SequencerOutputMap.this.removeProperties(this.last);
            }
            finally {
                this.last = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public class Entry {
        private final Path path;
        private final Name primaryType;
        private final List<PropertyValue> properties;

        protected Entry(Path path, List<PropertyValue> properties) {
            assert (path != null);
            assert (properties != null);
            this.path = path;
            this.properties = properties;
            if (this.properties.size() > 0 && this.properties.get(0).getName().equals("jcr:primaryType")) {
                PropertyValue primaryTypeProperty = this.properties.remove(0);
                this.primaryType = (Name)SequencerOutputMap.this.getFactories().getNameFactory().create(primaryTypeProperty.getValue());
            } else {
                this.primaryType = null;
            }
        }

        public Path getPath() {
            return this.path;
        }

        public Name getPrimaryTypeValue() {
            return this.primaryType;
        }

        public List<PropertyValue> getPropertyValues() {
            return SequencerOutputMap.this.getProperties(this.path);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public class PropertyValue
    implements Comparable<PropertyValue> {
        private final Name name;
        private final Object value;

        protected PropertyValue(Name propertyName, Object value) {
            this.name = propertyName;
            this.value = value;
        }

        public Name getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public int compareTo(PropertyValue that) {
            if (this == that) {
                return 0;
            }
            if (this.name.equals("jcr:primaryType")) {
                return -1;
            }
            if (that.name.equals("jcr:primaryType")) {
                return 1;
            }
            return this.name.compareTo((Object)that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PropertyValue) {
                PropertyValue that = (PropertyValue)obj;
                return this.getName().equals(that.getName());
            }
            return false;
        }

        public String toString() {
            return "[" + this.name + "=" + StringUtil.readableString((Object)this.value) + "]";
        }
    }
}

