/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2009 by Red Hat Inc and/or its affiliates or by
 * third-party contributors as indicated by either @author tags or express
 * copyright attribution statements applied by the authors.  All
 * third-party contributions are distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 */
package org.hibernate.ejb.test.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import org.hibernate.ejb.test.TestCase;

/**
 * https://jira.jboss.org/jira/browse/JBPAPP-2858
 * Native queries should not be automatically paginated in getSingleResult() as it fails for some DB and or queries
 * 
 * @author Strong Liu
 */
public class NamedNativeQueryTest extends TestCase {

	@Override
	public Class[] getAnnotatedClasses() {
		return new Class[] { SpaceShip.class };
	}

	public void testNativeQuerys() {
		EntityManager em = getOrCreateEntityManager();
		em.getTransaction().begin();

		SpaceShip ship = new SpaceShip();
		ship.setModel("X-Wing");
		ship.setName("YuBlue");
		em.persist(ship);

		em.getTransaction().commit();
		em.clear();
		em.getTransaction().begin();
		Query q = em.createNamedQuery("implicitSample");

		Object obj = q.getSingleResult();
		assertNotNull(obj);
		em.getTransaction().commit();
		em.close();
	}
}
