package org.hibernate.test.perf;

import java.util.ArrayList;
import java.util.HashMap;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.junit.functional.FunctionalTestCase;
import org.hibernate.test.perf.object.A;
import org.hibernate.test.perf.object.B;
import org.hibernate.test.perf.object.C;

public class CascadingTest   extends FunctionalTestCase  {

    public CascadingTest(String string) {
		super(string);
	}

	public String[] getMappings() {
		return new String[] { "perf/CascadingTest.hbm.xml" };
	}

	/**
     * Make 5510 objects on database
     */
    public void testSaveSession() {
        Session session = openSession();
        Transaction tx = session.beginTransaction();
        long timeTotal = System.currentTimeMillis();
        for (int x = 0; x < 10; x++) {
            makeObjects(session);
        }
        session.flush();
        tx.commit();
        session.close();
        System.out.println("Total took " + ((System.currentTimeMillis() - timeTotal)) + " ms");
    }
    

    /**
     * Make 551 new objects
     * 
     * @param session
     */
    private void makeObjects(Session session) {
        A a = new A();
        a.setA(-1);
        a.setMap(new HashMap());
        for (int i = 0; i < 50; i++) {
            B b = new B();
            b.setB(i);
            b.setList(new ArrayList());
            a.getMap().put(new Integer(i), b);
            for (int j = 0; j < 10; j++) {
                C c = new C();
                c.setC(j * 1000000);
                b.getList().add(c);
            }
        }
        long time = System.currentTimeMillis();
        session.save(a);
        System.out.println("Save took " + ((System.currentTimeMillis() - time)) + " ms");
        time = System.currentTimeMillis();
    }
}
