//$Id: CustomSQLTest.java 10977 2006-12-12 23:28:04Z steve.ebersole@jboss.com $
package org.hibernate.test.legacy;

import java.sql.SQLException;

import junit.framework.Test;

import org.hibernate.HibernateException;
import org.hibernate.classic.Session;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SybaseASE15Dialect;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.junit.functional.FunctionalTestClassTestSuite;

/**
 * @author MAX
 *
 */
public class CustomSQLTest extends LegacyTestCase {

	public CustomSQLTest(String name) {
		super(name);
	}

	public String[] getMappings() {
		return new String[] { "legacy/CustomSQL.hbm.xml" };
	}

	public static Test suite() {
		return new FunctionalTestClassTestSuite( CustomSQLTest.class );
	}

	public void testInsert() throws HibernateException, SQLException {
		if ( getDialect() instanceof MySQLDialect
				|| getDialect() instanceof SybaseDialect 
				|| getDialect() instanceof SybaseASE15Dialect
				|| getDialect() instanceof DB2Dialect
				|| getDialect() instanceof SQLServerDialect)
			return;
		
		Role p = new Role();

		p.setName("Patient");

		Session s = openSession();

		s.save(p);
		s.flush();

		s.connection().commit();
		s.close();

		getSessions().evict(Role.class);
		s = openSession();

		Role p2 = (Role) s.get(Role.class, new Long(p.getId()));
		assertNotSame(p, p2);
		assertEquals(p2.getId(),p.getId());
		assertTrue(p2.getName().equalsIgnoreCase(p.getName()));
		s.delete(p2);
		s.flush();


		s.connection().commit();
		s.close();


	}

	public void testJoinedSubclass() throws HibernateException, SQLException {
		Medication m = new Medication();

		m.setPrescribedDrug(new Drug());

		m.getPrescribedDrug().setName("Morphine");


		Session s = openSession();

		s.save(m.getPrescribedDrug());
		s.save(m);

		s.flush();
		s.connection().commit();
		s.close();
		s = openSession();

		Medication m2  = (Medication) s.get(Medication.class, m.getId());
		assertNotSame(m, m2);

		s.flush();
		s.connection().commit();
		s.close();

	}

//	public void testCollectionCUD() throws HibernateException, SQLException {
//		
//		
//		Role role = new Role();
//
//		role.setName("Jim Flanders");
//
//		Intervention iv = new Medication();
//		iv.setDescription("JF medical intervention");
//
//		role.getInterventions().add(iv);
//
//		List sx = new ArrayList();
//		sx.add("somewhere");
//		sx.add("somehow");
//		sx.add("whatever");
//		role.setBunchOfStrings(sx);
//
//		Session s = openSession();
//
//		s.save(role);
//		s.flush();
//		s.connection().commit();
//		s.close();
//
//		s = openSession();
//
//		Role r = (Role) s.get(Role.class,new Long(role.getId()));
//		assertNotSame(role,r);
//
//		assertEquals(1,r.getInterventions().size());
//
//		assertEquals(3, r.getBunchOfStrings().size());
//
//		r.getBunchOfStrings().set(1, "replacement");
//		s.flush();
//		s.connection().commit();
//		s.close();
//
//		s = openSession();
//
//		r = (Role) s.get(Role.class,new Long(role.getId()));
//		assertNotSame(role,r);
//
//		assertEquals(r.getBunchOfStrings().get(1),"replacement");
//		assertEquals(3, r.getBunchOfStrings().size());
//
//		r.getBunchOfStrings().set(1, "replacement");
//
//		r.getBunchOfStrings().remove(1);
//		s.flush();
//
//		r.getBunchOfStrings().clear();
//		s.flush();
//
//		s.connection().commit();
//		s.close();
//
//	}
//
//	public void testCRUD() throws HibernateException, SQLException {
//
//
//		Person p = new Person();
//
//		p.setName("Max");
//		p.setLastName("Andersen");
//		p.setNationalID("110974XYZ�");
//		p.setAddress("P. P. Street 8");
//
//		Session s = openSession();
//
//		s.save(p);
//		s.flush();
//
//		s.connection().commit();
//		s.close();
//
//		getSessions().evict(Person.class);
//		s = openSession();
//
//		Person p2 = (Person) s.get(Person.class, p.getId());
//		assertNotSame(p, p2);
//		assertEquals(p2.getId(),p.getId());
//		assertEquals(p2.getLastName(),p.getLastName());
//		s.flush();
//
//		List list = s.find("select p from Party as p");
//		assertTrue(list.size() == 1);
//
//		s.connection().commit();
//		s.close();
//
//		s = openSession();
//
//		list = s.find("select p from Person as p where p.address = 'L�rkev�nget 1'");
//		assertTrue(list.size() == 0);
//		p.setAddress("L�rkev�nget 1");
//		s.update(p);
//		list = s.find("select p from Person as p where p.address = 'L�rkev�nget 1'");
//		assertTrue(list.size() == 1);
//		list = s.find("select p from Party as p where p.address = 'P. P. Street 8'");
//		assertTrue(list.size() == 0);
//
//		s.delete(p);
//		list = s.find("select p from Person as p");
//		assertTrue(list.size() == 0);
//
//		s.connection().commit();
//		s.close();
//
//
//	}
}
