//$Id: Cache.java 19092 2010-03-23 21:14:04Z stliu $
package org.hibernate.annotations;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Add caching strategy to a root entity or a collection
 *
 * @author Emmanuel Bernard
 */
@Target({TYPE, METHOD, FIELD})
@Retention(RUNTIME)
public @interface Cache {
	/** concurrency strategy chosen */
	CacheConcurrencyStrategy usage();
	/** cache region name */
	String region() default "";
	/**
	 * whether or not lazy-properties are included in the second level cache
	 * default all, other value: non-lazy
	 */
	String include() default "all";
}
