/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.hsqldb.util.AppendableException;
import org.hsqldb.util.SqlToolError;
import org.hsqldb.util.SqltoolRB;

public class SqlFile {
    private static final int DEFAULT_HISTORY_SIZE = 40;
    private File file;
    private boolean interactive;
    private String primaryPrompt = "sql> ";
    private String rawPrompt = null;
    private String contPrompt = "  +> ";
    private Connection curConn = null;
    private boolean htmlMode = false;
    private Map userVars;
    private List history = null;
    private int rawMode = 0;
    private String nullRepToken = null;
    private String dsvTargetFile = null;
    private String dsvTargetTable = null;
    private String dsvConstCols = null;
    private String dsvRejectFile = null;
    private String dsvRejectReport = null;
    public static String LS = System.getProperty("line.separator");
    private int maxHistoryLength = 1;
    private SqltoolRB rb = null;
    private String magicPrefix = null;
    private static final int RAW_FALSE = 0;
    private static final int RAW_EMPTY = 1;
    private static final int RAW_DATA = 2;
    private static Pattern specialPattern = Pattern.compile("\\s*\\\\(\\S+)(?:\\s+(.*\\S))?\\s*");
    private static Pattern plPattern = Pattern.compile("\\s*\\*\\s*(.*\\S)?\\s*");
    private static Pattern foreachPattern = Pattern.compile("\\s*\\*\\s*foreach\\s+(\\S+)\\s*\\(([^)]*)\\)\\s*");
    private static Pattern ifwhilePattern = Pattern.compile("\\s*\\*\\s*\\S+\\s*\\(([^)]*)\\)\\s*");
    private static Pattern varsetPattern = Pattern.compile("\\s*\\*\\s*(\\S+)\\s*([=_~])\\s*(?:(.*\\S)\\s*)?");
    private static Pattern substitutionPattern = Pattern.compile("(\\S)(.+?)\\1(.*?)\\1(.+)?\\s*");
    private static Pattern slashHistoryPattern = Pattern.compile("\\s*/([^/]+)/\\s*(\\S.*)?");
    private static Pattern historyPattern = Pattern.compile("\\s*(-?\\d+)?\\s*(\\S.*)?");
    private static Pattern wincmdPattern = null;
    BooleanBucket possiblyUncommitteds = new BooleanBucket();
    private static final String DIVIDER = "----------------------------------------------------------------------------------------------------------------------------------";
    private static final String SPACES = "                                                                                                                                  ";
    private static String revnum;
    private String DSV_OPTIONS_TEXT = null;
    private String D_OPTIONS_TEXT = null;
    private String RAW_LEADIN_MSG = null;
    public boolean recursed = false;
    private String lastSqlStatement = null;
    private int curLinenum = -1;
    private PrintStream psStd = null;
    private PrintStream psErr = null;
    private PrintWriter pwQuery = null;
    private PrintWriter pwDsv = null;
    StringBuffer immCmdSB = new StringBuffer();
    private boolean continueOnError = false;
    private static final String DEFAULT_CHARSET;
    private BufferedReader br = null;
    private String charset = null;
    private String buffer = null;
    private boolean doPrepare = false;
    private String prepareVar = null;
    private String dsvColDelim = null;
    private String dsvSkipPrefix = null;
    private String dsvRowDelim = null;
    private String dsvSkipCols = null;
    private String DSV_X_SYNTAX_MSG = null;
    private String DSV_M_SYNTAX_MSG = null;
    private String nobufferYetString = null;
    private static final char[] nonVarChars;
    public boolean plMode = false;
    private String fetchingVar = null;
    private boolean silentFetch = false;
    private boolean fetchBinary = false;
    private static final String DEFAULT_NULL_REP = "[null]";
    private static final String DEFAULT_ROW_DELIM;
    private static final String DEFAULT_COL_DELIM = "|";
    private static final String DEFAULT_SKIP_PREFIX = "#";
    private static final int DEFAULT_ELEMENT = 0;
    private static final int HSQLDB_ELEMENT = 1;
    private static final int ORACLE_ELEMENT = 2;
    private static final int[] listMDSchemaCols;
    private static final int[] listMDIndexCols;
    private static final int[][] listMDTableCols;
    private static final String[] oracleSysSchemas;
    private boolean excludeSysSchemas = false;
    private static final int COL_HEAD = 0;
    private static final int COL_ODD = 1;
    private static final int COL_EVEN = 2;
    private static final String PRE_TR;
    private static final String PRE_TD;
    int oldestHist = 1;
    byte[] binBuffer = null;
    private static final int JDBC3_BOOLEAN = 16;
    private static final int JDBC3_DATALINK = 70;

    static {
        if (System.getProperty("os.name").startsWith("Windows")) {
            wincmdPattern = Pattern.compile("([^\"]+)?(\"[^\"]*\")?");
        }
        revnum = null;
        revnum = "354";
        DEFAULT_CHARSET = null;
        nonVarChars = new char[]{' ', '\t', '=', '}', '\n', '\r'};
        DEFAULT_ROW_DELIM = LS;
        listMDSchemaCols = new int[]{1};
        listMDIndexCols = new int[]{2, 6, 3, 9, 4, 10, 11};
        listMDTableCols = new int[][]{{2, 3}, {2, 3}, {2, 3}};
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
        PRE_TR = SqlFile.spaces(4);
        PRE_TD = SqlFile.spaces(8);
    }

    private void updateUserSettings() {
        this.dsvSkipPrefix = SqlFile.convertEscapes((String)this.userVars.get("*DSV_SKIP_PREFIX"));
        if (this.dsvSkipPrefix == null) {
            this.dsvSkipPrefix = DEFAULT_SKIP_PREFIX;
        }
        this.dsvSkipCols = (String)this.userVars.get("*DSV_SKIP_COLS");
        this.dsvColDelim = SqlFile.convertEscapes((String)this.userVars.get("*DSV_COL_DELIM"));
        if (this.dsvColDelim == null) {
            this.dsvColDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_COL_DELIM"));
        }
        if (this.dsvColDelim == null) {
            this.dsvColDelim = DEFAULT_COL_DELIM;
        }
        this.dsvRowDelim = SqlFile.convertEscapes((String)this.userVars.get("*DSV_ROW_DELIM"));
        if (this.dsvRowDelim == null) {
            this.dsvRowDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_ROW_DELIM"));
        }
        if (this.dsvRowDelim == null) {
            this.dsvRowDelim = DEFAULT_ROW_DELIM;
        }
        this.dsvTargetFile = (String)this.userVars.get("*DSV_TARGET_FILE");
        if (this.dsvTargetFile == null) {
            this.dsvTargetFile = (String)this.userVars.get("*CSV_FILEPATH");
        }
        this.dsvTargetTable = (String)this.userVars.get("*DSV_TARGET_TABLE");
        if (this.dsvTargetTable == null) {
            this.dsvTargetTable = (String)this.userVars.get("*CSV_TABLENAME");
        }
        this.dsvConstCols = (String)this.userVars.get("*DSV_CONST_COLS");
        this.dsvRejectFile = (String)this.userVars.get("*DSV_REJECT_FILE");
        this.dsvRejectReport = (String)this.userVars.get("*DSV_REJECT_REPORT");
        this.nullRepToken = (String)this.userVars.get("*NULL_REP_TOKEN");
        if (this.nullRepToken == null) {
            this.nullRepToken = (String)this.userVars.get("*CSV_NULL_REP");
        }
        if (this.nullRepToken == null) {
            this.nullRepToken = DEFAULT_NULL_REP;
        }
    }

    public SqlFile(File inFile, boolean inInteractive, Map inVars) throws IOException {
        try {
            this.rb = new SqltoolRB();
            this.rb.validate();
            this.rb.setMissingPosValueBehavior(2);
            this.rb.setMissingPropertyBehavior(2);
        }
        catch (RuntimeException re) {
            System.err.println("Failed to initialize resource bundle");
            throw re;
        }
        this.rawPrompt = String.valueOf(this.rb.getString(SqltoolRB.RAWMODE_PROMPT)) + "> ";
        this.DSV_OPTIONS_TEXT = this.rb.getString(SqltoolRB.DSV_OPTIONS);
        this.D_OPTIONS_TEXT = this.rb.getString(SqltoolRB.D_OPTIONS);
        this.RAW_LEADIN_MSG = this.rb.getString(SqltoolRB.RAW_LEADIN);
        this.DSV_X_SYNTAX_MSG = this.rb.getString(SqltoolRB.DSV_X_SYNTAX);
        this.DSV_M_SYNTAX_MSG = this.rb.getString(SqltoolRB.DSV_M_SYNTAX);
        this.nobufferYetString = this.rb.getString(SqltoolRB.NOBUFFER_YET);
        this.file = inFile;
        this.interactive = inInteractive;
        this.userVars = inVars;
        if (this.userVars == null) {
            this.userVars = new HashMap();
        }
        this.updateUserSettings();
        if (this.file != null && !this.file.canRead()) {
            throw new IOException(this.rb.getString(SqltoolRB.SQLFILE_READFAIL, this.file.toString()));
        }
        if (this.interactive) {
            this.history = new ArrayList();
            String histLenString = System.getProperty("sqltool.historyLength");
            if (histLenString != null) {
                try {
                    this.maxHistoryLength = Integer.parseInt(histLenString);
                }
                catch (Exception exception) {}
            } else {
                this.maxHistoryLength = 40;
            }
        }
    }

    public SqlFile(boolean inInteractive, Map inVars) throws IOException {
        this(null, inInteractive, inVars);
    }

    public void execute(Connection conn, Boolean coeOverride) throws SqlToolError, SQLException {
        this.execute(conn, System.out, System.err, coeOverride);
    }

    public void execute(Connection conn, boolean coeOverride) throws SqlToolError, SQLException {
        this.execute(conn, System.out, System.err, new Boolean(coeOverride));
    }

    public synchronized void execute(Connection conn, PrintStream stdIn, PrintStream errIn, Boolean coeOverride) throws SqlToolError, SQLException {
        String specifiedCharSet;
        this.psStd = stdIn;
        this.psErr = errIn;
        this.curConn = conn;
        this.curLinenum = -1;
        boolean inComment = false;
        boolean rollbackUncoms = true;
        boolean bl = this.continueOnError = coeOverride == null ? this.interactive : coeOverride;
        if (this.userVars.size() > 0) {
            this.plMode = true;
        }
        this.charset = (specifiedCharSet = System.getProperty("sqlfile.charset")) == null ? DEFAULT_CHARSET : specifiedCharSet;
        try {
            try {
                this.br = new BufferedReader(this.charset == null ? new InputStreamReader(this.file == null ? System.in : new FileInputStream(this.file)) : new InputStreamReader(this.file == null ? System.in : new FileInputStream(this.file), this.charset));
                this.curLinenum = 0;
                if (this.interactive) {
                    this.stdprintln(this.rb.getString(SqltoolRB.SQLFILE_BANNER, revnum));
                }
                while (true) {
                    block62: {
                        String msg;
                        Throwable cause;
                        int postCommentIndex;
                        if (this.interactive && this.magicPrefix == null) {
                            this.psStd.print(this.immCmdSB.length() > 0 || this.rawMode == 2 ? this.contPrompt : (this.rawMode == 0 ? this.primaryPrompt : this.rawPrompt));
                        }
                        String inputLine = this.br.readLine();
                        if (this.magicPrefix != null) {
                            inputLine = String.valueOf(this.magicPrefix) + inputLine;
                            this.magicPrefix = null;
                        }
                        if (inputLine == null) {
                            if (!this.interactive) break;
                            this.psStd.println();
                            break;
                        }
                        ++this.curLinenum;
                        if (inComment) {
                            postCommentIndex = inputLine.indexOf("*/") + 2;
                            if (postCommentIndex <= 1) continue;
                            inputLine = inputLine.substring(postCommentIndex);
                            this.immCmdSB.setLength(0);
                            inComment = false;
                        }
                        String trimmedInput = inputLine.trim();
                        try {
                            if (this.rawMode != 0) {
                                boolean rawExecute = inputLine.equals(".;");
                                if (rawExecute || inputLine.equals(":.")) {
                                    if (this.rawMode == 1) {
                                        this.rawMode = 0;
                                        throw new SqlToolError(this.rb.getString(SqltoolRB.RAW_EMPTY));
                                    }
                                    this.rawMode = 0;
                                    this.setBuf(this.immCmdSB.toString());
                                    this.immCmdSB.setLength(0);
                                    if (rawExecute) {
                                        this.historize();
                                        this.processSQL();
                                        continue;
                                    }
                                    if (!this.interactive) continue;
                                    this.stdprintln(this.rb.getString(SqltoolRB.RAW_MOVEDTOBUFFER));
                                    continue;
                                }
                                if (this.rawMode == 2) {
                                    this.immCmdSB.append('\n');
                                }
                                this.rawMode = 2;
                                if (inputLine.length() <= 0) continue;
                                this.immCmdSB.append(inputLine);
                                continue;
                            }
                            if (this.immCmdSB.length() == 0) {
                                if (trimmedInput.startsWith("/*")) {
                                    postCommentIndex = trimmedInput.indexOf("*/", 2) + 2;
                                    if (postCommentIndex > 1) {
                                        inputLine = inputLine.substring(postCommentIndex + inputLine.length() - trimmedInput.length());
                                        trimmedInput = inputLine.trim();
                                    } else {
                                        this.immCmdSB.append("COMMENT");
                                        inComment = true;
                                        continue;
                                    }
                                }
                                if (trimmedInput.length() == 0) continue;
                                if (trimmedInput.charAt(0) == '*' && (trimmedInput.length() < 2 || trimmedInput.charAt(1) != '{') || trimmedInput.charAt(0) == '\\') {
                                    this.setBuf(trimmedInput);
                                    this.processFromBuffer();
                                    continue;
                                }
                                if (trimmedInput.charAt(0) == ':' && this.interactive) {
                                    this.processBuffHist(trimmedInput.substring(1));
                                    continue;
                                }
                                String ucased = trimmedInput.toUpperCase();
                                if (ucased.startsWith("DECLARE") || ucased.startsWith("BEGIN")) {
                                    this.rawMode = 1;
                                    this.immCmdSB.append(inputLine);
                                    if (!this.interactive) continue;
                                    this.stdprintln(this.RAW_LEADIN_MSG);
                                    continue;
                                }
                            }
                            if (trimmedInput.length() == 0 && this.interactive && !inComment) {
                                this.setBuf(this.immCmdSB.toString());
                                this.immCmdSB.setLength(0);
                                this.stdprintln(this.rb.getString(SqltoolRB.INPUT_MOVEDTOBUFFER));
                                continue;
                            }
                            String deTerminated = SqlFile.deTerminated(inputLine);
                            if (!trimmedInput.equals(";")) {
                                if (this.immCmdSB.length() > 0) {
                                    this.immCmdSB.append('\n');
                                }
                                this.immCmdSB.append(deTerminated == null ? inputLine : deTerminated);
                            }
                            if (deTerminated == null) continue;
                            if (this.immCmdSB.toString().trim().length() == 0) {
                                this.immCmdSB.setLength(0);
                                throw new SqlToolError(this.rb.getString(SqltoolRB.SQLSTATEMENT_EMPTY));
                            }
                            this.setBuf(this.immCmdSB.toString());
                            this.immCmdSB.setLength(0);
                            this.historize();
                            this.processSQL();
                        }
                        catch (BadSpecial bs) {
                            this.errprintln(this.rb.getString(SqltoolRB.ERRORAT, new String[]{this.file == null ? "stdin" : this.file.toString(), Integer.toString(this.curLinenum), inputLine, bs.getMessage()}));
                            cause = bs.getCause();
                            if (cause != null) {
                                this.errprintln(this.rb.getString(SqltoolRB.CAUSEREPORT, cause.toString()));
                            }
                            if (!this.continueOnError) {
                                throw new SqlToolError(bs);
                            }
                        }
                        catch (SQLException se) {
                            this.errprintln("SQL " + this.rb.getString(SqltoolRB.ERRORAT, new String[]{this.file == null ? "stdin" : this.file.toString(), Integer.toString(this.curLinenum), this.lastSqlStatement, se.getMessage()}));
                            if (!this.continueOnError) {
                                throw se;
                            }
                        }
                        catch (BreakException be) {
                            msg = be.getMessage();
                            if (this.recursed) {
                                rollbackUncoms = false;
                            } else {
                                if (msg == null || msg.equals("file")) break;
                                this.errprintln(this.rb.getString(SqltoolRB.BREAK_UNSATISFIED, msg));
                            }
                            if (this.recursed || !this.continueOnError) {
                                throw be;
                            }
                        }
                        catch (ContinueException ce) {
                            msg = ce.getMessage();
                            if (this.recursed) {
                                rollbackUncoms = false;
                            } else {
                                this.errprintln(this.rb.getString(SqltoolRB.CONTINUE_UNSATISFIED, msg));
                            }
                            if (this.recursed || !this.continueOnError) {
                                throw ce;
                            }
                        }
                        catch (QuitNow qn) {
                            throw qn;
                        }
                        catch (SqlToolError ste) {
                            this.errprint(this.rb.getString(SqltoolRB.ERRORAT, new String[]{this.file == null ? "stdin" : this.file.toString(), Integer.toString(this.curLinenum), inputLine, ste.getMessage() == null ? "" : ste.getMessage()}));
                            if (ste.getMessage() != null) {
                                this.errprintln("");
                            }
                            if ((cause = ste.getCause()) != null) {
                                this.errprintln(this.rb.getString(SqltoolRB.CAUSEREPORT, cause.toString()));
                            }
                            if (this.continueOnError) break block62;
                            throw ste;
                        }
                    }
                    this.immCmdSB.setLength(0);
                }
                if (inComment || this.immCmdSB.length() != 0) {
                    this.errprintln(this.rb.getString(SqltoolRB.INPUT_UNTERMINATED, this.immCmdSB.toString()));
                    throw new SqlToolError(this.rb.getString(SqltoolRB.INPUT_UNTERMINATED, this.immCmdSB.toString()));
                }
                rollbackUncoms = false;
            }
            catch (IOException ioe) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PRIMARYINPUT_ACCESSFAIL), ioe);
            }
            catch (QuitNow qn) {
                if (this.recursed) {
                    throw qn;
                }
                boolean bl2 = rollbackUncoms = qn.getMessage() != null;
                if (rollbackUncoms) {
                    this.errprintln(this.rb.getString(SqltoolRB.ABORTING, qn.getMessage()));
                    throw new SqlToolError(qn.getMessage());
                }
                this.closeQueryOutputStream();
                if (this.fetchingVar != null) {
                    this.errprintln(this.rb.getString(SqltoolRB.PLVAR_SET_INCOMPLETE, this.fetchingVar));
                    rollbackUncoms = true;
                }
                if (this.br != null) {
                    try {
                        this.br.close();
                    }
                    catch (IOException ioe) {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.INPUTREADER_CLOSEFAIL), ioe);
                    }
                }
                if (rollbackUncoms && this.possiblyUncommitteds.get()) {
                    this.errprintln(this.rb.getString(SqltoolRB.ROLLINGBACK));
                    this.curConn.rollback();
                    this.possiblyUncommitteds.set(false);
                }
                return;
            }
        }
        finally {
            this.closeQueryOutputStream();
            if (this.fetchingVar != null) {
                this.errprintln(this.rb.getString(SqltoolRB.PLVAR_SET_INCOMPLETE, this.fetchingVar));
                rollbackUncoms = true;
            }
            if (this.br != null) {
                try {
                    this.br.close();
                }
                catch (IOException ioe) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.INPUTREADER_CLOSEFAIL), ioe);
                }
            }
            if (rollbackUncoms && this.possiblyUncommitteds.get()) {
                this.errprintln(this.rb.getString(SqltoolRB.ROLLINGBACK));
                this.curConn.rollback();
                this.possiblyUncommitteds.set(false);
            }
        }
    }

    private static String deTerminated(String inString) {
        int index = inString.lastIndexOf(59);
        if (index < 0) {
            return null;
        }
        int i = index + 1;
        while (i < inString.length()) {
            if (!Character.isWhitespace(inString.charAt(i))) {
                return null;
            }
            ++i;
        }
        return inString.substring(0, index);
    }

    public void processFromBuffer() throws BadSpecial, SQLException, SqlToolError {
        this.historize();
        if (this.buffer.charAt(0) == '*' && (this.buffer.length() < 2 || this.buffer.charAt(1) != '{')) {
            this.processPL(this.buffer);
            return;
        }
        if (this.buffer.charAt(0) == '\\') {
            this.processSpecial(this.buffer);
            return;
        }
        this.processSQL();
    }

    private void processBuffHist(String inString) throws BadSpecial, SQLException, SqlToolError {
        if (inString.length() < 1) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.BUFHIST_UNSPECIFIED));
        }
        char commandChar = inString.charAt(0);
        String other = inString.substring(1);
        if (other.trim().length() == 0) {
            other = null;
        }
        switch (commandChar) {
            case 'b': 
            case 'l': {
                this.enforce1charBH(other, 'l');
                if (this.buffer == null) {
                    this.stdprintln(this.nobufferYetString);
                } else {
                    this.stdprintln(this.rb.getString(SqltoolRB.EDITBUFFER_CONTENTS, this.buffer));
                }
                return;
            }
            case 'h': {
                this.enforce1charBH(other, 'h');
                this.showHistory();
                return;
            }
            case '?': {
                this.stdprintln(this.rb.getString(SqltoolRB.BUFFER_HELP));
                return;
            }
        }
        Integer histNum = null;
        Matcher hm = slashHistoryPattern.matcher(inString);
        if (hm.matches()) {
            histNum = this.historySearch(hm.group(1));
            if (histNum == null) {
                this.stdprintln(this.rb.getString(SqltoolRB.SUBSTITUTION_NOMATCH));
                return;
            }
        } else {
            hm = historyPattern.matcher(inString);
            if (!hm.matches()) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.EDIT_MALFORMAT));
            }
            Integer n = histNum = hm.group(1) == null || hm.group(1).length() < 1 ? null : new Integer(hm.group(1));
        }
        if (hm.groupCount() != 2) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.EDIT_MALFORMAT));
        }
        commandChar = hm.group(2) == null || hm.group(2).length() < 1 ? (char)'\u0000' : hm.group(2).charAt(0);
        String string = other = commandChar == '\u0000' ? null : hm.group(2).substring(1);
        if (other != null && other.length() < 1) {
            other = null;
        }
        String targetCommand = histNum == null ? null : this.commandFromHistory(histNum);
        switch (commandChar) {
            case '\u0000': {
                this.setBuf(targetCommand);
                this.stdprintln(this.rb.getString(SqltoolRB.BUFFER_RESTORED, this.buffer));
                return;
            }
            case ';': {
                this.enforce1charBH(other, ';');
                if (targetCommand != null) {
                    this.setBuf(targetCommand);
                }
                if (this.buffer == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
                }
                this.stdprintln(this.rb.getString(SqltoolRB.BUFFER_EXECUTING, this.buffer));
                this.processFromBuffer();
                return;
            }
            case 'a': {
                if (targetCommand == null) {
                    targetCommand = this.buffer;
                }
                if (targetCommand == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
                }
                this.immCmdSB.append(targetCommand);
                if (other != null) {
                    String deTerminated = SqlFile.deTerminated(other);
                    if (!other.equals(";")) {
                        this.immCmdSB.append(deTerminated == null ? other : deTerminated);
                    }
                    if (deTerminated != null) {
                        this.setBuf(this.immCmdSB.toString());
                        this.immCmdSB.setLength(0);
                        this.stdprintln(this.rb.getString(SqltoolRB.BUFFER_EXECUTING, this.buffer));
                        this.processFromBuffer();
                        return;
                    }
                }
                this.magicPrefix = this.immCmdSB.toString();
                this.immCmdSB.setLength(0);
                if (this.interactive) {
                    this.stdprint(this.magicPrefix);
                }
                return;
            }
            case 'w': {
                if (targetCommand == null) {
                    targetCommand = this.buffer;
                }
                if (targetCommand == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
                }
                if (other == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.DESTFILE_DEMAND));
                }
                String targetFile = this.dereference(other.trim(), false);
                PrintWriter pw = null;
                try {
                    try {
                        pw = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(targetFile, true)) : new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile, true), this.charset));
                        pw.print(targetCommand);
                        if (!targetCommand.matches("\\s*[*:\\\\].*")) {
                            pw.print(';');
                        }
                        pw.println();
                        pw.flush();
                    }
                    catch (Exception e) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_APPENDFAIL, targetFile), e);
                    }
                }
                finally {
                    if (pw != null) {
                        pw.close();
                    }
                }
                return;
            }
            case 's': {
                boolean modeExecute = false;
                boolean modeGlobal = false;
                if (targetCommand == null) {
                    targetCommand = this.buffer;
                }
                if (targetCommand == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
                }
                try {
                    String newBuffer;
                    String optionGroup;
                    if (other == null || other.length() < 3) {
                        throw new BadSubst(this.rb.getString(SqltoolRB.SUBSTITUTION_MALFORMAT));
                    }
                    Matcher m = substitutionPattern.matcher(other);
                    if (!m.matches()) {
                        throw new BadSubst(this.rb.getString(SqltoolRB.SUBSTITUTION_MALFORMAT));
                    }
                    if (m.groupCount() < 3 || m.groupCount() > 4) {
                        throw new RuntimeException("Matched substitution pattern, but captured " + m.groupCount() + " groups");
                    }
                    String string2 = optionGroup = m.groupCount() > 3 && m.group(4) != null ? new String(m.group(4)) : null;
                    if (optionGroup != null) {
                        if (optionGroup.indexOf(59) > -1) {
                            modeExecute = true;
                            optionGroup = optionGroup.replaceFirst(";", "");
                        }
                        if (optionGroup.indexOf(103) > -1) {
                            modeGlobal = true;
                            optionGroup = optionGroup.replaceFirst("g", "");
                        }
                    }
                    Matcher bufferMatcher = Pattern.compile("(?s" + (optionGroup == null ? "" : optionGroup) + ')' + m.group(2)).matcher(targetCommand);
                    String string3 = newBuffer = modeGlobal ? bufferMatcher.replaceAll(m.group(3)) : bufferMatcher.replaceFirst(m.group(3));
                    if (newBuffer.equals(targetCommand)) {
                        this.stdprintln(this.rb.getString(SqltoolRB.SUBSTITUTION_NOMATCH));
                        return;
                    }
                    this.setBuf(newBuffer);
                    this.stdprintln(this.rb.getString(modeExecute ? SqltoolRB.BUFFER_EXECUTING : SqltoolRB.EDITBUFFER_CONTENTS, this.buffer));
                }
                catch (PatternSyntaxException pse) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SUBSTITUTION_SYNTAX), pse);
                }
                catch (BadSubst badSubst) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SUBSTITUTION_SYNTAX));
                }
                if (modeExecute) {
                    this.immCmdSB.setLength(0);
                    this.processFromBuffer();
                }
                return;
            }
        }
        throw new BadSpecial(this.rb.getString(SqltoolRB.BUFFER_UNKNOWN, Character.toString(commandChar)));
    }

    private void enforce1charSpecial(String token, char command) throws BadSpecial {
        if (token.length() != 1) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_EXTRACHARS, Character.toString(command), token.substring(1)));
        }
    }

    private void enforce1charBH(String token, char command) throws BadSpecial {
        if (token != null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.BUFFER_EXTRACHARS, Character.toString(command), token));
        }
    }

    private void processSpecial(String inString) throws BadSpecial, QuitNow, SQLException, SqlToolError {
        if (inString.equals("\\")) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_UNSPECIFIED));
        }
        Matcher m = specialPattern.matcher(this.plMode ? this.dereference(inString, false) : inString);
        if (!m.matches()) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_MALFORMAT));
        }
        if (m.groupCount() < 1 || m.groupCount() > 2) {
            throw new RuntimeException("Pattern matched, yet captured " + m.groupCount() + " groups");
        }
        String arg1 = m.group(1);
        String other = m.groupCount() > 1 ? m.group(2) : null;
        switch (arg1.charAt(0)) {
            case 'q': {
                this.enforce1charSpecial(arg1, 'q');
                if (other != null) {
                    throw new QuitNow(other);
                }
                throw new QuitNow();
            }
            case 'H': {
                this.enforce1charSpecial(arg1, 'H');
                this.htmlMode = !this.htmlMode;
                this.stdprintln(this.rb.getString(SqltoolRB.HTML_MODE, Boolean.toString(this.htmlMode)));
                return;
            }
            case 'm': {
                int colonIndex;
                if (arg1.equals("m?") || arg1.equals("m") && other != null && other.equals("?")) {
                    this.stdprintln(String.valueOf(this.DSV_OPTIONS_TEXT) + LS + this.DSV_M_SYNTAX_MSG);
                    return;
                }
                if (arg1.length() != 1 || other == null) {
                    throw new BadSpecial(this.DSV_M_SYNTAX_MSG);
                }
                boolean noComments = other.charAt(other.length() - 1) == '*';
                String skipPrefix = null;
                if (noComments) {
                    if ((other = other.substring(0, other.length() - 1).trim()).length() < 1) {
                        throw new BadSpecial(this.DSV_M_SYNTAX_MSG);
                    }
                } else {
                    skipPrefix = this.dsvSkipPrefix;
                }
                if ((colonIndex = other.indexOf(" :")) > -1 && colonIndex < other.length() - 2) {
                    skipPrefix = other.substring(colonIndex + 2);
                    other = other.substring(0, colonIndex).trim();
                }
                this.importDsv(other, skipPrefix);
                return;
            }
            case 'x': {
                if (arg1.equals("x?") || arg1.equals("x") && other != null && other.equals("?")) {
                    this.stdprintln(String.valueOf(this.DSV_OPTIONS_TEXT) + LS + this.DSV_X_SYNTAX_MSG);
                    return;
                }
                try {
                    try {
                        String tableName;
                        if (arg1.length() != 1 || other == null) {
                            throw new BadSpecial(this.DSV_X_SYNTAX_MSG);
                        }
                        String string = tableName = other.indexOf(32) > 0 ? null : other;
                        if (this.dsvTargetFile == null && tableName == null) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.DSV_TARGETFILE_DEMAND));
                        }
                        File dsvFile = new File(this.dsvTargetFile == null ? String.valueOf(tableName) + ".dsv" : this.dsvTargetFile);
                        this.pwDsv = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(dsvFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(dsvFile), this.charset));
                        ResultSet rs = this.curConn.createStatement().executeQuery(tableName == null ? other : "SELECT * FROM " + tableName);
                        ArrayList<Integer> colList = new ArrayList<Integer>();
                        int[] incCols = null;
                        if (this.dsvSkipCols != null) {
                            HashSet<String> skipCols = new HashSet<String>();
                            String[] skipColsArray = this.dsvSkipCols.split("\\s*\\Q" + this.dsvColDelim + "\\E\\s*");
                            int i = 0;
                            while (i < skipColsArray.length) {
                                skipCols.add(skipColsArray[i].toLowerCase());
                                ++i;
                            }
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int i2 = 1;
                            while (i2 <= rsmd.getColumnCount()) {
                                if (!skipCols.remove(rsmd.getColumnName(i2).toLowerCase())) {
                                    colList.add(new Integer(i2));
                                }
                                ++i2;
                            }
                            if (colList.size() < 1) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.DSV_NOCOLSLEFT, this.dsvSkipCols));
                            }
                            if (skipCols.size() > 0) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.DSV_SKIPCOLS_MISSING, ((Object)skipCols).toString()));
                            }
                            incCols = new int[colList.size()];
                            i2 = 0;
                            while (i2 < incCols.length) {
                                incCols[i2] = (Integer)colList.get(i2);
                                ++i2;
                            }
                        }
                        this.displayResultSet(null, rs, incCols, null);
                        this.pwDsv.flush();
                        this.stdprintln(this.rb.getString(SqltoolRB.FILE_WROTECHARS, Long.toString(dsvFile.length()), dsvFile.toString()));
                    }
                    catch (FileNotFoundException e) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_WRITEFAIL, other), e);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_WRITEFAIL, other), e);
                    }
                }
                finally {
                    if (this.pwDsv != null) {
                        this.pwDsv.close();
                    }
                    this.pwDsv = null;
                }
                return;
            }
            case 'd': {
                if (arg1.equals("d?") || arg1.equals("d") && other != null && other.equals("?")) {
                    this.stdprintln(this.D_OPTIONS_TEXT);
                    return;
                }
                if (arg1.length() == 2) {
                    this.listTables(arg1.charAt(1), other);
                    return;
                }
                if (arg1.length() == 1 && other != null) {
                    try {
                        int space = other.indexOf(32);
                        if (space < 0) {
                            this.describe(other, null);
                        } else {
                            this.describe(other.substring(0, space), other.substring(space + 1).trim());
                        }
                        return;
                    }
                    catch (SQLException se) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAIL), se);
                    }
                }
                throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_D_LIKE));
            }
            case 'o': {
                this.enforce1charSpecial(arg1, 'o');
                if (other == null) {
                    if (this.pwQuery == null) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.OUTPUTFILE_NONETOCLOSE));
                    }
                    this.closeQueryOutputStream();
                    return;
                }
                if (this.pwQuery != null) {
                    this.stdprintln(this.rb.getString(SqltoolRB.OUTPUTFILE_REOPENING));
                    this.closeQueryOutputStream();
                }
                try {
                    this.pwQuery = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(other, true)) : new OutputStreamWriter((OutputStream)new FileOutputStream(other, true), this.charset));
                    this.pwQuery.println(String.valueOf(this.htmlMode ? "<HTML>" + LS + "<!--" : DEFAULT_SKIP_PREFIX) + " " + new Date() + ".  " + this.rb.getString(SqltoolRB.OUTPUTFILE_HEADER, this.getClass().getName()) + (this.htmlMode ? " -->" + LS + LS + "<BODY>" : LS));
                    this.pwQuery.flush();
                }
                catch (Exception e) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_WRITEFAIL, other), e);
                }
                return;
            }
            case 'i': {
                this.enforce1charSpecial(arg1, 'i');
                if (other == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SQLFILE_NAME_DEMAND));
                }
                try {
                    SqlFile sf = new SqlFile(new File(other), false, this.userVars);
                    sf.recursed = true;
                    sf.possiblyUncommitteds = this.possiblyUncommitteds;
                    sf.plMode = this.plMode;
                    sf.execute(this.curConn, this.continueOnError);
                }
                catch (ContinueException ce) {
                    throw ce;
                }
                catch (BreakException be) {
                    String beMessage = be.getMessage();
                    if (beMessage != null && !beMessage.equals("file")) {
                        throw be;
                    }
                }
                catch (QuitNow qn) {
                    throw qn;
                }
                catch (Exception e) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SQLFILE_EXECUTE_FAIL, other), e);
                }
                return;
            }
            case 'p': {
                this.enforce1charSpecial(arg1, 'p');
                if (other == null) {
                    this.stdprintln(true);
                } else {
                    this.stdprintln(other, true);
                }
                return;
            }
            case 'a': {
                this.enforce1charSpecial(arg1, 'a');
                if (other != null) {
                    this.curConn.setAutoCommit(Boolean.valueOf(other));
                }
                this.stdprintln(this.rb.getString(SqltoolRB.A_SETTING, Boolean.toString(this.curConn.getAutoCommit())));
                return;
            }
            case '=': {
                this.enforce1charSpecial(arg1, '=');
                this.curConn.commit();
                this.possiblyUncommitteds.set(false);
                this.stdprintln(this.rb.getString(SqltoolRB.COMMITTED));
                return;
            }
            case 'b': {
                if (arg1.length() == 1) {
                    if (other != null) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_B_MALFORMAT));
                    }
                    this.fetchBinary = true;
                    return;
                }
                if (arg1.charAt(1) == 'p') {
                    if (other != null) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_B_MALFORMAT));
                    }
                    this.doPrepare = true;
                    return;
                }
                if (arg1.charAt(1) != 'd' && arg1.charAt(1) != 'l' || other == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_B_MALFORMAT));
                }
                File file = new File(other);
                try {
                    if (arg1.charAt(1) == 'd') {
                        this.dump(file);
                    } else {
                        this.binBuffer = SqlFile.loadBinary(file);
                        this.stdprintln(this.rb.getString(SqltoolRB.BINARY_LOADEDBYTESINTO, this.binBuffer.length));
                    }
                }
                catch (BadSpecial bs) {
                    throw bs;
                }
                catch (IOException ioe) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.BINARY_FILEFAIL, other), ioe);
                }
                return;
            }
            case '*': 
            case 'c': {
                this.enforce1charSpecial(arg1, '=');
                if (other != null) {
                    this.continueOnError = Boolean.valueOf(other);
                }
                this.stdprintln(this.rb.getString(SqltoolRB.C_SETTING, Boolean.toString(this.continueOnError)));
                return;
            }
            case '?': {
                this.stdprintln(this.rb.getString(SqltoolRB.SPECIAL_HELP));
                return;
            }
            case '!': {
                byte[] ba = new byte[1024];
                String extCommand = String.valueOf(arg1.length() == 1 ? "" : arg1.substring(1)) + (arg1.length() > 1 && other != null ? " " : "") + (other == null ? "" : other);
                if (extCommand.trim().length() < 1) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.BANG_INCOMPLETE));
                }
                try {
                    int i;
                    Runtime runtime = Runtime.getRuntime();
                    Process proc = wincmdPattern == null ? runtime.exec(extCommand) : runtime.exec(SqlFile.genWinArgs(extCommand));
                    proc.getOutputStream().close();
                    InputStream stream = proc.getInputStream();
                    while ((i = stream.read(ba)) > 0) {
                        this.stdprint(new String(ba, 0, i));
                    }
                    stream.close();
                    stream = proc.getErrorStream();
                    while ((i = stream.read(ba)) > 0) {
                        this.errprint(new String(ba, 0, i));
                    }
                    stream.close();
                    if (proc.waitFor() != 0) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.BANG_COMMAND_FAIL, extCommand));
                    }
                }
                catch (BadSpecial bs) {
                    throw bs;
                }
                catch (Exception e) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.BANG_COMMAND_FAIL, extCommand), e);
                }
                return;
            }
            case '.': {
                this.enforce1charSpecial(arg1, '.');
                this.rawMode = 1;
                if (this.interactive) {
                    this.stdprintln(this.RAW_LEADIN_MSG);
                }
                return;
            }
        }
        throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_UNKNOWN, Character.toString(arg1.charAt(0))));
    }

    static int pastName(String inString, int startIndex) {
        String workString = inString.substring(startIndex);
        int e = inString.length();
        int i = 0;
        while (i < nonVarChars.length) {
            int nonVarIndex = workString.indexOf(nonVarChars[i]);
            if (nonVarIndex > -1 && nonVarIndex < e) {
                e = nonVarIndex;
            }
            ++i;
        }
        return startIndex + e;
    }

    private String dereference(String inString, boolean permitAlias) throws SqlToolError {
        boolean permitUnset;
        String s;
        int b;
        String varValue;
        String varName;
        int e;
        StringBuffer expandBuffer = new StringBuffer(inString);
        if (permitAlias && inString.trim().charAt(0) == '/') {
            int slashIndex = inString.indexOf(47);
            e = SqlFile.pastName(inString.substring(slashIndex + 1), 0);
            if (e < 1) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PLALIAS_MALFORMAT));
            }
            varName = inString.substring(slashIndex + 1, slashIndex + 1 + e);
            varValue = (String)this.userVars.get(varName);
            if (varValue == null) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, varName));
            }
            expandBuffer.replace(slashIndex, slashIndex + 1 + e, (String)this.userVars.get(varName));
        }
        int iterations = 0;
        while ((b = (s = expandBuffer.toString()).indexOf("${")) >= 0) {
            e = s.indexOf(125, b + 2);
            if (e == b + 2) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.SYSPROP_EMPTY));
            }
            if (e < 0) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.SYSPROP_UNTERMINATED));
            }
            permitUnset = s.charAt(b + 2) == ':';
            varName = s.substring(b + (permitUnset ? 3 : 2), e);
            if (iterations++ > 10000) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.VAR_INFINITE, varName));
            }
            varValue = System.getProperty(varName);
            if (varValue == null) {
                if (permitUnset) {
                    varValue = "";
                } else {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.SYSPROP_UNDEFINED, varName));
                }
            }
            expandBuffer.replace(b, e + 1, varValue);
        }
        iterations = 0;
        while ((b = (s = expandBuffer.toString()).indexOf("*{")) >= 0) {
            e = s.indexOf(125, b + 2);
            if (e == b + 2) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_NAMEEMPTY));
            }
            if (e < 0) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNTERMINATED));
            }
            permitUnset = s.charAt(b + 2) == ':';
            varName = s.substring(b + (permitUnset ? 3 : 2), e);
            if (iterations++ > 10000) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.VAR_INFINITE, varName));
            }
            varValue = (String)this.userVars.get(varName);
            if (varValue == null) {
                if (permitUnset) {
                    varValue = "";
                } else {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, varName));
                }
            }
            expandBuffer.replace(b, e + 1, varValue);
        }
        return expandBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void processPL(String inString) throws BadSpecial, SqlToolError {
        block75: {
            block74: {
                block77: {
                    block76: {
                        m = SqlFile.plPattern.matcher(this.dereference(inString, false));
                        if (!m.matches()) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_MALFORMAT));
                        }
                        if (m.groupCount() < 1 || m.group(1) == null) {
                            this.plMode = true;
                            this.stdprintln(this.rb.getString(SqltoolRB.PL_EXPANSIONMODE, "on"));
                            return;
                        }
                        tokens = m.group(1).split("\\s+");
                        if (tokens[0].charAt(0) == '?') {
                            this.stdprintln(this.rb.getString(SqltoolRB.PL_HELP));
                            return;
                        }
                        this.plMode = true;
                        if (tokens[0].equals("end")) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.END_NOBLOCK));
                        }
                        if (tokens[0].equals("continue")) {
                            if (tokens.length > 1) {
                                if (tokens.length == 2 && (tokens[1].equals("foreach") || tokens[1].equals("while"))) {
                                    throw new ContinueException(tokens[1]);
                                }
                                throw new BadSpecial(this.rb.getString(SqltoolRB.CONTINUE_SYNTAX));
                            }
                            throw new ContinueException();
                        }
                        if (tokens[0].equals("break")) {
                            if (tokens.length > 1) {
                                if (tokens.length == 2 && (tokens[1].equals("foreach") || tokens[1].equals("if") || tokens[1].equals("while") || tokens[1].equals("file"))) {
                                    throw new BreakException(tokens[1]);
                                }
                                throw new BadSpecial(this.rb.getString(SqltoolRB.BREAK_SYNTAX));
                            }
                            throw new BreakException();
                        }
                        if (tokens[0].equals("list") || tokens[0].equals("listvalues") || tokens[0].equals("listsysprops")) {
                            sysProps = tokens[0].equals("listsysprops");
                            v0 = doValues = tokens[0].equals("listvalues") != false || sysProps != false;
                            if (tokens.length == 1) {
                                this.stdprint(this.formatNicely(sysProps != false ? System.getProperties() : this.userVars, doValues));
                            } else {
                                if (doValues) {
                                    this.stdprintln(this.rb.getString(SqltoolRB.PL_LIST_PARENS));
                                } else {
                                    this.stdprintln(this.rb.getString(SqltoolRB.PL_LIST_LENGTHS));
                                }
                                i = 1;
                                while (i < tokens.length) {
                                    s = (String)(sysProps != false ? System.getProperties() : this.userVars).get(tokens[i]);
                                    if (s != null) {
                                        this.stdprintln("    " + tokens[i] + ": " + (doValues != false ? "(" + s + ')' : Integer.toString(s.length())));
                                    }
                                    ++i;
                                }
                            }
                            return;
                        }
                        if (tokens[0].equals("dump") || tokens[0].equals("load")) {
                            if (tokens.length != 3) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.DUMPLOAD_MALFORMAT));
                            }
                            varName = tokens[1];
                            if (varName.indexOf(58) > -1) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_NOCOLON));
                            }
                            file = new File(tokens[2]);
                            try {
                                if (tokens[0].equals("dump")) {
                                    this.dump(varName, file);
                                } else {
                                    this.load(varName, file, this.charset);
                                }
                            }
                            catch (IOException ioe) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.DUMPLOAD_FAIL, varName, file.toString()), ioe);
                            }
                            return;
                        }
                        if (tokens[0].equals("prepare")) {
                            if (tokens.length != 2) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.PREPARE_MALFORMAT));
                            }
                            if (this.userVars.get(tokens[1]) == null) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, tokens[1]));
                            }
                            this.prepareVar = tokens[1];
                            this.doPrepare = true;
                            return;
                        }
                        if (tokens[0].equals("foreach")) {
                            foreachM = SqlFile.foreachPattern.matcher(this.dereference(inString, false));
                            if (!foreachM.matches()) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.FOREACH_MALFORMAT));
                            }
                            if (foreachM.groupCount() != 2) {
                                throw new RuntimeException("foreach pattern matched, but captured " + foreachM.groupCount() + " groups");
                            }
                            varName = foreachM.group(1);
                            if (varName.indexOf(58) > -1) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_NOCOLON));
                            }
                            values = foreachM.group(2).split("\\s+");
                            tmpFile = null;
                            try {
                                tmpFile = this.plBlockFile("foreach");
                            }
                            catch (IOException ioe) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.PL_TEMPFILE_FAIL), ioe);
                            }
                            origval = (String)this.userVars.get(varName);
                            try {
                                i = 0;
                                while (i < values.length) {
                                    block73: {
                                        try {
                                            varVal = values[i];
                                            this.userVars.put(varName, varVal);
                                            this.updateUserSettings();
                                            sf = new SqlFile(tmpFile, false, this.userVars);
                                            sf.plMode = true;
                                            sf.recursed = true;
                                            sf.possiblyUncommitteds = this.possiblyUncommitteds;
                                            sf.execute(this.curConn, this.continueOnError);
                                        }
                                        catch (ContinueException ce) {
                                            ceMessage = ce.getMessage();
                                            if (ceMessage == null || ceMessage.equals("foreach")) break block73;
                                            throw ce;
                                        }
                                    }
                                    ++i;
                                }
                            }
                            catch (BreakException be) {
                                beMessage = be.getMessage();
                                if (beMessage != null && !beMessage.equals("foreach")) {
                                    throw be;
                                }
                            }
                            catch (QuitNow qn) {
                                throw qn;
                            }
                            catch (Exception e) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), e);
                            }
                            if (origval == null) {
                                this.userVars.remove(varName);
                                this.updateUserSettings();
                            } else {
                                this.userVars.put(varName, origval);
                            }
                            if (tmpFile != null && !tmpFile.delete()) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.TEMPFILE_REMOVAL_FAIL, tmpFile.toString()));
                            }
                            return;
                        }
                        if (!tokens[0].equals("if") && !tokens[0].equals("while")) break block75;
                        ifwhileM = SqlFile.ifwhilePattern.matcher(this.dereference(inString, false));
                        if (!ifwhileM.matches()) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.IFWHILE_MALFORMAT));
                        }
                        if (ifwhileM.groupCount() != 1) {
                            throw new RuntimeException("if/while pattern matched, but captured " + ifwhileM.groupCount() + " groups");
                        }
                        values = ifwhileM.group(1).replaceAll("!([a-zA-Z0-9*])", "! $1").replaceAll("([a-zA-Z0-9*])!", "$1 !").split("\\s+");
                        tmpFile = null;
                        if (!tokens[0].equals("if")) break block76;
                        try {
                            tmpFile = this.plBlockFile("if");
                        }
                        catch (IOException ioe) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), ioe);
                        }
                        try {
                            if (!this.eval(values)) ** GOTO lbl185
                            sf = new SqlFile(tmpFile, false, this.userVars);
                            sf.plMode = true;
                            sf.recursed = true;
                            sf.possiblyUncommitteds = this.possiblyUncommitteds;
                            sf.execute(this.curConn, this.continueOnError);
                        }
                        catch (BreakException be) {
                            beMessage = be.getMessage();
                            if (beMessage != null && beMessage.equals("if")) ** GOTO lbl185
                            throw be;
                        }
                        catch (ContinueException ce) {
                            throw ce;
                        }
                        catch (QuitNow qn) {
                            throw qn;
                        }
                        catch (BadSpecial bs) {
                            bs.appendMessage(this.rb.getString(SqltoolRB.IF_MALFORMAT));
                            throw bs;
                        }
                        catch (Exception e) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), e);
                        }
                    }
                    if (!tokens[0].equals("while")) break block77;
                    try {
                        tmpFile = this.plBlockFile("while");
                        if (true) ** GOTO lbl181
                    }
                    catch (IOException ioe) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.PL_TEMPFILE_FAIL), ioe);
                    }
                    {
                        do {
                            try {
                                sf = new SqlFile(tmpFile, false, this.userVars);
                                sf.recursed = true;
                                sf.possiblyUncommitteds = this.possiblyUncommitteds;
                                sf.plMode = true;
                                sf.execute(this.curConn, this.continueOnError);
                            }
                            catch (ContinueException ce) {
                                ceMessage = ce.getMessage();
                                if (ceMessage == null || ceMessage.equals("while")) continue;
                                throw ce;
                            }
lbl181:
                            // 3 sources

                        } while (this.eval(values));
                        break block74;
                    }
                }
                throw new RuntimeException(this.rb.getString(SqltoolRB.PL_UNKNOWN, tokens[0]));
            }
            if (tmpFile != null && !tmpFile.delete()) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.TEMPFILE_REMOVAL_FAIL, tmpFile.toString()));
            }
            return;
        }
        m = SqlFile.varsetPattern.matcher(this.dereference(inString, false));
        if (!m.matches()) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_UNKNOWN, tokens[0]));
        }
        if (m.groupCount() < 2 || m.groupCount() > 3) {
            throw new RuntimeException("varset pattern matched but captured " + m.groupCount() + " groups");
        }
        varName = m.group(1);
        if (varName.indexOf(58) > -1) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_NOCOLON));
        }
        switch (m.group(2).charAt(0)) {
            case '_': {
                this.silentFetch = true;
            }
            case '~': {
                if (m.groupCount() > 2 && m.group(3) != null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_TILDEDASH_NOMOREARGS, m.group(3)));
                }
                this.userVars.remove(varName);
                this.updateUserSettings();
                this.fetchingVar = varName;
                return;
            }
            case '=': {
                if (this.fetchingVar != null && this.fetchingVar.equals(varName)) {
                    this.fetchingVar = null;
                }
                if (m.groupCount() > 2 && m.group(3) != null) {
                    this.userVars.put(varName, m.group(3));
                } else {
                    this.userVars.remove(varName);
                }
                this.updateUserSettings();
                return;
            }
        }
        throw new BadSpecial(this.rb.getString(SqltoolRB.PL_UNKNOWN, tokens[0]));
    }

    private File plBlockFile(String seeking) throws IOException, SqlToolError {
        int nestlevel = 1;
        if (seeking == null || !seeking.equals("foreach") && !seeking.equals("if") && !seeking.equals("while")) {
            throw new RuntimeException("Assertion failed.  Unsupported PL block type:  " + seeking);
        }
        File tmpFile = File.createTempFile("sqltool-", ".sql");
        PrintWriter pw = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(tmpFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), this.charset));
        try {
            pw.println("/* " + new Date() + ". " + this.getClass().getName() + " PL block. */");
            pw.println();
            while (true) {
                String s;
                if ((s = this.br.readLine()) == null) {
                    s = this.rb.getString(SqltoolRB.PL_BLOCK_UNTERMINATED, seeking);
                    this.errprintln(s);
                    throw new SqlToolError(s);
                }
                ++this.curLinenum;
                Matcher m = plPattern.matcher(s);
                if (m.matches() && m.groupCount() > 0 && m.group(1) != null) {
                    String[] tokens = m.group(1).split("\\s+");
                    String curPlCommand = tokens[0];
                    if (curPlCommand.equals(seeking)) {
                        ++nestlevel;
                    } else if (curPlCommand.equals("end")) {
                        if (tokens.length < 2) {
                            s = this.rb.getString(SqltoolRB.END_SYNTAX, "1");
                            this.errprintln(s);
                            throw new SqlToolError(s);
                        }
                        String inType = tokens[1];
                        if (inType.equals(seeking) && --nestlevel < 1) break;
                        if (!(inType.equals("foreach") || inType.equals("if") || inType.equals("while"))) {
                            s = this.rb.getString(SqltoolRB.END_SYNTAX, "2");
                            this.errprintln(s);
                            throw new SqlToolError(s);
                        }
                    }
                }
                pw.println(s);
            }
            pw.flush();
        }
        finally {
            pw.close();
        }
        return tmpFile;
    }

    private void stdprint(String s) {
        this.stdprint(s, false);
    }

    private void stdprintln(String s) {
        this.stdprintln(s, false);
    }

    private void stdprintln(boolean queryOutput) {
        if (this.htmlMode) {
            this.psStd.println("<BR>");
        } else {
            this.psStd.println();
        }
        if (queryOutput && this.pwQuery != null) {
            if (this.htmlMode) {
                this.pwQuery.println("<BR>");
            } else {
                this.pwQuery.println();
            }
            this.pwQuery.flush();
        }
    }

    private void errprint(String s) {
        this.psErr.print(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + s + "</DIV>" : s);
    }

    private void errprintln(String s) {
        this.psErr.println(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + s + "</DIV>" : s);
    }

    private void stdprint(String s, boolean queryOutput) {
        this.psStd.print(this.htmlMode ? "<P>" + s + "</P>" : s);
        if (queryOutput && this.pwQuery != null) {
            this.pwQuery.print(this.htmlMode ? "<P>" + s + "</P>" : s);
            this.pwQuery.flush();
        }
    }

    private void stdprintln(String s, boolean queryOutput) {
        this.psStd.println(this.htmlMode ? "<P>" + s + "</P>" : s);
        if (queryOutput && this.pwQuery != null) {
            this.pwQuery.println(this.htmlMode ? "<P>" + s + "</P>" : s);
            this.pwQuery.flush();
        }
    }

    /*
     * Exception decompiling
     */
    private void listTables(char c, String inFilter) throws BadSpecial, SqlToolError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processSQL() throws SQLException, SqlToolError {
        this.lastSqlStatement = this.plMode ? this.dereference(this.buffer, true) : this.buffer;
        Statement statement = null;
        if (this.doPrepare) {
            if (this.lastSqlStatement.indexOf(63) < 1) {
                this.lastSqlStatement = null;
                throw new SqlToolError(this.rb.getString(SqltoolRB.PREPARE_DEMANDQM));
            }
            this.doPrepare = false;
            PreparedStatement ps = this.curConn.prepareStatement(this.lastSqlStatement);
            if (this.prepareVar == null) {
                if (this.binBuffer == null) {
                    this.lastSqlStatement = null;
                    throw new SqlToolError(this.rb.getString(SqltoolRB.BINBUFFER_EMPTY));
                }
                ps.setBytes(1, this.binBuffer);
            } else {
                String val = (String)this.userVars.get(this.prepareVar);
                if (val == null) {
                    this.lastSqlStatement = null;
                    throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, this.prepareVar));
                }
                this.prepareVar = null;
                ps.setString(1, val);
            }
            ps.executeUpdate();
            statement = ps;
        } else {
            statement = this.curConn.createStatement();
            statement.execute(this.lastSqlStatement);
        }
        this.possiblyUncommitteds.set(true);
        try {
            this.displayResultSet(statement, statement.getResultSet(), null, null);
        }
        catch (Throwable throwable) {
            try {
                statement.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (Exception exception) {}
        this.lastSqlStatement = null;
    }

    /*
     * Unable to fully structure code
     */
    private void displayResultSet(Statement statement, ResultSet r, int[] incCols, String filter) throws SQLException, SqlToolError {
        updateCount = statement == null ? -1 : statement.getUpdateCount();
        silent = this.silentFetch;
        binary = this.fetchBinary;
        this.silentFetch = false;
        this.fetchBinary = false;
        if (this.excludeSysSchemas) {
            this.stdprintln(this.rb.getString(SqltoolRB.VENDOR_NOSUP_SYSSCHEMAS));
        }
        switch (updateCount) {
            case -1: {
                if (r == null) {
                    this.stdprintln(this.rb.getString(SqltoolRB.NORESULT), true);
                    break;
                }
                m = r.getMetaData();
                cols = m.getColumnCount();
                incCount = incCols == null ? cols : incCols.length;
                rows = new ArrayList<String[]>();
                headerArray = null;
                maxWidth = new int[incCount];
                if (!this.htmlMode) {
                    i = 0;
                    while (i < maxWidth.length) {
                        maxWidth[i] = 0;
                        ++i;
                    }
                }
                rightJust = new boolean[incCount];
                dataType = new int[incCount];
                autonulls = new boolean[incCount];
                insi = -1;
                headerArray = new String[incCount];
                i = 1;
                while (i <= cols) {
                    if (incCols == null) ** GOTO lbl41
                    skip = true;
                    j = 0;
                    while (j < incCols.length) {
                        if (i == incCols[j]) {
                            skip = false;
                        }
                        ++j;
                    }
                    if (skip) ** GOTO lbl53
lbl41:
                    // 2 sources

                    headerArray[++insi] = m.getColumnLabel(i);
                    dataType[insi] = m.getColumnType(i);
                    rightJust[insi] = false;
                    autonulls[insi] = true;
                    switch (dataType[insi]) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            rightJust[insi] = true;
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -1: 
                        case 12: 
                        case 2003: 
                        case 2004: 
                        case 2005: {
                            autonulls[insi] = false;
                        }
                    }
                    if (!this.htmlMode && headerArray[insi].length() > maxWidth[insi]) {
                        maxWidth[insi] = headerArray[insi].length();
                    }
lbl53:
                    // 4 sources

                    ++i;
                }
                while (r.next()) {
                    fieldArray = new String[incCount];
                    insi = -1;
                    filteredOut = filter != null;
                    i = 1;
                    while (i <= cols) {
                        if (incCols == null) ** GOTO lbl70
                        skip = true;
                        j = 0;
                        while (j < incCols.length) {
                            if (i == incCols[j]) {
                                skip = false;
                            }
                            ++j;
                        }
                        if (skip) ** GOTO lbl129
lbl70:
                        // 2 sources

                        if (!SqlFile.canDisplayType(dataType[++insi])) {
                            binary = true;
                        }
                        val = null;
                        if (!binary) {
                            switch (dataType[insi]) {
                                case 91: 
                                case 92: 
                                case 93: {
                                    ts = r.getTimestamp(i);
                                    v0 = val = ts == null ? null : ts.toString();
                                    if (dataType[insi] == 93 || val == null) break;
                                    dotAt = val.lastIndexOf(46);
                                    z = dotAt + 1;
                                    while (z < val.length()) {
                                        if (val.charAt(z) != '0') {
                                            dotAt = 0;
                                            break;
                                        }
                                        ++z;
                                    }
                                    if (dotAt <= 1) break;
                                    val = val.substring(0, dotAt);
                                    break;
                                }
                                default: {
                                    val = r.getString(i);
                                    if (val != null) break;
                                    try {
                                        val = this.streamToString(r.getAsciiStream(i), this.charset);
                                        break;
                                    }
                                    catch (Exception v1) {}
                                }
                            }
                        }
                        if (binary || val == null && !r.wasNull()) {
                            if (this.pwDsv != null) {
                                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_BINCOL));
                            }
                            try {
                                this.binBuffer = SqlFile.streamToBytes(r.getBinaryStream(i));
                            }
                            catch (IOException ioe) {
                                throw new SqlToolError("Failed to read value using stream", ioe);
                            }
                            this.stdprintln(this.rb.getString(SqltoolRB.BINBUF_WRITE, Integer.toString(this.binBuffer.length), headerArray[insi], SqlFile.sqlTypeToString(dataType[insi])));
                            return;
                        }
                        if (this.excludeSysSchemas && val != null && i == 2) {
                            z = 0;
                            while (z < SqlFile.oracleSysSchemas.length) {
                                if (val.equals(SqlFile.oracleSysSchemas[z])) {
                                    filteredOut = true;
                                    break;
                                }
                                ++z;
                            }
                        }
                        this.userVars.put("?", val == null ? this.nullRepToken : val);
                        if (this.fetchingVar != null) {
                            this.userVars.put(this.fetchingVar, this.userVars.get("?"));
                            this.updateUserSettings();
                            this.fetchingVar = null;
                        }
                        if (silent) {
                            return;
                        }
                        if (filter != null && (val == null || val.indexOf(filter) > -1)) {
                            filteredOut = false;
                        }
                        fieldArray[insi] = val == null && this.pwDsv == null ? (dataType[insi] == 12 ? (this.htmlMode != false ? "<I>null</I>" : this.nullRepToken) : "") : val;
                        if (!this.htmlMode && this.pwDsv == null && fieldArray[insi].length() > maxWidth[insi]) {
                            maxWidth[insi] = fieldArray[insi].length();
                        }
lbl129:
                        // 4 sources

                        ++i;
                    }
                    if (filteredOut) continue;
                    rows.add(fieldArray);
                }
                if (this.pwDsv == null) {
                    this.condlPrintln("<TABLE border='1'>", true);
                    if (incCount > 1) {
                        this.condlPrint(String.valueOf(SqlFile.htmlRow(0)) + SqlFile.LS + SqlFile.PRE_TD, true);
                        i = 0;
                        while (i < headerArray.length) {
                            this.condlPrint("<TD>" + headerArray[i] + "</TD>", true);
                            this.condlPrint(String.valueOf(i > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(headerArray[i], maxWidth[i], rightJust[i], i < headerArray.length - 1 || rightJust[i] != false), false);
                            ++i;
                        }
                        this.condlPrintln(String.valueOf(SqlFile.LS) + SqlFile.PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                        if (!this.htmlMode) {
                            i = 0;
                            while (i < headerArray.length) {
                                this.condlPrint(String.valueOf(i > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(maxWidth[i]), false);
                                ++i;
                            }
                            this.condlPrintln("", false);
                        }
                    }
                    i = 0;
                    while (i < rows.size()) {
                        this.condlPrint(String.valueOf(SqlFile.htmlRow(i % 2 == 0 ? 2 : 1)) + SqlFile.LS + SqlFile.PRE_TD, true);
                        fieldArray = (String[])rows.get(i);
                        j = 0;
                        while (j < fieldArray.length) {
                            this.condlPrint("<TD>" + fieldArray[j] + "</TD>", true);
                            this.condlPrint(String.valueOf(j > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(fieldArray[j], maxWidth[j], rightJust[j], j < fieldArray.length - 1 || rightJust[j] != false), false);
                            ++j;
                        }
                        this.condlPrintln(String.valueOf(SqlFile.LS) + SqlFile.PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                        ++i;
                    }
                    this.condlPrintln("</TABLE>", true);
                    if (rows.size() != 1) {
                        this.stdprintln(String.valueOf(SqlFile.LS) + this.rb.getString(SqltoolRB.ROWS_FETCHED, rows.size()), true);
                    }
                    this.condlPrintln("<HR>", true);
                    break;
                }
                if (incCount > 0) {
                    i = 0;
                    while (i < headerArray.length) {
                        this.dsvSafe(headerArray[i]);
                        this.pwDsv.print(headerArray[i]);
                        if (i < headerArray.length - 1) {
                            this.pwDsv.print(this.dsvColDelim);
                        }
                        ++i;
                    }
                    this.pwDsv.print(this.dsvRowDelim);
                }
                i = 0;
                while (i < rows.size()) {
                    fieldArray = (String[])rows.get(i);
                    j = 0;
                    while (j < fieldArray.length) {
                        this.dsvSafe(fieldArray[j]);
                        this.pwDsv.print(fieldArray[j] == null ? (autonulls[j] ? "" : this.nullRepToken) : fieldArray[j]);
                        if (j < fieldArray.length - 1) {
                            this.pwDsv.print(this.dsvColDelim);
                        }
                        ++j;
                    }
                    this.pwDsv.print(this.dsvRowDelim);
                    ++i;
                }
                this.stdprintln(this.rb.getString(SqltoolRB.ROWS_FETCHED_DSV, rows.size()));
                break;
            }
            default: {
                this.userVars.put("?", Integer.toString(updateCount));
                if (this.fetchingVar != null) {
                    this.userVars.put(this.fetchingVar, this.userVars.get("?"));
                    this.updateUserSettings();
                    this.fetchingVar = null;
                }
                if (updateCount == 0) break;
                this.stdprintln(updateCount == 1 ? this.rb.getString(SqltoolRB.ROW_UPDATE_SINGULAR) : this.rb.getString(SqltoolRB.ROW_UPDATE_MULTIPLE, updateCount));
            }
        }
    }

    private static String htmlRow(int colType) {
        switch (colType) {
            case 0: {
                return String.valueOf(PRE_TR) + "<TR style='font-weight: bold;'>";
            }
            case 1: {
                return String.valueOf(PRE_TR) + "<TR style='background: #94d6ef; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
            case 2: {
                return String.valueOf(PRE_TR) + "<TR style='background: silver; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
        }
        return null;
    }

    private static String divider(int len) {
        return len > DIVIDER.length() ? DIVIDER : DIVIDER.substring(0, len);
    }

    private static String spaces(int len) {
        return len > SPACES.length() ? SPACES : SPACES.substring(0, len);
    }

    private static String pad(String inString, int fulllen, boolean rightJustify, boolean doPad) {
        if (!doPad) {
            return inString;
        }
        int len = fulllen - inString.length();
        if (len < 1) {
            return inString;
        }
        String pad = SqlFile.spaces(len);
        return String.valueOf(rightJustify ? pad : "") + inString + (rightJustify ? "" : pad);
    }

    private void showHistory() throws BadSpecial {
        if (this.history == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UNAVAILABLE));
        }
        if (this.history.size() < 1) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_NONE));
        }
        int i = 0;
        while (i < this.history.size()) {
            this.psStd.println(DEFAULT_SKIP_PREFIX + (i + this.oldestHist) + " or " + (i - this.history.size()) + ':');
            this.psStd.println((String)this.history.get(i));
            ++i;
        }
        if (this.buffer != null) {
            this.psStd.println(this.rb.getString(SqltoolRB.EDITBUFFER_CONTENTS, this.buffer));
        }
        this.psStd.println();
        this.psStd.println(this.rb.getString(SqltoolRB.BUFFER_INSTRUCTIONS));
    }

    private String commandFromHistory(int inIndex) throws BadSpecial {
        int index = inIndex;
        if (this.history == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UNAVAILABLE));
        }
        if (index == 0) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_NUMBER_REQ));
        }
        if (index > 0) {
            if ((index -= this.oldestHist) < 0) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_BACKTO, this.oldestHist));
            }
            if (index >= this.history.size()) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UPTO, this.history.size() + this.oldestHist - 1));
            }
        } else if ((index += this.history.size()) < 0) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_BACK, this.history.size()));
        }
        return (String)this.history.get(index);
    }

    private Integer historySearch(String findRegex) throws BadSpecial {
        if (this.history == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UNAVAILABLE));
        }
        Pattern pattern = Pattern.compile("(?ims)" + findRegex);
        int index = this.history.size() - 1;
        while (index >= 0) {
            if (pattern.matcher((String)this.history.get(index)).find()) {
                return new Integer(index + this.oldestHist);
            }
            --index;
        }
        return null;
    }

    private void setBuf(String newContent) {
        this.buffer = new String(newContent);
    }

    private void historize() {
        if (this.history == null || this.buffer == null) {
            return;
        }
        if (this.history.size() > 0 && this.history.get(this.history.size() - 1).equals(this.buffer)) {
            return;
        }
        this.history.add(this.buffer);
        if (this.history.size() <= this.maxHistoryLength) {
            return;
        }
        this.history.remove(0);
        ++this.oldestHist;
    }

    private void describe(String tableName, String inFilter) throws SQLException {
        String filter = inFilter;
        ArrayList<String[]> rows = new ArrayList<String[]>();
        String[] headerArray = new String[]{this.rb.getString(SqltoolRB.DESCRIBE_TABLE_NAME), this.rb.getString(SqltoolRB.DESCRIBE_TABLE_DATATYPE), this.rb.getString(SqltoolRB.DESCRIBE_TABLE_WIDTH), this.rb.getString(SqltoolRB.DESCRIBE_TABLE_NONULLS)};
        int[] maxWidth = new int[4];
        boolean[] blArray = new boolean[4];
        blArray[2] = true;
        boolean[] rightJust = blArray;
        int i = 0;
        while (i < headerArray.length) {
            if (!this.htmlMode && headerArray[i].length() > maxWidth[i]) {
                maxWidth[i] = headerArray[i].length();
            }
            ++i;
        }
        Statement statement = this.curConn.createStatement();
        ResultSet r = null;
        try {
            int j;
            String[] fieldArray;
            statement.execute("SELECT * FROM " + tableName + " WHERE 1 = 2");
            r = statement.getResultSet();
            ResultSetMetaData m = r.getMetaData();
            int cols = m.getColumnCount();
            int i2 = 0;
            while (i2 < cols) {
                fieldArray = new String[4];
                fieldArray[0] = m.getColumnName(i2 + 1);
                if (filter == null || fieldArray[0].indexOf(filter) >= 0) {
                    fieldArray[1] = m.getColumnTypeName(i2 + 1);
                    fieldArray[2] = Integer.toString(m.getColumnDisplaySize(i2 + 1));
                    fieldArray[3] = m.isNullable(i2 + 1) == 1 ? (this.htmlMode ? "&nbsp;" : "") : "*";
                    rows.add(fieldArray);
                    j = 0;
                    while (j < fieldArray.length) {
                        if (fieldArray[j].length() > maxWidth[j]) {
                            maxWidth[j] = fieldArray[j].length();
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            this.condlPrint("<TABLE border='1'>" + LS + SqlFile.htmlRow(0) + LS + PRE_TD, true);
            i2 = 0;
            while (i2 < headerArray.length) {
                this.condlPrint("<TD>" + headerArray[i2] + "</TD>", true);
                this.condlPrint(String.valueOf(i2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(headerArray[i2], maxWidth[i2], rightJust[i2], i2 < headerArray.length - 1 || rightJust[i2]), false);
                ++i2;
            }
            this.condlPrintln(String.valueOf(LS) + PRE_TR + "</TR>", true);
            this.condlPrintln("", false);
            if (!this.htmlMode) {
                i2 = 0;
                while (i2 < headerArray.length) {
                    this.condlPrint(String.valueOf(i2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(maxWidth[i2]), false);
                    ++i2;
                }
                this.condlPrintln("", false);
            }
            i2 = 0;
            while (i2 < rows.size()) {
                this.condlPrint(String.valueOf(SqlFile.htmlRow(i2 % 2 == 0 ? 2 : 1)) + LS + PRE_TD, true);
                fieldArray = (String[])rows.get(i2);
                j = 0;
                while (j < fieldArray.length) {
                    this.condlPrint("<TD>" + fieldArray[j] + "</TD>", true);
                    this.condlPrint(String.valueOf(j > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(fieldArray[j], maxWidth[j], rightJust[j], j < fieldArray.length - 1 || rightJust[j]), false);
                    ++j;
                }
                this.condlPrintln(String.valueOf(LS) + PRE_TR + "</TR>", true);
                this.condlPrintln("", false);
                ++i2;
            }
            this.condlPrintln(String.valueOf(LS) + "</TABLE>" + LS + "<HR>", true);
        }
        catch (Throwable throwable) {
            try {
                if (r != null) {
                    r.close();
                    r = null;
                }
                statement.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (r != null) {
                r.close();
                r = null;
            }
            statement.close();
        }
        catch (Exception exception) {}
    }

    private boolean eval(String[] inTokens) throws BadSpecial {
        boolean negate = inTokens.length > 0 && inTokens[0].equals("!");
        String[] tokens = new String[negate ? inTokens.length - 1 : inTokens.length];
        int i = 0;
        while (i < tokens.length) {
            String inToken = inTokens[i + (negate ? 1 : 0)];
            tokens[i] = inToken.length() > 1 && inToken.charAt(0) == '*' ? (String)this.userVars.get(inToken.substring(1)) : inTokens[i + (negate ? 1 : 0)];
            if (tokens[i] == null) {
                tokens[i] = "";
            }
            ++i;
        }
        if (tokens.length == 1) {
            return (tokens[0].length() > 0 && !tokens[0].equals("0")) ^ negate;
        }
        if (tokens.length == 3) {
            if (tokens[1].equals("==")) {
                return tokens[0].equals(tokens[2]) ^ negate;
            }
            if (tokens[1].equals("!=") || tokens[1].equals("<>") || tokens[1].equals("><")) {
                return !tokens[0].equals(tokens[2]) ^ negate;
            }
            if (tokens[1].equals(">")) {
                return (tokens[0].length() > tokens[2].length() || tokens[0].length() == tokens[2].length() && tokens[0].compareTo(tokens[2]) > 0) ^ negate;
            }
            if (tokens[1].equals("<")) {
                return (tokens[2].length() > tokens[0].length() || tokens[2].length() == tokens[0].length() && tokens[2].compareTo(tokens[0]) > 0) ^ negate;
            }
        }
        throw new BadSpecial(this.rb.getString(SqltoolRB.LOGICAL_UNRECOGNIZED));
    }

    private void closeQueryOutputStream() {
        if (this.pwQuery == null) {
            return;
        }
        if (this.htmlMode) {
            this.pwQuery.println("</BODY></HTML>");
            this.pwQuery.flush();
        }
        this.pwQuery.close();
        this.pwQuery = null;
    }

    private void condlPrintln(String s, boolean printHtml) {
        if (printHtml && !this.htmlMode || this.htmlMode && !printHtml) {
            return;
        }
        this.psStd.println(s);
        if (this.pwQuery != null) {
            this.pwQuery.println(s);
            this.pwQuery.flush();
        }
    }

    private void condlPrint(String s, boolean printHtml) {
        if (printHtml && !this.htmlMode || this.htmlMode && !printHtml) {
            return;
        }
        this.psStd.print(s);
        if (this.pwQuery != null) {
            this.pwQuery.print(s);
            this.pwQuery.flush();
        }
    }

    private String formatNicely(Map map, boolean withValues) {
        StringBuffer sb = new StringBuffer();
        Iterator it = new TreeMap(map).keySet().iterator();
        if (withValues) {
            SqlFile.appendLine(sb, this.rb.getString(SqltoolRB.PL_LIST_PARENS));
        } else {
            SqlFile.appendLine(sb, this.rb.getString(SqltoolRB.PL_LIST_LENGTHS));
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            String s = (String)map.get(key);
            SqlFile.appendLine(sb, "    " + key + ": " + (withValues ? "(" + s + ')' : Integer.toString(s.length())));
        }
        return sb.toString();
    }

    private void dump(String varName, File dumpFile) throws IOException, BadSpecial {
        String val = (String)this.userVars.get(varName);
        if (val == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, varName));
        }
        OutputStreamWriter osw = this.charset == null ? new OutputStreamWriter(new FileOutputStream(dumpFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(dumpFile), this.charset);
        try {
            char lastChar;
            osw.write(val);
            if (val.length() > 0 && (lastChar = val.charAt(val.length() - 1)) != '\n' && lastChar != '\r') {
                osw.write(LS);
            }
            osw.flush();
        }
        finally {
            osw.close();
        }
        this.stdprintln(this.rb.getString(SqltoolRB.FILE_WROTECHARS, Long.toString(dumpFile.length()), dumpFile.toString()));
    }

    private void dump(File dumpFile) throws IOException, BadSpecial {
        if (this.binBuffer == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.BINBUFFER_EMPTY));
        }
        FileOutputStream fos = new FileOutputStream(dumpFile);
        int len = 0;
        try {
            fos.write(this.binBuffer);
            len = this.binBuffer.length;
            this.binBuffer = null;
            fos.flush();
        }
        finally {
            fos.close();
        }
        this.stdprintln(this.rb.getString(SqltoolRB.FILE_WROTECHARS, len, dumpFile.toString()));
    }

    /*
     * Exception decompiling
     */
    public String streamToString(InputStream is, String cs) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void load(String varName, File asciiFile, String cs) throws IOException {
        String string = this.streamToString(new FileInputStream(asciiFile), cs);
        this.userVars.put(varName, string);
        this.updateUserSettings();
    }

    public static byte[] streamToBytes(InputStream is) throws IOException {
        int i;
        byte[] xferBuffer = new byte[10240];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((i = is.read(xferBuffer)) > 0) {
            baos.write(xferBuffer, 0, i);
        }
        return baos.toByteArray();
    }

    public static byte[] loadBinary(File binFile) throws IOException {
        byte[] xferBuffer = new byte[10240];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream fis = new FileInputStream(binFile);
        try {
            int i;
            while ((i = fis.read(xferBuffer)) > 0) {
                baos.write(xferBuffer, 0, i);
            }
        }
        finally {
            fis.close();
        }
        byte[] ba = baos.toByteArray();
        return ba;
    }

    public static boolean canDisplayType(int i) {
        switch (i) {
            case 1111: 
            case 2000: 
            case 2002: 
            case 2004: {
                return false;
            }
        }
        return true;
    }

    public static String sqlTypeToString(int i) {
        switch (i) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "Unknown type " + i;
    }

    public void dsvSafe(String s) throws SqlToolError {
        if (this.pwDsv == null || this.dsvColDelim == null || this.dsvRowDelim == null || this.nullRepToken == null) {
            throw new RuntimeException("Assertion failed.  \ndsvSafe called when DSV settings are incomplete");
        }
        if (s == null) {
            return;
        }
        if (s.indexOf(this.dsvColDelim) > 0) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_COLDELIM_PRESENT, this.dsvColDelim));
        }
        if (s.indexOf(this.dsvRowDelim) > 0) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_ROWDELIM_PRESENT, this.dsvRowDelim));
        }
        if (s.trim().equals(this.nullRepToken)) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_NULLREP_PRESENT, this.nullRepToken));
        }
    }

    public static String convertEscapes(String inString) {
        if (inString == null) {
            return null;
        }
        return SqlFile.convertNumericEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(inString, "\\n", "\n"), "\\r", "\r"), "\\t", "\t"), "\\\\", "\\"), "\\f", "\f"));
    }

    /*
     * Unable to fully structure code
     */
    private static String convertNumericEscapes(String string) {
        workString = string;
        i = 0;
        dig = '0';
        ** GOTO lbl15
        {
            workString = SqlFile.convertNumericEscape(string, i);
            do {
                if ((i = workString.indexOf("\\" + dig, i)) > -1 && i < workString.length() - 1) continue block0;
                while ((i = workString.indexOf("\\x" + dig, i)) > -1 && i < workString.length() - 1) {
                    workString = SqlFile.convertNumericEscape(string, i);
                }
                while ((i = workString.indexOf("\\X" + dig, i)) > -1 && i < workString.length() - 1) {
                    workString = SqlFile.convertNumericEscape(string, i);
                }
                dig = (char)(dig + '\u0001');
lbl15:
                // 2 sources

            } while (dig <= 57);
        }
        return workString;
    }

    private static String convertNumericEscape(String string, int offset) {
        int post = -1;
        int firstDigit = -1;
        int radix = -1;
        if (Character.toUpperCase(string.charAt(offset + 1)) == 'X') {
            firstDigit = offset + 2;
            radix = 16;
            post = firstDigit + 2;
            if (post > string.length()) {
                post = string.length();
            }
        } else {
            firstDigit = offset + 1;
            radix = Character.toUpperCase(string.charAt(firstDigit)) == '0' ? 8 : 10;
            post = firstDigit + 1;
            while (post < string.length() && Character.isDigit(string.charAt(post))) {
                ++post;
            }
        }
        return String.valueOf(string.substring(0, offset)) + (char)Integer.parseInt(string.substring(firstDigit, post), radix) + string.substring(post);
    }

    private static String convertEscapes(String string, String from, String to) {
        String workString = string;
        int i = 0;
        int fromLen = from.length();
        while ((i = workString.indexOf(from, i)) > -1 && i < workString.length() - 1) {
            workString = String.valueOf(workString.substring(0, i)) + to + workString.substring(i + fromLen);
        }
        return workString;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importDsv(String filePath, String skipPrefix) throws SqlToolError {
        block123: {
            block122: {
                block121: {
                    bfr = null;
                    file = new File(filePath);
                    constColMap = null;
                    if (this.dsvConstCols != null) {
                        constColMap = new TreeMap<String, String>();
                        constPairs = this.dsvConstCols.split("\\Q" + this.dsvColDelim + "\\E\\s*");
                        i = 0;
                        while (i < constPairs.length) {
                            firstEq = constPairs[i].indexOf(61);
                            n = constPairs[i].substring(0, firstEq).trim().toLowerCase();
                            if (n.trim().length() < 1) {
                                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_CONSTCOLS_NULLCOL));
                            }
                            constColMap.put(n, constPairs[i].substring(firstEq + 1));
                            ++i;
                        }
                    }
                    skipCols = null;
                    if (this.dsvSkipCols != null) {
                        skipCols = new HashSet<String>();
                        skipColsArray = this.dsvSkipCols.split("\\s*\\Q" + this.dsvColDelim + "\\E\\s*");
                        i = 0;
                        while (i < skipColsArray.length) {
                            skipCols.add(skipColsArray[i].toLowerCase());
                            ++i;
                        }
                    }
                    if (!file.canRead()) {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.FILE_READFAIL, file.toString()));
                    }
                    try {
                        bfr = new byte[(int)file.length()];
                    }
                    catch (RuntimeException re) {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.READ_TOOBIG), re);
                    }
                    bytesread = 0;
                    is = null;
                    try {
                        try {
                            is = new FileInputStream(file);
                            while (bytesread < bfr.length && (retval = is.read(bfr, bytesread, bfr.length - bytesread)) > 0) {
                                bytesread += retval;
                            }
                        }
                        catch (IOException ioe) {
                            throw new SqlToolError(ioe);
                        }
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException ioe) {
                                this.errprintln(String.valueOf(this.rb.getString(SqltoolRB.INPUTFILE_CLOSEFAIL)) + ": " + ioe);
                            }
                        }
                    }
                    if (bytesread != bfr.length) {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.READ_PARTIAL, bytesread, bfr.length));
                    }
                    string = null;
                    try {
                        string = this.charset == null ? new String(bfr) : new String(bfr, this.charset);
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new RuntimeException(uee);
                    }
                    catch (RuntimeException re) {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.READ_CONVERTFAIL), re);
                    }
                    headerList = new ArrayList<String>();
                    tableName = this.dsvTargetTable;
                    recEnd = -1000;
                    lineCount = 0;
                    recStart = -1;
                    trimmedLine = null;
                    switching = false;
                    while (true) {
                        v0 = recStart = recStart < 0 ? 0 : recEnd + this.dsvRowDelim.length();
                        if (recStart > string.length() - 2) {
                            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NONE));
                        }
                        recEnd = string.indexOf(this.dsvRowDelim, recStart);
                        ++lineCount;
                        if (recEnd < 0) {
                            recEnd = string.length();
                        }
                        if ((trimmedLine = string.substring(recStart, recEnd).trim()).length() < 1 || skipPrefix != null && trimmedLine.startsWith(skipPrefix)) continue;
                        if (trimmedLine.startsWith("targettable=")) {
                            if (tableName != null) continue;
                            tableName = trimmedLine.substring("targettable=".length()).trim();
                            continue;
                        }
                        if (trimmedLine.equals("headerswitch{")) {
                            if (tableName == null) {
                                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NOSWITCHTARG, lineCount));
                            }
                            switching = true;
                            continue;
                        }
                        if (trimmedLine.equals("}")) {
                            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NOSWITCHMATCH, lineCount));
                        }
                        if (!switching) break block121;
                        colonAt = trimmedLine.indexOf(58);
                        if (colonAt < 1) throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NONSWITCHED, lineCount));
                        if (colonAt == trimmedLine.length() - 1) {
                            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NONSWITCHED, lineCount));
                        }
                        matcher = trimmedLine.substring(0, colonAt).trim();
                        if (matcher.equals("*") || matcher.equalsIgnoreCase(tableName)) break;
                    }
                    recStart = 1 + string.indexOf(58, recStart);
                }
                headerLine = string.substring(recStart, recEnd);
                colStart = recStart;
                colEnd = -1;
                while (true) {
                    if (colEnd == recEnd) {
                        if (skipCols != null) {
                            break;
                        }
                        break block122;
                    }
                    colEnd = string.indexOf(this.dsvColDelim, colStart);
                    if (colEnd < 0 || colEnd > recEnd) {
                        colEnd = recEnd;
                    }
                    if (colEnd - colStart < 1) {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_NOCOLHEADER, headerList.size() + 1, lineCount));
                    }
                    colName = string.substring(colStart, colEnd).trim().toLowerCase();
                    headerList.add(colName.equals("-") != false || skipCols != null && skipCols.remove(colName) != false || constColMap != null && constColMap.containsKey(colName) != false ? null : colName);
                    colStart = colEnd + this.dsvColDelim.length();
                }
                if (skipCols.size() > 0) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_SKIPCOLS_MISSING, skipCols.toString()));
                }
            }
            oneCol = false;
            i = 0;
            while (i < headerList.size()) {
                if (headerList.get(i) != null) {
                    oneCol = true;
                    break;
                }
                ++i;
            }
            if (!oneCol) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_NOCOLSLEFT, this.dsvSkipCols));
            }
            inputColHeadCount = headerList.size();
            if (constColMap != null) {
                headerList.addAll(constColMap.keySet());
            }
            headers = headerList.toArray(new String[0]);
            if (tableName == null && (i = (tableName = file.getName()).lastIndexOf(46)) > 0) {
                tableName = tableName.substring(0, i);
            }
            tmpSb = new StringBuffer();
            tmpList = new ArrayList<String>();
            skippers = 0;
            i = 0;
            while (true) {
                if (i >= headers.length) {
                    autonulls = new boolean[headers.length - skippers];
                    parseDate = new boolean[autonulls.length];
                    parseBool = new boolean[autonulls.length];
                    insertFieldName = tmpList.toArray(new String[0]);
                    sb = new StringBuffer("INSERT INTO " + tableName + " (" + tmpSb + ") VALUES (");
                    typeQuerySb = new StringBuffer("SELECT " + tmpSb + " FROM " + tableName + " WHERE 1 = 2");
                    ** try [egrp 6[TRYBLOCK] [7 : 1556->1786)] { 
lbl152:
                    // 1 sources

                    break;
                }
                if (headers[i] == null) {
                    ++skippers;
                } else {
                    if (tmpSb.length() > 0) {
                        tmpSb.append(", ");
                    }
                    tmpSb.append(headers[i]);
                    tmpList.add(headers[i]);
                }
                ++i;
            }
            {
                rsmd = this.curConn.createStatement().executeQuery(typeQuerySb.toString()).getMetaData();
                if (rsmd.getColumnCount() != autonulls.length) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_METADATA_MISMATCH));
                }
                i = 0;
                while (i < autonulls.length) {
                    autonulls[i] = true;
                    parseDate[i] = false;
                    parseBool[i] = false;
                    switch (rsmd.getColumnType(i + 1)) {
                        case 16: {
                            parseBool[i] = true;
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -1: 
                        case 12: 
                        case 2003: 
                        case 2004: 
                        case 2005: {
                            autonulls[i] = false;
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            parseDate[i] = true;
                            break;
                        }
                    }
                    ++i;
                }
            }
lbl186:
            // 1 sources

            catch (SQLException se) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.QUERY_METADATAFAIL, typeQuerySb.toString()), se);
            }
            i = 0;
            while (true) {
                if (i >= autonulls.length) {
                    rejectCount = 0;
                    rejectFile = null;
                    rejectReportFile = null;
                    rejectWriter = null;
                    rejectReportWriter = null;
                    if (this.dsvRejectFile != null) {
                        ** try [egrp 7[TRYBLOCK] [8 : 1874->1972)] { 
lbl198:
                        // 1 sources

                        break;
                    }
                    break block123;
                }
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append('?');
                ++i;
            }
            {
                rejectFile = new File(this.dsvRejectFile);
                rejectWriter = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(rejectFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(rejectFile), this.charset));
                rejectWriter.print(String.valueOf(headerLine) + this.dsvRowDelim);
            }
lbl211:
            // 1 sources

            catch (IOException ioe) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_REJECTFILE_SETUPFAIL, this.dsvRejectFile), ioe);
            }
        }
        if (this.dsvRejectReport != null) {
            try {
                rejectReportFile = new File(this.dsvRejectReport);
                rejectReportWriter = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(rejectReportFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(rejectReportFile), this.charset));
                rejectReportWriter.println(this.rb.getString(SqltoolRB.REJECTREPORT_TOP, new String[]{new Date().toString(), file.getPath(), rejectFile == null ? this.rb.getString(SqltoolRB.NONE) : rejectFile.getPath(), rejectFile == null ? null : rejectFile.getPath()}));
            }
            catch (IOException ioe) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_REJECTREPORT_SETUPFAIL, this.dsvRejectReport), ioe);
            }
        }
        recCount = 0;
        skipCount = 0;
        ps = null;
        importAborted = false;
        try {
            try {
                ps = this.curConn.prepareStatement(String.valueOf(sb.toString()) + ')');
            }
            catch (SQLException se) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.INSERTION_PREPAREFAIL, sb.toString()), se);
            }
            dataVals = new String[autonulls.length];
            currentFieldName = null;
            while (true) {
                try {
                    try {
                        while ((recStart = recEnd + this.dsvRowDelim.length()) < string.length()) {
                            recEnd = string.indexOf(this.dsvRowDelim, recStart);
                            ++lineCount;
                            if (recEnd < 0) {
                                recEnd = string.length();
                            }
                            if ((trimmedLine = string.substring(recStart, recEnd).trim()).length() < 1) continue;
                            if (skipPrefix != null && trimmedLine.startsWith(skipPrefix)) {
                                ++skipCount;
                                continue;
                            }
                            if (switching) {
                                if (trimmedLine.equals("}")) {
                                    switching = false;
                                    continue;
                                }
                                colonAt = trimmedLine.indexOf(58);
                                if (colonAt < 1) throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_MATCHERNONHEAD, lineCount));
                                if (colonAt != trimmedLine.length() - 1) continue;
                                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_MATCHERNONHEAD, lineCount));
                            }
                            ++recCount;
                            colStart = recStart;
                            colEnd = -1;
                            readColCount = 0;
                            storeColCount = 0;
                            while (true) {
                                if (colEnd == recEnd) {
                                    if (readColCount < inputColHeadCount) {
                                        throw new RowError(this.rb.getString(SqltoolRB.DSV_COLCOUNT_MISMATCH, inputColHeadCount, readColCount));
                                    }
                                    break;
                                }
                                colEnd = string.indexOf(this.dsvColDelim, colStart);
                                if (colEnd < 0 || colEnd > recEnd) {
                                    colEnd = recEnd;
                                }
                                if (readColCount == inputColHeadCount) {
                                    throw new RowError(this.rb.getString(SqltoolRB.DSV_COLCOUNT_MISMATCH, inputColHeadCount, 1 + readColCount));
                                }
                                if (headers[readColCount++] != null) {
                                    dataVals[storeColCount++] = string.substring(colStart, colEnd);
                                }
                                colStart = colEnd + this.dsvColDelim.length();
                            }
                            if (constColMap != null) {
                                it = constColMap.values().iterator();
                                while (it.hasNext()) {
                                    dataVals[storeColCount++] = (String)it.next();
                                }
                            }
                            if (storeColCount != dataVals.length) {
                                throw new RowError(this.rb.getString(SqltoolRB.DSV_INSERTCOL_MISMATCH, dataVals.length, storeColCount));
                            }
                            i = 0;
                            while (true) {
                                if (i >= dataVals.length) {
                                    retval = ps.executeUpdate();
                                    if (retval == 1) break;
                                    throw new RowError(this.rb.getString(SqltoolRB.INPUTREC_MODIFIED, retval));
                                }
                                currentFieldName = insertFieldName[i];
                                if (autonulls[i]) {
                                    dataVals[i] = dataVals[i].trim();
                                }
                                if (parseDate[i]) {
                                    if (dataVals[i].length() < 1 && autonulls[i] || dataVals[i].equals(this.nullRepToken)) {
                                        ps.setTimestamp(i + 1, null);
                                    } else {
                                        dateString = dataVals[i].indexOf(58) > 0 ? dataVals[i] : String.valueOf(dataVals[i]) + " 0:00:00";
                                        try {
                                            ps.setTimestamp(i + 1, Timestamp.valueOf(dateString));
                                        }
                                        catch (IllegalArgumentException iae) {
                                            throw new RowError(this.rb.getString(SqltoolRB.TIME_BAD, dateString), iae);
                                        }
                                    }
                                } else if (parseBool[i]) {
                                    if (dataVals[i].length() < 1 && autonulls[i] || dataVals[i].equals(this.nullRepToken)) {
                                        ps.setNull(i + 1, 16);
                                    } else {
                                        try {
                                            ps.setBoolean(i + 1, Boolean.valueOf(dataVals[i]));
                                        }
                                        catch (IllegalArgumentException iae) {
                                            throw new RowError(this.rb.getString(SqltoolRB.BOOLEAN_BAD, dataVals[i]), iae);
                                        }
                                    }
                                } else {
                                    ps.setString(i + 1, dataVals[i].length() < 1 && autonulls[i] != false || dataVals[i].equals(this.nullRepToken) != false ? null : dataVals[i]);
                                }
                                currentFieldName = null;
                                ++i;
                            }
                            this.possiblyUncommitteds.set(true);
                        }
                    }
                    catch (SQLException se) {
                        throw new RowError(null, se);
                    }
                }
                catch (RowError re) {
                    ++rejectCount;
                    if (rejectWriter != null || rejectReportWriter != null) {
                        if (rejectWriter != null) {
                            rejectWriter.print(String.valueOf(string.substring(recStart, recEnd)) + this.dsvRowDelim);
                        }
                        if (rejectReportWriter == null) continue;
                        this.genRejectReportRecord(rejectReportWriter, rejectCount, lineCount, currentFieldName, re.getMessage(), re.getCause());
                        continue;
                    }
                    importAborted = true;
                    v1 = new StringBuilder(String.valueOf(this.rb.getString(SqltoolRB.DSV_RECIN_FAIL, lineCount, currentFieldName)));
                    if (re.getMessage() == null) {
                        v2 = "";
                        throw new SqlToolError(v1.append(v2).toString(), re.getCause());
                    }
                    v2 = "  " + re.getMessage();
                    throw new SqlToolError(v1.append(v2).toString(), re.getCause());
                }
                break;
            }
        }
        catch (Throwable var50_76) {
            summaryString = null;
            if (recCount > 0) {
                summaryString = this.rb.getString(SqltoolRB.DSV_IMPORT_SUMMARY, new String[]{skipPrefix == null ? "" : "'" + skipPrefix + "'-", Integer.toString(skipCount), Integer.toString(rejectCount), Integer.toString(recCount - rejectCount), importAborted != false ? "importAborted" : null});
                this.stdprintln(summaryString);
            }
            try {
                if (recCount > rejectCount && !this.curConn.getAutoCommit()) {
                    this.stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
                }
            }
            catch (SQLException v3) {
                this.stdprintln(this.rb.getString(SqltoolRB.AUTOCOMMIT_FETCHFAIL));
                this.stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
            }
            if (rejectWriter != null) {
                rejectWriter.flush();
                rejectWriter.close();
            }
            if (rejectReportWriter != null && rejectCount > 0) {
                rejectReportWriter.println(this.rb.getString(SqltoolRB.REJECTREPORT_BOTTOM, summaryString, SqlFile.revnum));
                rejectReportWriter.flush();
                rejectReportWriter.close();
            }
            if (rejectCount != 0) throw var50_76;
            if (rejectFile != null && rejectFile.exists() && !rejectFile.delete()) {
                this.errprintln(this.rb.getString(SqltoolRB.DSV_REJECTFILE_PURGEFAIL, rejectFile.toString()));
            }
            if (rejectReportFile == null) throw var50_76;
            if (rejectReportFile.delete() != false) throw var50_76;
            this.errprintln(this.rb.getString(SqltoolRB.DSV_REJECTREPORT_PURGEFAIL, rejectFile == null ? null : rejectFile.toString()));
            throw var50_76;
        }
        summaryString = null;
        if (recCount > 0) {
            summaryString = this.rb.getString(SqltoolRB.DSV_IMPORT_SUMMARY, new String[]{skipPrefix == null ? "" : "'" + skipPrefix + "'-", Integer.toString(skipCount), Integer.toString(rejectCount), Integer.toString(recCount - rejectCount), importAborted != false ? "importAborted" : null});
            this.stdprintln(summaryString);
        }
        try {
            if (recCount > rejectCount && !this.curConn.getAutoCommit()) {
                this.stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
            }
        }
        catch (SQLException v4) {
            this.stdprintln(this.rb.getString(SqltoolRB.AUTOCOMMIT_FETCHFAIL));
            this.stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
        }
        if (rejectWriter != null) {
            rejectWriter.flush();
            rejectWriter.close();
        }
        if (rejectReportWriter != null && rejectCount > 0) {
            rejectReportWriter.println(this.rb.getString(SqltoolRB.REJECTREPORT_BOTTOM, summaryString, SqlFile.revnum));
            rejectReportWriter.flush();
            rejectReportWriter.close();
        }
        if (rejectCount != 0) return;
        if (rejectFile != null && rejectFile.exists() && !rejectFile.delete()) {
            this.errprintln(this.rb.getString(SqltoolRB.DSV_REJECTFILE_PURGEFAIL, rejectFile.toString()));
        }
        if (rejectReportFile == null) return;
        if (rejectReportFile.delete() != false) return;
        this.errprintln(this.rb.getString(SqltoolRB.DSV_REJECTREPORT_PURGEFAIL, rejectFile == null ? null : rejectFile.toString()));
    }

    public static void appendLine(StringBuffer sb, String s) {
        sb.append(String.valueOf(s) + LS);
    }

    private static String[] genWinArgs(String monolithic) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("cmd.exe");
        list.add("/y");
        list.add("/c");
        Matcher m = wincmdPattern.matcher(monolithic);
        while (m.find()) {
            int i = 1;
            while (i <= m.groupCount()) {
                if (m.group(i) != null) {
                    if (m.group(i).length() > 1 && m.group(i).charAt(0) == '\"') {
                        list.add(m.group(i).substring(1, m.group(i).length() - 1));
                    } else {
                        String[] internalTokens = m.group(i).split("\\s+");
                        int j = 0;
                        while (j < internalTokens.length) {
                            list.add(internalTokens[j]);
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return list.toArray(new String[0]);
    }

    private void genRejectReportRecord(PrintWriter pw, int rCount, int lCount, String field, String eMsg, Throwable cause) {
        pw.println(this.rb.getString(SqltoolRB.REJECTREPORT_ROW, new String[]{String.valueOf(rCount % 2 == 0 ? "even" : "odd") + "row", Integer.toString(rCount), Integer.toString(lCount), field == null ? "&nbsp;" : field, String.valueOf(eMsg == null ? "" : eMsg) + (eMsg == null || cause == null ? "" : "<HR/>") + (cause == null ? "" : (cause instanceof SQLException && cause.getMessage() != null ? cause.getMessage() : cause.toString()))}));
    }

    private static class BadSpecial
    extends AppendableException {
        static final long serialVersionUID = 7162440064026570590L;

        BadSpecial(String s) {
            super(s);
            if (s == null) {
                throw new RuntimeException("Must construct BadSpecials with non-null message");
            }
        }

        BadSpecial(String s, Throwable t) {
            super(s, t);
            if (s == null) {
                throw new RuntimeException("Must construct BadSpecials with non-null message");
            }
        }
    }

    private class BadSubst
    extends Exception {
        static final long serialVersionUID = 7325933736897253269L;

        BadSubst(String s) {
            super(s);
        }
    }

    private static class BooleanBucket {
        private boolean bPriv = false;

        BooleanBucket() {
        }

        public void set(boolean bIn) {
            this.bPriv = bIn;
        }

        public boolean get() {
            return this.bPriv;
        }
    }

    private class BreakException
    extends SqlToolError {
        static final long serialVersionUID = 351150072817675994L;

        public BreakException() {
        }

        public BreakException(String s) {
            super(s);
        }
    }

    private class ContinueException
    extends SqlToolError {
        static final long serialVersionUID = 5064604160827106014L;

        public ContinueException() {
        }

        public ContinueException(String s) {
            super(s);
        }
    }

    private class QuitNow
    extends SqlToolError {
        static final long serialVersionUID = 1811094258670900488L;

        public QuitNow(String s) {
            super(s);
        }

        public QuitNow() {
        }
    }

    private class RowError
    extends AppendableException {
        static final long serialVersionUID = 754346434606022750L;

        RowError(String s) {
            super(s);
        }

        RowError(Throwable t) {
            this(null, t);
        }

        RowError(String s, Throwable t) {
            super(s, t);
        }
    }
}

