/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.hsqldb.util.CommonSwing;
import org.hsqldb.util.ConnectionDialogCommon;
import org.hsqldb.util.ConnectionSetting;

class ConnectionDialogSwing
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private Connection mConnection;
    private JTextField mName;
    private JTextField mDriver;
    private JTextField mURL;
    private JTextField mUser;
    private JPasswordField mPassword;
    private String[][] connTypes;
    private Hashtable settings;
    private JButton okCancel;
    private JButton clear;
    private JComboBox mSettingName = new JComboBox(this.loadRecentConnectionSettings());
    private static ConnectionSetting currentConnectionSetting = null;

    public static void setConnectionSetting(ConnectionSetting connectionSetting) {
        currentConnectionSetting = connectionSetting;
    }

    public static Connection createConnection(String driver, String url, String user, String password) throws Exception {
        Class.forName(driver).newInstance();
        return DriverManager.getConnection(url, user, password);
    }

    ConnectionDialogSwing(JFrame owner, String title) {
        super(owner, title, true);
    }

    private void create() {
        Box main = Box.createHorizontalBox();
        Box labels = Box.createVerticalBox();
        Box controls = Box.createVerticalBox();
        Box buttons = Box.createHorizontalBox();
        Box whole = Box.createVerticalBox();
        Box extra = Box.createHorizontalBox();
        main.add(Box.createHorizontalStrut(10));
        main.add(Box.createHorizontalGlue());
        main.add(labels);
        main.add(Box.createHorizontalStrut(10));
        main.add(Box.createHorizontalGlue());
        main.add(controls);
        main.add(Box.createHorizontalStrut(10));
        main.add(Box.createVerticalGlue());
        main.add(extra);
        main.add(Box.createVerticalGlue());
        whole.add(Box.createVerticalGlue());
        whole.add(Box.createVerticalStrut(10));
        whole.add(main);
        whole.add(Box.createVerticalGlue());
        whole.add(Box.createVerticalStrut(10));
        whole.add(buttons);
        whole.add(Box.createVerticalGlue());
        whole.add(Box.createVerticalStrut(10));
        whole.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("Recent Setting:"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("Setting Name:"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("Type:"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("Driver:"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("URL:"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("User:"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("Password:"));
        labels.add(Box.createVerticalGlue());
        labels.add(Box.createVerticalStrut(10));
        controls.add(Box.createVerticalGlue());
        this.mSettingName.setActionCommand("Select Setting");
        this.mSettingName.addActionListener(this);
        controls.add(this.mSettingName);
        controls.add(Box.createHorizontalGlue());
        this.mName = new JTextField();
        this.mName.addActionListener(this);
        controls.add(this.mName);
        this.clear = new JButton("Clear Names");
        this.clear.setActionCommand("Clear");
        this.clear.addActionListener(this);
        buttons.add(this.clear);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(Box.createHorizontalStrut(10));
        JComboBox<String> types = new JComboBox<String>();
        this.connTypes = ConnectionDialogCommon.getTypes();
        int i = 0;
        while (i < this.connTypes.length) {
            types.addItem(this.connTypes[i][0]);
            ++i;
        }
        types.addItemListener(this);
        controls.add(types);
        controls.add(Box.createVerticalGlue());
        this.mDriver = new JTextField(this.connTypes[0][1]);
        this.mDriver.addActionListener(this);
        controls.add(this.mDriver);
        this.mURL = new JTextField(this.connTypes[0][2]);
        this.mURL.addActionListener(this);
        controls.add(this.mURL);
        controls.add(Box.createVerticalGlue());
        this.mUser = new JTextField("sa");
        this.mUser.addActionListener(this);
        controls.add(this.mUser);
        controls.add(Box.createVerticalGlue());
        this.mPassword = new JPasswordField("");
        this.mPassword.addActionListener(this);
        controls.add(this.mPassword);
        controls.add(Box.createVerticalGlue());
        controls.add(Box.createVerticalStrut(10));
        buttons.add(Box.createHorizontalGlue());
        buttons.add(Box.createHorizontalStrut(10));
        this.okCancel = new JButton("     Ok      ");
        this.okCancel.setActionCommand("ConnectOk");
        this.okCancel.addActionListener(this);
        buttons.add(this.okCancel);
        this.getRootPane().setDefaultButton(this.okCancel);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(Box.createHorizontalStrut(20));
        this.okCancel = new JButton("  Cancel   ");
        this.okCancel.setActionCommand("ConnectCancel");
        this.okCancel.addActionListener(this);
        buttons.add(this.okCancel);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(Box.createHorizontalStrut(10));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add("Center", whole);
        this.getContentPane().add("Center", jPanel);
        this.doLayout();
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        if (currentConnectionSetting != null) {
            this.mName.setText(currentConnectionSetting.getName());
            this.mDriver.setText(currentConnectionSetting.getDriver());
            this.mURL.setText(currentConnectionSetting.getUrl());
            this.mUser.setText(currentConnectionSetting.getUser());
            this.mPassword.setText(currentConnectionSetting.getPassword());
        }
        if (d.width >= 640) {
            this.setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        } else {
            this.setLocation(0, 0);
            this.setSize(d);
        }
        this.setVisible(true);
    }

    public static Connection createConnection(JFrame owner, String title) {
        ConnectionDialogSwing dialog = new ConnectionDialogSwing(owner, title);
        try {
            SwingUtilities.updateComponentTreeUI(dialog);
        }
        catch (Exception e) {
            CommonSwing.errorMessage(e);
        }
        dialog.create();
        return dialog.mConnection;
    }

    private static JLabel createLabel(String s) {
        JLabel l = new JLabel(s);
        return l;
    }

    public Vector loadRecentConnectionSettings() {
        Vector<String> passSettings = new Vector<String>();
        this.settings = new Hashtable();
        try {
            this.settings = ConnectionDialogCommon.loadRecentConnectionSettings();
            Iterator it = this.settings.values().iterator();
            passSettings.add(ConnectionDialogCommon.emptySettingName);
            while (it.hasNext()) {
                passSettings.add(((ConnectionSetting)it.next()).getName());
            }
        }
        catch (IOException ioe) {
            CommonSwing.errorMessage(ioe);
        }
        return passSettings;
    }

    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s.equals("ConnectOk") || ev.getSource() instanceof JTextField) {
            try {
                if (this.mURL.getText().indexOf(171) >= 0) {
                    throw new Exception("please specify db path");
                }
                this.mConnection = ConnectionDialogSwing.createConnection(this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), new String(this.mPassword.getPassword()));
                if (this.mName.getText() != null && this.mName.getText().trim().length() != 0) {
                    ConnectionSetting newSetting = new ConnectionSetting(this.mName.getText(), this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), new String(this.mPassword.getPassword()));
                    ConnectionDialogCommon.addToRecentConnectionSettings(this.settings, newSetting);
                }
                this.dispose();
            }
            catch (SQLException e) {
                this.mConnection = null;
                CommonSwing.errorMessage(e, true);
            }
            catch (Exception e) {
                CommonSwing.errorMessage(e);
            }
        } else if (s.equals("Select Setting")) {
            String s2 = (String)this.mSettingName.getSelectedItem();
            ConnectionSetting setting = (ConnectionSetting)this.settings.get(s2);
            if (setting != null) {
                this.mName.setText(setting.getName());
                this.mDriver.setText(setting.getDriver());
                this.mURL.setText(setting.getUrl());
                this.mUser.setText(setting.getUser());
                this.mPassword.setText(setting.getPassword());
            }
        } else if (s.equals("ConnectCancel")) {
            this.dispose();
        } else if (s.equals("Clear")) {
            ConnectionDialogCommon.deleteRecentConnectionSettings();
            this.settings = new Hashtable();
            this.mSettingName.removeAllItems();
            this.mSettingName.addItem(ConnectionDialogCommon.emptySettingName);
            this.mName.setText(null);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        String s = (String)e.getItem();
        int i = 0;
        while (i < this.connTypes.length) {
            if (s.equals(this.connTypes[i][0])) {
                this.mDriver.setText(this.connTypes[i][1]);
                this.mURL.setText(this.connTypes[i][2]);
            }
            ++i;
        }
    }
}

