/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;

public class CodeSwitcher {
    private static final String ls = System.getProperty("line.separator", "\n");
    private Vector vList = new Vector();
    private Vector vSwitchOn = new Vector();
    private Vector vSwitchOff = new Vector();
    private Vector vSwitches = new Vector();
    private static final int MAX_LINELENGTH = 82;

    public static void main(String[] a) {
        CodeSwitcher s = new CodeSwitcher();
        if (a.length == 0) {
            CodeSwitcher.showUsage();
            return;
        }
        boolean path = false;
        int i = 0;
        while (i < a.length) {
            String p = a[i];
            if (p.startsWith("+")) {
                s.vSwitchOn.addElement(p.substring(1));
            } else if (p.startsWith("-")) {
                s.vSwitchOff.addElement(p.substring(1));
            } else {
                s.addDir(p);
                path = true;
            }
            ++i;
        }
        if (!path) {
            CodeSwitcher.printError("no path specified");
            CodeSwitcher.showUsage();
        }
        s.process();
        if (s.vSwitchOff.size() == 0 && s.vSwitchOn.size() == 0) {
            s.printSwitches();
        }
    }

    static void showUsage() {
        System.out.print("Usage: java CodeSwitcher [paths] [labels] [+][-]\nIf no labels are specified then all used\nlabels in the source code are shown.\nUse +MODE to switch on the things labeld MODE\nUse -MODE to switch off the things labeld MODE\nPath: Any number of path or files may be\nspecified. Use . for the current directory\n(including sub-directories).\nExample: java CodeSwitcher +JAVA2 .\nThis example switches on code labeled JAVA2\nin all *.java files in the current directory\nand all subdirectories.\n");
    }

    CodeSwitcher() {
    }

    void process() {
        int len = this.vList.size();
        int i = 0;
        while (i < len) {
            System.out.print(".");
            String file = (String)this.vList.elementAt(i);
            if (!this.processFile(file)) {
                System.out.println("in file " + file + " !");
            }
            ++i;
        }
        System.out.println("");
    }

    void printSwitches() {
        System.out.println("Used labels:");
        int i = 0;
        while (i < this.vSwitches.size()) {
            System.out.println((String)this.vSwitches.elementAt(i));
            ++i;
        }
    }

    void addDir(String path) {
        File f = new File(path);
        if (f.isFile() && path.endsWith(".java")) {
            this.vList.addElement(path);
        } else if (f.isDirectory()) {
            String[] list = f.list();
            int i = 0;
            while (i < list.length) {
                this.addDir(String.valueOf(path) + File.separatorChar + list[i]);
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean processFile(String name) {
        File f = new File(name);
        File fnew = new File(String.valueOf(name) + ".new");
        int state = 0;
        boolean switchoff = false;
        boolean working = false;
        try {
            Vector v = CodeSwitcher.getFileLines(f);
            Vector v1 = new Vector(v.size());
            int i = 0;
            while (i < v.size()) {
                v1.addElement(v.elementAt(i));
                ++i;
            }
            i = 0;
            while (i < v.size()) {
                String line = (String)v.elementAt(i);
                if (line == null) break;
                if (working && (line.equals("/*") || line.equals("*/"))) {
                    v.removeElementAt(i--);
                } else if (line.startsWith("//#")) {
                    if (line.startsWith("//#ifdef ")) {
                        if (state != 0) {
                            CodeSwitcher.printError("'#ifdef' not allowed inside '#ifdef'");
                            return false;
                        }
                        state = 1;
                        String s = line.substring(9);
                        if (this.vSwitchOn.indexOf(s) != -1) {
                            working = true;
                            switchoff = false;
                        } else if (this.vSwitchOff.indexOf(s) != -1) {
                            working = true;
                            v.insertElementAt("/*", ++i);
                            switchoff = true;
                        }
                        if (this.vSwitches.indexOf(s) == -1) {
                            this.vSwitches.addElement(s);
                        }
                    } else if (line.startsWith("//#else")) {
                        if (state != 1) {
                            CodeSwitcher.printError("'#else' without '#ifdef'");
                            return false;
                        }
                        state = 2;
                        if (working) {
                            if (switchoff) {
                                if (v.elementAt(i - 1).equals("")) {
                                    v.insertElementAt("*/", i - 1);
                                    ++i;
                                } else {
                                    v.insertElementAt("*/", i++);
                                }
                                switchoff = false;
                            } else {
                                v.insertElementAt("/*", ++i);
                                switchoff = true;
                            }
                        }
                    } else if (line.startsWith("//#endif")) {
                        if (state == 0) {
                            CodeSwitcher.printError("'#endif' without '#ifdef'");
                            return false;
                        }
                        state = 0;
                        if (working && switchoff) {
                            if (v.elementAt(i - 1).equals("")) {
                                v.insertElementAt("*/", i - 1);
                                ++i;
                            } else {
                                v.insertElementAt("*/", i++);
                            }
                        }
                        working = false;
                    }
                }
                ++i;
            }
            if (state != 0) {
                CodeSwitcher.printError("'#endif' missing");
                return false;
            }
            boolean filechanged = false;
            int i2 = 0;
            while (i2 < v.size()) {
                if (!v1.elementAt(i2).equals(v.elementAt(i2))) {
                    filechanged = true;
                    break;
                }
                ++i2;
            }
            if (!filechanged) {
                return true;
            }
            CodeSwitcher.writeFileLines(v, fnew);
            File fbak = new File(String.valueOf(name) + ".bak");
            fbak.delete();
            f.renameTo(fbak);
            File fcopy = new File(name);
            fnew.renameTo(fcopy);
            fbak.delete();
            return true;
        }
        catch (Exception e) {
            CodeSwitcher.printError(e.toString());
            return false;
        }
    }

    static Vector getFileLines(File f) throws IOException {
        String line;
        LineNumberReader read = new LineNumberReader(new FileReader(f));
        Vector<String> v = new Vector<String>();
        while ((line = read.readLine()) != null) {
            v.addElement(line);
        }
        read.close();
        return v;
    }

    static void writeFileLines(Vector v, File f) throws IOException {
        FileWriter write = new FileWriter(f);
        int i = 0;
        while (i < v.size()) {
            write.write((String)v.elementAt(i));
            write.write(ls);
            ++i;
        }
        write.flush();
        write.close();
    }

    static void printError(String error) {
        System.out.println("");
        System.out.println("ERROR: " + error);
    }
}

