/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Tokenizer;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowInputTextLog
extends RowInputBase
implements RowInputInterface {
    Tokenizer tokenizer = new Tokenizer();
    String tableName = null;
    String schemaName = null;
    int statementType;

    public RowInputTextLog() {
        super(new byte[0]);
    }

    public void setSource(String text) throws HsqlException {
        this.tokenizer.reset(text);
        this.statementType = 1;
        String s = this.tokenizer.getString();
        if (s.equals("INSERT")) {
            this.statementType = 3;
            this.tokenizer.getString();
            this.tableName = this.tokenizer.getString();
            this.tokenizer.getString();
        } else if (s.equals("DELETE")) {
            this.statementType = 2;
            this.tokenizer.getString();
            this.tableName = this.tokenizer.getString();
        } else if (s.equals("COMMIT")) {
            this.statementType = 5;
        } else if (s.equals("SET") && this.tokenizer.isGetThis("SCHEMA")) {
            this.schemaName = this.tokenizer.getSimpleName();
            this.statementType = 7;
        }
    }

    public int getStatementType() {
        return this.statementType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected String readField() throws IOException {
        try {
            this.tokenizer.getString();
            if (this.statementType == 2) {
                this.tokenizer.getString();
                this.tokenizer.getString();
            }
            String s = this.tokenizer.getString();
            if (this.tokenizer.getType() == 0) {
                s = null;
            }
            return s;
        }
        catch (HsqlException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected String readNumberField() throws IOException {
        try {
            String s;
            this.tokenizer.getString();
            if (this.statementType == 2) {
                this.tokenizer.getString();
                this.tokenizer.getString();
            }
            if ("-".equals(s = this.tokenizer.getString())) {
                s = String.valueOf(s) + this.tokenizer.getString();
            } else if (this.tokenizer.getType() == 0) {
                s = null;
            }
            return s;
        }
        catch (HsqlException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String readString() throws IOException {
        String s = this.readField();
        return ValuePool.getString(s);
    }

    public short readShortData() throws IOException {
        String s = this.readNumberField();
        if (s == null) {
            return 0;
        }
        return Short.parseShort(s);
    }

    public int readIntData() throws IOException {
        String s = this.readNumberField();
        if (s == null) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public long readLongData() throws IOException {
        String s = this.readNumberField();
        if (s == null) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public int readType() throws IOException {
        return 0;
    }

    protected boolean checkNull() {
        return false;
    }

    protected String readChar(int type) throws IOException {
        return this.readString();
    }

    protected Integer readSmallint() throws IOException, HsqlException {
        String s = this.readNumberField();
        if (s == null) {
            return null;
        }
        int i = Integer.parseInt(s);
        return ValuePool.getInt(i);
    }

    protected Integer readInteger() throws IOException, HsqlException {
        String s = this.readNumberField();
        if (s == null) {
            return null;
        }
        int i = Integer.parseInt(s);
        return ValuePool.getInt(i);
    }

    protected Long readBigint() throws IOException, HsqlException {
        String s = this.readNumberField();
        if (s == null) {
            return null;
        }
        long i = Long.parseLong(s);
        return ValuePool.getLong(i);
    }

    protected Double readReal(int type) throws IOException, HsqlException {
        String s = this.readNumberField();
        if (s == null) {
            return null;
        }
        double i = JavaSystem.parseDouble(s);
        if (this.tokenizer.isGetThis("/")) {
            s = this.tokenizer.getString();
            JavaSystem.parseDouble(s);
            if (i == 0.0) {
                i = Double.NaN;
            } else if (i == -1.0) {
                i = Double.NEGATIVE_INFINITY;
            } else if (i == 1.0) {
                i = Double.POSITIVE_INFINITY;
            }
        }
        return ValuePool.getDouble(Double.doubleToLongBits(i));
    }

    protected BigDecimal readDecimal() throws IOException, HsqlException {
        String s = this.readNumberField();
        if (s == null) {
            return null;
        }
        BigDecimal i = new BigDecimal(s);
        return ValuePool.getBigDecimal(i);
    }

    protected Time readTime() throws IOException, HsqlException {
        String s = this.readField();
        if (s == null) {
            return null;
        }
        return HsqlDateTime.timeValue(s);
    }

    protected Date readDate() throws IOException, HsqlException {
        String s = this.readField();
        if (s == null) {
            return null;
        }
        return HsqlDateTime.dateValue(s);
    }

    protected Timestamp readTimestamp() throws IOException, HsqlException {
        String s = this.readField();
        if (s == null) {
            return null;
        }
        return HsqlDateTime.timestampValue(s);
    }

    protected Boolean readBit() throws IOException, HsqlException {
        String s = this.readField();
        if (s == null) {
            return null;
        }
        return s.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object readOther() throws IOException, HsqlException {
        String s = this.readField();
        if (s == null) {
            return null;
        }
        byte[] data = Column.hexToByteArray(s);
        return new JavaObject(data);
    }

    protected Binary readBinary(int type) throws IOException, HsqlException {
        String s = this.readField();
        if (s == null) {
            return null;
        }
        return new Binary(Column.hexToByteArray(s), false);
    }
}

