/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.types.Binary;

public abstract class RowInputBase
extends HsqlByteArrayInputStream {
    static final int NO_POS = -1;
    protected int filePos = -1;
    protected int size;

    public RowInputBase() {
        this(new byte[4]);
    }

    public RowInputBase(byte[] buf) {
        super(buf);
        this.size = buf.length;
    }

    public int getPos() {
        return this.filePos;
    }

    public int getSize() {
        return this.size;
    }

    public abstract int readIntData() throws IOException;

    public abstract long readLongData() throws IOException;

    public abstract int readType() throws IOException;

    public abstract String readString() throws IOException;

    protected abstract boolean checkNull() throws IOException;

    protected abstract String readChar(int var1) throws IOException, HsqlException;

    protected abstract Integer readSmallint() throws IOException, HsqlException;

    protected abstract Integer readInteger() throws IOException, HsqlException;

    protected abstract Long readBigint() throws IOException, HsqlException;

    protected abstract Double readReal(int var1) throws IOException, HsqlException;

    protected abstract BigDecimal readDecimal() throws IOException, HsqlException;

    protected abstract Boolean readBit() throws IOException, HsqlException;

    protected abstract Time readTime() throws IOException, HsqlException;

    protected abstract Date readDate() throws IOException, HsqlException;

    protected abstract Timestamp readTimestamp() throws IOException, HsqlException;

    protected abstract Object readOther() throws IOException, HsqlException;

    protected abstract Binary readBinary(int var1) throws IOException, HsqlException;

    public Object[] readData(int[] colTypes) throws IOException, HsqlException {
        int l = colTypes.length;
        Object[] data = new Object[l];
        int i = 0;
        while (i < l) {
            if (!this.checkNull()) {
                Object o = null;
                int type = colTypes[i];
                switch (type) {
                    case -1: 
                    case 0: 
                    case 1: 
                    case 12: 
                    case 100: {
                        o = this.readChar(type);
                        break;
                    }
                    case -6: 
                    case 5: {
                        o = this.readSmallint();
                        break;
                    }
                    case 4: {
                        o = this.readInteger();
                        break;
                    }
                    case -5: {
                        o = this.readBigint();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        o = this.readReal(type);
                        break;
                    }
                    case 2: 
                    case 3: {
                        o = this.readDecimal();
                        break;
                    }
                    case 91: {
                        o = this.readDate();
                        break;
                    }
                    case 92: {
                        o = this.readTime();
                        break;
                    }
                    case 93: {
                        o = this.readTimestamp();
                        break;
                    }
                    case 16: {
                        o = this.readBit();
                        break;
                    }
                    case 1111: {
                        o = this.readOther();
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        o = this.readBinary(type);
                        break;
                    }
                    default: {
                        throw Trace.runtimeError(201, "RowInputBase " + Types.getTypeString(type));
                    }
                }
                data[i] = o;
            }
            ++i;
        }
        return data;
    }

    public void resetRow(int filepos, int rowsize) throws IOException {
        this.mark = 0;
        this.reset();
        if (this.buf.length < rowsize) {
            this.buf = new byte[rowsize];
        }
        this.filePos = filepos;
        this.size = this.count = rowsize;
        this.pos = 4;
        this.buf[0] = (byte)(rowsize >>> 24 & 0xFF);
        this.buf[1] = (byte)(rowsize >>> 16 & 0xFF);
        this.buf[2] = (byte)(rowsize >>> 8 & 0xFF);
        this.buf[3] = (byte)(rowsize >>> 0 & 0xFF);
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int skipBytes(int n) throws IOException {
        throw Trace.runtimeError(201, "RowInputBase");
    }

    public String readLine() throws IOException {
        throw Trace.runtimeError(201, "RowInputBase");
    }
}

