/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;

public class ZipUnzipFile {
    private static final int COPY_BLOCK_SIZE = 65536;

    public static void compressFile(String infilename, String outfilename, FileAccess storage) throws IOException {
        InputStream in = null;
        DeflaterOutputStream f = null;
        boolean completed = false;
        if (!storage.isStreamElement(infilename)) {
            return;
        }
        try {
            try {
                int l;
                byte[] b = new byte[65536];
                in = storage.openInputStreamElement(infilename);
                f = new DeflaterOutputStream(storage.openOutputStreamElement(outfilename), new Deflater(1), 65536);
                while ((l = in.read(b, 0, 65536)) != -1) {
                    f.write(b, 0, l);
                }
                completed = true;
            }
            catch (Throwable e) {
                throw FileUtil.toIOException(e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (f != null) {
                    f.finish();
                    f.close();
                }
                if (!completed && storage.isStreamElement(outfilename)) {
                    storage.removeElement(outfilename);
                }
            }
            catch (Throwable e) {
                throw FileUtil.toIOException(e);
            }
        }
    }

    public static void decompressFile(String infilename, String outfilename, FileAccess storage) throws IOException {
        InflaterInputStream f = null;
        OutputStream outstream = null;
        boolean completed = false;
        try {
            if (!storage.isStreamElement(infilename)) {
                return;
            }
            try {
                int l;
                storage.removeElement(outfilename);
                f = new InflaterInputStream(storage.openInputStreamElement(infilename), new Inflater());
                outstream = storage.openOutputStreamElement(outfilename);
                byte[] b = new byte[65536];
                while ((l = f.read(b, 0, 65536)) != -1) {
                    outstream.write(b, 0, l);
                }
                completed = true;
            }
            catch (Throwable e) {
                throw FileUtil.toIOException(e);
            }
        }
        finally {
            try {
                if (f != null) {
                    f.close();
                }
                if (outstream != null) {
                    outstream.close();
                }
                if (!completed && storage.isStreamElement(outfilename)) {
                    storage.removeElement(outfilename);
                }
            }
            catch (Throwable e) {
                throw FileUtil.toIOException(e);
            }
        }
    }
}

