/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import org.hsqldb.lib.HsqlArrayList;

public class StringUtil {
    public static String toLowerSubset(String source, char substitute) {
        int len = source.length();
        StringBuffer src = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char ch = source.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                src.append(substitute);
            } else if (i == 0 && Character.isDigit(ch)) {
                src.append(substitute);
            } else {
                src.append(Character.toLowerCase(ch));
            }
            ++i;
        }
        return src.toString();
    }

    public static String arrayToString(Object array) {
        int len = Array.getLength(array);
        int last = len - 1;
        StringBuffer sb = new StringBuffer(2 * (len + 1));
        sb.append('{');
        int i = 0;
        while (i < len) {
            sb.append(Array.get(array, i));
            if (i != last) {
                sb.append(',');
            }
            ++i;
        }
        sb.append('}');
        return sb.toString();
    }

    public static String getList(String[] s, String separator, String quote) {
        int len = s.length;
        StringBuffer b = new StringBuffer(len * 16);
        int i = 0;
        while (i < len) {
            b.append(quote);
            b.append(s[i]);
            b.append(quote);
            if (i + 1 < len) {
                b.append(separator);
            }
            ++i;
        }
        return b.toString();
    }

    public static String getList(Object[] s, String separator, String quote) {
        int len = s.length;
        StringBuffer b = new StringBuffer(len * 16);
        int i = 0;
        while (i < len) {
            b.append(quote);
            b.append(s[i]);
            b.append(quote);
            if (i + 1 < len) {
                b.append(separator);
            }
            ++i;
        }
        return b.toString();
    }

    public static String getList(int[] s, String separator, String quote) {
        int len = s.length;
        StringBuffer b = new StringBuffer(len * 8);
        int i = 0;
        while (i < len) {
            b.append(quote);
            b.append(s[i]);
            b.append(quote);
            if (i + 1 < len) {
                b.append(separator);
            }
            ++i;
        }
        return b.toString();
    }

    public static String getList(String[][] s, String separator, String quote) {
        int len = s.length;
        StringBuffer b = new StringBuffer(len * 16);
        int i = 0;
        while (i < len) {
            b.append(quote);
            b.append(s[i][0]);
            b.append(quote);
            if (i + 1 < len) {
                b.append(separator);
            }
            ++i;
        }
        return b.toString();
    }

    public static void appendPair(StringBuffer b, String s1, String s2, String separator, String terminator) {
        b.append(s1);
        b.append(separator);
        b.append(s2);
        b.append(terminator);
    }

    public static boolean isEmpty(String s) {
        int i = s == null ? 0 : s.length();
        while (i > 0) {
            if (s.charAt(--i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static int rTrimSize(String s) {
        int i = s.length();
        while (i > 0) {
            if (s.charAt(--i) == ' ') continue;
            return i + 1;
        }
        return 0;
    }

    public static int skipSpaces(String s, int start) {
        int limit = s.length();
        int i = start;
        while (i < limit) {
            if (s.charAt(i) != ' ') break;
            ++i;
        }
        return i;
    }

    public static String[] split(String s, String separator) {
        HsqlArrayList list = new HsqlArrayList();
        int currindex = 0;
        boolean more = true;
        while (more) {
            int nextindex = s.indexOf(separator, currindex);
            if (nextindex == -1) {
                nextindex = s.length();
                more = false;
            }
            list.add(s.substring(currindex, nextindex));
            currindex = nextindex + separator.length();
        }
        return (String[])list.toArray(new String[list.size()]);
    }
}

