/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Sort;

public class HsqlArrayList
extends BaseList
implements HsqlList {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final float DEFAULT_RESIZE_FACTOR = 2.0f;
    private Object[] elementData;
    private boolean minimizeOnClear;

    public HsqlArrayList() {
        this.elementData = new Object[10];
    }

    public HsqlArrayList(boolean minimize) {
        this.elementData = new Object[10];
        this.minimizeOnClear = minimize;
    }

    public HsqlArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new NegativeArraySizeException("Invalid initial capacity given");
        }
        this.elementData = initialCapacity == 0 ? new Object[1] : new Object[initialCapacity];
    }

    public void add(int index, Object element) {
        if (index > this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + ">" + this.elementCount);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        int i = this.elementCount;
        while (i > index) {
            this.elementData[i] = this.elementData[i - 1];
            --i;
        }
        this.elementData[index] = element;
        ++this.elementCount;
    }

    public boolean add(Object element) {
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementData[this.elementCount] = element;
        ++this.elementCount;
        return true;
    }

    public Object get(int index) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        return this.elementData[index];
    }

    public int indexOf(Object o) {
        int i = 0;
        while (i < this.elementCount) {
            if (this.elementData[i].equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object remove(int index) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        Object removedObj = this.elementData[index];
        int i = index;
        while (i < this.elementCount - 1) {
            this.elementData[i] = this.elementData[i + 1];
            ++i;
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
        if (this.minimizeOnClear && this.elementCount == 0) {
            this.elementData = new Object[10];
        }
        return removedObj;
    }

    public Object set(int index, Object element) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        Object replacedObj = this.elementData[index];
        this.elementData[index] = element;
        return replacedObj;
    }

    public final int size() {
        return this.elementCount;
    }

    private void increaseCapacity() {
        int baseSize = this.elementData.length == 0 ? 1 : this.elementData.length;
        Object[] newArray = new Object[(int)((float)baseSize * 2.0f)];
        System.arraycopy(this.elementData, 0, newArray, 0, this.elementData.length);
        this.elementData = newArray;
        newArray = null;
    }

    public void trim() {
        Object[] newArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, newArray, 0, this.elementCount);
        this.elementData = newArray;
        newArray = null;
    }

    public void clear() {
        if (this.minimizeOnClear && this.elementData.length > 10) {
            this.elementData = new Object[10];
            this.elementCount = 0;
            return;
        }
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i] = null;
            ++i;
        }
        this.elementCount = 0;
    }

    public void setSize(int newSize) {
        if (newSize < this.elementCount) {
            if (this.minimizeOnClear && newSize == 0 && this.elementData.length > 10) {
                this.elementData = new Object[10];
                this.elementCount = 0;
                return;
            }
            int i = newSize;
            while (i < this.elementCount) {
                this.elementData[i] = null;
                ++i;
            }
        }
        this.elementCount = newSize;
        while (this.elementCount > this.elementData.length) {
            this.increaseCapacity();
        }
    }

    public Object[] toArray() {
        Object[] a = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, a, 0, this.elementCount);
        return a;
    }

    public Object[] toArray(int start, int limit) {
        Object[] a = new Object[this.elementCount - limit];
        System.arraycopy(this.elementData, start, a, 0, this.elementCount - limit);
        return a;
    }

    public Object toArray(Object a) {
        if (Array.getLength(a) < this.elementCount) {
            a = Array.newInstance(a.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, a, 0, this.elementCount);
        return a;
    }

    public void sort(ObjectComparator c) {
        if (this.elementCount < 2) {
            return;
        }
        Sort.sort(this.elementData, c, 0, this.elementCount - 1);
    }

    public Object[] getArray() {
        return this.elementData;
    }
}

