/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

public class ArrayCounter {
    public static int[] countSegments(int[] array, int elements, int segments, int start, int limit) {
        int[] counts = new int[segments];
        long interval = ArrayCounter.calcInterval(segments, start, limit);
        int index = 0;
        int element = 0;
        if (interval <= 0L) {
            return counts;
        }
        int i = 0;
        while (i < elements) {
            element = array[i];
            if (element >= start && element < limit) {
                int n = index = (int)((long)(element - start) / interval);
                counts[n] = counts[n] + 1;
            }
            ++i;
        }
        return counts;
    }

    public static int rank(int[] array, int elements, int target, int start, int limit, int margin) {
        int elementCount = 0;
        int currentLimit = limit;
        while (true) {
            long interval = ArrayCounter.calcInterval(256, start, currentLimit);
            int[] counts = ArrayCounter.countSegments(array, elements, 256, start, currentLimit);
            int i = 0;
            while (i < counts.length) {
                if (elementCount + counts[i] >= target) break;
                elementCount += counts[i];
                start = (int)((long)start + interval);
                ++i;
            }
            if (elementCount + margin >= target) {
                return start;
            }
            if (interval <= 1L) {
                return start;
            }
            currentLimit = (long)start + interval < (long)limit ? (int)((long)start + interval) : limit;
        }
    }

    static long calcInterval(int segments, int start, int limit) {
        long range = limit - start;
        if (range < 0L) {
            return 0L;
        }
        int partSegment = range % (long)segments == 0L ? 0 : 1;
        return range / (long)segments + (long)partSegment;
    }
}

