/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.Result;
import org.hsqldb.Types;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcColumnMetaData;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.persist.HsqlProperties;

public class jdbcResultSetMetaData
implements ResultSetMetaData {
    private jdbcColumnMetaData[] columnMetaData;
    private int columnCount;
    private boolean useColumnName;
    private static final boolean TRACE = false;

    jdbcResultSetMetaData(jdbcResultSet rs, HsqlProperties props) throws SQLException {
        this.init(rs, props);
    }

    jdbcResultSetMetaData(Result r, HsqlProperties props) throws SQLException {
        this.init(r, props);
    }

    void init(jdbcResultSet rs, HsqlProperties props) throws SQLException {
        if (rs == null) {
            throw Util.sqlException(40, 119, null);
        }
        this.init(rs.rResult, props);
    }

    void init(Result r, HsqlProperties props) throws SQLException {
        if (r == null) {
            throw Util.sqlException(40, 120, null);
        }
        if (!r.isData()) {
            return;
        }
        this.columnCount = r.getColumnCount();
        this.useColumnName = props == null ? true : props.isPropertyTrue("get_column_name");
        this.columnMetaData = new jdbcColumnMetaData[this.columnCount];
        Result.ResultMetaData rmd = r.metaData;
        int i = 0;
        while (i < this.columnCount) {
            Boolean iua;
            jdbcColumnMetaData cmd;
            this.columnMetaData[i] = cmd = new jdbcColumnMetaData();
            cmd.catalogName = rmd.catalogNames[i] == null ? "" : rmd.catalogNames[i];
            cmd.schemaName = rmd.schemaNames[i] == null ? "" : rmd.schemaNames[i];
            cmd.tableName = rmd.tableNames[i] == null ? "" : rmd.tableNames[i];
            cmd.columnName = rmd.colNames[i] == null ? "" : rmd.colNames[i];
            cmd.columnLabel = rmd.colLabels[i] == null ? "" : rmd.colLabels[i];
            cmd.columnType = rmd.colTypes[i];
            cmd.columnTypeName = Types.getTypeString(cmd.columnType);
            cmd.isWritable = rmd.isWritable[i];
            cmd.isReadOnly = !cmd.isWritable;
            cmd.isAutoIncrement = rmd.isIdentity[i];
            cmd.isNullable = rmd.colNullable[i];
            int type = cmd.columnType;
            cmd.columnClassName = rmd.classNames[i];
            if (cmd.columnClassName == null || cmd.columnClassName.length() == 0) {
                cmd.columnClassName = Types.getColStClsName(type);
            }
            if (Types.acceptsPrecisionCreateParam(type)) {
                if (rmd.colSizes[i] == 0) {
                    cmd.columnDisplaySize = Types.getMaxDisplaySize(type);
                } else {
                    cmd.columnDisplaySize = rmd.colSizes[i];
                    if (Types.acceptsScaleCreateParam(type) && rmd.colScales[i] != 0) {
                        cmd.columnDisplaySize += 1 + rmd.colScales[i];
                    }
                }
            } else {
                cmd.columnDisplaySize = Types.getMaxDisplaySize(type);
            }
            if (Types.isNumberType(type) && Types.acceptsPrecisionCreateParam(type)) {
                cmd.precision = rmd.colSizes[i];
                if (cmd.precision == 0) {
                    cmd.precision = Types.getPrecision(type);
                }
            } else {
                cmd.precision = Types.getPrecision(type);
            }
            if (Types.acceptsScaleCreateParam(type)) {
                cmd.scale = rmd.colScales[i];
            }
            cmd.isSigned = (iua = Types.isUnsignedAttribute(type)) != null && iua == false;
            Boolean ics = Types.isCaseSensitive(type);
            cmd.isCaseSensitive = ics != null && ics != false;
            cmd.isSearchable = Types.isSearchable(type);
            ++i;
        }
    }

    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].isAutoIncrement;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].isCaseSensitive;
    }

    public boolean isSearchable(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].isSearchable;
    }

    public boolean isCurrency(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].isCurrency;
    }

    public int isNullable(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].isNullable;
    }

    public boolean isSigned(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].isSigned;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].columnDisplaySize;
    }

    public String getColumnLabel(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].columnLabel;
    }

    public String getColumnName(int column) throws SQLException {
        this.checkColumn(column);
        return this.useColumnName ? this.columnMetaData[column].columnName : this.columnMetaData[--column].columnLabel;
    }

    public String getSchemaName(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].schemaName;
    }

    public int getPrecision(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].precision;
    }

    public int getScale(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].scale;
    }

    public String getTableName(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].tableName;
    }

    public String getCatalogName(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].catalogName;
    }

    public int getColumnType(int column) throws SQLException {
        this.checkColumn(column);
        int type = this.columnMetaData[--column].columnType;
        return type == 100 ? 12 : type;
    }

    public String getColumnTypeName(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].columnTypeName;
    }

    public boolean isReadOnly(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].isReadOnly;
    }

    public boolean isWritable(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].isWritable;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].isDefinitelyWritable;
    }

    public String getColumnClassName(int column) throws SQLException {
        this.checkColumn(column);
        return this.columnMetaData[--column].columnClassName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this.columnCount == 0) {
            sb.append("[columnCount=0]");
            return sb.toString();
        }
        sb.append('[');
        int i = 0;
        while (i < this.columnCount) {
            sb.append('\n');
            sb.append("   column_");
            sb.append(i + 1);
            sb.append('=');
            sb.append(this.columnMetaData[i]);
            if (i + 1 < this.columnCount) {
                sb.append(',');
                sb.append(' ');
            }
            ++i;
        }
        sb.append('\n');
        sb.append(']');
        return sb.toString();
    }

    private void checkColumn(int column) throws SQLException {
        if (column < 1 || column > this.columnCount) {
            throw Util.sqlException(28, String.valueOf(column));
        }
    }
}

