/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.hsqldb.Result;
import org.hsqldb.Types;
import org.hsqldb.jdbc.Util;

public class jdbcParameterMetaData
implements ParameterMetaData {
    Result.ResultMetaData rmd;
    int[] types;
    int[] modes;
    boolean[] isIdentity;
    int[] nullability;
    String[] classNames;
    int parameterCount;

    jdbcParameterMetaData(Result r) throws SQLException {
        if (r == null) {
            this.parameterCount = 0;
            return;
        }
        this.rmd = r.metaData;
        this.types = this.rmd.colTypes;
        this.parameterCount = this.types.length;
        this.nullability = this.rmd.colNullable;
        this.isIdentity = this.rmd.isIdentity;
        this.classNames = this.rmd.classNames;
        this.modes = this.rmd.paramMode;
    }

    void checkRange(int param) throws SQLException {
        if (param < 1 || param > this.parameterCount) {
            String msg = String.valueOf(param) + " is out of range";
            throw Util.sqlException(62, msg);
        }
    }

    public String getParameterClassName(int param) throws SQLException {
        this.checkRange(param);
        return this.classNames[--param];
    }

    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    public int getParameterMode(int param) throws SQLException {
        this.checkRange(param);
        return this.modes[--param];
    }

    public int getParameterType(int param) throws SQLException {
        this.checkRange(param);
        int t = this.types[--param];
        return t == 100 ? 12 : t;
    }

    public String getParameterTypeName(int param) throws SQLException {
        this.checkRange(param);
        return Types.getTypeName(this.types[--param]);
    }

    public int getPrecision(int param) throws SQLException {
        this.checkRange(param);
        return Types.getPrecision(this.types[--param]);
    }

    public int getScale(int param) throws SQLException {
        this.checkRange(param);
        return 0;
    }

    public int isNullable(int param) throws SQLException {
        this.checkRange(param);
        return this.nullability[--param];
    }

    public boolean isSigned(int param) throws SQLException {
        this.checkRange(param);
        Boolean b = Types.isUnsignedAttribute(this.types[--param]);
        return b != null && b == false && !this.isIdentity[param];
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Throwable t) {
            return String.valueOf(super.toString()) + "[toStringImpl_exception=" + t + "]";
        }
    }

    private String toStringImpl() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        int count = this.getParameterCount();
        if (count == 0) {
            sb.append("[parameterCount=0]");
            return sb.toString();
        }
        Method[] methods = this.getClass().getDeclaredMethods();
        sb.append('[');
        int len = methods.length;
        int i = 0;
        while (i < count) {
            sb.append('\n');
            sb.append("    parameter_");
            sb.append(i + 1);
            sb.append('=');
            sb.append('[');
            int j = 0;
            while (j < len) {
                Method method = methods[j];
                if (Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 1) {
                    sb.append(method.getName());
                    sb.append('=');
                    sb.append(method.invoke((Object)this, new Integer(i + 1)));
                    if (j + 1 < len) {
                        sb.append(',');
                        sb.append(' ');
                    }
                }
                ++j;
            }
            sb.append(']');
            if (i + 1 < count) {
                sb.append(',');
                sb.append(' ');
            }
            ++i;
        }
        sb.append('\n');
        sb.append(']');
        return sb.toString();
    }
}

