/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.AsciiStringInputStream;

public final class jdbcClob
implements Clob {
    volatile String data;

    public jdbcClob(String data) throws SQLException {
        if (data == null) {
            throw Util.sqlException(62, "null");
        }
        this.data = data;
    }

    public long length() throws SQLException {
        String ldata = this.data;
        return ldata.length();
    }

    public String getSubString(long pos, int length) throws SQLException {
        String ldata = this.data;
        int dlen = ldata.length();
        if (--pos < 0L || pos > (long)dlen) {
            Util.sqlException(62, "pos: " + (pos + 1L));
        }
        if (length < 0 || (long)length > (long)dlen - pos) {
            throw Util.sqlException(62, "length: " + length);
        }
        if (pos == 0L && length == dlen) {
            return ldata;
        }
        return ldata.substring((int)pos, (int)pos + length);
    }

    public Reader getCharacterStream() throws SQLException {
        String ldata = this.data;
        return new StringReader(ldata);
    }

    public InputStream getAsciiStream() throws SQLException {
        String ldata = this.data;
        return new AsciiStringInputStream(ldata);
    }

    public long position(String searchstr, long start) throws SQLException {
        int pos;
        if (searchstr == null || start > Integer.MAX_VALUE) {
            return -1L;
        }
        String ldata = this.data;
        return (pos = ldata.indexOf(searchstr, (int)(--start))) < 0 ? -1 : pos + 1;
    }

    public long position(Clob searchstr, long start) throws SQLException {
        long sslen;
        if (searchstr == null) {
            return -1L;
        }
        String ldata = this.data;
        long dlen = ldata.length();
        if (--start > dlen - (sslen = searchstr.length())) {
            return -1L;
        }
        String s = searchstr instanceof jdbcClob ? ((jdbcClob)searchstr).data : searchstr.getSubString(1L, (int)sslen);
        int pos = ldata.indexOf(s, (int)start);
        return pos < 0 ? -1 : pos + 1;
    }

    public int setString(long pos, String str) throws SQLException {
        throw Util.notSupported();
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw Util.notSupported();
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw Util.notSupported();
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        throw Util.notSupported();
    }

    public void truncate(long len) throws SQLException {
        long chars = len >> 1;
        String ldata = this.data;
        long dlen = ldata.length();
        if (chars != dlen) {
            if (len < 0L || chars > dlen) {
                throw Util.sqlException(62, Long.toString(len));
            }
            this.data = new String(ldata.substring(0, (int)chars));
        }
    }
}

