/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Server;
import org.hsqldb.Session;
import org.hsqldb.lib.HashSet;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

class ServerConnection
implements Runnable {
    boolean keepAlive;
    private String user;
    private String password;
    int dbID;
    private volatile Session session;
    private Socket socket;
    private Server server;
    private DataInputStream dataInput;
    private BufferedOutputStream dataOutput;
    private static int mCurrentThread = 0;
    private int mThread;
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    RowOutputBinary rowOut = new RowOutputBinary(4096);
    RowInputBinary rowIn = new RowInputBinary(this.rowOut);
    Thread runnerThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerConnection(Socket socket, Server server) {
        this.socket = socket;
        this.server = server;
        Object object = ServerConnection.class;
        synchronized (ServerConnection.class) {
            this.mThread = mCurrentThread++;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            object = server.serverConnSet;
            synchronized (object) {
                server.serverConnSet.add(this);
            }
            return;
        }
    }

    void signalClose() {
        this.keepAlive = false;
        if (!Thread.currentThread().equals(this.runnerThread)) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
        this.socket = null;
        HashSet hashSet = this.server.serverConnSet;
        synchronized (hashSet) {
            this.server.serverConnSet.remove(this);
        }
    }

    private void init() {
        this.runnerThread = Thread.currentThread();
        this.keepAlive = true;
        try {
            Result resultOut;
            this.socket.setTcpNoDelay(true);
            this.dataInput = new DataInputStream(this.socket.getInputStream());
            this.dataOutput = new BufferedOutputStream(this.socket.getOutputStream());
            Result resultIn = Result.read(this.rowIn, this.dataInput);
            try {
                this.dbID = this.server.getDBID(resultIn.subSubString);
                this.user = resultIn.getMainString();
                this.password = resultIn.getSubString();
                if (!this.server.isSilent()) {
                    this.server.printWithThread(String.valueOf(this.mThread) + ":trying to connect user " + this.user);
                }
                this.session = DatabaseManager.newSession(this.dbID, resultIn.getMainString(), resultIn.getSubString());
                resultOut = new Result(1);
                resultOut.databaseID = this.session.getDatabase().databaseID;
                resultOut.sessionID = this.session.getId();
            }
            catch (HsqlException e) {
                this.session = null;
                resultOut = new Result(e, null);
            }
            catch (RuntimeException e) {
                this.session = null;
                resultOut = new Result(e, null);
            }
            Result.write(resultOut, this.rowOut, this.dataOutput);
            return;
        }
        catch (Exception exception) {
            this.server.printWithThread(String.valueOf(this.mThread) + ":couldn't connect " + this.user);
            this.close();
            return;
        }
    }

    public void run() {
        this.init();
        if (this.session != null) {
            try {
                while (this.keepAlive) {
                    Result resultIn = Result.read(this.rowIn, this.dataInput);
                    this.server.printRequest(this.mThread, resultIn);
                    Result resultOut = resultIn.mode == 10 ? this.resetSession() : this.session.execute(resultIn);
                    Result.write(resultOut, this.rowOut, this.dataOutput);
                    this.rowOut.setBuffer(this.mainBuffer);
                    this.rowIn.resetRow(this.mainBuffer.length);
                }
            }
            catch (IOException iOException) {
                this.server.printWithThread(String.valueOf(this.mThread) + ":disconnected " + this.user);
            }
            catch (HsqlException e) {
                this.server.printStackTrace(e);
            }
        }
        this.close();
    }

    private Result resetSession() {
        Result resultOut;
        if (!this.server.isSilent()) {
            this.server.printWithThread(String.valueOf(this.mThread) + ":trying to connect user " + this.user);
        }
        try {
            this.session.close();
            this.session = DatabaseManager.newSession(this.dbID, this.user, this.password);
            resultOut = new Result(1);
            resultOut.databaseID = this.session.getDatabase().databaseID;
            resultOut.sessionID = this.session.getId();
        }
        catch (HsqlException e) {
            this.session = null;
            resultOut = new Result(e, null);
        }
        return resultOut;
    }

    String getConnectionThreadName() {
        return "HSQLDB Connection @" + Integer.toString(this.hashCode(), 16);
    }
}

