/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.net.InetAddress;
import org.hsqldb.ServerConstants;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;

public final class ServerConfiguration
implements ServerConstants {
    private ServerConfiguration() {
    }

    public static int getDefaultPort(int protocol, boolean isTls) {
        switch (protocol) {
            case 1: {
                return isTls ? 554 : 9001;
            }
            case 0: {
                return isTls ? 443 : 80;
            }
            case 2: {
                return isTls ? -1 : 9101;
            }
        }
        return -1;
    }

    public static HsqlProperties getPropertiesFromFile(String path) {
        if (StringUtil.isEmpty(path)) {
            return null;
        }
        HsqlProperties p = new HsqlProperties(path);
        try {
            p.load();
        }
        catch (Exception exception) {}
        return p;
    }

    public static String[] listLocalInetAddressNames() {
        int i;
        InetAddress[] addrs;
        InetAddress addr;
        HashSet set = new HashSet();
        try {
            addr = InetAddress.getLocalHost();
            addrs = InetAddress.getAllByName(addr.getHostAddress());
            i = 0;
            while (i < addrs.length) {
                set.add(addrs[i].getHostAddress());
                set.add(addrs[i].getHostName());
                ++i;
            }
            addrs = InetAddress.getAllByName(addr.getHostName());
            i = 0;
            while (i < addrs.length) {
                set.add(addrs[i].getHostAddress());
                set.add(addrs[i].getHostName());
                ++i;
            }
        }
        catch (Exception exception) {}
        try {
            addr = InetAddress.getByName(null);
            addrs = InetAddress.getAllByName(addr.getHostAddress());
            i = 0;
            while (i < addrs.length) {
                set.add(addrs[i].getHostAddress());
                set.add(addrs[i].getHostName());
                ++i;
            }
            addrs = InetAddress.getAllByName(addr.getHostName());
            i = 0;
            while (i < addrs.length) {
                set.add(addrs[i].getHostAddress());
                set.add(addrs[i].getHostName());
                ++i;
            }
        }
        catch (Exception exception) {}
        try {
            set.add(InetAddress.getByName("loopback").getHostAddress());
            set.add(InetAddress.getByName("loopback").getHostName());
        }
        catch (Exception exception) {}
        return (String[])set.toArray(new String[set.size()]);
    }

    public static HsqlProperties newDefaultProperties(int protocol) {
        HsqlProperties p = new HsqlProperties();
        p.setProperty("server.restart_on_shutdown", false);
        p.setProperty("server.address", "0.0.0.0");
        p.setProperty("server.no_system_exit", true);
        boolean isTls = false;
        try {
            isTls = System.getProperty("javax.net.ssl.keyStore") != null;
        }
        catch (Exception exception) {}
        p.setProperty("server.port", ServerConfiguration.getDefaultPort(protocol, isTls));
        p.setProperty("server.silent", true);
        p.setProperty("server.tls", isTls);
        p.setProperty("server.trace", false);
        p.setProperty("server.default_page", "index.html");
        p.setProperty("server.root", ".");
        return p;
    }

    public static void translateAddressProperty(HsqlProperties p) {
        if (p == null) {
            return;
        }
        String address = p.getProperty("server.address");
        if (StringUtil.isEmpty(address)) {
            p.setProperty("server.address", "0.0.0.0");
        }
    }

    public static void translateDefaultDatabaseProperty(HsqlProperties p) {
        if (p == null) {
            return;
        }
        if (!p.isPropertyTrue("server.remote_open")) {
            if (p.getProperty("server.database.0") == null) {
                String defaultdb = p.getProperty("server.database");
                if (defaultdb == null) {
                    defaultdb = "test";
                }
                p.setProperty("server.database.0", defaultdb);
                p.setProperty("server.dbname.0", "");
            } else if (p.getProperty("server.dbname.0") == null) {
                p.setProperty("server.dbname.0", "");
            }
        }
    }

    public static void translateDefaultNoSystemExitProperty(HsqlProperties p) {
        if (p == null) {
            return;
        }
        p.setPropertyIfNotExists("server.no_system_exit", "false");
    }
}

