/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;

final class CompiledStatement {
    static final String PCOL_PREFIX = "@p";
    static final String RETURN_COLUMN_NAME = "@p0";
    static final int UNKNOWN = 0;
    static final int INSERT_VALUES = 1;
    static final int INSERT_SELECT = 2;
    static final int UPDATE = 3;
    static final int DELETE = 4;
    static final int SELECT = 5;
    static final int SELECT_INTO = 6;
    static final int CALL = 7;
    static final int DML = 7;
    static final int DQL = 8;
    static final int DDL = 9;
    int id;
    boolean isValid = true;
    Table targetTable;
    TableFilter targetFilter;
    Expression condition;
    int[] columnMap;
    Expression[] columnValues;
    boolean[] checkColumns;
    Expression expression;
    Select select;
    Expression[] parameters;
    int[] paramTypes;
    SubQuery[] subqueries;
    int type;
    String sql;
    final HsqlNameManager.HsqlName schemaHsqlName;
    private static final Result updateCountResult = new Result(1);

    CompiledStatement(HsqlNameManager.HsqlName schema) {
        this.parameters = new Expression[0];
        this.paramTypes = new int[0];
        this.subqueries = new SubQuery[0];
        this.type = 9;
        this.schemaHsqlName = schema;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName schema, TableFilter targetFilter, Expression deleteCondition, SubQuery[] subqueries, Expression[] params) throws HsqlException {
        this.schemaHsqlName = schema;
        this.targetFilter = targetFilter;
        this.targetTable = targetFilter.filterTable;
        if (deleteCondition != null) {
            this.condition = new Expression(deleteCondition);
            this.condition.resolveTables(targetFilter);
            this.condition.resolveTypes(session);
            targetFilter.setConditions(session, this.condition);
        }
        this.setParameters(params);
        this.setSubqueries(subqueries);
        this.type = 4;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName schema, TableFilter targetFilter, int[] columnMap, Expression[] columnValues, Expression updateCondition, SubQuery[] subqueries, Expression[] params) throws HsqlException {
        this.schemaHsqlName = schema;
        this.targetFilter = targetFilter;
        this.targetTable = targetFilter.filterTable;
        this.columnMap = columnMap;
        this.columnValues = columnValues;
        int i = 0;
        while (i < columnValues.length) {
            Expression cve = columnValues[i];
            if (cve.isParam()) {
                cve.setTableColumnAttributes(this.targetTable, columnMap[i]);
            } else {
                cve.resolveTables(targetFilter);
                cve.resolveTypes(session);
            }
            ++i;
        }
        if (updateCondition != null) {
            this.condition = new Expression(updateCondition);
            this.condition.resolveTables(targetFilter);
            this.condition.resolveTypes(session);
            targetFilter.setConditions(session, this.condition);
        }
        this.setParameters(params);
        this.setSubqueries(subqueries);
        this.type = 3;
    }

    CompiledStatement(HsqlNameManager.HsqlName schema, Table targetTable, int[] columnMap, Expression[] columnValues, boolean[] checkColumns, SubQuery[] subqueries, Expression[] params) throws HsqlException {
        this.schemaHsqlName = schema;
        this.targetTable = targetTable;
        this.columnMap = columnMap;
        this.checkColumns = checkColumns;
        this.columnValues = columnValues;
        int i = 0;
        while (i < columnValues.length) {
            Expression cve = columnValues[i];
            if (cve.isParam()) {
                cve.setTableColumnAttributes(targetTable, columnMap[i]);
            }
            ++i;
        }
        this.setParameters(params);
        this.setSubqueries(subqueries);
        this.type = 1;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName schema, Table targetTable, int[] columnMap, boolean[] checkColumns, Select select, SubQuery[] subqueries, Expression[] params) throws HsqlException {
        this.schemaHsqlName = schema;
        this.targetTable = targetTable;
        this.columnMap = columnMap;
        this.checkColumns = checkColumns;
        this.select = select;
        this.resolveInsertParameterTypes();
        select.prepareResult(session);
        this.setParameters(params);
        this.setSubqueries(subqueries);
        this.type = 2;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName schema, Select select, SubQuery[] subqueries, Expression[] params) throws HsqlException {
        this.schemaHsqlName = schema;
        this.select = select;
        int i = 0;
        while (i < select.iResultLen) {
            Expression colexpr = select.exprColumns[i];
            if (colexpr.getDataType() == 0) {
                colexpr.setDataType(12);
            }
            ++i;
        }
        select.prepareResult(session);
        this.setParameters(params);
        this.setSubqueries(subqueries);
        this.type = 5;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName schema, Expression expression, SubQuery[] subqueries, Expression[] params) throws HsqlException {
        this.schemaHsqlName = schema;
        this.expression = expression;
        expression.resolveTypes(session);
        expression.paramMode = 4;
        this.setParameters(params);
        this.setSubqueries(subqueries);
        this.type = 7;
    }

    private void resolveInsertParameterTypes() {
        int i = 0;
        while (i < this.select.iResultLen) {
            Expression colexpr = this.select.exprColumns[i];
            if (colexpr.getDataType() == 0) {
                Column col = this.targetTable.getColumn(this.columnMap[i]);
                colexpr.setDataType(col.getType());
            }
            ++i;
        }
    }

    private void setParameters(Expression[] params) {
        this.parameters = params;
        int[] types = new int[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            types[i] = this.parameters[i].getDataType();
            ++i;
        }
        this.paramTypes = types;
    }

    private void setSubqueries(SubQuery[] subqueries) {
        this.subqueries = subqueries;
    }

    void materializeSubQueries(Session session) throws HsqlException {
        int i = 0;
        while (i < this.subqueries.length) {
            SubQuery sq = this.subqueries[i];
            if (!sq.isMaterialised && sq.isResolved) {
                sq.populateTable(session);
                sq.isMaterialised = true;
            }
            ++i;
        }
    }

    void dematerializeSubQueries(Session session) {
        if (this.subqueries == null) {
            return;
        }
        int i = 0;
        while (i < this.subqueries.length) {
            this.subqueries[i].table.clearAllRows(session);
            this.subqueries[i].isMaterialised = false;
            ++i;
        }
    }

    void clearVariables() {
        this.isValid = false;
        this.targetTable = null;
        this.targetFilter = null;
        this.condition = null;
        this.columnMap = null;
        this.columnValues = null;
        this.checkColumns = null;
        this.expression = null;
        this.select = null;
        this.parameters = null;
        this.paramTypes = null;
        this.subqueries = null;
    }

    boolean canExecute(Session session) throws HsqlException {
        switch (this.type) {
            case 5: 
            case 7: {
                int i = 0;
                while (i < this.select.tFilter.length) {
                    HsqlNameManager.HsqlName name = this.select.tFilter[i].filterTable.getName();
                    session.check(name, 1);
                    ++i;
                }
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                session.check(this.targetTable.getName(), 2);
                break;
            }
            case 1: {
                session.check(this.targetTable.getName(), 4);
                break;
            }
            case 3: {
                session.check(this.targetTable.getName(), 8);
            }
        }
        return true;
    }

    void checkTableWriteAccess(Session session, Table table) throws HsqlException {
        session.checkReadWrite();
        if (table.isView()) {
            throw Trace.error(55, table.getName().name);
        }
        table.checkDataReadOnly();
    }

    Result describeResult() {
        switch (this.type) {
            case 7: {
                Expression e = this.expression;
                Result r = Result.newSingleColumnResult(RETURN_COLUMN_NAME, e.getDataType());
                r.metaData.classNames[0] = e.getValueClassName();
                return r;
            }
            case 5: {
                return this.select.sIntoTable == null ? this.select.describeResult() : updateCountResult;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                return updateCountResult;
            }
        }
        return new Result(Trace.runtimeError(201, "CompiledStatement.describeResult()"), null);
    }

    Result describeParameters() {
        int outlen = this.parameters.length;
        int offset = 0;
        Result out = Result.newParameterDescriptionResult(outlen);
        int i = 0;
        while (i < this.parameters.length) {
            Expression e = this.parameters[i];
            int idx = i + offset;
            out.metaData.colNames[idx] = PCOL_PREFIX + (i + 1);
            out.metaData.classNames[idx] = e.getValueClassName();
            out.metaData.colTypes[idx] = e.getDataType();
            out.metaData.colSizes[idx] = e.getColumnSize();
            out.metaData.colScales[idx] = e.getColumnScale();
            out.metaData.colNullable[idx] = e.nullability;
            out.metaData.isIdentity[idx] = e.isIdentity;
            out.metaData.paramMode[idx] = e.paramMode;
            ++i;
        }
        return out;
    }

    public String describe(Session session) {
        try {
            return this.describeImpl(session);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    private String describeImpl(Session session) throws Exception {
        StringBuffer sb = new StringBuffer();
        switch (this.type) {
            case 5: {
                sb.append(this.select.describe(session));
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb);
                return sb.toString();
            }
            case 1: {
                sb.append("INSERT VALUES");
                sb.append('[').append('\n');
                this.appendColumns(sb).append('\n');
                this.appendTable(sb).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
            case 2: {
                sb.append("INSERT SELECT");
                sb.append('[').append('\n');
                this.appendColumns(sb).append('\n');
                this.appendTable(sb).append('\n');
                sb.append(this.select.describe(session)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
            case 3: {
                sb.append("UPDATE");
                sb.append('[').append('\n');
                this.appendColumns(sb).append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                sb.append(this.targetFilter.describe(session)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
            case 4: {
                sb.append("DELETE");
                sb.append('[').append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                sb.append(this.targetFilter.describe(session)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
            case 7: {
                sb.append("CALL");
                sb.append('[');
                sb.append(this.expression.describe(session)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
        }
        return "UNKNOWN";
    }

    private StringBuffer appendSubqueries(StringBuffer sb) {
        sb.append("SUBQUERIES[");
        int i = 0;
        while (i < this.subqueries.length) {
            sb.append("\n[level=").append(this.subqueries[i].level).append('\n').append("hasParams=").append(this.subqueries[i].hasParams).append('\n');
            if (this.subqueries[i].select != null) {
                sb.append("org.hsqldb.Select@").append(Integer.toHexString(this.subqueries[i].select.hashCode()));
            }
            sb.append("]");
            ++i;
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendTable(StringBuffer sb) {
        sb.append("TABLE[").append(this.targetTable.getName().name).append(']');
        return sb;
    }

    private StringBuffer appendColumns(StringBuffer sb) {
        sb.append("COLUMNS=[");
        int i = 0;
        while (i < this.columnMap.length) {
            sb.append('\n').append(this.columnMap[i]).append(':').append(' ').append(this.targetTable.getColumn((int)this.columnMap[i]).columnName.name).append('[').append(this.columnValues[i]).append(']');
            ++i;
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendParms(StringBuffer sb) {
        sb.append("PARAMETERS=[");
        int i = 0;
        while (i < this.parameters.length) {
            sb.append('\n').append('@').append(i).append('[').append(this.parameters[i]).append(']');
            ++i;
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendCondition(Session session, StringBuffer sb) {
        return this.condition == null ? sb.append("CONDITION[]\n") : sb.append("CONDITION[").append(this.condition.describe(session)).append("]\n");
    }
}

