/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Component;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class GridSwing
extends AbstractTableModel {
    JTable jtable = null;
    Object[] headers = new Object[0];
    Vector rows = new Vector();

    public String getColumnName(int i) {
        return this.headers[i].toString();
    }

    public Class getColumnClass(int i) {
        Object o;
        if (this.rows.size() > 0 && (o = this.getValueAt(0, i)) != null) {
            if (o instanceof Timestamp || o instanceof Time) {
                return Object.class;
            }
            return o.getClass();
        }
        return super.getColumnClass(i);
    }

    public int getColumnCount() {
        return this.headers.length;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object[] getHead() {
        return this.headers;
    }

    public Vector getData() {
        return this.rows;
    }

    public Object getValueAt(int row, int col) {
        if (row >= this.rows.size()) {
            return null;
        }
        Object[] colArray = (Object[])this.rows.elementAt(row);
        if (col >= colArray.length) {
            return null;
        }
        return colArray[col];
    }

    public void setHead(Object[] h) {
        this.headers = new Object[h.length];
        int i = 0;
        while (i < h.length) {
            this.headers[i] = h[i];
            ++i;
        }
    }

    public void addRow(Object[] r) {
        Object[] row = new Object[r.length];
        int i = 0;
        while (i < r.length) {
            row[i] = r[i];
            Object cfr_ignored_0 = row[i];
            ++i;
        }
        this.rows.addElement(row);
    }

    public void clear() {
        this.rows.removeAllElements();
    }

    public void setJTable(JTable table) {
        this.jtable = table;
    }

    public void fireTableChanged(TableModelEvent e) {
        super.fireTableChanged(e);
        GridSwing.autoSizeTableColumns(this.jtable);
    }

    public static void autoSizeTableColumns(JTable table) {
        TableModel model = table.getModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int maxCellWidth = Integer.MIN_VALUE;
        int cellWidth = 0;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int i = 0;
        while (i < table.getColumnCount()) {
            column = table.getColumnModel().getColumn(i);
            comp = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width + 10;
            maxCellWidth = Integer.MIN_VALUE;
            int j = 0;
            while (j < Math.min(model.getRowCount(), 30)) {
                TableCellRenderer r = table.getCellRenderer(j, i);
                comp = r.getTableCellRendererComponent(table, model.getValueAt(j, i), false, false, j, i);
                cellWidth = comp.getPreferredSize().width;
                if (cellWidth >= maxCellWidth) {
                    maxCellWidth = cellWidth;
                }
                ++j;
            }
            column.setPreferredWidth(Math.max(headerWidth, maxCellWidth) + 10);
            ++i;
        }
    }
}

