/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.resources;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;

public final class BundleHandler {
    private static final Object mutex = new Object();
    private static Locale locale = Locale.getDefault();
    private static HashMap bundleHandleMap = new HashMap();
    private static HsqlArrayList bundleList = new HsqlArrayList();
    private static final String prefix = "org/hsqldb/resources/";
    private static final Method newGetBundleMethod = BundleHandler.getNewGetBundleMethod();

    private BundleHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale getLocale() {
        Object object = mutex;
        synchronized (object) {
            return locale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(Locale l) throws IllegalArgumentException {
        Object object = mutex;
        synchronized (object) {
            if (l == null) {
                throw new IllegalArgumentException("null locale");
            }
            locale = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBundleHandle(String name, ClassLoader cl) {
        Integer bundleHandle;
        String bundleName = prefix + name;
        Object object = mutex;
        synchronized (object) {
            String bundleKey = String.valueOf(locale.toString()) + bundleName;
            bundleHandle = (Integer)bundleHandleMap.get(bundleKey);
            if (bundleHandle == null) {
                try {
                    ResourceBundle bundle = BundleHandler.getBundle(bundleName, locale, cl);
                    bundleList.add(bundle);
                    bundleHandle = new Integer(bundleList.size() - 1);
                    bundleHandleMap.put(bundleKey, bundleHandle);
                }
                catch (Exception exception) {}
            }
        }
        return bundleHandle == null ? -1 : bundleHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(int handle, String key) {
        String s;
        ResourceBundle bundle;
        Object object = mutex;
        synchronized (object) {
            bundle = handle < 0 || handle >= bundleList.size() || key == null ? null : (ResourceBundle)bundleList.get(handle);
        }
        if (bundle == null) {
            s = null;
        } else {
            try {
                s = bundle.getString(key);
            }
            catch (Exception exception) {
                s = null;
            }
        }
        return s;
    }

    private static Method getNewGetBundleMethod() {
        Class<ResourceBundle> clazz = ResourceBundle.class;
        Class[] args = new Class[]{String.class, Locale.class, ClassLoader.class};
        try {
            return clazz.getMethod("getBundle", args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ResourceBundle getBundle(String name, Locale locale, ClassLoader cl) throws NullPointerException, MissingResourceException {
        if (cl == null) {
            return ResourceBundle.getBundle(name, locale);
        }
        if (newGetBundleMethod == null) {
            return ResourceBundle.getBundle(name, locale);
        }
        try {
            return (ResourceBundle)newGetBundleMethod.invoke(null, name, locale, cl);
        }
        catch (Exception exception) {
            return ResourceBundle.getBundle(name, locale);
        }
    }
}

