/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.LockFile;
import org.hsqldb.persist.Log;

public class Logger {
    public SimpleLog appLog = new SimpleLog(null, SimpleLog.LOG_NONE, false);
    private Log log;
    private LockFile lf;
    boolean needsCheckpoint;
    private boolean logStatements;
    private boolean syncFile = false;

    public void openLog(Database db) throws HsqlException {
        this.needsCheckpoint = false;
        String path = db.getPath();
        int loglevel = db.getProperties().getIntegerProperty("hsqldb.applog", 0);
        if (loglevel != SimpleLog.LOG_NONE) {
            this.appLog = new SimpleLog(String.valueOf(path) + ".app.log", loglevel, !db.isFilesReadOnly());
        }
        this.appLog.sendLine(SimpleLog.LOG_ERROR, "Database (re)opened");
        this.logStatements = false;
        if (!db.isFilesReadOnly()) {
            this.acquireLock(path);
        }
        this.log = new Log(db);
        this.log.open();
        this.logStatements = !db.isFilesReadOnly();
    }

    public boolean closeLog(int closemode) {
        if (this.log == null) {
            this.appLog.sendLine(SimpleLog.LOG_ERROR, "Database closed");
            this.appLog.close();
            return true;
        }
        try {
            switch (closemode) {
                case -1: {
                    this.log.shutdown();
                    break;
                }
                case 0: {
                    this.log.close(false);
                    break;
                }
                case 1: 
                case 2: {
                    this.log.close(true);
                }
            }
        }
        catch (Throwable e) {
            this.appLog.logContext(e, "error closing log");
            this.appLog.close();
            this.log = null;
            return false;
        }
        this.appLog.sendLine(SimpleLog.LOG_ERROR, "Database closed");
        this.appLog.close();
        this.log = null;
        return true;
    }

    public boolean hasLog() {
        return this.log != null;
    }

    public DataFileCache getCache() throws HsqlException {
        if (this.log == null) {
            return null;
        }
        return this.log.getCache();
    }

    public boolean hasCache() {
        if (this.log == null) {
            return false;
        }
        return this.log.hasCache();
    }

    public synchronized void logConnectUser(Session session) throws HsqlException {
        if (this.logStatements) {
            this.writeToLog(session, session.getUser().getConnectStatement());
        }
    }

    public synchronized void writeToLog(Session session, String statement) throws HsqlException {
        if (this.logStatements && this.log != null) {
            this.log.writeStatement(session, statement);
        }
    }

    public synchronized void writeInsertStatement(Session session, Table table, Object[] row) throws HsqlException {
        if (this.logStatements) {
            this.log.writeInsertStatement(session, table, row);
        }
    }

    public synchronized void writeDeleteStatement(Session session, Table t, Object[] row) throws HsqlException {
        if (this.logStatements) {
            this.log.writeDeleteStatement(session, t, row);
        }
    }

    public synchronized void writeSequenceStatement(Session session, NumberSequence s) throws HsqlException {
        if (this.logStatements) {
            this.log.writeSequenceStatement(session, s);
        }
    }

    public synchronized void writeCommitStatement(Session session) throws HsqlException {
        if (this.logStatements) {
            this.log.writeCommitStatement(session);
            this.synchLog();
        }
    }

    public synchronized void synchLog() {
        if (this.logStatements && this.syncFile) {
            this.log.synchLog();
        }
    }

    public synchronized void synchLogForce() {
        if (this.logStatements) {
            this.log.synchLog();
        }
    }

    public synchronized void checkpoint(boolean mode) throws HsqlException {
        if (this.logStatements) {
            this.appLog.logContext(SimpleLog.LOG_NORMAL, "start");
            this.needsCheckpoint = false;
            this.log.checkpoint(mode);
            this.appLog.logContext(SimpleLog.LOG_NORMAL, "end");
        }
    }

    public synchronized void setLogSize(int megas) {
        if (this.log != null) {
            this.log.setLogSize(megas);
        }
    }

    public synchronized void setScriptType(int i) throws HsqlException {
        if (this.log != null) {
            this.log.setScriptType(i);
        }
    }

    public synchronized void setWriteDelay(int delay) {
        if (this.log != null) {
            this.syncFile = delay == 0;
            this.log.setWriteDelay(delay);
        }
    }

    public int getWriteDelay() {
        return this.log != null ? this.log.getWriteDelay() : 0;
    }

    public int getLogSize() {
        return this.log != null ? this.log.getLogSize() : 0;
    }

    public int getScriptType() {
        return this.log != null ? this.log.getScriptType() : 0;
    }

    public DataFileCache openTextCache(Table table, String source, boolean readOnlyData, boolean reversed) throws HsqlException {
        return this.log.openTextCache(table, source, readOnlyData, reversed);
    }

    public void closeTextCache(Table table) throws HsqlException {
        this.log.closeTextCache(table);
    }

    public boolean needsCheckpoint() {
        return this.needsCheckpoint;
    }

    public void acquireLock(String path) throws HsqlException {
        if (this.lf != null) {
            return;
        }
        this.lf = LockFile.newLockFileLock(path);
    }

    public void releaseLock() {
        block3: {
            try {
                if (this.lf != null) {
                    this.lf.tryRelease();
                }
            }
            catch (Exception e) {
                if (!Trace.TRACE) break block3;
                Trace.printSystemOut(e.toString());
            }
        }
        this.lf = null;
    }
}

