/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import org.hsqldb.lib.IntValueHashMap;

public class ArrayUtil {
    public static final int CLASS_CODE_BYTE = 66;
    public static final int CLASS_CODE_CHAR = 67;
    public static final int CLASS_CODE_DOUBLE = 68;
    public static final int CLASS_CODE_FLOAT = 70;
    public static final int CLASS_CODE_INT = 73;
    public static final int CLASS_CODE_LONG = 74;
    public static final int CLASS_CODE_OBJECT = 76;
    public static final int CLASS_CODE_SHORT = 83;
    public static final int CLASS_CODE_BOOLEAN = 90;
    private static IntValueHashMap classCodeMap = new IntValueHashMap();

    static {
        classCodeMap.put(Byte.TYPE, 66);
        classCodeMap.put(Character.TYPE, 83);
        classCodeMap.put(Short.TYPE, 83);
        classCodeMap.put(Integer.TYPE, 73);
        classCodeMap.put(Long.TYPE, 74);
        classCodeMap.put(Float.TYPE, 70);
        classCodeMap.put(Double.TYPE, 68);
        classCodeMap.put(Boolean.TYPE, 90);
        classCodeMap.put(Object.class, 76);
    }

    static int getClassCode(Class cla) {
        if (!cla.isPrimitive()) {
            return 76;
        }
        return classCodeMap.get((Object)cla, -1);
    }

    public static void clearArray(int type, Object data, int from, int to) {
        switch (type) {
            case 66: {
                byte[] array = (byte[])data;
                while (--to >= from) {
                    array[to] = 0;
                }
                return;
            }
            case 67: {
                byte[] array = (byte[])data;
                while (--to >= from) {
                    array[to] = 0;
                }
                return;
            }
            case 83: {
                short[] array = (short[])data;
                while (--to >= from) {
                    array[to] = 0;
                }
                return;
            }
            case 73: {
                int[] array = (int[])data;
                while (--to >= from) {
                    array[to] = 0;
                }
                return;
            }
            case 74: {
                long[] array = (long[])data;
                while (--to >= from) {
                    array[to] = 0L;
                }
                return;
            }
            case 70: {
                float[] array = (float[])data;
                while (--to >= from) {
                    array[to] = 0.0f;
                }
                return;
            }
            case 68: {
                double[] array = (double[])data;
                while (--to >= from) {
                    array[to] = 0.0;
                }
                return;
            }
            case 90: {
                boolean[] array = (boolean[])data;
                while (--to >= from) {
                    array[to] = false;
                }
                return;
            }
        }
        Object[] array = (Object[])data;
        while (--to >= from) {
            array[to] = null;
        }
    }

    public static void adjustArray(int type, Object array, int usedElements, int index, int count) {
        int size;
        int target;
        int source;
        if (index >= usedElements) {
            return;
        }
        int newCount = usedElements + count;
        if (count >= 0) {
            source = index;
            target = index + count;
            size = usedElements - index;
        } else {
            source = index - count;
            target = index;
            size = usedElements - index + count;
        }
        if (size > 0) {
            System.arraycopy(array, source, array, target, size);
        }
        if (count < 0) {
            ArrayUtil.clearArray(type, array, newCount, usedElements);
        }
    }

    public static void sortArray(int[] array) {
        boolean swapped;
        do {
            swapped = false;
            int i = 0;
            while (i < array.length - 1) {
                if (array[i] > array[i + 1]) {
                    int temp = array[i + 1];
                    array[i + 1] = array[i];
                    array[i] = temp;
                    swapped = true;
                }
                ++i;
            }
        } while (swapped);
    }

    public static int find(Object[] array, Object object) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == object) {
                return i;
            }
            if (object != null && object.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int find(int[] array, int value) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int findNot(int[] array, int value) {
        int i = 0;
        while (i < array.length) {
            if (array[i] != value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean areEqualSets(int[] arra, int[] arrb) {
        return arra.length == arrb.length && ArrayUtil.haveEqualSets(arra, arrb, arra.length);
    }

    public static boolean areEqual(int[] arra, int[] arrb, int count, boolean full) {
        if (ArrayUtil.haveEqualArrays(arra, arrb, count)) {
            if (full) {
                return arra.length == arrb.length && count == arra.length;
            }
            return true;
        }
        return false;
    }

    public static boolean haveEqualSets(int[] arra, int[] arrb, int count) {
        if (count > arra.length || count > arrb.length) {
            return false;
        }
        if (count == 1) {
            return arra[0] == arrb[0];
        }
        int[] tempa = (int[])ArrayUtil.resizeArray(arra, count);
        int[] tempb = (int[])ArrayUtil.resizeArray(arrb, count);
        ArrayUtil.sortArray(tempa);
        ArrayUtil.sortArray(tempb);
        int j = 0;
        while (j < count) {
            if (tempa[j] != tempb[j]) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static boolean haveEqualArrays(int[] arra, int[] arrb, int count) {
        if (count > arra.length || count > arrb.length) {
            return false;
        }
        int j = 0;
        while (j < count) {
            if (arra[j] != arrb[j]) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static boolean haveEqualArrays(Object[] arra, Object[] arrb, int count) {
        if (count > arra.length || count > arrb.length) {
            return false;
        }
        int j = 0;
        while (j < count) {
            if (!(arra[j] == arrb[j] || arra[j] != null && arra[j].equals(arrb[j]))) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static boolean haveCommonElement(int[] arra, int[] arrb, int bcount) {
        int i = 0;
        while (i < arra.length) {
            int c = arra[i];
            int j = 0;
            while (j < bcount) {
                if (c == arrb[j]) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static int[] commonElements(int[] arra, int[] arrb) {
        int[] c = null;
        int n = ArrayUtil.countCommonElements(arra, arrb);
        if (n > 0) {
            c = new int[n];
            int k = 0;
            int i = 0;
            while (i < arra.length) {
                int j = 0;
                while (j < arrb.length) {
                    if (arra[i] == arrb[j]) {
                        c[k++] = arra[i];
                    }
                    ++j;
                }
                ++i;
            }
        }
        return c;
    }

    public static int countCommonElements(int[] arra, int[] arrb) {
        int k = 0;
        int i = 0;
        while (i < arra.length) {
            int j = 0;
            while (j < arrb.length) {
                if (arra[i] == arrb[j]) {
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return k;
    }

    public static int countSameElements(byte[] arra, int start, byte[] arrb) {
        int k = 0;
        int limit = arra.length - start;
        if (limit > arrb.length) {
            limit = arrb.length;
        }
        int i = 0;
        while (i < limit) {
            if (arra[i + start] != arrb[i]) break;
            ++k;
            ++i;
        }
        return k;
    }

    public static int find(byte[] arra, int start, int limit, byte[] arrb) {
        int k = 0;
        limit = limit - arrb.length + 1;
        byte value = arrb[0];
        while (k < limit) {
            if (arra[k] == value) {
                if (arrb.length == 1) {
                    return k;
                }
                if (ArrayUtil.containsAt(arra, k, arrb)) {
                    return k;
                }
            }
            ++k;
        }
        return -1;
    }

    public static int findNotIn(byte[] arra, int start, int limit, byte[] charset) {
        int k = 0;
        if (k < limit) {
            int i = 0;
            while (i < charset.length) {
                if (arra[k] == charset[i]) {
                    // empty if block
                }
                ++i;
            }
            return k;
        }
        return -1;
    }

    public static int findIn(byte[] arra, int start, int limit, byte[] charset) {
        int k = 0;
        while (k < limit) {
            int i = 0;
            while (i < charset.length) {
                if (arra[k] == charset[i]) {
                    return k;
                }
                ++i;
            }
            ++k;
        }
        return -1;
    }

    public static int find(byte[] arra, int start, int limit, int b, int c) {
        int k = 0;
        while (k < limit) {
            if (arra[k] == b || arra[k] == c) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public static void intIndexesToBooleanArray(int[] arra, boolean[] arrb) {
        int i = 0;
        while (i < arra.length) {
            if (arra[i] < arrb.length) {
                arrb[arra[i]] = true;
            }
            ++i;
        }
    }

    public static boolean containsAllTrueElements(boolean[] arra, boolean[] arrb) {
        int i = 0;
        while (i < arra.length) {
            if (arrb[i] && !arra[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsAt(byte[] arra, int start, byte[] arrb) {
        return ArrayUtil.countSameElements(arra, start, arrb) == arrb.length;
    }

    public static int countStartElementsAt(byte[] arra, int start, byte[] arrb) {
        int k = 0;
        int i = start;
        block0: while (i < arra.length) {
            int j = 0;
            while (j < arrb.length) {
                if (arra[i] == arrb[j]) {
                    ++k;
                } else {
                    ++j;
                    continue;
                }
                ++i;
                continue block0;
            }
            break block0;
        }
        return k;
    }

    public static int countNonStartElementsAt(byte[] arra, int start, byte[] arrb) {
        int k = 0;
        int i = start;
        block0: while (i < arra.length) {
            int j = 0;
            while (j < arrb.length) {
                if (arra[i] == arrb[j]) break block0;
                ++j;
            }
            ++k;
            ++i;
        }
        return k;
    }

    public static void copyArray(Object source, Object dest, int count) {
        System.arraycopy(source, 0, dest, 0, count);
    }

    public static int[] arraySlice(int[] source, int start, int count) {
        int[] slice = new int[count];
        System.arraycopy(source, start, slice, 0, count);
        return slice;
    }

    public static void fillArray(Object[] array, Object value) {
        int to = array.length;
        while (--to >= 0) {
            array[to] = value;
        }
    }

    public static void fillArray(int[] array, int value) {
        int to = array.length;
        while (--to >= 0) {
            array[to] = value;
        }
    }

    public static Object duplicateArray(Object source) {
        int size = Array.getLength(source);
        Object newarray = Array.newInstance(source.getClass().getComponentType(), size);
        System.arraycopy(source, 0, newarray, 0, size);
        return newarray;
    }

    public static Object resizeArrayIfDifferent(Object source, int newsize) {
        int oldsize = Array.getLength(source);
        if (oldsize == newsize) {
            return source;
        }
        Object newarray = Array.newInstance(source.getClass().getComponentType(), newsize);
        if (oldsize < newsize) {
            newsize = oldsize;
        }
        System.arraycopy(source, 0, newarray, 0, newsize);
        return newarray;
    }

    public static Object resizeArray(Object source, int newsize) {
        Object newarray = Array.newInstance(source.getClass().getComponentType(), newsize);
        int oldsize = Array.getLength(source);
        if (oldsize < newsize) {
            newsize = oldsize;
        }
        System.arraycopy(source, 0, newarray, 0, newsize);
        return newarray;
    }

    public static Object toAdjustedArray(Object source, Object addition, int colindex, int adjust) {
        int newsize = Array.getLength(source) + adjust;
        Object newarray = Array.newInstance(source.getClass().getComponentType(), newsize);
        ArrayUtil.copyAdjustArray(source, newarray, addition, colindex, adjust);
        return newarray;
    }

    public static void copyAdjustArray(Object source, Object dest, Object addition, int colindex, int adjust) {
        int length = Array.getLength(source);
        if (colindex < 0) {
            System.arraycopy(source, 0, dest, 0, length);
            return;
        }
        System.arraycopy(source, 0, dest, 0, colindex);
        if (adjust == 0) {
            int endcount = length - colindex - 1;
            Array.set(dest, colindex, addition);
            if (endcount > 0) {
                System.arraycopy(source, colindex + 1, dest, colindex + 1, endcount);
            }
        } else if (adjust < 0) {
            int endcount = length - colindex - 1;
            if (endcount > 0) {
                System.arraycopy(source, colindex + 1, dest, colindex, endcount);
            }
        } else {
            int endcount = length - colindex;
            Array.set(dest, colindex, addition);
            if (endcount > 0) {
                System.arraycopy(source, colindex, dest, colindex + 1, endcount);
            }
        }
    }

    public static int[] toAdjustedColumnArray(int[] colarr, int colindex, int adjust) {
        if (colarr == null) {
            return null;
        }
        int[] intarr = new int[colarr.length];
        int j = 0;
        int i = 0;
        while (i < colarr.length) {
            if (colarr[i] > colindex) {
                intarr[j] = colarr[i] + adjust;
                ++j;
            } else if (colarr[i] == colindex) {
                if (adjust >= 0) {
                    intarr[j] = colarr[i] + adjust;
                    ++j;
                }
            } else {
                intarr[j] = colarr[i];
                ++j;
            }
            ++i;
        }
        if (colarr.length != j) {
            int[] newarr = new int[j];
            ArrayUtil.copyArray(intarr, newarr, j);
            return newarr;
        }
        return intarr;
    }

    public static void copyColumnValues(Object[] row, int[] colindex, Object[] colobject) {
        int i = 0;
        while (i < colindex.length) {
            colobject[i] = row[colindex[i]];
            ++i;
        }
    }

    public static void copyColumnValues(int[] row, int[] colindex, int[] colobject) {
        int i = 0;
        while (i < colindex.length) {
            colobject[i] = row[colindex[i]];
            ++i;
        }
    }

    public static void fillSequence(int[] colindex) {
        int i = 0;
        while (i < colindex.length) {
            colindex[i] = i;
            ++i;
        }
    }
}

