/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.util.Locale;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Token;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.store.ValuePool;

public class Tokenizer {
    private static final int NO_TYPE = 0;
    private static final int NAME = 1;
    private static final int LONG_NAME = 2;
    private static final int SPECIAL = 3;
    private static final int NUMBER = 4;
    private static final int FLOAT = 5;
    private static final int STRING = 6;
    private static final int LONG = 7;
    private static final int DECIMAL = 8;
    private static final int BOOLEAN = 9;
    private static final int DATE = 10;
    private static final int TIME = 11;
    private static final int TIMESTAMP = 12;
    private static final int NULL = 13;
    private static final int NAMED_PARAM = 14;
    private static final int QUOTED_IDENTIFIER = 15;
    private static final int REMARK_LINE = 16;
    private static final int REMARK = 17;
    private String sCommand;
    private int iLength;
    private int iIndex;
    private int tokenIndex;
    private int nextTokenIndex;
    private int beginIndex;
    private int iType;
    private String sToken;
    private int indexLongNameFirst = -1;
    private String sLongNameFirst = null;
    private int typeLongNameFirst;
    private boolean retainFirst = false;
    private boolean bWait;
    private boolean lastTokenQuotedID;
    static IntValueHashMap valueTokens = new IntValueHashMap();
    static BigDecimal LONG_MAX_VALUE_INCREMENT;

    static {
        valueTokens.put("NULL", 13);
        valueTokens.put("TRUE", 9);
        valueTokens.put("FALSE", 9);
        LONG_MAX_VALUE_INCREMENT = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1L));
    }

    public Tokenizer() {
    }

    public Tokenizer(String s) {
        this.sCommand = s;
        this.iLength = s.length();
        this.iIndex = 0;
    }

    public void reset(String s) {
        this.sCommand = s;
        this.iLength = s.length();
        this.iIndex = 0;
        this.tokenIndex = 0;
        this.nextTokenIndex = 0;
        this.beginIndex = 0;
        this.iType = 0;
        this.typeLongNameFirst = 0;
        this.sToken = null;
        this.indexLongNameFirst = -1;
        this.sLongNameFirst = null;
        this.bWait = false;
        this.lastTokenQuotedID = false;
        this.retainFirst = false;
    }

    void back() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        this.nextTokenIndex = this.iIndex;
        this.iIndex = this.indexLongNameFirst != -1 ? this.indexLongNameFirst : this.tokenIndex;
        this.bWait = true;
    }

    String getThis(String match) throws HsqlException {
        this.getToken();
        this.matchThis(match);
        return this.sToken;
    }

    void matchThis(String match) throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        if (!this.sToken.equals(match) || this.iType == 15 || this.iType == 2) {
            String token = this.iType == 2 ? this.sLongNameFirst : this.sToken;
            throw Trace.error(11, 160, new Object[]{token, match});
        }
    }

    void throwUnexpected() throws HsqlException {
        String token = this.iType == 2 ? this.sLongNameFirst : this.sToken;
        throw Trace.error(11, token);
    }

    public boolean isGetThis(String match) throws HsqlException {
        this.getToken();
        if (this.iType != 15 && this.iType != 2 && this.sToken.equals(match)) {
            return true;
        }
        this.back();
        return false;
    }

    boolean wasValue() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        switch (this.iType) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    boolean wasQuotedIdentifier() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        return this.lastTokenQuotedID;
    }

    boolean wasFirstQuotedIdentifier() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        return this.typeLongNameFirst == 15;
    }

    boolean wasLongName() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        return this.iType == 2;
    }

    boolean wasSimpleName() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        if (this.iType == 15 && this.sToken.length() != 0) {
            return true;
        }
        if (this.iType != 1) {
            return false;
        }
        return !Token.isKeyword(this.sToken);
    }

    boolean wasParameter() throws HsqlException {
        Trace.doAssert(!this.bWait, "Querying state when in Wait mode");
        return this.iType == 14;
    }

    boolean wasName() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        if (this.iType == 15) {
            return true;
        }
        if (this.iType != 1 && this.iType != 2) {
            return false;
        }
        return !Token.isKeyword(this.sToken);
    }

    String getLongNamePre() throws HsqlException {
        return null;
    }

    String getLongNameFirst() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        return this.sLongNameFirst;
    }

    boolean wasSimpleToken() throws HsqlException {
        return this.iType != 15 && this.iType != 2 && this.iType != 6 && this.iType != 14;
    }

    String getSimpleToken() throws HsqlException {
        this.getToken();
        if (!this.wasSimpleToken()) {
            String token = this.iType == 2 ? this.sLongNameFirst : this.sToken;
            throw Trace.error(11, token);
        }
        return this.sToken;
    }

    public boolean wasThis(String match) throws HsqlException {
        return this.sToken.equals(match) && this.iType != 15 && this.iType != 2 && this.iType != 6;
    }

    public String getName() throws HsqlException {
        this.getToken();
        if (!this.wasName()) {
            throw Trace.error(11, this.sToken);
        }
        return this.sToken;
    }

    public String getSimpleName() throws HsqlException {
        this.getToken();
        if (!this.wasSimpleName()) {
            String token = this.iType == 2 ? this.sLongNameFirst : this.sToken;
            throw Trace.error(11, token);
        }
        return this.sToken;
    }

    public String getString() throws HsqlException {
        this.getToken();
        return this.sToken;
    }

    int getInt() throws HsqlException {
        long v = this.getBigint();
        if (v > Integer.MAX_VALUE || v < Integer.MIN_VALUE) {
            throw Trace.error(16, Types.getTypeString(this.getType()));
        }
        return (int)v;
    }

    long getBigint() throws HsqlException {
        boolean minus = false;
        this.getToken();
        if (this.sToken.equals("-")) {
            minus = true;
            this.getToken();
        }
        Object o = this.getAsValue();
        int t = this.getType();
        switch (t) {
            case -5: 
            case 4: {
                break;
            }
            case 3: {
                if (minus && LONG_MAX_VALUE_INCREMENT.equals(o)) {
                    return Long.MIN_VALUE;
                }
            }
            default: {
                throw Trace.error(16, Types.getTypeString(t));
            }
        }
        long v = ((Number)o).longValue();
        return minus ? -v : v;
    }

    Object getInType(int type) throws HsqlException {
        this.getToken();
        Object o = this.getAsValue();
        int t = this.getType();
        if (t != type) {
            throw Trace.error(16, Types.getTypeString(t));
        }
        return o;
    }

    public int getType() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        switch (this.iType) {
            case 6: {
                return 12;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return -5;
            }
            case 5: {
                return 8;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 16;
            }
            case 10: {
                return 91;
            }
            case 11: {
                return 92;
            }
            case 12: {
                return 93;
            }
        }
        return 0;
    }

    Object getAsValue() throws HsqlException {
        if (!this.wasValue()) {
            throw Trace.error(11, this.sToken);
        }
        switch (this.iType) {
            case 13: {
                return null;
            }
            case 6: {
                return this.sToken;
            }
            case 7: {
                return ValuePool.getLong(Long.parseLong(this.sToken));
            }
            case 4: {
                if (this.sToken.length() < 11) {
                    try {
                        return ValuePool.getInt(Integer.parseInt(this.sToken));
                    }
                    catch (Exception exception) {}
                }
                if (this.sToken.length() < 20) {
                    try {
                        this.iType = 7;
                        return ValuePool.getLong(Long.parseLong(this.sToken));
                    }
                    catch (Exception exception) {}
                }
                this.iType = 8;
                return new BigDecimal(this.sToken);
            }
            case 5: {
                double d = JavaSystem.parseDouble(this.sToken);
                long l = Double.doubleToLongBits(d);
                return ValuePool.getDouble(l);
            }
            case 8: {
                return new BigDecimal(this.sToken);
            }
            case 9: {
                return this.sToken.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return HsqlDateTime.dateValue(this.sToken);
            }
            case 11: {
                return HsqlDateTime.timeValue(this.sToken);
            }
            case 12: {
                return HsqlDateTime.timestampValue(this.sToken);
            }
        }
        return this.sToken;
    }

    int getPosition() {
        return this.iIndex;
    }

    String getPart(int begin, int end) {
        return this.sCommand.substring(begin, end);
    }

    int getPartMarker() {
        return this.beginIndex;
    }

    void setPartMarker() {
        this.beginIndex = this.iIndex;
    }

    void setPartMarker(int position) {
        this.beginIndex = position;
    }

    String getLastPart() {
        return this.sCommand.substring(this.beginIndex, this.iIndex);
    }

    private void getToken() throws HsqlException {
        if (this.bWait) {
            this.bWait = false;
            this.iIndex = this.nextTokenIndex;
            return;
        }
        if (!this.retainFirst) {
            this.sLongNameFirst = null;
            this.indexLongNameFirst = -1;
            this.typeLongNameFirst = 0;
        }
        while (this.iIndex < this.iLength && Character.isWhitespace(this.sCommand.charAt(this.iIndex))) {
            ++this.iIndex;
        }
        this.sToken = "";
        this.tokenIndex = this.iIndex;
        if (this.iIndex >= this.iLength) {
            this.iType = 0;
            return;
        }
        char c = this.sCommand.charAt(this.iIndex);
        boolean point = false;
        boolean digit = false;
        boolean exp = false;
        boolean afterexp = false;
        boolean end = false;
        char cfirst = '\u0000';
        this.lastTokenQuotedID = false;
        if (Character.isJavaIdentifierStart(c)) {
            this.iType = 1;
        } else if (Character.isDigit(c)) {
            this.iType = 4;
            digit = true;
        } else {
            switch (c) {
                case '(': {
                    this.sToken = "(";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case ')': {
                    this.sToken = ")";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case ',': {
                    this.sToken = ",";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '*': {
                    this.sToken = "*";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '=': {
                    this.sToken = "=";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case ';': {
                    this.sToken = ";";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '+': {
                    this.sToken = "+";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '%': {
                    this.sToken = "%";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '?': {
                    this.sToken = "?";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case ':': {
                    Trace.check(++this.iIndex < this.iLength, 12);
                    c = this.sCommand.charAt(this.iIndex);
                    Trace.check(Character.isJavaIdentifierStart(c), 74, ":" + c);
                    this.iType = 14;
                    break;
                }
                case '\"': {
                    this.lastTokenQuotedID = true;
                    this.iType = 15;
                    ++this.iIndex;
                    this.sToken = this.getString('\"');
                    if (this.iIndex == this.sCommand.length()) {
                        return;
                    }
                    c = this.sCommand.charAt(this.iIndex);
                    if (c == '.') {
                        this.sLongNameFirst = this.sToken;
                        this.indexLongNameFirst = this.tokenIndex;
                        this.typeLongNameFirst = this.iType;
                        ++this.iIndex;
                        if (this.retainFirst) {
                            throw Trace.error(226);
                        }
                        this.retainFirst = true;
                        this.getToken();
                        this.retainFirst = false;
                        this.iType = 2;
                    }
                    return;
                }
                case '\'': {
                    this.iType = 6;
                    ++this.iIndex;
                    this.sToken = this.getString('\'');
                    return;
                }
                case '!': 
                case '-': 
                case '/': 
                case '<': 
                case '>': 
                case '|': {
                    cfirst = c;
                    this.iType = 3;
                    break;
                }
                case '.': {
                    this.iType = 8;
                    point = true;
                    break;
                }
                default: {
                    throw Trace.error(11, String.valueOf(c));
                }
            }
        }
        int start = this.iIndex++;
        while (true) {
            if (this.iIndex >= this.iLength) {
                c = ' ';
                end = true;
                Trace.check(this.iType != 6 && this.iType != 15, 12);
            } else {
                c = this.sCommand.charAt(this.iIndex);
            }
            switch (this.iType) {
                case 1: 
                case 14: {
                    int type;
                    if (Character.isJavaIdentifierPart(c)) break;
                    this.sToken = this.sCommand.substring(start, this.iIndex).toUpperCase(Locale.ENGLISH);
                    if (this.iType == 14) {
                        return;
                    }
                    if (c == '.') {
                        this.typeLongNameFirst = this.iType;
                        this.sLongNameFirst = this.sToken;
                        this.indexLongNameFirst = this.tokenIndex;
                        ++this.iIndex;
                        if (this.retainFirst) {
                            throw Trace.error(226);
                        }
                        this.retainFirst = true;
                        this.getToken();
                        this.retainFirst = false;
                        this.iType = 2;
                    } else if (c != '(' && (type = valueTokens.get((Object)this.sToken, -1)) != -1) {
                        this.iType = type;
                    }
                    return;
                }
                case 6: 
                case 15: {
                    break;
                }
                case 17: {
                    if (end) {
                        this.iType = 0;
                        return;
                    }
                    if (c != 42) break;
                    ++this.iIndex;
                    if (this.iIndex >= this.iLength || this.sCommand.charAt(this.iIndex) != '/') break;
                    ++this.iIndex;
                    this.getToken();
                    return;
                }
                case 16: {
                    if (end) {
                        this.iType = 0;
                        return;
                    }
                    if (c != '\r' && c != 10) break;
                    this.getToken();
                    return;
                }
                case 3: {
                    if (c == '/' && cfirst == '/') {
                        this.iType = 16;
                        break;
                    }
                    if (c == '-' && cfirst == '-') {
                        this.iType = 16;
                        break;
                    }
                    if (c == '*' && cfirst == '/') {
                        this.iType = 17;
                        break;
                    }
                    if (c == '>' || c == '=' || c == '|') break;
                    this.sToken = this.sCommand.substring(start, this.iIndex);
                    return;
                }
                case 4: 
                case 5: 
                case 8: {
                    if (Character.isDigit(c)) {
                        digit = true;
                        break;
                    }
                    if (c == '.') {
                        this.iType = 8;
                        if (point) {
                            throw Trace.error(11, ".");
                        }
                        point = true;
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        if (exp) {
                            throw Trace.error(11, "E");
                        }
                        this.iType = 5;
                        afterexp = true;
                        point = true;
                        exp = true;
                        break;
                    }
                    if (c == '-' && afterexp) {
                        afterexp = false;
                        break;
                    }
                    if (c == '+' && afterexp) {
                        afterexp = false;
                        break;
                    }
                    afterexp = false;
                    if (!digit) {
                        if (point && start == this.iIndex - 1) {
                            this.sToken = ".";
                            this.iType = 3;
                            return;
                        }
                        throw Trace.error(11, String.valueOf(c));
                    }
                    this.sToken = this.sCommand.substring(start, this.iIndex);
                    return;
                }
            }
            ++this.iIndex;
        }
    }

    private String getString(char quoteChar) throws HsqlException {
        try {
            int nextIndex = this.iIndex;
            boolean quoteInside = false;
            while (true) {
                if ((nextIndex = this.sCommand.indexOf(quoteChar, nextIndex)) < 0) {
                    throw Trace.error(12);
                }
                if (nextIndex >= this.iLength - 1 || this.sCommand.charAt(nextIndex + 1) != quoteChar) break;
                quoteInside = true;
                nextIndex += 2;
            }
            char[] chBuffer = new char[nextIndex - this.iIndex];
            this.sCommand.getChars(this.iIndex, nextIndex, chBuffer, 0);
            int j = chBuffer.length;
            if (quoteInside) {
                j = 0;
                int i = 0;
                while (i < chBuffer.length) {
                    if (chBuffer[i] == quoteChar) {
                        ++i;
                    }
                    chBuffer[j] = chBuffer[i];
                    ++i;
                    ++j;
                }
            }
            this.iIndex = ++nextIndex;
            return new String(chBuffer, 0, j);
        }
        catch (HsqlException e) {
            throw e;
        }
        catch (Exception e) {
            e.toString();
            return null;
        }
    }

    int getLength() {
        return this.iLength;
    }
}

