/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.CompiledStatement;
import org.hsqldb.CompiledStatementExecutor;
import org.hsqldb.CompiledStatementManager;
import org.hsqldb.Database;
import org.hsqldb.DatabaseCommandInterpreter;
import org.hsqldb.Expression;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Node;
import org.hsqldb.Parser;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.SessionInterface;
import org.hsqldb.Table;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Transaction;
import org.hsqldb.User;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.store.ValuePool;

public class Session
implements SessionInterface {
    private volatile boolean isAutoCommit;
    private volatile boolean isReadOnly;
    private volatile boolean isClosed;
    Database database;
    private User user;
    HsqlArrayList rowActionList;
    private boolean isNestedTransaction;
    private int nestedOldTransIndex;
    int isolationMode = 2;
    long actionTimestamp;
    long transactionTimestamp;
    private int currentMaxRows;
    private int sessionMaxRows;
    private Number lastIdentity = ValuePool.getInt(0);
    private final int sessionId;
    HashMappedList savepoints;
    private boolean script;
    private Tokenizer tokenizer;
    private Parser parser;
    static final Result emptyUpdateCount = new Result(1);
    private jdbcConnection intConnection;
    public HsqlNameManager.HsqlName currentSchema;
    public HsqlNameManager.HsqlName loggedSchema;
    private HsqlNameManager.HsqlName oldSchema;
    boolean isProcessingScript;
    boolean isProcessingLog;
    private IntKeyHashMap indexArrayMap;
    private IntKeyHashMap indexArrayKeepMap;
    private final long connectTime = System.currentTimeMillis();
    DatabaseCommandInterpreter dbCommandInterpreter;
    CompiledStatementExecutor compiledStatementExecutor;
    CompiledStatementManager compiledStatementManager;
    long currentDateTimeSCN;
    long currentMillis;
    Date currentDate;
    Time currentTime;
    Timestamp currentTimestamp;
    HsqlArrayList sqlWarnings;

    Session getSession() {
        return this;
    }

    Session(Database db, User user, boolean autocommit, boolean readonly, int id) {
        this.sessionId = id;
        this.database = db;
        this.user = user;
        this.rowActionList = new HsqlArrayList(true);
        this.savepoints = new HashMappedList(4);
        this.isAutoCommit = autocommit;
        this.isReadOnly = readonly;
        this.dbCommandInterpreter = new DatabaseCommandInterpreter(this);
        this.compiledStatementExecutor = new CompiledStatementExecutor(this);
        this.compiledStatementManager = db.compiledStatementManager;
        this.tokenizer = new Tokenizer();
        this.parser = new Parser(this, this.database, this.tokenizer);
        this.resetSchema();
    }

    void resetSchema() {
        HsqlNameManager.HsqlName initialSchema = this.user.getInitialSchema();
        this.currentSchema = initialSchema == null ? this.database.schemaManager.getDefaultSchemaHsqlName() : initialSchema;
    }

    public int getId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isClosed) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.isClosed) {
                return;
            }
            this.database.sessionManager.removeSession(this);
            this.rollback();
            try {
                this.database.logger.writeToLog(this, "DISCONNECT");
            }
            catch (HsqlException hsqlException) {}
            this.clearIndexRoots();
            this.clearIndexRootsKeep();
            this.compiledStatementManager.removeSession(this.sessionId);
            this.database.closeIfLast();
            this.database = null;
            this.user = null;
            this.rowActionList = null;
            this.savepoints = null;
            this.intConnection = null;
            this.compiledStatementExecutor = null;
            this.compiledStatementManager = null;
            this.dbCommandInterpreter = null;
            this.lastIdentity = null;
            this.isClosed = true;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setIsolation(int level) throws HsqlException {
        this.isolationMode = level;
    }

    public int getIsolation() throws HsqlException {
        return this.isolationMode;
    }

    void setLastIdentity(Number i) {
        this.lastIdentity = i;
    }

    Number getLastIdentity() {
        return this.lastIdentity;
    }

    Database getDatabase() {
        return this.database;
    }

    String getUsername() {
        return this.user.getName();
    }

    public User getUser() {
        return this.user;
    }

    void setUser(User user) {
        this.user = user;
    }

    int getMaxRows() {
        return this.currentMaxRows;
    }

    int getSQLMaxRows() {
        return this.sessionMaxRows;
    }

    void setSQLMaxRows(int rows) {
        this.currentMaxRows = this.sessionMaxRows = rows;
    }

    void checkAdmin() throws HsqlException {
        this.user.checkAdmin();
    }

    void check(HsqlNameManager.HsqlName object, int right) throws HsqlException {
        this.user.check(object, right);
    }

    void check(String object) throws HsqlException {
        this.user.check(object);
    }

    void checkReadWrite() throws HsqlException {
        if (this.isReadOnly) {
            throw Trace.error(31);
        }
    }

    void checkDDLWrite() throws HsqlException {
        if (this.database.isFilesReadOnly() && !this.user.isSys()) {
            throw Trace.error(31);
        }
        this.checkReadWrite();
    }

    boolean addDeleteAction(Table table, Row row) throws HsqlException {
        if (!this.isAutoCommit || this.isNestedTransaction) {
            Transaction t = new Transaction(true, table, row, this.actionTimestamp);
            this.rowActionList.add(t);
            this.database.txManager.addTransaction(this, t);
            return true;
        }
        table.removeRowFromStore(row);
        return false;
    }

    boolean addInsertAction(Table table, Row row) throws HsqlException {
        if (!this.isAutoCommit || this.isNestedTransaction) {
            Transaction t = new Transaction(false, table, row, this.actionTimestamp);
            this.rowActionList.add(t);
            this.database.txManager.addTransaction(this, t);
            return true;
        }
        table.commitRowToStore(row);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCommit(boolean autocommit) {
        if (this.isClosed) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (autocommit != this.isAutoCommit) {
                this.commit();
                this.isAutoCommit = autocommit;
                try {
                    this.database.logger.writeToLog(this, this.getAutoCommitStatement());
                }
                catch (HsqlException hsqlException) {}
            }
        }
    }

    public void startPhasedTransaction() throws HsqlException {
    }

    public void prepareCommit() throws HsqlException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (this.isClosed) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (!this.rowActionList.isEmpty()) {
                try {
                    this.database.logger.writeCommitStatement(this);
                }
                catch (HsqlException hsqlException) {}
            }
            this.database.txManager.commit(this);
            this.clearIndexRoots();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        if (this.isClosed) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.rowActionList.size() != 0) {
                try {
                    this.database.logger.writeToLog(this, "ROLLBACK");
                }
                catch (HsqlException hsqlException) {}
            }
            this.database.txManager.rollback(this);
            this.clearIndexRoots();
        }
    }

    public void resetSession() throws HsqlException {
        throw new HsqlException("", "", 0);
    }

    void savepoint(String name) throws HsqlException {
        this.savepoints.remove(name);
        this.savepoints.add(name, ValuePool.getInt(this.rowActionList.size()));
        try {
            this.database.logger.writeToLog(this, "SAVEPOINT " + name);
        }
        catch (HsqlException hsqlException) {}
    }

    void rollbackToSavepoint(String name) throws HsqlException {
        if (this.isClosed) {
            return;
        }
        try {
            this.database.logger.writeToLog(this, "ROLLBACK TO SAVEPOINT " + name);
        }
        catch (HsqlException hsqlException) {}
        this.database.txManager.rollbackSavepoint(this, name);
    }

    void releaseSavepoint(String name) throws HsqlException {
        int index = this.savepoints.getIndex(name);
        Trace.check(index >= 0, 44, name);
        while (this.savepoints.size() > index) {
            this.savepoints.remove(this.savepoints.size() - 1);
        }
    }

    void beginNestedTransaction() throws HsqlException {
        if (this.isNestedTransaction) {
            Trace.doAssert(false, "beginNestedTransaction");
        }
        this.nestedOldTransIndex = this.rowActionList.size();
        this.isNestedTransaction = true;
        if (this.isAutoCommit) {
            try {
                this.database.logger.writeToLog(this, "SET AUTOCOMMIT FALSE");
            }
            catch (HsqlException hsqlException) {}
        }
    }

    void endNestedTransaction(boolean rollback) throws HsqlException {
        if (!this.isNestedTransaction) {
            Trace.doAssert(false, "endNestedTransaction");
        }
        if (rollback) {
            this.database.txManager.rollbackTransactions(this, this.nestedOldTransIndex, true);
        }
        this.isNestedTransaction = false;
        if (this.isAutoCommit) {
            this.database.txManager.commit(this);
            try {
                this.database.logger.writeToLog(this, "SET AUTOCOMMIT TRUE");
            }
            catch (HsqlException hsqlException) {}
        }
    }

    public void setReadOnly(boolean readonly) throws HsqlException {
        if (!readonly && this.database.databaseReadOnly) {
            throw Trace.error(31);
        }
        this.isReadOnly = readonly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    boolean isNestedTransaction() {
        return this.isNestedTransaction;
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    void setScripting(boolean script) {
        this.script = script;
    }

    boolean getScripting() {
        return this.script;
    }

    public String getAutoCommitStatement() {
        return this.isAutoCommit ? "SET AUTOCOMMIT TRUE" : "SET AUTOCOMMIT FALSE";
    }

    jdbcConnection getInternalConnection() throws HsqlException {
        if (this.intConnection == null) {
            this.intConnection = new jdbcConnection(this);
        }
        return this.intConnection;
    }

    boolean isAdmin() {
        return this.user.isAdmin();
    }

    long getConnectTime() {
        return this.connectTime;
    }

    int getTransactionSize() {
        return this.rowActionList.size();
    }

    boolean isAccessible(String dbobject) throws HsqlException {
        return this.user.isAccessible(dbobject);
    }

    boolean isAccessible(HsqlNameManager.HsqlName dbobject) throws HsqlException {
        return this.user.isAccessible(dbobject);
    }

    CompiledStatement sqlCompileStatement(String sql) throws HsqlException {
        CompiledStatement cs;
        this.parser.reset(sql);
        int brackets = 0;
        String token = this.tokenizer.getString();
        int cmd = Token.get(token);
        switch (cmd) {
            case 313: {
                brackets = this.parser.parseOpenBracketsSelect() + 1;
            }
            case 193: {
                cs = this.parser.compileSelectStatement(brackets);
                break;
            }
            case 112: {
                cs = this.parser.compileInsertStatement();
                break;
            }
            case 222: {
                cs = this.parser.compileUpdateStatement();
                break;
            }
            case 62: {
                cs = this.parser.compileDeleteStatement();
                break;
            }
            case 23: {
                cs = this.parser.compileCallStatement();
                break;
            }
            default: {
                cs = new CompiledStatement(this.currentSchema);
            }
        }
        if (cs.type != 9) {
            while (this.tokenizer.getPosition() < this.tokenizer.getLength()) {
                token = this.tokenizer.getString();
                if (token.length() == 0 || token.equals(";")) continue;
                throw Trace.error(11, token);
            }
        }
        cs.sql = sql;
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result cmd) {
        try {
            if (this.isClosed) {
                Trace.check(false, 33, Trace.getMessage(222));
            }
        }
        catch (Throwable t) {
            return new Result(t, null);
        }
        Database database = this.database;
        synchronized (database) {
            int type = cmd.mode;
            if (this.sessionMaxRows == 0) {
                this.currentMaxRows = cmd.updateCount;
            }
            this.actionTimestamp = this.database.txManager.nextActionTimestamp();
            JavaSystem.gc();
            switch (type) {
                case 65548: {
                    Result resultout = this.sqlExecute(cmd);
                    resultout = this.performPostExecute(resultout);
                    return resultout;
                }
                case 9: {
                    Result resultout = this.sqlExecuteBatch(cmd);
                    resultout = this.performPostExecute(resultout);
                    return resultout;
                }
                case 65547: {
                    Result resultout = this.sqlExecuteDirectNoPreChecks(cmd.getMainString());
                    resultout = this.performPostExecute(resultout);
                    return resultout;
                }
                case 8: {
                    Result resultout = this.sqlExecuteBatchDirect(cmd);
                    resultout = this.performPostExecute(resultout);
                    return resultout;
                }
                case 65555: {
                    CompiledStatement cs;
                    try {
                        cs = this.compiledStatementManager.compile(this, cmd.getMainString());
                    }
                    catch (Throwable t) {
                        return new Result(t, cmd.getMainString());
                    }
                    Result rmd = cs.describeResult();
                    Result pmd = cs.describeParameters();
                    return Result.newPrepareResponse(cs.id, rmd, pmd);
                }
                case 65552: {
                    this.compiledStatementManager.freeStatement(cmd.getStatementID(), this.sessionId, false);
                    return emptyUpdateCount;
                }
                case 7: {
                    return this.getAttributes();
                }
                case 6: {
                    return this.setAttributes(cmd);
                }
                case 66541: {
                    switch (cmd.getEndTranType()) {
                        case 0: {
                            this.commit();
                            break;
                        }
                        case 1: {
                            this.rollback();
                            break;
                        }
                        case 4: {
                            try {
                                String name = cmd.getMainString();
                                this.releaseSavepoint(name);
                                break;
                            }
                            catch (Throwable t) {
                                return new Result(t, null);
                            }
                        }
                        case 2: {
                            try {
                                this.rollbackToSavepoint(cmd.getMainString());
                                break;
                            }
                            catch (Throwable t) {
                                return new Result(t, null);
                            }
                        }
                    }
                    return emptyUpdateCount;
                }
                case 66552: {
                    switch (cmd.getConnectionAttrType()) {
                        case 10027: {
                            try {
                                this.savepoint(cmd.getMainString());
                                break;
                            }
                            catch (Throwable t) {
                                return new Result(t, null);
                            }
                        }
                    }
                    return emptyUpdateCount;
                }
                case 65545: {
                    this.close();
                    return emptyUpdateCount;
                }
            }
            return new Result(Trace.runtimeError(201, "Session.execute()"), null);
        }
    }

    /*
     * Loose catch block
     */
    private Result performPostExecute(Result r) {
        Result result;
        block13: {
            if (this.database != null) {
                this.database.schemaManager.logSequences(this, this.database.logger);
                if (this.isAutoCommit) {
                    this.clearIndexRoots();
                    this.database.logger.synchLog();
                }
            }
            result = r;
            if (this.database == null || !this.database.logger.needsCheckpoint()) break block13;
            try {
                this.database.logger.checkpoint(false);
            }
            catch (HsqlException hsqlException) {
                this.database.logger.appLog.logContext(SimpleLog.LOG_ERROR, "checkpoint did not complete");
            }
        }
        return result;
        catch (Exception e) {
            Result result2;
            block14: {
                try {
                    result2 = new Result(e, null);
                    if (this.database == null || !this.database.logger.needsCheckpoint()) break block14;
                }
                catch (Throwable throwable) {
                    if (this.database != null && this.database.logger.needsCheckpoint()) {
                        try {
                            this.database.logger.checkpoint(false);
                        }
                        catch (HsqlException hsqlException) {
                            this.database.logger.appLog.logContext(SimpleLog.LOG_ERROR, "checkpoint did not complete");
                        }
                    }
                    throw throwable;
                }
                try {
                    this.database.logger.checkpoint(false);
                }
                catch (HsqlException hsqlException) {
                    this.database.logger.appLog.logContext(SimpleLog.LOG_ERROR, "checkpoint did not complete");
                }
            }
            return result2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result sqlExecuteDirectNoPreChecks(String sql) {
        Database database = this.database;
        synchronized (database) {
            return this.dbCommandInterpreter.execute(sql);
        }
    }

    Result sqlExecuteCompiledNoPreChecks(CompiledStatement cs, Object[] pvals) {
        return this.compiledStatementExecutor.execute(cs, pvals);
    }

    private Result sqlExecuteBatch(Result cmd) {
        int csid = cmd.getStatementID();
        CompiledStatement cs = this.database.compiledStatementManager.getStatement(this, csid);
        if (cs == null) {
            return new Result(Trace.runtimeError(203, null), null);
        }
        Expression[] cfr_ignored_0 = cs.parameters;
        int count = 0;
        int[] updateCounts = new int[cmd.getSize()];
        Record record = cmd.rRoot;
        while (record != null) {
            Object[] pvals = record.data;
            Result in = this.sqlExecuteCompiledNoPreChecks(cs, pvals);
            if (in.mode == 1) {
                updateCounts[count++] = in.updateCount;
            } else if (in.isData()) {
                updateCounts[count++] = -2;
            } else {
                updateCounts = ArrayUtil.arraySlice(updateCounts, 0, count);
                break;
            }
            record = record.next;
        }
        Result out = new Result(65548, updateCounts, 0);
        return out;
    }

    private Result sqlExecuteBatchDirect(Result cmd) {
        int count = 0;
        int[] updateCounts = new int[cmd.getSize()];
        Record record = cmd.rRoot;
        while (record != null) {
            Result in;
            String sql = (String)record.data[0];
            try {
                in = this.dbCommandInterpreter.execute(sql);
            }
            catch (Throwable throwable) {
                in = new Result(2);
            }
            if (in.mode == 1) {
                updateCounts[count++] = in.updateCount;
            } else if (in.isData()) {
                updateCounts[count++] = -2;
            } else {
                updateCounts = ArrayUtil.arraySlice(updateCounts, 0, count);
                break;
            }
            record = record.next;
        }
        Result out = new Result(65548, updateCounts, 0);
        return out;
    }

    private Result sqlExecute(Result cmd) {
        int csid = cmd.getStatementID();
        CompiledStatement cs = this.compiledStatementManager.getStatement(this, csid);
        if (cs == null) {
            return new Result(Trace.runtimeError(203, null), null);
        }
        Object[] pvals = cmd.getParameterData();
        return this.sqlExecute(cs, pvals);
    }

    private Result sqlExecute(CompiledStatement cs, Object[] pvals) {
        return this.sqlExecuteCompiledNoPreChecks(cs, pvals);
    }

    Date getCurrentDate() {
        if (this.currentDateTimeSCN != this.actionTimestamp) {
            this.currentDateTimeSCN = this.actionTimestamp;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = HsqlDateTime.getCurrentDate(this.currentMillis);
            this.currentTime = null;
            this.currentTimestamp = null;
        } else if (this.currentDate == null) {
            this.currentDate = HsqlDateTime.getCurrentDate(this.currentMillis);
        }
        return this.currentDate;
    }

    Time getCurrentTime() {
        if (this.currentDateTimeSCN != this.actionTimestamp) {
            this.currentDateTimeSCN = this.actionTimestamp;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = null;
            this.currentTime = new Time(HsqlDateTime.getNormalisedTime(this.currentMillis));
            this.currentTimestamp = null;
        } else if (this.currentTime == null) {
            this.currentTime = new Time(HsqlDateTime.getNormalisedTime(this.currentMillis));
        }
        return this.currentTime;
    }

    Timestamp getCurrentTimestamp() {
        if (this.currentDateTimeSCN != this.actionTimestamp) {
            this.currentDateTimeSCN = this.actionTimestamp;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = null;
            this.currentTime = null;
            this.currentTimestamp = HsqlDateTime.getTimestamp(this.currentMillis);
        } else if (this.currentTimestamp == null) {
            this.currentTimestamp = HsqlDateTime.getTimestamp(this.currentMillis);
        }
        return this.currentTimestamp;
    }

    Result getAttributes() {
        Result r = Result.newSessionAttributesResult();
        Object[] row = new Object[]{this.database.getURI(), this.getUsername(), ValuePool.getInt(this.sessionId), ValuePool.getInt(this.isolationMode), ValuePool.getBoolean(this.isAutoCommit), ValuePool.getBoolean(this.database.databaseReadOnly), ValuePool.getBoolean(this.isReadOnly)};
        r.add(row);
        return r;
    }

    Result setAttributes(Result r) {
        Object[] row = r.rRoot.data;
        int i = 0;
        while (i < row.length) {
            Object value = row[i];
            if (value != null) {
                try {
                    switch (i) {
                        case 4: {
                            this.setAutoCommit((Boolean)value);
                            break;
                        }
                        case 6: {
                            this.setReadOnly((Boolean)value);
                        }
                    }
                }
                catch (HsqlException e) {
                    return new Result(e, null);
                }
            }
            ++i;
        }
        return emptyUpdateCount;
    }

    public String getInternalConnectionURL() {
        return "jdbc:hsqldb:" + this.database.getURI();
    }

    boolean isProcessingScript() {
        return this.isProcessingScript;
    }

    boolean isProcessingLog() {
        return this.isProcessingLog;
    }

    boolean isSchemaDefintion() {
        return this.oldSchema != null;
    }

    void startSchemaDefinition(String schema) throws HsqlException {
        if (this.isProcessingScript) {
            this.setSchema(schema);
            return;
        }
        this.oldSchema = this.currentSchema;
        this.setSchema(schema);
    }

    void endSchemaDefinition() throws HsqlException {
        if (this.oldSchema == null) {
            return;
        }
        this.currentSchema = this.oldSchema;
        this.oldSchema = null;
        this.database.logger.writeToLog(this, "SET SCHEMA " + this.currentSchema.statementName);
    }

    public void setSchema(String schema) throws HsqlException {
        this.currentSchema = this.database.schemaManager.getSchemaHsqlName(schema);
    }

    HsqlNameManager.HsqlName getSchemaHsqlName(String name) throws HsqlException {
        return name == null ? this.currentSchema : this.database.schemaManager.getSchemaHsqlName(name);
    }

    public String getSchemaName(String name) throws HsqlException {
        return name == null ? this.currentSchema.name : this.database.schemaManager.getSchemaName(name);
    }

    HsqlNameManager.HsqlName getSchemaHsqlNameForWrite(String name) throws HsqlException {
        HsqlNameManager.HsqlName schema = this.getSchemaHsqlName(name);
        if (this.database.schemaManager.isSystemSchema(schema)) {
            throw Trace.error(227);
        }
        return schema;
    }

    public String getSchemaNameForWrite(String name) throws HsqlException {
        HsqlNameManager.HsqlName schema = this.getSchemaHsqlNameForWrite(name);
        return schema.name;
    }

    Node getIndexRoot(HsqlNameManager.HsqlName index, boolean preserve) {
        if (preserve) {
            if (this.indexArrayKeepMap == null) {
                return null;
            }
            return (Node)this.indexArrayKeepMap.get(index.hashCode());
        }
        if (this.indexArrayMap == null) {
            return null;
        }
        return (Node)this.indexArrayMap.get(index.hashCode());
    }

    void setIndexRoot(HsqlNameManager.HsqlName index, boolean preserve, Node root) {
        if (preserve) {
            if (this.indexArrayKeepMap == null) {
                if (root == null) {
                    return;
                }
                this.indexArrayKeepMap = new IntKeyHashMap();
            }
            this.indexArrayKeepMap.put(index.hashCode(), root);
        } else {
            if (this.indexArrayMap == null) {
                if (root == null) {
                    return;
                }
                this.indexArrayMap = new IntKeyHashMap();
            }
            this.indexArrayMap.put(index.hashCode(), root);
        }
    }

    void dropIndex(HsqlNameManager.HsqlName index, boolean preserve) {
        if (preserve) {
            if (this.indexArrayKeepMap != null) {
                this.indexArrayKeepMap.remove(index.hashCode());
            }
        } else if (this.indexArrayMap != null) {
            this.indexArrayMap.remove(index.hashCode());
        }
    }

    void clearIndexRoots() {
        if (this.indexArrayMap != null) {
            this.indexArrayMap.clear();
        }
    }

    void clearIndexRootsKeep() {
        if (this.indexArrayKeepMap != null) {
            this.indexArrayKeepMap.clear();
        }
    }

    public void addWarning(HsqlException warning) {
        if (this.sqlWarnings == null) {
            this.sqlWarnings = new HsqlArrayList(true);
        }
        this.sqlWarnings.add(warning);
    }

    public HsqlException[] getAndClearWarnings() {
        if (this.sqlWarnings == null) {
            return new HsqlException[0];
        }
        HsqlException[] array = new HsqlException[this.sqlWarnings.size()];
        this.sqlWarnings.toArray(array);
        this.sqlWarnings.clear();
        return array;
    }
}

