/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlSocketFactory;
import org.hsqldb.HsqlSocketRequestHandler;
import org.hsqldb.Result;
import org.hsqldb.ServerConfiguration;
import org.hsqldb.ServerConnection;
import org.hsqldb.Trace;
import org.hsqldb.WebServer;
import org.hsqldb.WebServerConnection;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.resources.BundleHandler;

public class Server
implements HsqlSocketRequestHandler {
    protected static final int serverBundleHandle = BundleHandler.getBundleHandle("org_hsqldb_Server_messages", null);
    HsqlProperties serverProperties;
    HashSet serverConnSet;
    private String[] dbAlias;
    private String[] dbType;
    private String[] dbPath;
    private HsqlProperties[] dbProps;
    private int[] dbID;
    private int maxConnections;
    protected String serverId;
    protected int serverProtocol;
    protected ThreadGroup serverConnectionThreadGroup;
    protected HsqlSocketFactory socketFactory;
    protected ServerSocket socket;
    private Thread serverThread;
    private Throwable serverError;
    private volatile int serverState;
    private volatile boolean isSilent;
    private volatile boolean isRemoteOpen;
    private PrintWriter logWriter;
    private PrintWriter errWriter;

    public Server() {
        this(1);
    }

    protected Server(int protocol) {
        this.init(protocol);
    }

    public static void main(String[] args) {
        String propsPath = FileUtil.canonicalOrAbsolutePath("server");
        HsqlProperties fileProps = ServerConfiguration.getPropertiesFromFile(propsPath);
        HsqlProperties props = fileProps == null ? new HsqlProperties() : fileProps;
        HsqlProperties stringProps = null;
        try {
            stringProps = HsqlProperties.argArrayToProps(args, "server");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Server.printHelp("server.help");
            return;
        }
        if (stringProps != null) {
            if (stringProps.getErrorKeys().length != 0) {
                Server.printHelp("server.help");
                return;
            }
            props.addProperties(stringProps);
        }
        ServerConfiguration.translateDefaultDatabaseProperty(props);
        ServerConfiguration.translateDefaultNoSystemExitProperty(props);
        Server server = new Server();
        try {
            server.setProperties(props);
        }
        catch (Exception e) {
            server.printError("Failed to set properties");
            server.printStackTrace(e);
            return;
        }
        server.print("Startup sequence initiated from main() method");
        if (fileProps != null) {
            server.print("Loaded properties from [" + propsPath + ".properties]");
        } else {
            server.print("Could not load properties from file");
            server.print("Using cli/default properties only");
        }
        server.start();
    }

    public void checkRunning(boolean running) throws RuntimeException {
        boolean error;
        this.printWithThread("checkRunning(" + running + ") entered");
        int state = this.getState();
        boolean bl = error = running && state != 1 || !running && state != 16;
        if (error) {
            String msg = "server is " + (running ? "not " : "") + "running";
            throw new RuntimeException(msg);
        }
        this.printWithThread("checkRunning(" + running + ") exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void signalCloseAllServerConnections() {
        this.printWithThread("signalCloseAllServerConnections() entered");
        var2_1 = this.serverConnSet;
        synchronized (var2_1) {
            it = new WrapperIterator(this.serverConnSet.toArray(null));
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_1
            if (true) ** GOTO lbl14
        }
        do {
            sc = (ServerConnection)it.next();
            this.printWithThread("Closing " + sc);
            sc.signalClose();
lbl14:
            // 2 sources

        } while (it.hasNext());
        this.printWithThread("signalCloseAllServerConnections() exited");
    }

    protected void finalize() throws Throwable {
        if (this.serverThread != null) {
            this.releaseServerSocket();
        }
    }

    public String getAddress() {
        return this.socket == null ? this.serverProperties.getProperty("server.address") : this.socket.getInetAddress().getHostAddress();
    }

    public String getDatabaseName(int index, boolean asconfigured) {
        if (asconfigured) {
            return this.serverProperties.getProperty("server.dbname." + index);
        }
        if (this.getState() == 1) {
            return this.dbAlias == null || index < 0 || index >= this.dbAlias.length ? null : this.dbAlias[index];
        }
        return null;
    }

    public String getDatabasePath(int index, boolean asconfigured) {
        if (asconfigured) {
            return this.serverProperties.getProperty("server.database." + index);
        }
        if (this.getState() == 1) {
            return this.dbPath == null || index < 0 || index >= this.dbPath.length ? null : this.dbPath[index];
        }
        return null;
    }

    public String getDatabaseType(int index) {
        return this.dbType == null || index < 0 || index >= this.dbType.length ? null : this.dbType[index];
    }

    public String getDefaultWebPage() {
        return "[IGNORED]";
    }

    public String getHelpString() {
        return BundleHandler.getString(serverBundleHandle, "server.help");
    }

    public PrintWriter getErrWriter() {
        return this.errWriter;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public int getPort() {
        return this.serverProperties.getIntegerProperty("server.port", ServerConfiguration.getDefaultPort(this.serverProtocol, this.isTls()));
    }

    public String getProductName() {
        return "HSQLDB server";
    }

    public String getProductVersion() {
        return "1.8.0";
    }

    public String getProtocol() {
        return this.isTls() ? "HSQLS" : "HSQL";
    }

    public Throwable getServerError() {
        return this.serverError;
    }

    public String getServerId() {
        return this.serverId;
    }

    public synchronized int getState() {
        return this.serverState;
    }

    public String getStateDescriptor() {
        String state;
        this.getServerError();
        switch (this.serverState) {
            case 16: {
                state = "SHUTDOWN";
                break;
            }
            case 4: {
                state = "OPENING";
                break;
            }
            case 8: {
                state = "CLOSING";
                break;
            }
            case 1: {
                state = "ONLINE";
                break;
            }
            default: {
                state = "UNKNOWN";
            }
        }
        return state;
    }

    public String getWebRoot() {
        return "[IGNORED]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(Socket s) {
        String ctn;
        Runnable r;
        this.printWithThread("handleConnection(" + s + ") entered");
        if (!this.allowConnection(s)) {
            try {
                s.close();
            }
            catch (Exception exception) {}
            this.printWithThread("allowConnection(): connection refused");
            this.printWithThread("handleConnection() exited");
            return;
        }
        if (this.socketFactory != null) {
            this.socketFactory.configureSocket(s);
        }
        if (this.serverProtocol == 1) {
            r = new ServerConnection(s, this);
            ctn = r.getConnectionThreadName();
            HashSet hashSet = this.serverConnSet;
            synchronized (hashSet) {
                this.serverConnSet.add(r);
            }
        } else {
            r = new WebServerConnection(s, (WebServer)this);
            ctn = ((WebServerConnection)r).getConnectionThreadName();
        }
        Thread t = new Thread(this.serverConnectionThreadGroup, r, ctn);
        t.start();
        this.printWithThread("handleConnection() exited");
    }

    public boolean isNoSystemExit() {
        return this.serverProperties.isPropertyTrue("server.no_system_exit");
    }

    public boolean isRestartOnShutdown() {
        return this.serverProperties.isPropertyTrue("server.restart_on_shutdown");
    }

    public boolean isSilent() {
        return this.isSilent;
    }

    public boolean isTls() {
        return this.serverProperties.isPropertyTrue("server.tls");
    }

    public boolean isTrace() {
        return this.serverProperties.isPropertyTrue("server.trace");
    }

    public boolean putPropertiesFromFile(String path) {
        if (this.getState() != 16) {
            throw new RuntimeException();
        }
        HsqlProperties p = ServerConfiguration.getPropertiesFromFile(path = FileUtil.canonicalOrAbsolutePath(path));
        if (p == null || p.isEmpty()) {
            return false;
        }
        this.printWithThread("putPropertiesFromFile(): [" + path + ".properties]");
        try {
            this.setProperties(p);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set properties: " + e);
        }
        return true;
    }

    public void putPropertiesFromString(String s) {
        if (this.getState() != 16) {
            throw new RuntimeException();
        }
        if (StringUtil.isEmpty(s)) {
            return;
        }
        this.printWithThread("putPropertiesFromString(): [" + s + "]");
        HsqlProperties p = HsqlProperties.delimitedArgPairsToProps(s, "=", ";", "server");
        try {
            this.setProperties(p);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set properties: " + e);
        }
    }

    public void setAddress(String address) throws RuntimeException {
        this.checkRunning(false);
        if (StringUtil.isEmpty(address)) {
            address = "0.0.0.0";
        }
        this.printWithThread("setAddress(" + address + ")");
        this.serverProperties.setProperty("server.address", address);
    }

    public void setDatabaseName(int index, String name) throws RuntimeException {
        this.checkRunning(false);
        this.printWithThread("setDatabaseName(" + index + "," + name + ")");
        this.serverProperties.setProperty("server.dbname." + index, name);
    }

    public void setDatabasePath(int index, String path) throws RuntimeException {
        this.checkRunning(false);
        this.printWithThread("setDatabasePath(" + index + "," + path + ")");
        this.serverProperties.setProperty("server.database." + index, path);
    }

    public void setDefaultWebPage(String file) {
        this.checkRunning(false);
        this.printWithThread("setDefaultWebPage(" + file + ")");
        if (this.serverProtocol != 0) {
            return;
        }
        this.serverProperties.setProperty("server.default_page", file);
    }

    public void setPort(int port) throws RuntimeException {
        this.checkRunning(false);
        this.printWithThread("setPort(" + port + ")");
        this.serverProperties.setProperty("server.port", port);
    }

    public void setErrWriter(PrintWriter pw) {
        this.errWriter = pw;
    }

    public void setLogWriter(PrintWriter pw) {
        this.logWriter = pw;
    }

    public void setNoSystemExit(boolean noExit) {
        this.printWithThread("setNoSystemExit(" + noExit + ")");
        this.serverProperties.setProperty("server.no_system_exit", noExit);
    }

    public void setRestartOnShutdown(boolean restart) {
        this.printWithThread("setRestartOnShutdown(" + restart + ")");
        this.serverProperties.setProperty("server.restart_on_shutdown", restart);
    }

    public void setSilent(boolean silent) {
        this.printWithThread("setSilent(" + silent + ")");
        this.serverProperties.setProperty("server.silent", silent);
        this.isSilent = silent;
    }

    public void setTls(boolean tls) {
        this.checkRunning(false);
        this.printWithThread("setTls(" + tls + ")");
        this.serverProperties.setProperty("server.tls", tls);
    }

    public void setTrace(boolean trace) {
        this.printWithThread("setTrace(" + trace + ")");
        this.serverProperties.setProperty("server.trace", trace);
        JavaSystem.setLogToSystem(trace);
    }

    public void setWebRoot(String root) {
        this.checkRunning(false);
        root = new File(root).getAbsolutePath();
        this.printWithThread("setWebRoot(" + root + ")");
        if (this.serverProtocol != 0) {
            return;
        }
        this.serverProperties.setProperty("server.root", root);
    }

    public void setProperties(HsqlProperties p) {
        this.checkRunning(false);
        if (p != null) {
            this.serverProperties.addProperties(p);
            ServerConfiguration.translateAddressProperty(this.serverProperties);
        }
        this.maxConnections = this.serverProperties.getIntegerProperty("server.maxconnections", 16);
        JavaSystem.setLogToSystem(this.isTrace());
        this.isSilent = this.serverProperties.isPropertyTrue("server.silent");
        this.isRemoteOpen = this.serverProperties.isPropertyTrue("server.remote_open");
    }

    public int start() {
        this.printWithThread("start() entered");
        int previousState = this.getState();
        if (this.serverThread != null) {
            this.printWithThread("start(): serverThread != null; no action taken");
            return previousState;
        }
        this.setState(4);
        this.serverThread = new ServerThread("HSQLDB Server ");
        this.serverThread.start();
        while (this.getState() == 4) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.printWithThread("start() exiting");
        return previousState;
    }

    public int stop() {
        this.printWithThread("stop() entered");
        int previousState = this.getState();
        if (this.serverThread == null) {
            this.printWithThread("stop() serverThread is null; no action taken");
            return previousState;
        }
        this.releaseServerSocket();
        this.printWithThread("stop() exiting");
        return previousState;
    }

    protected boolean allowConnection(Socket socket) {
        return true;
    }

    protected void init(int protocol) {
        this.serverState = 16;
        this.serverConnSet = new HashSet();
        this.serverId = this.toString();
        this.serverId = this.serverId.substring(this.serverId.lastIndexOf(46) + 1);
        this.serverProtocol = protocol;
        this.serverProperties = ServerConfiguration.newDefaultProperties(protocol);
        this.logWriter = new PrintWriter(System.out);
        this.errWriter = new PrintWriter(System.err);
        JavaSystem.setLogToSystem(this.isTrace());
    }

    protected synchronized void setState(int state) {
        this.serverState = state;
    }

    final void notify(int action, int id) {
        this.printWithThread("notifiy(" + action + "," + id + ") entered");
        if (action != 0) {
            return;
        }
        this.releaseDatabase(id);
        boolean shutdown = true;
        int i = 0;
        while (i < this.dbID.length) {
            if (this.dbAlias[i] != null) {
                shutdown = false;
            }
            ++i;
        }
        if (!this.isRemoteOpen && shutdown) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final synchronized void releaseDatabase(int id) {
        this.printWithThread("releaseDatabase(" + id + ") entered");
        i = 0;
        while (i < this.dbID.length) {
            if (this.dbID[i] == id && this.dbAlias[i] != null) {
                this.dbID[i] = 0;
                this.dbAlias[i] = null;
                this.dbPath[i] = null;
                this.dbType[i] = null;
                this.dbProps[i] = null;
            }
            ++i;
        }
        i = this.serverConnSet;
        synchronized (i) {
            it = new WrapperIterator(this.serverConnSet.toArray(null));
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl16 : MonitorExitStatement: MONITOREXIT : i
            if (true) ** GOTO lbl26
        }
        do {
            sc = (ServerConnection)it.next();
            if (sc.dbID != id) continue;
            sc.signalClose();
            this.serverConnSet.remove(sc);
lbl26:
            // 3 sources

        } while (it.hasNext());
        this.printWithThread("releaseDatabase(" + id + ") exiting");
    }

    protected synchronized void print(String msg) {
        PrintWriter writer = this.logWriter;
        if (writer != null) {
            writer.println("[" + this.serverId + "]: " + msg);
            writer.flush();
        }
    }

    final void printResource(String key) {
        if (serverBundleHandle < 0) {
            return;
        }
        String resource = BundleHandler.getString(serverBundleHandle, key);
        if (resource == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(resource, "\n\r");
        while (st.hasMoreTokens()) {
            this.print(st.nextToken());
        }
    }

    protected synchronized void printStackTrace(Throwable t) {
        if (this.errWriter != null) {
            t.printStackTrace(this.errWriter);
            this.errWriter.flush();
        }
    }

    final void printWithTimestamp(String msg) {
        this.print(String.valueOf(HsqlDateTime.getSytemTimeString()) + " " + msg);
    }

    protected void printWithThread(String msg) {
        if (!this.isSilent()) {
            this.print("[" + Thread.currentThread() + "]: " + msg);
        }
    }

    protected synchronized void printError(String msg) {
        PrintWriter writer = this.errWriter;
        if (writer != null) {
            writer.print("[" + this.serverId + "]: ");
            writer.print("[" + Thread.currentThread() + "]: ");
            writer.println(msg);
            writer.flush();
        }
    }

    final void printRequest(int cid, Result r) {
        if (this.isSilent()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(cid);
        sb.append(':');
        block0 : switch (r.mode) {
            case 65555: {
                sb.append("SQLCLI:SQLPREPARE ");
                sb.append(r.getMainString());
                break;
            }
            case 65547: {
                if (r.getSize() < 2) {
                    sb.append(r.getMainString());
                    break;
                }
                sb.append("SQLCLI:SQLEXECDIRECT:BATCHMODE\n");
                Iterator it = r.iterator();
                while (it.hasNext()) {
                    Object[] data = (Object[])it.next();
                    sb.append(data[0]).append('\n');
                }
                break;
            }
            case 65548: {
                sb.append("SQLCLI:SQLEXECUTE:");
                if (r.getSize() > 1) {
                    sb.append("BATCHMODE:");
                }
                sb.append(r.getStatementID());
                break;
            }
            case 65552: {
                sb.append("SQLCLI:SQLFREESTMT:");
                sb.append(r.getStatementID());
                break;
            }
            case 7: {
                sb.append("HSQLCLI:GETSESSIONATTR");
                break;
            }
            case 6: {
                sb.append("HSQLCLI:SETSESSIONATTR:");
                sb.append("AUTOCOMMIT ");
                sb.append(r.rRoot.data[4]);
                sb.append(" CONNECTION_READONLY ");
                sb.append(r.rRoot.data[6]);
                break;
            }
            case 66541: {
                sb.append("SQLCLI:SQLENDTRAN:");
                switch (r.getEndTranType()) {
                    case 0: {
                        sb.append("COMMIT");
                        break block0;
                    }
                    case 1: {
                        sb.append("ROLLBACK");
                        break block0;
                    }
                    case 4: {
                        sb.append("SAVEPOINT_NAME_RELEASE ");
                        sb.append(r.getMainString());
                        break block0;
                    }
                    case 2: {
                        sb.append("SAVEPOINT_NAME_ROLLBACK ");
                        sb.append(r.getMainString());
                        break block0;
                    }
                }
                sb.append(r.getEndTranType());
                break;
            }
            case 65610: {
                sb.append("SQLCLI:SQLSTARTTRAN");
                break;
            }
            case 65545: {
                sb.append("SQLCLI:SQLDISCONNECT");
                break;
            }
            case 66552: {
                sb.append("SQLCLI:SQLSETCONNECTATTR:");
                switch (r.getConnectionAttrType()) {
                    case 10027: {
                        sb.append("SQL_ATTR_SAVEPOINT_NAME ");
                        sb.append(r.getMainString());
                        break block0;
                    }
                }
                sb.append(r.getConnectionAttrType());
                break;
            }
            default: {
                sb.append("SQLCLI:MODE:");
                sb.append(r.mode);
            }
        }
        this.print(sb.toString());
    }

    final synchronized int getDBID(String aliasPath) throws HsqlException {
        int dbIndex;
        int semipos = aliasPath.indexOf(59);
        String alias = aliasPath;
        String filepath = null;
        if (semipos != -1) {
            alias = aliasPath.substring(0, semipos);
            filepath = aliasPath.substring(semipos + 1);
        }
        if ((dbIndex = ArrayUtil.find(this.dbAlias, alias)) == -1) {
            if (filepath == null) {
                RuntimeException e = new RuntimeException("database alias does not exist");
                this.printError("database alias=" + alias + " does not exist");
                this.setServerError(e);
                throw e;
            }
            return this.openDatabase(alias, filepath);
        }
        return this.dbID[dbIndex];
    }

    final int openDatabase(String alias, String filepath) throws HsqlException {
        if (!this.isRemoteOpen) {
            RuntimeException e = new RuntimeException("remote open not allowed");
            this.printError("Remote database open not allowed");
            this.setServerError(e);
            throw e;
        }
        int i = this.getFirstEmptyDatabaseIndex();
        if (i < -1) {
            RuntimeException e = new RuntimeException("limit of open databases reached");
            this.printError("limit of open databases reached");
            this.setServerError(e);
            throw e;
        }
        HsqlProperties newprops = DatabaseURL.parseURL(filepath, false);
        if (newprops == null) {
            RuntimeException e = new RuntimeException("invalid database path");
            this.printError("invalid database path");
            this.setServerError(e);
            throw e;
        }
        String path = newprops.getProperty("database");
        String type = newprops.getProperty("connection_type");
        try {
            int dbid;
            this.dbID[i] = dbid = DatabaseManager.getDatabase(type, path, this, newprops);
            this.dbAlias[i] = alias;
            this.dbPath[i] = path;
            this.dbType[i] = type;
            this.dbProps[i] = newprops;
            return dbid;
        }
        catch (HsqlException e) {
            this.printError("Database [index=" + i + "db=" + this.dbType[i] + this.dbPath[i] + ", alias=" + this.dbAlias[i] + "] did not open: " + e.toString());
            this.setServerError(e);
            throw e;
        }
    }

    final int getFirstEmptyDatabaseIndex() {
        int i = 0;
        while (i < this.dbAlias.length) {
            if (this.dbAlias[i] == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    final boolean openDatabases() {
        this.printWithThread("openDatabases() entered");
        boolean success = false;
        this.setDBInfoArrays();
        int i = 0;
        while (i < this.dbAlias.length) {
            block6: {
                if (this.dbAlias[i] != null) {
                    int id;
                    this.printWithThread("Opening database: [" + this.dbType[i] + this.dbPath[i] + "]");
                    StopWatch sw = new StopWatch();
                    try {
                        this.dbID[i] = id = DatabaseManager.getDatabase(this.dbType[i], this.dbPath[i], this, this.dbProps[i]);
                        success = true;
                    }
                    catch (HsqlException e) {
                        this.printError("Database [index=" + i + "db=" + this.dbType[i] + this.dbPath[i] + ", alias=" + this.dbAlias[i] + "] did not open: " + e.toString());
                        this.setServerError(e);
                        this.dbAlias[i] = null;
                        this.dbPath[i] = null;
                        this.dbType[i] = null;
                        this.dbProps[i] = null;
                        break block6;
                    }
                    sw.stop();
                    String msg = "Database [index=" + i + ", id=" + id + ", " + "db=" + this.dbType[i] + this.dbPath[i] + ", alias=" + this.dbAlias[i] + "] opened sucessfully";
                    this.print(sw.elapsedTimeToMessage(msg));
                }
            }
            ++i;
        }
        this.printWithThread("openDatabases() exiting");
        if (this.isRemoteOpen) {
            success = true;
        }
        if (!success && this.getServerError() == null) {
            this.setServerError(Trace.error(147));
        }
        return success;
    }

    private void setDBInfoArrays() {
        this.dbAlias = this.getDBNameArray();
        this.dbPath = new String[this.dbAlias.length];
        this.dbType = new String[this.dbAlias.length];
        this.dbID = new int[this.dbAlias.length];
        this.dbProps = new HsqlProperties[this.dbAlias.length];
        int i = 0;
        while (i < this.dbAlias.length) {
            if (this.dbAlias[i] != null) {
                String path = this.getDatabasePath(i, true);
                if (path == null) {
                    this.dbAlias[i] = null;
                } else {
                    HsqlProperties dbURL = DatabaseURL.parseURL(path, false);
                    if (dbURL == null) {
                        this.dbAlias[i] = null;
                    } else {
                        this.dbPath[i] = dbURL.getProperty("database");
                        this.dbType[i] = dbURL.getProperty("connection_type");
                        this.dbProps[i] = dbURL;
                    }
                }
            }
            ++i;
        }
    }

    private String[] getDBNameArray() {
        int prefixLen = "server.dbname.".length();
        String[] dblist = new String[10];
        int maxindex = 0;
        try {
            Enumeration en = this.serverProperties.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (!key.startsWith("server.dbname.")) continue;
                try {
                    int dbnum = Integer.parseInt(key.substring(prefixLen));
                    maxindex = dbnum < maxindex ? maxindex : dbnum;
                    dblist[dbnum] = this.serverProperties.getProperty(key).toLowerCase();
                }
                catch (NumberFormatException e) {
                    this.printWithThread("dblist: " + e.toString());
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.printWithThread("dblist: " + e.toString());
        }
        return dblist;
    }

    private void openServerSocket() throws Exception {
        this.printWithThread("openServerSocket() entered");
        if (this.isTls()) {
            this.printWithThread("Requesting TLS/SSL-encrypted JDBC");
        }
        StopWatch sw = new StopWatch();
        this.socketFactory = HsqlSocketFactory.getInstance(this.isTls());
        String address = this.getAddress();
        int port = this.getPort();
        if (StringUtil.isEmpty(address) || "0.0.0.0".equalsIgnoreCase(address.trim())) {
            this.socket = this.socketFactory.createServerSocket(port);
        } else {
            try {
                this.socket = this.socketFactory.createServerSocket(port, address);
            }
            catch (UnknownHostException unknownHostException) {
                Object[] messageParameters;
                int messageID;
                String[] candidateAddrs = ServerConfiguration.listLocalInetAddressNames();
                if (candidateAddrs.length > 0) {
                    messageID = 148;
                    messageParameters = new Object[]{address, candidateAddrs};
                } else {
                    messageID = 149;
                    messageParameters = new Object[]{address};
                }
                throw new UnknownHostException(Trace.getMessage(messageID, true, messageParameters));
            }
        }
        this.socket.setSoTimeout(1000);
        this.printWithThread("Got server socket: " + this.socket);
        this.print(sw.elapsedTimeToMessage("Server socket opened successfully"));
        if (this.socketFactory.isSecure()) {
            this.print("Using TLS/SSL-encrypted JDBC");
        }
        this.printWithThread("openServerSocket() exiting");
    }

    private void printServerOnlineMessage() {
        String s = String.valueOf(this.getProductName()) + " " + this.getProductVersion() + " is online";
        this.printWithTimestamp(s);
        this.printResource("online.help");
    }

    protected void printProperties() {
        if (this.isSilent()) {
            return;
        }
        Enumeration e = this.serverProperties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.serverProperties.getProperty(key);
            this.printWithThread(String.valueOf(key) + "=" + value);
        }
    }

    private void releaseServerSocket() {
        this.printWithThread("releaseServerSocket() entered");
        if (this.socket != null) {
            this.printWithThread("Releasing server socket: [" + this.socket + "]");
            this.setState(8);
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.printError("Exception closing server socket");
                this.printError("releaseServerSocket(): " + e);
            }
            this.socket = null;
        }
        this.printWithThread("releaseServerSocket() exited");
    }

    private void run() {
        this.printWithThread("run() entered");
        this.print("Initiating startup sequence...");
        this.printProperties();
        StopWatch sw = new StopWatch();
        this.setServerError(null);
        try {
            this.openServerSocket();
        }
        catch (Exception e) {
            this.setServerError(e);
            this.printError("run()/openServerSocket(): ");
            this.printStackTrace(e);
            this.shutdown(true);
            return;
        }
        String tgName = "HSQLDB Connections @" + Integer.toString(this.hashCode(), 16);
        ThreadGroup tg = new ThreadGroup(tgName);
        tg.setDaemon(false);
        this.serverConnectionThreadGroup = tg;
        if (!this.openDatabases()) {
            this.setServerError(null);
            this.printError("Shutting down because there are no open databases");
            this.shutdown(true);
            return;
        }
        this.setState(1);
        this.print(sw.elapsedTimeToMessage("Startup sequence completed"));
        this.printServerOnlineMessage();
        try {
            while (true) {
                try {
                    while (true) {
                        this.handleConnection(this.socket.accept());
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            if (this.getState() == 1) {
                this.setServerError(e);
                this.printError(this + ".run()/handleConnection(): ");
                this.printStackTrace(e);
            }
            this.shutdown(false);
        }
        catch (Throwable t) {
            try {
                this.printWithThread(t.toString());
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.shutdown(false);
            }
        }
    }

    protected void setServerError(Throwable t) {
        this.serverError = t;
    }

    public void shutdown() {
        this.shutdown(false);
    }

    protected synchronized void shutdown(boolean error) {
        int i;
        if (this.serverState == 16) {
            return;
        }
        this.printWithThread("shutdown() entered");
        StopWatch sw = new StopWatch();
        this.print("Initiating shutdown sequence...");
        this.releaseServerSocket();
        DatabaseManager.deRegisterServer(this);
        if (this.dbPath != null) {
            i = 0;
            while (i < this.dbPath.length) {
                this.releaseDatabase(this.dbID[i]);
                ++i;
            }
        }
        if (this.serverConnectionThreadGroup != null) {
            if (!this.serverConnectionThreadGroup.isDestroyed()) {
                i = 0;
                while (this.serverConnectionThreadGroup.activeCount() > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                    ++i;
                }
                try {
                    this.serverConnectionThreadGroup.destroy();
                    this.printWithThread(String.valueOf(this.serverConnectionThreadGroup.getName()) + " destroyed");
                }
                catch (Throwable t) {
                    this.printWithThread(String.valueOf(this.serverConnectionThreadGroup.getName()) + " not destroyed");
                    this.printWithThread(t.toString());
                }
            }
            this.serverConnectionThreadGroup = null;
        }
        this.serverThread = null;
        this.setState(16);
        this.print(sw.elapsedTimeToMessage("Shutdown sequence completed"));
        if (this.isNoSystemExit()) {
            this.printWithTimestamp("SHUTDOWN : System.exit() was not called");
            this.printWithThread("shutdown() exited");
        } else {
            this.printWithTimestamp("SHUTDOWN : System.exit() is called next");
            this.printWithThread("shutdown() exiting...");
            try {
                System.exit(0);
            }
            catch (Throwable t) {
                this.printWithThread(t.toString());
            }
        }
    }

    protected static void printHelp(String key) {
        System.out.println(BundleHandler.getString(serverBundleHandle, key));
    }

    private class ServerThread
    extends Thread {
        ServerThread(String name) {
            super(name);
            this.setName(String.valueOf(name) + '@' + Integer.toString(Server.this.hashCode(), 16));
        }

        public void run() {
            Server.this.run();
            Server.this.printWithThread("ServerThread.run() exited");
        }
    }
}

