/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Session;
import org.hsqldb.lib.StringUtil;

class Like {
    private char[] cLike;
    private int[] wildCardType;
    private int iLen;
    private boolean isIgnoreCase;
    private int iFirstWildCard;
    private boolean isNull;
    Character escapeChar;
    boolean hasCollation;
    boolean optimised;
    static final int UNDERSCORE_CHAR = 1;
    static final int PERCENT_CHAR = 2;

    Like(Character escape, boolean collation) {
        this.escapeChar = escape;
        this.hasCollation = collation;
    }

    void setParams(Session session, String s, boolean ignorecase) {
        this.isIgnoreCase = ignorecase;
        this.normalize(session, s);
        this.optimised = true;
    }

    void resetPattern(Session session, String s) {
        this.normalize(session, s);
    }

    private String getStartsWith() {
        if (this.iLen == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.iLen && this.wildCardType[i] == 0) {
            s.append(this.cLike[i]);
            ++i;
        }
        if (i == 0) {
            return null;
        }
        return s.toString();
    }

    Boolean compare(Session session, String s) {
        if (s == null) {
            return null;
        }
        if (this.isIgnoreCase) {
            s = session.database.collation.toUpperCase(s);
        }
        return this.compareAt(s, 0, 0, s.length()) ? Boolean.TRUE : Boolean.FALSE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean compareAt(String s, int i, int j, int jLen) {
        while (i < this.iLen) {
            switch (this.wildCardType[i]) {
                case 0: {
                    if (j < jLen && this.cLike[i] == s.charAt(j++)) break;
                    return false;
                }
                case 1: {
                    if (j++ < jLen) break;
                    return false;
                }
                case 2: {
                    if (++i >= this.iLen) {
                        return true;
                    }
                    while (j < jLen) {
                        if (this.cLike[i] == s.charAt(j) && this.compareAt(s, i, j, jLen)) {
                            return true;
                        }
                        ++j;
                    }
                    return false;
                }
            }
            ++i;
        }
        return j == jLen;
    }

    private void normalize(Session session, String pattern) {
        boolean bl = this.isNull = pattern == null;
        if (!this.isNull && this.isIgnoreCase) {
            pattern = session.database.collation.toUpperCase(pattern);
        }
        this.iLen = 0;
        this.iFirstWildCard = -1;
        int l = pattern == null ? 0 : pattern.length();
        this.cLike = new char[l];
        this.wildCardType = new int[l];
        boolean bEscaping = false;
        boolean bPercent = false;
        int i = 0;
        while (i < l) {
            block8: {
                char c;
                block10: {
                    block6: {
                        block11: {
                            block9: {
                                block7: {
                                    c = pattern.charAt(i);
                                    if (bEscaping) break block6;
                                    if (this.escapeChar == null || this.escapeChar.charValue() != c) break block7;
                                    bEscaping = true;
                                    break block8;
                                }
                                if (c != '_') break block9;
                                this.wildCardType[this.iLen] = 1;
                                if (this.iFirstWildCard == -1) {
                                    this.iFirstWildCard = this.iLen;
                                }
                                break block10;
                            }
                            if (c != '%') break block11;
                            if (bPercent) break block8;
                            bPercent = true;
                            this.wildCardType[this.iLen] = 2;
                            if (this.iFirstWildCard == -1) {
                                this.iFirstWildCard = this.iLen;
                            }
                            break block10;
                        }
                        bPercent = false;
                        break block10;
                    }
                    bPercent = false;
                    bEscaping = false;
                }
                this.cLike[this.iLen++] = c;
            }
            ++i;
        }
        i = 0;
        while (i < this.iLen - 1) {
            if (this.wildCardType[i] == 2 && this.wildCardType[i + 1] == 1) {
                this.wildCardType[i] = 1;
                this.wildCardType[i + 1] = 2;
            }
            ++i;
        }
    }

    boolean hasWildcards() {
        return this.iFirstWildCard != -1;
    }

    boolean isEquivalentToFalsePredicate() {
        return this.isNull;
    }

    boolean isEquivalentToEqualsPredicate() {
        return this.iFirstWildCard == -1;
    }

    boolean isEquivalentToNotNullPredicate() {
        if (this.isNull || !this.hasWildcards()) {
            return false;
        }
        int i = 0;
        while (i < this.wildCardType.length) {
            if (this.wildCardType[i] != 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean isEquivalentToBetweenPredicate() {
        return this.iFirstWildCard > 0 && this.iFirstWildCard == this.wildCardType.length - 1 && this.cLike[this.iFirstWildCard] == '%';
    }

    boolean isEquivalentToBetweenPredicateAugmentedWithLike() {
        return this.iFirstWildCard > 0 && this.cLike[this.iFirstWildCard] == '%';
    }

    String getRangeLow() {
        return this.getStartsWith();
    }

    String getRangeHigh() {
        String s = this.getStartsWith();
        return s == null ? null : s.concat("\uffff");
    }

    public String describe(Session session) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append("[\n");
        sb.append("escapeChar=").append(this.escapeChar).append('\n');
        sb.append("isNull=").append(this.isNull).append('\n');
        sb.append("optimised=").append(this.optimised).append('\n');
        sb.append("isIgnoreCase=").append(this.isIgnoreCase).append('\n');
        sb.append("iLen=").append(this.iLen).append('\n');
        sb.append("iFirstWildCard=").append(this.iFirstWildCard).append('\n');
        sb.append("cLike=");
        sb.append(StringUtil.arrayToString(this.cLike));
        sb.append('\n');
        sb.append("wildCardType=");
        sb.append(StringUtil.arrayToString(this.wildCardType));
        sb.append(']');
        return sb.toString();
    }
}

