/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.GrantConstants;
import org.hsqldb.Grantee;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.StringUtil;

class GranteeManager
implements GrantConstants {
    static final String SYSTEM_AUTHORIZATION_NAME = "_SYSTEM";
    static final String DBA_ADMIN_ROLE_NAME = "DBA";
    static final String PUBLIC_ROLE_NAME = "PUBLIC";
    static final String[] emptyRightsList = new String[0];
    static final IntKeyHashMap hRightsLists = new IntKeyHashMap();
    private HashMappedList map = new HashMappedList();
    private HashMappedList roleMap = new HashMappedList();
    static final IntValueHashMap rightsStringLookup = new IntValueHashMap(7);

    static {
        rightsStringLookup.put("ALL", 15);
        rightsStringLookup.put("SELECT", 1);
        rightsStringLookup.put("UPDATE", 8);
        rightsStringLookup.put("DELETE", 2);
        rightsStringLookup.put("INSERT", 4);
    }

    public GranteeManager(Database inDatabase) throws HsqlException {
        this.addRole(DBA_ADMIN_ROLE_NAME);
        this.getRole(DBA_ADMIN_ROLE_NAME).setAdminDirect();
    }

    void grant(String name, Object dbobject, int rights) throws HsqlException {
        Grantee g = this.get(name);
        if (g == null) {
            throw Trace.error(232, name);
        }
        if (GranteeManager.isImmutable(name)) {
            throw Trace.error(243, name);
        }
        g.grant(dbobject, rights);
        g.updateAllRights();
        if (g.isRole) {
            this.updateAllRights(g);
        }
    }

    void grant(String name, String role) throws HsqlException {
        Grantee grantee = this.get(name);
        if (grantee == null) {
            throw Trace.error(232, name);
        }
        if (GranteeManager.isImmutable(name)) {
            throw Trace.error(243, name);
        }
        Grantee r = this.get(role);
        if (r == null) {
            throw Trace.error(239, role);
        }
        if (role.equals(name)) {
            throw Trace.error(244, name);
        }
        if (r.hasRole(name)) {
            throw Trace.error(244, String.valueOf(Trace.getMessage(245)) + " GRANT " + name + " TO " + role);
        }
        if (grantee.getDirectRoles().contains(role)) {
            throw Trace.error(245, role);
        }
        grantee.grant(role);
        grantee.updateAllRights();
        if (grantee.isRole) {
            this.updateAllRights(grantee);
        }
    }

    void revoke(String name, String role) throws HsqlException {
        Grantee g = this.get(name);
        if (g == null) {
            throw Trace.error(232, name);
        }
        g.revoke(role);
        g.updateAllRights();
        if (g.isRole) {
            this.updateAllRights(g);
        }
    }

    void revoke(String name, Object dbobject, int rights) throws HsqlException {
        Grantee g = this.get(name);
        g.revoke(dbobject, rights);
        g.updateAllRights();
        if (g.isRole) {
            this.updateAllRights(g);
        }
    }

    void removeEmptyRole(Grantee role) {
        String name = role.getName();
        int i = 0;
        while (i < this.map.size()) {
            Grantee grantee = (Grantee)this.map.get(i);
            grantee.roles.remove(name);
            ++i;
        }
    }

    void removeDbObject(Object dbobject) {
        int i = 0;
        while (i < this.map.size()) {
            Grantee g = (Grantee)this.map.get(i);
            g.revokeDbObject(dbobject);
            ++i;
        }
    }

    void updateAllRights(Grantee role) {
        Grantee grantee;
        String name = role.getName();
        int i = 0;
        while (i < this.map.size()) {
            grantee = (Grantee)this.map.get(i);
            if (grantee.isRole) {
                grantee.updateNestedRoles(name);
            }
            ++i;
        }
        i = 0;
        while (i < this.map.size()) {
            grantee = (Grantee)this.map.get(i);
            if (!grantee.isRole) {
                grantee.updateAllRights();
            }
            ++i;
        }
    }

    public boolean removeGrantee(String name) {
        if (GranteeManager.isReserved(name)) {
            return false;
        }
        Grantee g = (Grantee)this.map.remove(name);
        if (g == null) {
            return false;
        }
        g.clearPrivileges();
        this.updateAllRights(g);
        if (g.isRole) {
            this.roleMap.remove(name);
            this.removeEmptyRole(g);
        }
        return true;
    }

    public Grantee addGrantee(String name) throws HsqlException {
        if (this.map.containsKey(name)) {
            throw Trace.error(241, name);
        }
        Grantee pubGrantee = null;
        if (!GranteeManager.isReserved(name) && (pubGrantee = this.get(PUBLIC_ROLE_NAME)) == null) {
            Trace.doAssert(false, Trace.getMessage(242));
        }
        Grantee g = new Grantee(name, pubGrantee, this);
        this.map.put(name, g);
        return g;
    }

    boolean isGrantee(String name) {
        return this.map.containsKey(name);
    }

    static int getCheckRight(String right) throws HsqlException {
        int r = GranteeManager.getRight(right);
        if (r != 0) {
            return r;
        }
        throw Trace.error(249, right);
    }

    static int getRight(String right) {
        return rightsStringLookup.get((Object)right, 0);
    }

    static String getRightsList(int rights) {
        if (rights == 0) {
            return null;
        }
        if (rights == 15) {
            return "ALL";
        }
        return StringUtil.getList(GranteeManager.getRightsArray(rights), ",", "");
    }

    static String[] getRightsArray(int rights) {
        if (rights == 0) {
            return emptyRightsList;
        }
        String[] list = (String[])hRightsLists.get(rights);
        if (list != null) {
            return list;
        }
        list = GranteeManager.getRightsArraySub(rights);
        hRightsLists.put(rights, list);
        return list;
    }

    private static String[] getRightsArraySub(int right) {
        if (right == 0) {
            return emptyRightsList;
        }
        HsqlArrayList a = new HsqlArrayList();
        Iterator it = rightsStringLookup.keySet().iterator();
        while (it.hasNext()) {
            int i;
            String rightString = (String)it.next();
            if (rightString.equals("ALL") || (right & (i = rightsStringLookup.get((Object)rightString, 0))) == 0) continue;
            a.add(rightString);
        }
        return (String[])a.toArray(new String[a.size()]);
    }

    HashSet getGrantedClassNames() throws HsqlException {
        int size = this.map.size();
        HashSet out = new HashSet();
        int i = 0;
        while (i < size) {
            Grantee grantee = (Grantee)this.map.get(i);
            if (grantee != null) {
                Iterator e = grantee.getGrantedClassNames(false).iterator();
                while (e.hasNext()) {
                    out.add(e.next());
                }
            }
            ++i;
        }
        return out;
    }

    public Grantee get(String name) {
        return (Grantee)this.map.get(name);
    }

    public Collection getGrantees() {
        return this.map.values();
    }

    public static boolean validRightString(String rightString) {
        return GranteeManager.getRight(rightString) != 0;
    }

    public static boolean isImmutable(String name) {
        return name.equals(SYSTEM_AUTHORIZATION_NAME) || name.equals(DBA_ADMIN_ROLE_NAME);
    }

    public static boolean isReserved(String name) {
        return name.equals(SYSTEM_AUTHORIZATION_NAME) || name.equals(DBA_ADMIN_ROLE_NAME) || name.equals(PUBLIC_ROLE_NAME);
    }

    String addRole(String name) throws HsqlException {
        if (name == null) {
            Trace.doAssert(false, Trace.getMessage(236));
        }
        Grantee g = null;
        if (GranteeManager.validRightString(name)) {
            throw Trace.error(237, name);
        }
        g = this.addGrantee(name);
        g.isRole = true;
        boolean result = this.roleMap.add(name, g);
        if (!result) {
            throw Trace.error(238, name);
        }
        return name;
    }

    void dropRole(String name) throws HsqlException {
        if (name.equals(DBA_ADMIN_ROLE_NAME)) {
            throw Trace.error(33);
        }
        if (!this.isRole(name)) {
            throw Trace.error(239, name);
        }
        this.removeGrantee(name);
        this.roleMap.remove(name);
    }

    public Set getRoleNames() {
        return this.roleMap.keySet();
    }

    Grantee getRole(String name) throws HsqlException {
        Grantee g;
        if (!this.isRole(name)) {
            Trace.doAssert(false, "No role '" + name + "'");
        }
        if ((g = (Grantee)this.roleMap.get(name)) == null) {
            throw Trace.error(234, name);
        }
        return g;
    }

    boolean isRole(String name) throws HsqlException {
        return this.roleMap.containsKey(name);
    }
}

