/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Function;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Library;
import org.hsqldb.Like;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.store.ValuePool;

public class Expression {
    static final int VALUE = 1;
    static final int COLUMN = 2;
    static final int QUERY = 3;
    static final int TRUE = 4;
    static final int FALSE = -4;
    static final int VALUELIST = 5;
    static final int ASTERISK = 6;
    static final int FUNCTION = 7;
    static final int LIMIT = 8;
    static final int ROW = 9;
    static final int PARAM = 9;
    static final int NEGATE = 10;
    static final int ADD = 11;
    static final int SUBTRACT = 12;
    static final int MULTIPLY = 13;
    static final int DIVIDE = 14;
    static final int CONCAT = 15;
    static final int NOT = 20;
    static final int EQUAL = 21;
    static final int BIGGER_EQUAL = 22;
    static final int BIGGER = 23;
    static final int SMALLER = 24;
    static final int SMALLER_EQUAL = 25;
    static final int NOT_EQUAL = 26;
    static final int LIKE = 27;
    static final int AND = 28;
    static final int OR = 29;
    static final int IN = 30;
    static final int EXISTS = 31;
    static final int ALL = 32;
    static final int ANY = 33;
    static final int IS_NULL = 34;
    static final int COUNT = 40;
    static final int SUM = 41;
    static final int MIN = 42;
    static final int MAX = 43;
    static final int AVG = 44;
    static final int EVERY = 45;
    static final int SOME = 46;
    static final int STDDEV_POP = 47;
    static final int STDDEV_SAMP = 48;
    static final int VAR_POP = 49;
    static final int VAR_SAMP = 50;
    static final int IFNULL = 60;
    static final int CONVERT = 61;
    static final int CASEWHEN = 62;
    static final int EXTRACT = 63;
    static final int POSITION = 64;
    static final int TRIM = 65;
    static final int SUBSTRING = 66;
    static final int NULLIF = 67;
    static final int CASE = 68;
    static final int COALESCE = 69;
    static final int ALTERNATIVE = 70;
    static final int SEQUENCE = 71;
    static final int PLUS = 100;
    static final int OPEN = 101;
    static final int CLOSE = 102;
    static final int SELECT = 103;
    static final int COMMA = 104;
    static final int BETWEEN = 106;
    static final int CAST = 107;
    static final int END = 108;
    static final int IS = 109;
    static final int WHEN = 110;
    static final int THEN = 111;
    static final int ELSE = 112;
    static final int ENDWHEN = 113;
    static final int DISTINCT = 114;
    static final int VIEW = 115;
    static final int AS = 122;
    static final int FOR = 123;
    static final int FROM = 124;
    static final int BOTH = 125;
    static final int LEADING = 126;
    static final int TRAILING = 127;
    static final int YEAR = 128;
    static final int MONTH = 129;
    static final int DAY = 130;
    static final int HOUR = 131;
    static final int MINUTE = 132;
    static final int SECOND = 133;
    static final int TIMEZONE_HOUR = 134;
    static final int T_TIMEZONE_MINUTE = 135;
    static final int DOW = 136;
    static final HashSet SQL_EXTRACT_FIELD_NAMES = new HashSet();
    static final HashSet SQL_TRIM_SPECIFICATION = new HashSet();
    private static final int AGGREGATE_SELF = -1;
    private static final int AGGREGATE_NONE = 0;
    private static final int AGGREGATE_LEFT = 1;
    private static final int AGGREGATE_RIGHT = 2;
    private static final int AGGREGATE_BOTH = 3;
    private static final int AGGREGATE_FUNCTION = 4;
    int exprType;
    private int aggregateSpec = 0;
    Expression eArg;
    Expression eArg2;
    Object valueData;
    private int dataType;
    HashSet hList;
    Expression[] valueList;
    private boolean isFixedConstantValueList;
    SubQuery subQuery;
    boolean isQueryCorrelated;
    Function function;
    private Like likeObject;
    private String catalog;
    private String schema;
    private String tableName;
    private String columnName;
    private TableFilter tableFilter;
    TableFilter outerFilter;
    private int columnIndex;
    private boolean columnQuoted;
    private int precision;
    private int scale;
    private String columnAlias;
    private boolean aliasQuoted;
    private boolean isDescending;
    int joinedTableColumnIndex = -1;
    boolean isDistinctAggregate;
    private boolean isParam;
    boolean isInJoin;
    static final Integer INTEGER_0;
    static final Integer INTEGER_1;
    int oldIType = -1;
    static final int PARAM_UNKNOWN = 0;
    public static final int PARAM_IN = 1;
    public static final int PARAM_IN_OUT = 2;
    public static final int PARAM_OUT = 4;
    static final int NO_NULLS = 0;
    static final int NULLABLE = 1;
    static final int NULLABLE_UNKNOWN = 2;
    boolean isIdentity;
    int nullability = 2;
    boolean isWritable;
    int paramMode = 0;
    String valueClassName;

    static {
        SQL_EXTRACT_FIELD_NAMES.addAll(new Object[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "DAYOFWEEK"});
        SQL_TRIM_SPECIFICATION.addAll(new Object[]{"LEADING", "TRAILING", "BOTH"});
        INTEGER_0 = ValuePool.getInt(0);
        INTEGER_1 = ValuePool.getInt(1);
    }

    Expression(boolean b) {
        this.exprType = b ? 4 : -4;
    }

    Expression(Function f) {
        this.exprType = 7;
        this.function = f;
        if (f.hasAggregate) {
            this.aggregateSpec = 4;
        }
    }

    Expression(NumberSequence sequence) {
        this.exprType = 71;
        this.valueData = sequence;
        this.dataType = sequence.getType();
    }

    Expression(Expression e) {
        this.exprType = e.exprType;
        this.dataType = e.dataType;
        this.eArg = e.eArg;
        this.eArg2 = e.eArg2;
        this.isInJoin = e.isInJoin;
        this.likeObject = e.likeObject;
        this.subQuery = e.subQuery;
        this.function = e.function;
        this.checkAggregate();
    }

    Expression(SubQuery sq) {
        this.exprType = 3;
        this.subQuery = sq;
    }

    Expression(Expression[] valueList) {
        this.exprType = 5;
        this.valueList = valueList;
    }

    Expression(int type, Expression e, Expression e2) {
        this.exprType = type;
        this.eArg = e;
        this.eArg2 = e2;
        this.checkAggregate();
    }

    Expression(Expression e, int dataType, int precision, int scale) {
        this.exprType = 61;
        this.eArg = e;
        this.dataType = dataType;
        this.precision = precision;
        this.scale = scale;
        this.columnAlias = e.columnAlias;
        this.aliasQuoted = e.aliasQuoted;
        this.checkAggregate();
    }

    Expression(Expression e, Expression e2, Character escape, boolean hasCollation) {
        this.exprType = 27;
        this.eArg = e;
        this.eArg2 = e2;
        this.likeObject = new Like(escape, hasCollation);
        this.checkAggregate();
    }

    Expression(String schema, String table, String column) {
        this.schema = schema;
        this.tableName = table;
        if (column == null) {
            this.exprType = 6;
        } else {
            this.exprType = 2;
            this.columnName = column;
        }
    }

    Expression(String table, String column, boolean isquoted) {
        this.tableName = table;
        if (column == null) {
            this.exprType = 6;
        } else {
            this.exprType = 2;
            this.columnName = column;
            this.columnQuoted = isquoted;
        }
    }

    Expression(TableFilter filter, Column column) {
        this.schema = filter.filterTable.tableName.schema.name;
        this.tableName = filter.getName();
        if (column == null) {
            this.exprType = 6;
        } else {
            this.exprType = 2;
            this.columnName = column.columnName.name;
            this.columnQuoted = column.columnName.isNameQuoted;
            this.dataType = column.getType();
        }
    }

    Expression(int datatype, Object o) {
        this.exprType = 1;
        this.dataType = datatype;
        this.valueData = o;
    }

    Expression(int datatype, Object o, boolean isParam) {
        this(datatype, o);
        this.isParam = isParam;
        if (isParam) {
            this.paramMode = 1;
        }
    }

    boolean isTypeEqual(Expression other) {
        return this.dataType == other.dataType && this.precision == other.precision && this.scale == other.scale;
    }

    private void checkAggregate() {
        if (Expression.isAggregate(this.exprType)) {
            this.aggregateSpec = -1;
        } else {
            this.aggregateSpec = 0;
            if (this.eArg != null && this.eArg.isAggregate()) {
                ++this.aggregateSpec;
            }
            if (this.eArg2 != null && this.eArg2.isAggregate()) {
                this.aggregateSpec += 2;
            }
        }
    }

    public String describe(Session session) {
        return this.describe(session, 0);
    }

    static String getContextDDL(Expression expression) throws HsqlException {
        String ddl = expression.getDDL();
        if (expression.exprType != 1 && expression.exprType != 2 && expression.exprType != 7 && expression.exprType != 70 && expression.exprType != 62 && expression.exprType != 61) {
            StringBuffer temp = new StringBuffer();
            ddl = temp.append('(').append(ddl).append(')').toString();
        }
        return ddl;
    }

    String getColumnDDL() throws HsqlException {
        Trace.doAssert(this.exprType == 2);
        StringBuffer buf = new StringBuffer();
        Table table = this.tableFilter.getTable();
        if (this.tableName != null) {
            if (!this.tableName.equals("SYSTEM_SUBQUERY")) {
                buf.append('\"').append(this.tableName).append('\"').append('.');
            }
        } else {
            buf.append(table.tableName.statementName).append('.');
        }
        buf.append(table.getColumn((int)this.columnIndex).columnName.statementName);
        return buf.toString();
    }

    String getDDL() throws HsqlException {
        StringBuffer buf = new StringBuffer(64);
        String left = null;
        String right = null;
        if (this.eArg != null) {
            left = Expression.getContextDDL(this.eArg);
        }
        if (this.eArg2 != null) {
            right = Expression.getContextDDL(this.eArg2);
        }
        switch (this.exprType) {
            case 7: {
                return this.function.getDLL();
            }
            case 1: {
                try {
                    return this.isParam ? "?" : Column.createSQLString(this.valueData, this.dataType);
                }
                catch (HsqlException hsqlException) {
                    return buf.toString();
                }
            }
            case 2: {
                Table table = this.tableFilter.getTable();
                if (this.tableName != null) {
                    buf.append(table.tableName.statementName);
                    buf.append('.');
                }
                buf.append(table.getColumn((int)this.columnIndex).columnName.statementName);
                return buf.toString();
            }
            case 4: {
                return "TRUE";
            }
            case -4: {
                return "FALSE";
            }
            case 5: {
                int i = 0;
                while (i < this.valueList.length) {
                    buf.append(this.valueList[i].getDDL());
                    if (i < this.valueList.length - 1) {
                        buf.append(',');
                    }
                    ++i;
                }
                return buf.toString();
            }
            case 6: {
                buf.append('*');
                return buf.toString();
            }
            case 10: {
                buf.append('-').append(left);
                return buf.toString();
            }
            case 11: {
                buf.append(left).append('+').append(right);
                return buf.toString();
            }
            case 12: {
                buf.append(left).append('-').append(right);
                return buf.toString();
            }
            case 13: {
                buf.append(left).append('*').append(right);
                return buf.toString();
            }
            case 14: {
                buf.append(left).append('/').append(right);
                return buf.toString();
            }
            case 15: {
                buf.append(left).append("||").append(right);
                return buf.toString();
            }
            case 20: {
                if (this.eArg.exprType == 34) {
                    buf.append(Expression.getContextDDL(this.eArg.eArg)).append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                    return buf.toString();
                }
                buf.append("NOT").append(' ').append(left);
                return buf.toString();
            }
            case 21: {
                buf.append(left).append('=').append(right);
                return buf.toString();
            }
            case 22: {
                buf.append(left).append(">=").append(right);
                return buf.toString();
            }
            case 23: {
                buf.append(left).append('>').append(right);
                return buf.toString();
            }
            case 24: {
                buf.append(left).append('<').append(right);
                return buf.toString();
            }
            case 25: {
                buf.append(left).append("<=").append(right);
                return buf.toString();
            }
            case 26: {
                if ("NULL".equals(right)) {
                    buf.append(left).append(" IS NOT ").append(right);
                } else {
                    buf.append(left).append("!=").append(right);
                }
                return buf.toString();
            }
            case 27: {
                buf.append(left).append(' ').append("LIKE").append(' ');
                buf.append(right);
                if (this.likeObject.escapeChar != null) {
                    buf.append(' ').append("ESCAPE").append(' ').append('\'');
                    buf.append(this.likeObject.escapeChar.toString()).append('\'');
                    buf.append(' ');
                }
                return buf.toString();
            }
            case 28: {
                buf.append(left).append(' ').append("AND").append(' ').append(right);
                return buf.toString();
            }
            case 29: {
                buf.append(left).append(' ').append("OR").append(' ').append(right);
                return buf.toString();
            }
            case 32: {
                buf.append(left).append(' ').append("ALL").append(' ').append(right);
                return buf.toString();
            }
            case 33: {
                buf.append(left).append(' ').append("ANY").append(' ').append(right);
                return buf.toString();
            }
            case 30: {
                buf.append(left).append(' ').append("IN").append(' ').append(right);
                return buf.toString();
            }
            case 61: {
                buf.append(' ').append("CONVERT").append('(');
                buf.append(left).append(',');
                buf.append(Types.getTypeString(this.dataType, this.precision, this.scale));
                buf.append(')');
                return buf.toString();
            }
            case 62: {
                buf.append(' ').append("CASEWHEN").append('(');
                buf.append(left).append(',').append(right).append(')');
                return buf.toString();
            }
            case 34: {
                buf.append(left).append(' ').append("IS").append(' ').append("NULL");
                return buf.toString();
            }
            case 70: {
                buf.append(left).append(',').append(right);
                return buf.toString();
            }
            case 3: {
                break;
            }
            case 31: {
                buf.append(' ').append("EXISTS").append(' ');
                break;
            }
            case 40: {
                buf.append(' ').append("COUNT").append('(');
                break;
            }
            case 41: {
                buf.append(' ').append("SUM").append('(');
                buf.append(left).append(')');
                break;
            }
            case 42: {
                buf.append(' ').append("MIN").append('(');
                buf.append(left).append(')');
                break;
            }
            case 43: {
                buf.append(' ').append("MAX").append('(');
                buf.append(left).append(')');
                break;
            }
            case 44: {
                buf.append(' ').append("AVG").append('(');
                buf.append(left).append(')');
                break;
            }
            case 45: {
                buf.append(' ').append("EVERY").append('(');
                buf.append(left).append(')');
                break;
            }
            case 46: {
                buf.append(' ').append("SOME").append('(');
                buf.append(left).append(')');
                break;
            }
            case 47: {
                buf.append(' ').append("STDDEV_POP").append('(');
                buf.append(left).append(')');
                break;
            }
            case 48: {
                buf.append(' ').append("STDDEV_SAMP").append('(');
                buf.append(left).append(')');
                break;
            }
            case 49: {
                buf.append(' ').append("VAR_POP").append('(');
                buf.append(left).append(')');
                break;
            }
            case 50: {
                buf.append(' ').append("VAR_SAMP").append('(');
                buf.append(left).append(')');
            }
        }
        throw Trace.error(99);
    }

    private String describe(Session session, int blanks) {
        StringBuffer buf = new StringBuffer(64);
        buf.append('\n');
        int i = 0;
        while (i < blanks) {
            buf.append(' ');
            ++i;
        }
        if (this.oldIType != -1) {
            buf.append("SET TRUE, WAS: ");
        }
        int lIType = this.oldIType == -1 ? this.exprType : this.oldIType;
        switch (lIType) {
            case 7: {
                buf.append("FUNCTION ");
                buf.append(this.function.describe(session));
                return buf.toString();
            }
            case 1: {
                if (this.isParam) {
                    buf.append("PARAM ");
                }
                buf.append("VALUE = ").append(this.valueData);
                buf.append(", TYPE = ").append(Types.getTypeString(this.dataType));
                return buf.toString();
            }
            case 2: {
                buf.append("COLUMN ");
                if (this.tableName != null) {
                    buf.append(this.tableName);
                    buf.append('.');
                }
                buf.append(this.columnName);
                return buf.toString();
            }
            case 3: {
                buf.append("QUERY ");
                buf.append(this.subQuery.select.describe(session));
                return buf.toString();
            }
            case 4: {
                buf.append("TRUE ");
                break;
            }
            case -4: {
                buf.append("FALSE ");
                break;
            }
            case 5: {
                buf.append("VALUELIST ");
                buf.append(" TYPE = ").append(Types.getTypeString(this.dataType));
                if (this.valueList == null) break;
                i = 0;
                while (i < this.valueList.length) {
                    buf.append(this.valueList[i].describe(session, blanks + blanks));
                    buf.append(' ');
                    ++i;
                }
                break;
            }
            case 6: {
                buf.append("* ");
                break;
            }
            case 10: {
                buf.append("NEGATE ");
                break;
            }
            case 11: {
                buf.append("ADD ");
                break;
            }
            case 12: {
                buf.append("SUBTRACT ");
                break;
            }
            case 13: {
                buf.append("MULTIPLY ");
                break;
            }
            case 14: {
                buf.append("DIVIDE ");
                break;
            }
            case 15: {
                buf.append("CONCAT ");
                break;
            }
            case 20: {
                buf.append("NOT ");
                break;
            }
            case 21: {
                buf.append("EQUAL ");
                break;
            }
            case 22: {
                buf.append("BIGGER_EQUAL ");
                break;
            }
            case 23: {
                buf.append("BIGGER ");
                break;
            }
            case 24: {
                buf.append("SMALLER ");
                break;
            }
            case 25: {
                buf.append("SMALLER_EQUAL ");
                break;
            }
            case 26: {
                buf.append("NOT_EQUAL ");
                break;
            }
            case 27: {
                buf.append("LIKE ");
                buf.append(this.likeObject.describe(session));
                break;
            }
            case 28: {
                buf.append("AND ");
                break;
            }
            case 29: {
                buf.append("OR ");
                break;
            }
            case 32: {
                buf.append("ALL ");
                break;
            }
            case 33: {
                buf.append("ANY ");
                break;
            }
            case 30: {
                buf.append("IN ");
                break;
            }
            case 34: {
                buf.append("IS_NULL ");
                break;
            }
            case 31: {
                buf.append("EXISTS ");
                break;
            }
            case 40: {
                buf.append("COUNT ");
                break;
            }
            case 41: {
                buf.append("SUM ");
                break;
            }
            case 42: {
                buf.append("MIN ");
                break;
            }
            case 43: {
                buf.append("MAX ");
                break;
            }
            case 44: {
                buf.append("AVG ");
                break;
            }
            case 45: {
                buf.append("EVERY").append(' ');
                break;
            }
            case 46: {
                buf.append("SOME").append(' ');
                break;
            }
            case 47: {
                buf.append("STDDEV_POP").append(' ');
                break;
            }
            case 48: {
                buf.append("STDDEV_SAMP").append(' ');
                break;
            }
            case 49: {
                buf.append("VAR_POP").append(' ');
                break;
            }
            case 50: {
                buf.append("VAR_SAMP").append(' ');
                break;
            }
            case 61: {
                buf.append("CONVERT ");
                buf.append(Types.getTypeString(this.dataType, this.precision, this.scale));
                buf.append(' ');
                break;
            }
            case 62: {
                buf.append("CASEWHEN ");
            }
        }
        if (this.isInJoin) {
            buf.append(" join");
        }
        if (this.eArg != null) {
            buf.append(" arg1=[");
            buf.append(this.eArg.describe(session, blanks + 1));
            buf.append(']');
        }
        if (this.eArg2 != null) {
            buf.append(" arg2=[");
            buf.append(this.eArg2.describe(session, blanks + 1));
            buf.append(']');
        }
        return buf.toString();
    }

    void setDataType(int type) {
        this.dataType = type;
    }

    void setTrue() {
        if (this.oldIType == -1) {
            this.oldIType = this.exprType;
        }
        this.exprType = 4;
    }

    void setNull() {
        this.isParam = false;
        this.exprType = 1;
        this.dataType = 0;
        this.valueData = null;
        this.eArg = null;
        this.eArg2 = null;
    }

    public boolean similarTo(Expression exp) {
        if (exp == null) {
            return false;
        }
        if (exp == this) {
            return true;
        }
        return this.exprType == exp.exprType && this.dataType == exp.dataType && Expression.equals(this.valueData, exp.valueData) && Expression.equals(this.valueList, exp.valueList) && Expression.equals(this.subQuery, exp.subQuery) && Expression.equals(this.function, exp.function) && Expression.equals(this.tableName, exp.tableName) && Expression.equals(this.columnName, exp.columnName) && Expression.similarTo(this.eArg, exp.eArg) && Expression.similarTo(this.eArg2, exp.eArg2);
    }

    static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static boolean equals(Expression[] ae1, Expression[] ae2) {
        if (ae1 == ae2) {
            return true;
        }
        if (ae1.length != ae2.length) {
            return false;
        }
        int len = ae1.length;
        boolean equals = true;
        int i = 0;
        while (i < len) {
            Expression e1 = ae1[i];
            Expression e2 = ae2[i];
            equals = e1 == null ? e2 == null : e1.equals(e2);
            ++i;
        }
        return equals;
    }

    static boolean similarTo(Expression e1, Expression e2) {
        return e1 == null ? e2 == null : e1.similarTo(e2);
    }

    boolean canBeInGroupBy() {
        if (this.exprType == 7) {
            return true;
        }
        return this.isColumn() && !this.isAggregate();
    }

    boolean canBeInOrderBy() {
        return this.exprType == 7 || this.joinedTableColumnIndex != -1 || this.isColumn() || this.isAggregate();
    }

    private boolean isColumn() {
        switch (this.exprType) {
            case 2: {
                return true;
            }
            case 10: {
                return this.eArg.isColumn();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.eArg.isColumn() || this.eArg2.isColumn();
            }
        }
        return false;
    }

    boolean collectColumnName(HashSet columnNames) {
        boolean result;
        boolean bl = result = this.exprType == 2;
        if (result) {
            columnNames.add(this.columnName);
        }
        return result;
    }

    void collectAllColumnNames(HashSet columnNames) {
        if (!this.collectColumnName(columnNames)) {
            if (this.eArg != null) {
                this.eArg.collectAllColumnNames(columnNames);
            }
            if (this.eArg2 != null) {
                this.eArg2.collectAllColumnNames(columnNames);
            }
        }
    }

    boolean isConstant() {
        switch (this.exprType) {
            case 1: {
                return true;
            }
            case 10: {
                return this.eArg.isConstant();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.eArg.isConstant() && this.eArg2.isConstant();
            }
        }
        return false;
    }

    boolean canBeInAggregate() {
        return this.isAggregate() || this.isConstant();
    }

    boolean isAggregate() {
        return this.aggregateSpec != 0;
    }

    boolean isSelfAggregate() {
        return this.aggregateSpec == -1;
    }

    static boolean isAggregate(int type) {
        switch (type) {
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return true;
            }
        }
        return false;
    }

    boolean isConditional() {
        switch (this.exprType) {
            case -4: 
            case 4: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 34: {
                return true;
            }
            case 20: {
                return this.eArg.isConditional();
            }
            case 28: 
            case 29: {
                return this.eArg.isConditional() && this.eArg2.isConditional();
            }
        }
        return false;
    }

    void collectInGroupByExpressions(HsqlArrayList colExps) {
        if (!this.isConstant() && !this.isSelfAggregate()) {
            if (this.isColumn()) {
                colExps.add(this);
            } else if (this.exprType != 7) {
                if (this.exprType == 62) {
                    this.eArg2.collectInGroupByExpressions(colExps);
                } else {
                    if (this.eArg != null) {
                        this.eArg.collectInGroupByExpressions(colExps);
                    }
                    if (this.eArg2 != null) {
                        this.eArg2.collectInGroupByExpressions(colExps);
                    }
                }
            }
        }
    }

    void setDescending() {
        this.isDescending = true;
    }

    boolean isDescending() {
        return this.isDescending;
    }

    void setAlias(String s, boolean isquoted) {
        this.columnAlias = s;
        this.aliasQuoted = isquoted;
    }

    void setColumnName(String newname, boolean isquoted) {
        this.columnName = newname;
        this.columnQuoted = isquoted;
    }

    void setTableName(String newname) {
        this.tableName = newname;
    }

    String getDefinedAlias() {
        return this.columnAlias;
    }

    String getAlias() {
        if (this.columnAlias != null) {
            return this.columnAlias;
        }
        if (this.exprType == 2) {
            return this.columnName;
        }
        return "";
    }

    boolean isAliasQuoted() {
        if (this.columnAlias != null) {
            return this.aliasQuoted;
        }
        if (this.exprType == 2) {
            return this.columnQuoted;
        }
        return false;
    }

    int getType() {
        return this.exprType;
    }

    Expression getArg() {
        return this.eArg;
    }

    Expression getArg2() {
        return this.eArg2;
    }

    TableFilter getFilter() {
        return this.tableFilter;
    }

    boolean checkResolved(boolean check) throws HsqlException {
        boolean result = true;
        if (this.eArg != null) {
            boolean bl = result = result && this.eArg.checkResolved(check);
        }
        if (this.eArg2 != null) {
            boolean bl = result = result && this.eArg2.checkResolved(check);
        }
        if (this.subQuery != null && this.subQuery.select != null) {
            boolean bl = result = result && this.subQuery.select.checkResolved(check);
        }
        if (this.function != null) {
            boolean bl = result = result && this.function.checkResolved(check);
        }
        if (this.valueList != null) {
            int i = 0;
            while (i < this.valueList.length) {
                result = result && this.valueList[i].checkResolved(check);
                ++i;
            }
        }
        if (this.exprType == 2) {
            if (this.tableFilter == null) {
                boolean bl = result = this.joinedTableColumnIndex != -1;
                if (!result && check) {
                    String err = this.tableName == null ? this.columnName : String.valueOf(this.tableName) + "." + this.columnName;
                    throw Trace.error(28, err);
                }
            } else {
                this.tableFilter.usedColumns[this.columnIndex] = true;
            }
        }
        return result;
    }

    void checkTables(HsqlArrayList filters) throws HsqlException {
        if (filters == null || this.exprType == 1) {
            return;
        }
        if (this.eArg != null) {
            this.eArg.checkTables(filters);
        }
        if (this.eArg2 != null) {
            this.eArg2.checkTables(filters);
        }
        switch (this.exprType) {
            case 2: {
                boolean found = false;
                int len = filters.size();
                int j = 0;
                while (j < len) {
                    Table table;
                    int i;
                    TableFilter filter = (TableFilter)filters.get(j);
                    String filterName = filter.getName();
                    if ((this.tableName == null || filterName.equals(this.tableName)) && (i = (table = filter.getTable()).findColumn(this.columnName)) != -1) {
                        if (this.tableName == null) {
                            if (found) {
                                throw Trace.error(156, this.columnName);
                            }
                            found = true;
                        } else {
                            return;
                        }
                    }
                    ++j;
                }
                if (found) {
                    return;
                }
                throw Trace.error(28, this.columnName);
            }
            case 3: {
                break;
            }
            case 7: {
                if (this.function == null) break;
                this.function.checkTables(filters);
                break;
            }
            case 32: 
            case 33: {
                break;
            }
            case 30: {
                if (this.eArg2.exprType == 3) break;
                Expression[] vl = this.eArg2.valueList;
                int i = 0;
                while (i < vl.length) {
                    vl[i].checkTables(filters);
                    ++i;
                }
                break;
            }
        }
    }

    Expression getExpressionForAlias(Expression[] columns, int length) {
        int i = 0;
        while (i < length) {
            if (this.columnName.equals(columns[i].columnAlias) && (this.tableName == null || this.tableName.equals(columns[i].tableName))) {
                return columns[i];
            }
            ++i;
        }
        return this;
    }

    void replaceAliases(Expression[] columns, int length) throws HsqlException {
        if (this.eArg != null) {
            if (this.eArg.exprType == 2) {
                this.eArg = this.eArg.getExpressionForAlias(columns, length);
            } else {
                this.eArg.replaceAliases(columns, length);
            }
        }
        if (this.eArg2 != null) {
            if (this.eArg2.exprType == 2) {
                this.eArg2 = this.eArg2.getExpressionForAlias(columns, length);
            } else {
                this.eArg2.replaceAliases(columns, length);
            }
        }
        switch (this.exprType) {
            case 3: {
                break;
            }
            case 7: {
                if (this.function == null) break;
                this.function.replaceAliases(columns, length);
                break;
            }
            case 32: 
            case 33: {
                break;
            }
            case 30: {
                if (this.eArg2.exprType == 3) break;
                Expression[] vl = this.eArg2.valueList;
                int i = 0;
                while (i < vl.length) {
                    if (vl[i].exprType == 2) {
                        vl[i] = vl[i].getExpressionForAlias(columns, length);
                    } else {
                        vl[i].replaceAliases(columns, length);
                    }
                    ++i;
                }
                break;
            }
        }
    }

    void setLikeOptimised() throws HsqlException {
        if (this.eArg != null) {
            this.eArg.setLikeOptimised();
        }
        if (this.eArg2 != null) {
            this.eArg2.setLikeOptimised();
        }
        if (this.exprType == 27) {
            this.likeObject.optimised = true;
        }
    }

    void getEquiJoinColumns(TableFilter filter, boolean[] columns, Expression[] elist) {
        if (this.eArg != null) {
            this.eArg.getEquiJoinColumns(filter, columns, elist);
        }
        if (this.eArg2 != null) {
            this.eArg2.getEquiJoinColumns(filter, columns, elist);
        }
        if (this.exprType == 21) {
            if (this.eArg.tableFilter == this.eArg2.tableFilter) {
                return;
            }
            if (this.eArg.tableFilter == filter) {
                if (this.eArg2.exprType == 2 || this.eArg2.exprType == 1) {
                    columns[this.eArg.columnIndex] = true;
                    elist[this.eArg.columnIndex] = this.eArg2;
                }
                return;
            }
            if (this.eArg2.tableFilter == filter && (this.eArg.exprType == 2 || this.eArg.exprType == 1)) {
                columns[this.eArg2.columnIndex] = true;
                elist[this.eArg2.columnIndex] = this.eArg;
            }
        }
    }

    TableFilter findTableFilter(TableFilter[] list) {
        int t = 0;
        while (t < list.length) {
            TableFilter f = list[t];
            if ((this.schema == null || f.filterTable.getSchemaName().equals(this.schema)) && f.getName().equals(this.tableName)) {
                return f;
            }
            ++t;
        }
        return null;
    }

    void resolveTables(TableFilter f) throws HsqlException {
        if (this.isParam || f == null || this.exprType == 1) {
            return;
        }
        if (this.eArg != null) {
            this.eArg.resolveTables(f);
        }
        if (this.eArg2 != null) {
            this.eArg2.resolveTables(f);
        }
        switch (this.exprType) {
            case 2: {
                Table table;
                int i;
                if (this.tableFilter != null) break;
                String filterName = f.getName();
                if (this.tableName != null && !this.tableName.equals(filterName) || (i = (table = f.getTable()).findColumn(this.columnName)) == -1) break;
                this.tableFilter = f;
                this.columnIndex = i;
                this.tableName = filterName;
                this.setTableColumnAttributes(table, i);
                return;
            }
            case 3: {
                if (this.subQuery == null) break;
                this.subQuery.select.resolveTablesUnion(f);
                break;
            }
            case 7: {
                if (this.function == null) break;
                this.function.resolveTables(f);
                break;
            }
            case 32: 
            case 33: {
                break;
            }
            case 30: {
                if (this.eArg2.exprType == 3) break;
                Expression[] vl = this.eArg2.valueList;
                int i = 0;
                while (i < vl.length) {
                    vl[i].resolveTables(f);
                    ++i;
                }
                break;
            }
        }
    }

    int getCaseWhenType(Session session) throws HsqlException {
        return this.eArg2.dataType;
    }

    void resolveTypes(Session session) throws HsqlException {
        if (this.isParam) {
            return;
        }
        if (this.eArg != null) {
            this.eArg.resolveTypes(session);
        }
        if (this.eArg2 != null) {
            this.eArg2.resolveTypes(session);
        }
        switch (this.exprType) {
            case 1: {
                if (this.dataType != 16 || this.valueData == null) break;
                this.exprType = (Boolean)this.valueData != false ? 4 : -4;
                break;
            }
            case 2: {
                break;
            }
            case 7: {
                this.function.resolveType(session);
                this.dataType = this.function.getReturnType();
                break;
            }
            case 3: {
                this.subQuery.select.resolveTypes(session);
                this.dataType = this.subQuery.select.exprColumns[0].dataType;
                break;
            }
            case 10: {
                if (this.eArg.isParam) {
                    throw Trace.error(216, 212);
                }
                this.dataType = this.eArg.dataType;
                if (!this.isFixedConstant()) break;
                this.valueData = this.getValue(session, this.dataType);
                this.eArg = null;
                this.exprType = 1;
                break;
            }
            case 11: {
                if (Types.isCharacterType(this.eArg.dataType) || Types.isCharacterType(this.eArg2.dataType)) {
                    this.exprType = 15;
                    this.dataType = 12;
                    if (this.isFixedConstant()) {
                        this.valueData = this.getValue(session, this.dataType);
                        this.eArg = null;
                        this.eArg2 = null;
                        this.exprType = 1;
                        break;
                    }
                    if (this.eArg.isParam) {
                        this.eArg.dataType = 12;
                    }
                    if (!this.eArg2.isParam) break;
                    this.eArg2.dataType = 12;
                    break;
                }
            }
            case 12: 
            case 13: 
            case 14: {
                if (this.eArg.isParam && this.eArg2.isParam) {
                    throw Trace.error(216, 213);
                }
                if (this.isFixedConstant()) {
                    this.dataType = Column.getCombinedNumberType(this.eArg.dataType, this.eArg2.dataType, this.exprType);
                    this.valueData = this.getValue(session, this.dataType);
                    this.eArg = null;
                    this.eArg2 = null;
                    this.exprType = 1;
                    break;
                }
                if (this.eArg.isParam) {
                    this.eArg.dataType = this.eArg2.dataType;
                } else if (this.eArg2.isParam) {
                    this.eArg2.dataType = this.eArg.dataType;
                }
                this.dataType = Column.getCombinedNumberType(this.eArg.dataType, this.eArg2.dataType, this.exprType);
                break;
            }
            case 15: {
                this.dataType = 12;
                if (this.isFixedConstant()) {
                    this.valueData = this.getValue(session, this.dataType);
                    this.eArg = null;
                    this.eArg2 = null;
                    this.exprType = 1;
                    break;
                }
                if (this.eArg.isParam) {
                    this.eArg.dataType = 12;
                }
                if (!this.eArg2.isParam) break;
                this.eArg2.dataType = 12;
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                if (this.eArg.isParam && this.eArg2.isParam) {
                    throw Trace.error(216, 214);
                }
                if (this.isFixedConditional()) {
                    Boolean result = this.test(session);
                    if (result == null) {
                        this.setNull();
                    } else {
                        this.exprType = result != false ? 4 : -4;
                    }
                    this.eArg = null;
                    this.eArg2 = null;
                } else if (this.eArg.isParam) {
                    int n = this.eArg.dataType = this.eArg2.dataType == 0 ? 12 : this.eArg2.dataType;
                    if (this.eArg2.exprType == 2) {
                        this.eArg.setTableColumnAttributes(this.eArg2);
                    }
                } else if (this.eArg2.isParam) {
                    int n = this.eArg2.dataType = this.eArg.dataType == 0 ? 12 : this.eArg.dataType;
                    if (this.eArg.exprType == 2) {
                        this.eArg2.setTableColumnAttributes(this.eArg);
                    }
                }
                this.dataType = 16;
                break;
            }
            case 27: {
                this.resolveTypeForLike(session);
                this.dataType = 16;
                break;
            }
            case 28: {
                Boolean arg2;
                boolean argFixed = this.eArg.isFixedConditional();
                boolean arg2Fixed = this.eArg2.isFixedConditional();
                Boolean arg = argFixed ? this.eArg.test(session) : null;
                Boolean bl = arg2 = arg2Fixed ? this.eArg2.test(session) : null;
                if (argFixed && arg2Fixed) {
                    if (arg == null || arg2 == null) {
                        this.setNull();
                    } else {
                        this.exprType = arg != false && arg2 != false ? 4 : -4;
                        this.eArg = null;
                        this.eArg2 = null;
                    }
                } else if (argFixed && !Boolean.TRUE.equals(arg) || arg2Fixed && !Boolean.TRUE.equals(arg2)) {
                    this.exprType = -4;
                    this.eArg = null;
                    this.eArg2 = null;
                } else {
                    if (this.eArg.isParam) {
                        this.eArg.dataType = 16;
                    }
                    if (this.eArg2.isParam) {
                        this.eArg2.dataType = 16;
                    }
                }
                this.dataType = 16;
                break;
            }
            case 29: {
                Boolean arg2;
                boolean argFixed = this.eArg.isFixedConditional();
                boolean arg2Fixed = this.eArg2.isFixedConditional();
                Boolean arg = argFixed ? this.eArg.test(session) : null;
                Boolean bl = arg2 = arg2Fixed ? this.eArg2.test(session) : null;
                if (argFixed && arg2Fixed) {
                    if (arg == null || arg2 == null) {
                        this.setNull();
                    } else {
                        this.exprType = arg != false || arg2 != false ? 4 : -4;
                        this.eArg = null;
                        this.eArg2 = null;
                    }
                } else if (argFixed && Boolean.TRUE.equals(arg) || arg2Fixed && Boolean.TRUE.equals(arg2)) {
                    this.exprType = 4;
                    this.eArg = null;
                    this.eArg2 = null;
                } else {
                    if (this.eArg.isParam) {
                        this.eArg.dataType = 16;
                    }
                    if (this.eArg2.isParam) {
                        this.eArg2.dataType = 16;
                    }
                }
                this.dataType = 16;
                break;
            }
            case 34: {
                if (this.isFixedConditional()) {
                    this.exprType = Boolean.TRUE.equals(this.test(session)) ? 4 : -4;
                    this.eArg = null;
                } else if (this.eArg.dataType == 0) {
                    this.eArg.dataType = 12;
                }
                this.dataType = 16;
                break;
            }
            case 20: {
                if (this.isFixedConditional()) {
                    Boolean arg = this.test(session);
                    if (arg == null) {
                        this.setNull();
                    } else {
                        this.exprType = arg != false ? 4 : -4;
                        this.eArg = null;
                    }
                } else if (this.eArg.isParam) {
                    this.eArg.dataType = 16;
                }
                this.dataType = 16;
                break;
            }
            case 32: 
            case 33: {
                this.dataType = this.eArg.dataType;
                break;
            }
            case 30: {
                this.resolveTypeForIn(session);
                this.dataType = 16;
                break;
            }
            case 31: {
                this.dataType = 16;
                break;
            }
            case 40: {
                if (this.eArg.isParam) {
                    throw Trace.error(216, 215);
                }
                this.dataType = 4;
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                if (this.eArg.isParam) {
                    throw Trace.error(216, 215);
                }
                this.dataType = SetFunction.getType(this.exprType, this.eArg.dataType);
                break;
            }
            case 61: {
                if (!this.eArg.isFixedConstant() && !this.eArg.isFixedConditional()) break;
                this.valueData = this.getValue(session);
                this.exprType = 1;
                this.eArg = null;
                break;
            }
            case 62: {
                if (this.eArg.isParam) {
                    this.eArg.dataType = 16;
                }
                this.dataType = this.getCaseWhenType(session);
                break;
            }
            case 70: {
                Expression case1 = this.eArg;
                Expression case2 = this.eArg2;
                if (case1.isParam && case2.isParam) {
                    throw Trace.error(216, 217);
                }
                if (case1.isParam || case1.dataType == 0) {
                    case1.dataType = case2.dataType;
                } else if (case2.isParam || case2.dataType == 0) {
                    case2.dataType = case1.dataType;
                }
                if (case1.dataType == 0 && case2.dataType == 0) {
                    this.dataType = 0;
                }
                if (Types.isNumberType(case1.dataType) && Types.isNumberType(case2.dataType)) {
                    this.dataType = Column.getCombinedNumberType(case1.dataType, case2.dataType, 70);
                    break;
                }
                if (Types.isCharacterType(case1.dataType) && Types.isCharacterType(case2.dataType)) {
                    this.dataType = -1;
                    break;
                }
                if (case1.dataType != case2.dataType) {
                    if (case2.exprType == 1) {
                        this.dataType = case2.dataType = case1.dataType;
                        case2.valueData = Column.convertObject(case2.valueData, this.dataType);
                        break;
                    }
                    if (case1.exprType == 1) {
                        this.dataType = case1.dataType = case2.dataType;
                        case1.valueData = Column.convertObject(case1.valueData, this.dataType);
                        break;
                    }
                    throw Trace.error(216, 218, new String[]{Types.getTypeString(case1.dataType), Types.getTypeString(case2.dataType)});
                }
                this.dataType = case1.dataType;
            }
        }
    }

    void resolveTypeForLike(Session session) throws HsqlException {
        if (this.eArg.isParam && this.eArg2.isParam) {
            throw Trace.error(216, 219);
        }
        if (this.isFixedConditional()) {
            Boolean arg = this.test(session);
            if (arg == null) {
                this.setNull();
            } else {
                this.exprType = arg != false ? 4 : -4;
                this.eArg = null;
                this.eArg2 = null;
            }
        } else if (this.eArg.isParam) {
            this.eArg.dataType = 12;
        } else if (this.eArg2.isParam) {
            this.eArg2.dataType = 12;
        }
        if (this.likeObject.optimised) {
            return;
        }
        boolean isRightArgFixedConstant = this.eArg2.isFixedConstant();
        String likeStr = isRightArgFixedConstant ? (String)this.eArg2.getValue(session, 12) : null;
        boolean ignoreCase = this.eArg.dataType == 100 || this.eArg2.dataType == 100;
        this.likeObject.setParams(session, likeStr, ignoreCase);
        if (!isRightArgFixedConstant) {
            return;
        }
        if (this.likeObject.isEquivalentToFalsePredicate()) {
            this.exprType = -4;
            this.eArg = null;
            this.eArg2 = null;
            this.likeObject = null;
        } else if (this.likeObject.isEquivalentToEqualsPredicate()) {
            this.exprType = 21;
            this.eArg2 = new Expression(12, this.likeObject.getRangeLow());
            this.likeObject = null;
        } else if (!this.likeObject.isEquivalentToNotNullPredicate()) {
            if (this.eArg.exprType != 2) {
                return;
            }
            if (!Types.isCharacterType(this.eArg.dataType)) {
                return;
            }
            boolean between = false;
            boolean like = false;
            boolean larger = false;
            if (this.likeObject.isEquivalentToBetweenPredicate()) {
                larger = this.likeObject.hasCollation;
                between = !larger;
                like = larger;
            } else if (this.likeObject.isEquivalentToBetweenPredicateAugmentedWithLike()) {
                larger = this.likeObject.hasCollation;
                between = !larger;
                like = true;
            }
            if (!between && !larger) {
                return;
            }
            Expression eFirst = new Expression(12, this.likeObject.getRangeLow());
            Expression eLast = new Expression(12, this.likeObject.getRangeHigh());
            if (between && !like) {
                Expression eArgOld = this.eArg;
                this.eArg = new Expression(22, eArgOld, eFirst);
                this.eArg2 = new Expression(25, eArgOld, eLast);
                this.exprType = 28;
                this.likeObject = null;
            } else if (between && like) {
                Expression gte = new Expression(22, this.eArg, eFirst);
                Expression lte = new Expression(25, this.eArg, eLast);
                this.eArg2 = new Expression(this.eArg, this.eArg2, this.likeObject.escapeChar, this.likeObject.hasCollation);
                this.eArg2.likeObject = this.likeObject;
                this.eArg = new Expression(28, gte, lte);
                this.exprType = 28;
                this.likeObject = null;
            } else if (larger) {
                Expression gte = new Expression(22, this.eArg, eFirst);
                this.eArg2 = new Expression(this.eArg, this.eArg2, this.likeObject.escapeChar, this.likeObject.hasCollation);
                this.eArg2.likeObject = this.likeObject;
                this.eArg = gte;
                this.exprType = 28;
                this.likeObject = null;
            }
        }
    }

    void resolveTypeForIn(Session session) throws HsqlException {
        if (this.eArg2.exprType == 3) {
            if (this.eArg.isParam) {
                this.eArg.dataType = this.eArg2.dataType;
            }
            this.isQueryCorrelated = !this.eArg2.subQuery.isResolved;
        } else {
            Expression[] vl = this.eArg2.valueList;
            int len = vl.length;
            if (this.eArg.isParam) {
                if (vl[0].isParam) {
                    throw Trace.error(216, 221);
                }
                Expression e = vl[0];
                int dt = e.dataType;
                if (dt != 0) {
                    if (this.eArg.dataType == 0) {
                        this.eArg.dataType = dt;
                    }
                    if (this.eArg2.dataType == 0) {
                        this.eArg2.dataType = dt;
                    }
                }
                int i = 1;
                while (i < len) {
                    e = vl[i];
                    if (e.isParam) {
                        if (e.dataType == 0 && dt != 0) {
                            e.dataType = dt;
                        }
                    } else {
                        e.resolveTypes(session);
                    }
                    ++i;
                }
            } else {
                int dt = this.eArg.dataType;
                if (this.eArg2.dataType == 0 && dt != 0) {
                    this.eArg2.dataType = dt;
                }
                int i = 0;
                while (i < len) {
                    Expression e = vl[i];
                    if (e.isParam) {
                        if (e.dataType == 0 && dt != 0) {
                            e.dataType = dt;
                        }
                    } else {
                        e.resolveTypes(session);
                    }
                    ++i;
                }
            }
            this.eArg2.isFixedConstantValueList = this.eArg2.dataType != 100;
            int i = 0;
            while (i < len) {
                if (!vl[i].isFixedConstant()) {
                    this.eArg2.isFixedConstantValueList = false;
                    this.isQueryCorrelated = true;
                    break;
                }
                ++i;
            }
            if (this.eArg2.isFixedConstantValueList) {
                this.eArg2.hList = new HashSet();
                i = 0;
                while (i < len) {
                    try {
                        Object value = this.eArg2.valueList[i].getValue(session);
                        value = Column.convertObject(value, this.eArg2.dataType);
                        if (this.eArg2.dataType == 1 && value != null) {
                            value = Library.rtrim((String)value);
                        }
                        this.eArg2.hList.add(value);
                    }
                    catch (HsqlException hsqlException) {}
                    ++i;
                }
            }
        }
    }

    boolean isResolved() {
        switch (this.exprType) {
            case 1: 
            case 10: {
                return true;
            }
            case 2: {
                return this.tableFilter != null && this.tableFilter.isAssigned;
            }
            case 3: {
                return this.subQuery.isResolved;
            }
        }
        return false;
    }

    static boolean isCompare(int i) {
        switch (i) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    String getTableName() {
        if (this.exprType == 6) {
            return this.tableName;
        }
        if (this.exprType == 2) {
            if (this.tableFilter == null) {
                return this.tableName;
            }
            return this.tableFilter.getTable().getName().name;
        }
        return "";
    }

    String getFilterTableName() {
        if (this.tableFilter == null) {
            return "";
        }
        return this.tableFilter.getTable().getName().name;
    }

    HsqlNameManager.HsqlName getTableHsqlName() {
        if (this.tableFilter == null) {
            return null;
        }
        return this.tableFilter.getTable().getName();
    }

    String getTableSchemaName() {
        if (this.tableFilter == null) {
            return null;
        }
        return this.tableFilter.getTable().getName().schema.name;
    }

    String getColumnName() {
        if (this.exprType == 2) {
            if (this.tableFilter == null) {
                return this.columnName;
            }
            return this.tableFilter.getTable().getColumn((int)this.columnIndex).columnName.name;
        }
        return this.getAlias();
    }

    String getBaseColumnName() {
        if (this.exprType == 2 && this.tableFilter != null) {
            return this.tableFilter.getTable().getColumn((int)this.columnIndex).columnName.name;
        }
        return null;
    }

    int getColumnNr() {
        return this.columnIndex;
    }

    int getColumnSize() {
        return this.precision;
    }

    int getColumnScale() {
        return this.scale;
    }

    void setDistinctAggregate(boolean distinct) {
        boolean bl = this.isDistinctAggregate = distinct && this.eArg.exprType != 6;
        if (this.exprType == 40) {
            this.dataType = distinct ? this.dataType : 4;
        }
    }

    void swapCondition() throws HsqlException {
        int i = 21;
        switch (this.exprType) {
            case 22: {
                i = 25;
                break;
            }
            case 25: {
                i = 22;
                break;
            }
            case 24: {
                i = 23;
                break;
            }
            case 23: {
                i = 24;
                break;
            }
            case 21: {
                break;
            }
            default: {
                Trace.doAssert(false, "Expression.swapCondition");
            }
        }
        this.exprType = i;
        Expression e = this.eArg;
        this.eArg = this.eArg2;
        this.eArg2 = e;
    }

    int getDataType() {
        return this.dataType;
    }

    Object getValue(Session session, int type) throws HsqlException {
        Object o = this.getValue(session);
        if (o == null || this.dataType == type) {
            return o;
        }
        return Column.convertObject(o, type);
    }

    Object getAggregatedValue(Session session, Object currValue) throws HsqlException {
        if (!this.isAggregate()) {
            return currValue;
        }
        Object leftValue = null;
        Object rightValue = null;
        switch (this.aggregateSpec) {
            case -1: {
                switch (this.exprType) {
                    case 40: {
                        if (currValue == null) {
                            return INTEGER_0;
                        }
                        return ((SetFunction)currValue).getValue();
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: {
                        if (currValue == null) {
                            return null;
                        }
                        return ((SetFunction)currValue).getValue();
                    }
                }
            }
            case 1: {
                leftValue = this.eArg.getAggregatedValue(session, currValue == null ? null : currValue[0]);
                if (currValue == null) {
                    rightValue = this.eArg2 == null ? null : this.eArg2.getValue(session);
                    break;
                }
                rightValue = currValue[1];
                break;
            }
            case 2: {
                leftValue = currValue == null ? (this.eArg == null ? null : this.eArg.getValue(session)) : ((Object[])currValue)[0];
                rightValue = this.eArg2.getAggregatedValue(session, currValue == null ? null : currValue[1]);
                break;
            }
            case 3: {
                if (currValue == null) {
                    currValue = new Object[2];
                }
                leftValue = this.eArg.getAggregatedValue(session, currValue[0]);
                rightValue = this.eArg2.getAggregatedValue(session, currValue[1]);
            }
        }
        switch (this.exprType) {
            case 10: {
                return Column.negate(leftValue, this.dataType);
            }
            case 61: {
                return Column.convertObject(session, leftValue, this.dataType, this.precision, this.scale);
            }
            case 4: {
                return Boolean.TRUE;
            }
            case -4: {
                return Boolean.FALSE;
            }
            case 20: {
                if (leftValue == null) {
                    return null;
                }
                return (Boolean)leftValue != false ? Boolean.FALSE : Boolean.TRUE;
            }
            case 28: {
                if (leftValue == null || rightValue == null) {
                    return null;
                }
                return (Boolean)leftValue != false && (Boolean)rightValue != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 29: {
                if (Boolean.TRUE.equals(leftValue)) {
                    return Boolean.TRUE;
                }
                return Boolean.TRUE.equals(rightValue) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 34: {
                return leftValue == null ? Boolean.TRUE : Boolean.FALSE;
            }
            case 27: {
                String s = (String)Column.convertObject(rightValue, 12);
                if (this.eArg2.isParam || this.eArg2.exprType != 1) {
                    this.likeObject.resetPattern(session, s);
                }
                String c = (String)Column.convertObject(leftValue, 12);
                return this.likeObject.compare(session, c);
            }
            case 32: 
            case 33: {
                return null;
            }
            case 30: {
                return this.eArg2.testInCondition(session, leftValue);
            }
            case 31: {
                if (!this.eArg.subQuery.isResolved) {
                    Result r = this.eArg.subQuery.select.getResult(session, 1);
                    return r.rRoot == null ? Boolean.FALSE : Boolean.TRUE;
                }
                return this.subQuery.table.isEmpty(session) ? Boolean.FALSE : Boolean.TRUE;
            }
            case 62: {
                leftValue = Column.convertObject(leftValue, 16);
                boolean test = (Boolean)leftValue;
                Object result = test ? ((Object[])rightValue)[0] : ((Object[])rightValue)[1];
                return Column.convertObject(result, this.dataType);
            }
            case 70: {
                leftValue = Column.convertObject(leftValue, this.dataType);
                rightValue = Column.convertObject(rightValue, this.dataType);
                Object[] objectPair = new Object[]{leftValue, rightValue};
                return objectPair;
            }
            case 7: {
                return this.function.getAggregatedValue(session, currValue);
            }
        }
        if (Expression.isCompare(this.exprType)) {
            if (this.eArg2.exprType == 33 || this.eArg2.exprType == 32) {
                return this.testAnyAllCondition(session, leftValue);
            }
            return this.compareValues(session, leftValue, rightValue);
        }
        if (leftValue != null) {
            leftValue = Column.convertObject(leftValue, this.dataType);
        }
        if (rightValue != null) {
            rightValue = Column.convertObject(rightValue, this.dataType);
        }
        switch (this.exprType) {
            case 11: {
                return Column.add(leftValue, rightValue, this.dataType);
            }
            case 12: {
                return Column.subtract(leftValue, rightValue, this.dataType);
            }
            case 13: {
                return Column.multiply(leftValue, rightValue, this.dataType);
            }
            case 14: {
                return Column.divide(leftValue, rightValue, this.dataType);
            }
            case 15: {
                return Column.concat(leftValue, rightValue);
            }
        }
        throw Trace.error(14, this.describe(session));
    }

    Object updateAggregatingValue(Session session, Object currValue) throws HsqlException {
        switch (this.aggregateSpec) {
            case -1: {
                if (currValue == null) {
                    currValue = new SetFunction(this.exprType, this.eArg.dataType, this.isDistinctAggregate);
                }
                Integer newValue = this.eArg.exprType == 6 ? INTEGER_1 : this.eArg.getValue(session);
                ((SetFunction)currValue).add(session, newValue);
                return currValue;
            }
            case 3: {
                Object[] valuePair = (Object[])currValue;
                if (valuePair == null) {
                    valuePair = new Object[]{this.eArg.updateAggregatingValue(session, valuePair[0]), this.eArg2.updateAggregatingValue(session, valuePair[1])};
                }
                return valuePair;
            }
            case 1: {
                Object[] valuePair = (Object[])currValue;
                if (valuePair == null) {
                    valuePair = new Object[2];
                }
                valuePair[0] = this.eArg.updateAggregatingValue(session, valuePair[0]);
                if (this.eArg2 != null) {
                    valuePair[1] = this.eArg2.getValue(session);
                }
                return valuePair;
            }
            case 2: {
                Object[] valuePair = (Object[])currValue;
                if (valuePair == null) {
                    valuePair = new Object[2];
                }
                if (this.eArg != null) {
                    valuePair[0] = this.eArg.getValue(session);
                }
                valuePair[1] = this.eArg2.updateAggregatingValue(session, valuePair[1]);
                return valuePair;
            }
            case 4: {
                return this.function.updateAggregatingValue(session, currValue);
            }
        }
        return currValue;
    }

    Object getValue(Session session) throws HsqlException {
        switch (this.exprType) {
            case 1: {
                return this.valueData;
            }
            case 2: {
                try {
                    return this.tableFilter.currentData[this.columnIndex];
                }
                catch (NullPointerException nullPointerException) {
                    String name = this.tableName == null ? this.columnName : String.valueOf(this.tableName) + '.' + this.columnName;
                    throw Trace.error(28, name);
                }
            }
            case 7: {
                return this.function.getValue(session);
            }
            case 3: {
                return this.subQuery.select.getValue(session, this.dataType);
            }
            case 10: {
                return Column.negate(this.eArg.getValue(session, this.dataType), this.dataType);
            }
            case 32: 
            case 33: {
                return null;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return this.test(session);
            }
            case 61: {
                return Column.convertObject(session, this.eArg.getValue(session), this.dataType, this.precision, this.scale);
            }
            case 62: {
                Boolean result = this.eArg.test(session);
                if (Boolean.TRUE.equals(result)) {
                    return this.eArg2.eArg.getValue(session, this.dataType);
                }
                return this.eArg2.eArg2.getValue(session, this.dataType);
            }
            case 70: {
                return new Object[]{this.eArg.getValue(session, this.dataType), this.eArg2.getValue(session, this.dataType)};
            }
        }
        Object a = null;
        Object b = null;
        if (this.eArg != null) {
            a = this.eArg.getValue(session, this.dataType);
        }
        if (this.eArg2 != null) {
            b = this.eArg2.getValue(session, this.dataType);
        }
        switch (this.exprType) {
            case 11: {
                return Column.add(a, b, this.dataType);
            }
            case 12: {
                return Column.subtract(a, b, this.dataType);
            }
            case 13: {
                return Column.multiply(a, b, this.dataType);
            }
            case 14: {
                return Column.divide(a, b, this.dataType);
            }
            case 15: {
                return Column.concat(a, b);
            }
            case 71: {
                return ((NumberSequence)this.valueData).getValueObject();
            }
        }
        return this.test(session);
    }

    boolean testCondition(Session session) throws HsqlException {
        return Boolean.TRUE.equals(this.test(session));
    }

    Boolean test(Session session) throws HsqlException {
        switch (this.exprType) {
            case 4: {
                return Boolean.TRUE;
            }
            case -4: {
                return Boolean.FALSE;
            }
            case 20: {
                Boolean result;
                if (this.eArg2 != null) {
                    Trace.doAssert(false, "Expression.test");
                }
                return (result = this.eArg.test(session)) == null ? null : (result != false ? Boolean.FALSE : Boolean.TRUE);
            }
            case 28: {
                Boolean r1 = this.eArg.test(session);
                if (r1 == null) {
                    return null;
                }
                Boolean r2 = this.eArg2.test(session);
                if (r2 == null) {
                    return null;
                }
                return r1 != false && r2 != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 29: {
                boolean r1 = Boolean.TRUE.equals(this.eArg.test(session));
                if (r1) {
                    return Boolean.TRUE;
                }
                return Boolean.TRUE.equals(this.eArg2.test(session)) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 34: {
                return this.eArg.getValue(session) == null ? Boolean.TRUE : Boolean.FALSE;
            }
            case 27: {
                String s = (String)this.eArg2.getValue(session, 12);
                if (this.eArg2.isParam || this.eArg2.exprType != 1) {
                    this.likeObject.resetPattern(session, s);
                }
                String c = (String)this.eArg.getValue(session, 12);
                return this.likeObject.compare(session, c);
            }
            case 30: {
                return this.eArg2.testInCondition(session, this.eArg.getValue(session));
            }
            case 31: {
                return this.eArg.testExistsCondition(session);
            }
            case 7: {
                Object value = Column.convertObject(this.function.getValue(session), 16);
                return (Boolean)value;
            }
        }
        if (this.eArg == null || this.eArg2 == null) {
            if (this.exprType == 2 && (this.dataType == 16 || Types.isNumberType(this.dataType))) {
                Object value = Column.convertObject(this.getValue(session), 16);
                return (Boolean)value;
            }
            throw Trace.error(106);
        }
        if (this.eArg2.exprType == 33 || this.eArg2.exprType == 32) {
            return this.testAnyAllCondition(session, this.eArg.getValue(session));
        }
        Object o1 = this.eArg.getValue(session);
        Object o2 = this.eArg2.getValue(session);
        if (o1 == null || o2 == null) {
            if (this.eArg.tableFilter != null && this.eArg.tableFilter.isOuterJoin) {
                if (this.isInJoin) {
                    if (this.eArg.tableFilter.isCurrentOuter && o1 == null) {
                        return Boolean.TRUE;
                    }
                } else {
                    this.eArg.tableFilter.nonJoinIsNull = o2 == null;
                }
            }
            return null;
        }
        return this.compareValues(session, o1, o2);
    }

    private Boolean compareValues(Session session, Object o1, Object o2) throws HsqlException {
        int type = this.eArg.dataType;
        if (this.eArg.dataType != this.eArg2.dataType) {
            if (Types.isNumberType(this.eArg.dataType) && Types.isNumberType(this.eArg2.dataType)) {
                type = Column.getCombinedNumberType(this.eArg.dataType, this.eArg2.dataType, this.exprType);
            }
            o1 = Column.convertObject(o1, type);
            o2 = Column.convertObject(o2, type);
        }
        int result = Column.compare(session.database.collation, o1, o2, type);
        switch (this.exprType) {
            case 21: {
                return result == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 23: {
                return result > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 22: {
                return result >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 25: {
                return result <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 24: {
                return result < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 26: {
                return result != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Trace.error(40, 167);
    }

    private Boolean testInCondition(Session session, Object o) throws HsqlException {
        if (o == null) {
            return null;
        }
        if (this.exprType == 5) {
            try {
                o = Column.convertObject(o, this.dataType);
            }
            catch (HsqlException hsqlException) {
                return Boolean.FALSE;
            }
            if (this.isFixedConstantValueList) {
                if (this.dataType == 1) {
                    o = Library.rtrim((String)o);
                }
                return this.hList.contains(o) ? Boolean.TRUE : Boolean.FALSE;
            }
            int len = this.valueList.length;
            int i = 0;
            while (i < len) {
                Object o2 = this.valueList[i].getValue(session, this.dataType);
                if (Column.compare(session.database.collation, o, o2, this.dataType) == 0) {
                    return Boolean.TRUE;
                }
                ++i;
            }
            return Boolean.FALSE;
        }
        if (this.exprType == 3) {
            Boolean result;
            try {
                o = Column.convertObject(o, this.subQuery.table.getColumnTypes()[0]);
            }
            catch (HsqlException hsqlException) {
                return Boolean.FALSE;
            }
            if (!this.subQuery.isResolved) {
                this.subQuery.populateTable(session);
            }
            Boolean bl = result = this.subQuery.table.getPrimaryIndex().findFirstRow(session, o, 21).hasNext() ? Boolean.TRUE : Boolean.FALSE;
            if (!this.subQuery.isResolved) {
                this.subQuery.table.clearAllRows(session);
            }
            return result;
        }
        throw Trace.error(16);
    }

    private Boolean testExistsCondition(Session session) throws HsqlException {
        if (this.subQuery.isResolved) {
            return this.subQuery.table.isEmpty(session) ? Boolean.FALSE : Boolean.TRUE;
        }
        Result r = this.subQuery.select.getResult(session, 1);
        return r.rRoot == null ? Boolean.FALSE : Boolean.TRUE;
    }

    private Boolean testAnyAllCondition(Session session, Object o) throws HsqlException {
        boolean populate;
        if (o == null) {
            return null;
        }
        SubQuery subquery = this.eArg2.eArg.subQuery;
        boolean bl = populate = !subquery.isResolved;
        if (populate) {
            subquery.populateTable(session);
        }
        Boolean result = this.getAnyAllValue(session, o, subquery);
        if (populate) {
            subquery.table.clearAllRows(session);
        }
        return result;
    }

    private Boolean getAnyAllValue(Session session, Object o, SubQuery subquery) throws HsqlException {
        boolean empty = subquery.table.isEmpty(session);
        Index index = subquery.table.getPrimaryIndex();
        RowIterator it = index.findFirstRowNotNull(session);
        Row firstrow = it.next();
        switch (this.eArg2.exprType) {
            case 33: {
                if (empty) {
                    return Boolean.FALSE;
                }
                if (firstrow == null) {
                    return null;
                }
                int range = Column.compareToTypeRange(o, this.eArg2.eArg.getDataType());
                if (range != 0) {
                    switch (this.exprType) {
                        case 21: {
                            return Boolean.FALSE;
                        }
                        case 26: {
                            return Boolean.TRUE;
                        }
                        case 22: 
                        case 23: {
                            return range > 0 ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 24: 
                        case 25: {
                            return range < 0 ? Boolean.TRUE : Boolean.FALSE;
                        }
                    }
                }
                o = Column.convertObject(o, this.eArg2.eArg.getDataType());
                if (this.exprType == 21) {
                    it = index.findFirstRow(session, o, 21);
                    return it.hasNext() ? Boolean.TRUE : Boolean.FALSE;
                }
                Row lastrow = index.lastRow(session);
                Object firstdata = firstrow.getData()[0];
                Object lastdata = lastrow.getData()[0];
                int comparefirst = Column.compare(session.database.collation, o, firstdata, this.eArg.getDataType());
                int comparelast = Column.compare(session.database.collation, o, lastdata, this.eArg.getDataType());
                switch (this.exprType) {
                    case 26: {
                        return comparefirst == 0 && comparelast == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    case 23: {
                        return comparefirst > 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 22: {
                        return comparefirst >= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 24: {
                        return comparelast < 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 25: {
                        return comparelast <= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
                break;
            }
            case 32: {
                if (empty) {
                    return Boolean.TRUE;
                }
                if (firstrow == null) {
                    return null;
                }
                int range = Column.compareToTypeRange(o, this.eArg2.eArg.getDataType());
                if (range != 0) {
                    switch (this.exprType) {
                        case 21: {
                            return Boolean.FALSE;
                        }
                        case 26: {
                            return Boolean.TRUE;
                        }
                        case 22: 
                        case 23: {
                            return range > 0 ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 24: 
                        case 25: {
                            return range < 0 ? Boolean.TRUE : Boolean.FALSE;
                        }
                    }
                }
                o = Column.convertObject(o, this.eArg2.eArg.getDataType());
                if (this.exprType == 21 || this.exprType == 26) {
                    it = index.findFirstRow(session, o, 21);
                    if (this.exprType == 21) {
                        return it.hasNext() && subquery.table.getRowCount(session) == 1 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    return it.hasNext() ? Boolean.FALSE : Boolean.TRUE;
                }
                Row lastrow = index.lastRow(session);
                Object firstdata = firstrow.getData()[0];
                Object lastdata = lastrow.getData()[0];
                o = Column.convertObject(o, this.eArg2.eArg.getDataType());
                int comparefirst = Column.compare(session.database.collation, o, firstdata, this.eArg.getDataType());
                int comparelast = Column.compare(session.database.collation, o, lastdata, this.eArg.getDataType());
                switch (this.exprType) {
                    case 26: {
                        return comparefirst == 0 || comparelast == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    case 23: {
                        return comparelast > 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 22: {
                        return comparelast >= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 24: {
                        return comparefirst < 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 25: {
                        return comparefirst <= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
            }
        }
        return null;
    }

    boolean setForJoin(TableFilter tf, boolean outer) {
        this.isInJoin = outer;
        if (outer) {
            this.outerFilter = tf;
        }
        if (this.eArg != null && !this.eArg.setForJoin(tf, outer)) {
            return false;
        }
        if (this.eArg2 != null && !this.eArg2.setForJoin(tf, outer)) {
            return false;
        }
        return !outer || this.exprType == 28 || this.exprType == 29 || this.exprType == 2 || this.exprType == 1 || this.exprType == 21 || this.exprType == 26 || this.exprType == 23 || this.exprType == 22 || this.exprType == 24 || this.exprType == 25 || this.exprType == 34;
    }

    static Select getCheckSelect(Session session, Table t, Expression e) throws HsqlException {
        Expression condition;
        Select s = new Select();
        s.exprColumns = new Expression[1];
        s.exprColumns[0] = new Expression(1, Boolean.TRUE);
        s.tFilter = new TableFilter[1];
        s.tFilter[0] = new TableFilter(t, null, null, false);
        s.queryCondition = condition = new Expression(20, e, null);
        s.resolveAll(session, true);
        return s;
    }

    void setLeftExpression(Expression e) {
        this.eArg = e;
    }

    void setRightExpression(Expression e) {
        this.eArg2 = e;
    }

    Expression getRightExpression() {
        return this.eArg2;
    }

    void bind(Object o) {
        this.valueData = o;
    }

    boolean isParam() {
        return this.isParam;
    }

    boolean isFixedConstant() {
        switch (this.exprType) {
            case 1: {
                return !this.isParam;
            }
            case 10: {
                return this.eArg.isFixedConstant();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.eArg.isFixedConstant() && this.eArg2.isFixedConstant();
            }
        }
        return false;
    }

    boolean isFixedConditional() {
        switch (this.exprType) {
            case -4: 
            case 4: {
                return true;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return this.eArg.isFixedConstant() && this.eArg2.isFixedConstant();
            }
            case 34: {
                return this.eArg.isFixedConstant();
            }
            case 20: {
                return this.eArg.isFixedConditional();
            }
            case 28: 
            case 29: {
                return this.eArg.isFixedConditional() && this.eArg2.isFixedConditional();
            }
        }
        return false;
    }

    void setTableColumnAttributes(Expression e) {
        this.precision = e.precision;
        this.scale = e.scale;
        this.isIdentity = e.isIdentity;
        this.nullability = e.nullability;
        this.isWritable = e.isWritable;
        this.catalog = e.catalog;
        this.schema = e.schema;
    }

    void setTableColumnAttributes(Table t, int i) {
        Column c = t.getColumn(i);
        this.dataType = c.getType();
        this.precision = c.getSize();
        this.scale = c.getScale();
        this.isIdentity = c.isIdentity();
        this.nullability = c.isNullable() && !this.isIdentity ? 1 : 0;
        this.isWritable = t.isWritable();
        this.catalog = t.getCatalogName();
        this.schema = t.getSchemaName();
    }

    String getValueClassName() {
        if (this.valueClassName == null) {
            this.valueClassName = this.function == null ? Types.getColStClsName(this.dataType == 100 ? 12 : this.dataType) : this.function.getReturnClassName();
        }
        return this.valueClassName;
    }

    static class Collector
    extends HashSet {
        Collector() {
        }

        void addAll(Expression e, int type) {
            int i;
            Expression[] list;
            Function function;
            if (e == null) {
                return;
            }
            this.addAll(e.getArg(), type);
            this.addAll(e.getArg2(), type);
            if (e.exprType == type) {
                this.add(e);
            }
            if (e.subQuery != null) {
                this.addAll(e.subQuery.select, type);
            }
            if ((function = e.function) != null && (list = function.eArg) != null) {
                i = 0;
                while (i < list.length) {
                    this.addAll(list[i], type);
                    ++i;
                }
            }
            if ((list = e.valueList) != null) {
                i = 0;
                while (i < list.length) {
                    this.addAll(list[i], type);
                    ++i;
                }
            }
        }

        void addAll(Select select, int type) {
            while (select != null) {
                Expression[] list = select.exprColumns;
                int i = 0;
                while (i < list.length) {
                    this.addAll(list[i], type);
                    ++i;
                }
                this.addAll(select.queryCondition, type);
                this.addAll(select.havingCondition, type);
                select = select.unionSelect;
            }
        }
    }
}

