/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.Column;
import org.hsqldb.DITypeInfo;
import org.hsqldb.Table;
import org.hsqldb.Types;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.store.ValuePool;

final class DITableInfo {
    int bestRowTemporary = 0;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown = 0;
    int bestRowNotPseudo = 1;
    static final short tableIndexOther = 3;
    private static final int HALF_MAX_INT = 0x3FFFFFFF;
    private int hnd_column_remarks = -1;
    private int hnd_table_remarks = -1;
    private Table table;
    private static final DITypeInfo ti = new DITypeInfo();

    DITableInfo() {
        this.setLocale(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLocale(Locale l) {
        Class<BundleHandler> clazz = BundleHandler.class;
        synchronized (BundleHandler.class) {
            Locale oldLocale = BundleHandler.getLocale();
            BundleHandler.setLocale(l);
            this.hnd_column_remarks = BundleHandler.getBundleHandle("column-remarks", null);
            this.hnd_table_remarks = BundleHandler.getBundleHandle("table-remarks", null);
            BundleHandler.setLocale(oldLocale);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    Integer getBRIPseudo() {
        return ValuePool.getInt(this.bestRowNotPseudo);
    }

    Integer getBRIScope() {
        return this.table.isWritable() ? ValuePool.getInt(this.bestRowTemporary) : ValuePool.getInt(this.bestRowSession);
    }

    Integer getColBufLen(int i) {
        int size;
        Column column = this.table.getColumn(i);
        int type = column.getDIType();
        switch (type) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                size = column.getSize();
                if (size == 0) break;
                if (size > 0x3FFFFFFF) {
                    size = 0;
                    break;
                }
                size *= 2;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                size = column.getSize();
                break;
            }
            case -5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: {
                size = 8;
                break;
            }
            case 93: {
                size = 12;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                size = 4;
                break;
            }
            case 16: {
                size = 1;
                break;
            }
            default: {
                size = 0;
            }
        }
        return size > 0 ? ValuePool.getInt(size) : null;
    }

    Integer getColCharOctLen(int i) {
        int size;
        Column column = this.table.getColumn(i);
        int type = column.getDIType();
        switch (type) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                size = column.getSize();
                if (size == 0) break;
                if (size > 0x3FFFFFFF) {
                    size = 0;
                    break;
                }
                size *= 2;
                break;
            }
            default: {
                size = 0;
            }
        }
        return size == 0 ? null : ValuePool.getInt(size);
    }

    Integer getColDataType(int i) {
        return ValuePool.getInt(this.table.getColumn(i).getDIType());
    }

    String getColDataTypeName(int i) {
        Column column = this.table.getColumn(i);
        ti.setTypeCode(column.getDIType());
        ti.setTypeSub(column.getDITypeSub());
        return ti.getTypeName();
    }

    Integer getColDataTypeSub(int i) {
        return ValuePool.getInt(this.table.getColumn(i).getDITypeSub());
    }

    String getColDefault(int i) {
        return this.table.getColumn(i).getDefaultDDL();
    }

    Boolean getColIsIdentity(int i) {
        return ValuePool.getBoolean(this.table.getColumn(i).isIdentity());
    }

    String getColIsNullable(int i) {
        Column column = this.table.getColumn(i);
        return column.isNullable() && !column.isIdentity() ? "YES" : "NO";
    }

    String getColName(int i) {
        return this.table.getColumn((int)i).columnName.name;
    }

    Integer getColNullability(int i) {
        Column column = this.table.getColumn(i);
        return column.isNullable() && !column.isIdentity() ? ValuePool.getInt(1) : ValuePool.getInt(0);
    }

    Integer getColPrecRadix(int i) {
        ti.setTypeCode(this.table.getColumn(i).getDIType());
        return ti.getNumPrecRadix();
    }

    String getColRemarks(int i) {
        if (this.table.getTableType() != 0) {
            return null;
        }
        String key = String.valueOf(this.getName()) + "_" + this.getColName(i);
        return BundleHandler.getString(this.hnd_column_remarks, key);
    }

    Integer getColScale(int i) {
        Column column = this.table.getColumn(i);
        int type = column.getDIType();
        return Types.acceptsScaleCreateParam(type) ? ValuePool.getInt(column.getScale()) : null;
    }

    String getColScopeCat(int i) {
        return null;
    }

    String getColScopeSchem(int i) {
        return null;
    }

    String getColScopeTable(int i) {
        return null;
    }

    Integer getColSize(int i) {
        Column column = this.table.getColumn(i);
        int type = column.getDIType();
        if (!Types.acceptsPrecisionCreateParam(type)) {
            return null;
        }
        int size = column.getSize();
        if (size > 0) {
            return ValuePool.getInt(size);
        }
        ti.setTypeCode(type);
        return ti.getPrecision();
    }

    Integer getColSqlDataType(int i) {
        ti.setTypeCode(this.table.getColumn(i).getDIType());
        return ti.getSqlDataType();
    }

    Integer getColSqlDateTimeSub(int i) {
        ti.setTypeCode(this.table.getColumn(i).getDIType());
        return ti.getSqlDateTimeSub();
    }

    String getDataSource() {
        return this.table.getDataSource();
    }

    String getHsqlType() {
        switch (this.table.getTableType()) {
            case 0: 
            case 2: 
            case 3: {
                return "MEMORY";
            }
            case 4: {
                return "CACHED";
            }
            case 5: 
            case 6: {
                return "TEXT";
            }
        }
        return null;
    }

    Integer getIndexCardinality(int i) {
        return null;
    }

    String getIndexColDirection(int i, int columnPosition) {
        return "A";
    }

    int[] getIndexColumns(int i) {
        return this.table.getIndex(i).getColumns();
    }

    String getIndexName(int i) {
        return this.table.getIndex((int)i).getName().name;
    }

    Integer getIndexRowCardinality(int i) {
        return null;
    }

    Integer getIndexType(int i) {
        return ValuePool.getInt(3);
    }

    int getIndexVisibleColumns(int i) {
        return this.table.getIndex(i).getVisibleColumns();
    }

    String getName() {
        return this.table.getName().name;
    }

    Long getNextIdentity() {
        if (this.table.identityColumn < 0) {
            return null;
        }
        return ValuePool.getLong(this.table.identitySequence.peek());
    }

    String getRemark() {
        return this.table.getTableType() == 0 ? BundleHandler.getString(this.hnd_table_remarks, this.getName()) : null;
    }

    String getStandardType() {
        switch (this.table.getTableType()) {
            case 7: {
                return "VIEW";
            }
            case 2: 
            case 5: {
                return "GLOBAL TEMPORARY";
            }
            case 0: {
                return "SYSTEM TABLE";
            }
        }
        return "TABLE";
    }

    Table getTable() {
        return this.table;
    }

    Boolean isDataSourceDescending() {
        return ValuePool.getBoolean(this.table.isDescDataSource());
    }

    Boolean isIndexNonUnique(int i) {
        return ValuePool.getBoolean(!this.table.getIndex(i).isUnique());
    }

    Boolean isReadOnly() {
        return ValuePool.getBoolean(this.table.isDataReadOnly());
    }

    void setTable(Table table) {
        this.table = table;
    }
}

