/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.OneToOneType;

public class SpecialOneToOneType
extends OneToOneType {
    public SpecialOneToOneType(String referencedEntityName, ForeignKeyDirection foreignKeyType, String uniqueKeyPropertyName, boolean lazy, boolean unwrapProxy, String entityName, String propertyName) {
        super(referencedEntityName, foreignKeyType, uniqueKeyPropertyName, lazy, unwrapProxy, true, entityName, propertyName);
    }

    @Override
    public int getColumnSpan(Mapping mapping) throws MappingException {
        return super.getIdentifierOrUniqueKeyType(mapping).getColumnSpan(mapping);
    }

    @Override
    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return super.getIdentifierOrUniqueKeyType(mapping).sqlTypes(mapping);
    }

    @Override
    public boolean useLHSPrimaryKey() {
        return false;
    }

    @Override
    public Object hydrate(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return super.getIdentifierOrUniqueKeyType(session.getFactory()).nullSafeGet(rs, names, session, owner);
    }

    @Override
    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (this.isNotEmbedded(session)) {
            return this.getIdentifierType(session).disassemble(value, session, owner);
        }
        if (value == null) {
            return null;
        }
        Serializable id = ForeignKeys.getEntityIdentifierIfNotUnsaved(this.getAssociatedEntityName(), value, session);
        if (id == null) {
            throw new AssertionFailure("cannot cache a reference to an object with a null id: " + this.getAssociatedEntityName());
        }
        return this.getIdentifierType(session).disassemble(id, session, owner);
    }

    @Override
    public Object assemble(Serializable oid, SessionImplementor session, Object owner) throws HibernateException {
        Serializable id = (Serializable)this.getIdentifierType(session).assemble(oid, session, null);
        if (this.isNotEmbedded(session)) {
            return id;
        }
        if (id == null) {
            return null;
        }
        return this.resolveIdentifier(id, session);
    }
}

