/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.type.ImmutableType;
import org.hibernate.type.NullableType;

public class AdaptedImmutableType
extends ImmutableType {
    private final NullableType mutableType;

    public AdaptedImmutableType(NullableType mutableType) {
        this.mutableType = mutableType;
    }

    @Override
    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        return this.mutableType.get(rs, name);
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        this.mutableType.set(st, value, index);
    }

    @Override
    public int sqlType() {
        return this.mutableType.sqlType();
    }

    @Override
    public String toString(Object value) throws HibernateException {
        return this.mutableType.toString(value);
    }

    @Override
    public Object fromStringValue(String xml) throws HibernateException {
        return this.mutableType.fromStringValue(xml);
    }

    @Override
    public Class getReturnedClass() {
        return this.mutableType.getReturnedClass();
    }

    @Override
    public String getName() {
        return "imm_" + this.mutableType.getName();
    }

    @Override
    public boolean isEqual(Object x, Object y) {
        return this.mutableType.isEqual(x, y);
    }

    @Override
    public int getHashCode(Object x, EntityMode entityMode) {
        return this.mutableType.getHashCode(x, entityMode);
    }

    @Override
    public int compare(Object x, Object y, EntityMode entityMode) {
        return this.mutableType.compare(x, y, entityMode);
    }
}

