/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.JoinWalker;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.EntityType;

public abstract class OuterJoinLoader
extends BasicLoader {
    protected Loadable[] persisters;
    protected CollectionPersister[] collectionPersisters;
    protected int[] collectionOwners;
    protected String[] aliases;
    protected LockMode[] lockModeArray;
    protected int[] owners;
    protected EntityType[] ownerAssociationTypes;
    protected String sql;
    protected String[] suffixes;
    protected String[] collectionSuffixes;
    private Map enabledFilters;

    protected final Dialect getDialect() {
        return this.getFactory().getDialect();
    }

    public OuterJoinLoader(SessionFactoryImplementor factory, Map enabledFilters) {
        super(factory);
        this.enabledFilters = enabledFilters;
    }

    @Override
    protected String[] getSuffixes() {
        return this.suffixes;
    }

    @Override
    protected String[] getCollectionSuffixes() {
        return this.collectionSuffixes;
    }

    @Override
    protected final String getSQLString() {
        return this.sql;
    }

    @Override
    protected final Loadable[] getEntityPersisters() {
        return this.persisters;
    }

    @Override
    protected int[] getOwners() {
        return this.owners;
    }

    @Override
    protected EntityType[] getOwnerAssociationTypes() {
        return this.ownerAssociationTypes;
    }

    @Override
    protected LockMode[] getLockModes(Map lockModes) {
        return this.lockModeArray;
    }

    public Map getEnabledFilters() {
        return this.enabledFilters;
    }

    @Override
    protected final String[] getAliases() {
        return this.aliases;
    }

    @Override
    protected final CollectionPersister[] getCollectionPersisters() {
        return this.collectionPersisters;
    }

    @Override
    protected final int[] getCollectionOwners() {
        return this.collectionOwners;
    }

    protected void initFromWalker(JoinWalker walker) {
        this.persisters = walker.getPersisters();
        this.collectionPersisters = walker.getCollectionPersisters();
        this.ownerAssociationTypes = walker.getOwnerAssociationTypes();
        this.lockModeArray = walker.getLockModeArray();
        this.suffixes = walker.getSuffixes();
        this.collectionSuffixes = walker.getCollectionSuffixes();
        this.owners = walker.getOwners();
        this.collectionOwners = walker.getCollectionOwners();
        this.sql = walker.getSQLString();
        this.aliases = walker.getAliases();
    }
}

