/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.resolver;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.BasicSQLExceptionConverter;
import org.hibernate.dialect.resolver.DialectResolver;
import org.hibernate.exception.JDBCConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDialectResolver
implements DialectResolver {
    private static final Logger log = LoggerFactory.getLogger(AbstractDialectResolver.class);

    @Override
    public final Dialect resolveDialect(DatabaseMetaData metaData) {
        try {
            return this.resolveDialectInternal(metaData);
        }
        catch (SQLException sqlException) {
            JDBCException jdbcException = BasicSQLExceptionConverter.INSTANCE.convert(sqlException);
            if (jdbcException instanceof JDBCConnectionException) {
                throw jdbcException;
            }
            log.warn("Unable to query java.sql.DatabaseMetaData : " + sqlException.getMessage());
            return null;
        }
        catch (Throwable t) {
            log.warn("Error executing resolver [" + this + "] : " + t.getMessage());
            return null;
        }
    }

    protected abstract Dialect resolveDialectInternal(DatabaseMetaData var1) throws SQLException;
}

