/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.TypedValue;
import org.hibernate.util.StringHelper;

public class PropertyExpression
implements Criterion {
    private final String propertyName;
    private final String otherPropertyName;
    private final String op;
    private static final TypedValue[] NO_TYPED_VALUES = new TypedValue[0];

    protected PropertyExpression(String propertyName, String otherPropertyName, String op) {
        this.propertyName = propertyName;
        this.otherPropertyName = otherPropertyName;
        this.op = op;
    }

    @Override
    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String[] xcols = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
        String[] ycols = criteriaQuery.getColumnsUsingProjection(criteria, this.otherPropertyName);
        String result = StringHelper.join(" and ", StringHelper.add(xcols, this.getOp(), ycols));
        if (xcols.length > 1) {
            result = '(' + result + ')';
        }
        return result;
    }

    @Override
    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return NO_TYPED_VALUES;
    }

    public String toString() {
        return this.propertyName + this.getOp() + this.otherPropertyName;
    }

    public String getOp() {
        return this.op;
    }
}

