/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.QuerySecondPass;
import org.hibernate.cfg.ResultSetMappingBinder;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedSQLQuerySecondPass
extends ResultSetMappingBinder
implements QuerySecondPass {
    private static Logger log = LoggerFactory.getLogger(NamedSQLQuerySecondPass.class);
    private Element queryElem;
    private String path;
    private Mappings mappings;

    public NamedSQLQuerySecondPass(Element queryElem, String path, Mappings mappings) {
        this.queryElem = queryElem;
        this.path = path;
        this.mappings = mappings;
    }

    @Override
    public void doSecondPass(Map persistentClasses) throws MappingException {
        NamedSQLQueryDefinition namedQuery;
        String resultSetRef;
        String queryName = this.queryElem.attribute("name").getValue();
        if (this.path != null) {
            queryName = this.path + '.' + queryName;
        }
        boolean cacheable = "true".equals(this.queryElem.attributeValue("cacheable"));
        String region = this.queryElem.attributeValue("cache-region");
        Attribute tAtt = this.queryElem.attribute("timeout");
        Integer timeout = tAtt == null ? null : new Integer(tAtt.getValue());
        Attribute fsAtt = this.queryElem.attribute("fetch-size");
        Integer fetchSize = fsAtt == null ? null : new Integer(fsAtt.getValue());
        Attribute roAttr = this.queryElem.attribute("read-only");
        boolean readOnly = roAttr != null && "true".equals(roAttr.getValue());
        Attribute cacheModeAtt = this.queryElem.attribute("cache-mode");
        String cacheMode = cacheModeAtt == null ? null : cacheModeAtt.getValue();
        Attribute cmAtt = this.queryElem.attribute("comment");
        String comment = cmAtt == null ? null : cmAtt.getValue();
        ArrayList<String> synchronizedTables = new ArrayList<String>();
        Iterator tables = this.queryElem.elementIterator("synchronize");
        while (tables.hasNext()) {
            synchronizedTables.add(((Element)tables.next()).attributeValue("table"));
        }
        boolean callable = "true".equals(this.queryElem.attributeValue("callable"));
        Attribute ref = this.queryElem.attribute("resultset-ref");
        String string = resultSetRef = ref == null ? null : ref.getValue();
        if (StringHelper.isNotEmpty(resultSetRef)) {
            namedQuery = new NamedSQLQueryDefinition(this.queryElem.getText(), resultSetRef, synchronizedTables, cacheable, region, timeout, fetchSize, HbmBinder.getFlushMode(this.queryElem.attributeValue("flush-mode")), HbmBinder.getCacheMode(cacheMode), readOnly, comment, HbmBinder.getParameterTypes(this.queryElem), callable);
        } else {
            ResultSetMappingDefinition definition = NamedSQLQuerySecondPass.buildResultSetMappingDefinition(this.queryElem, this.path, this.mappings);
            namedQuery = new NamedSQLQueryDefinition(this.queryElem.getText(), definition.getQueryReturns(), synchronizedTables, cacheable, region, timeout, fetchSize, HbmBinder.getFlushMode(this.queryElem.attributeValue("flush-mode")), HbmBinder.getCacheMode(cacheMode), readOnly, comment, HbmBinder.getParameterTypes(this.queryElem), callable);
        }
        log.debug("Named SQL query: " + queryName + " -> " + namedQuery.getQueryString());
        this.mappings.addSQLQuery(queryName, namedQuery);
    }
}

