/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Timestamper;

public class HashtableCache
implements Cache {
    private final Map hashtable = new Hashtable();
    private final String regionName;

    public HashtableCache(String regionName) {
        this.regionName = regionName;
    }

    @Override
    public String getRegionName() {
        return this.regionName;
    }

    @Override
    public Object read(Object key) throws CacheException {
        return this.hashtable.get(key);
    }

    @Override
    public Object get(Object key) throws CacheException {
        return this.hashtable.get(key);
    }

    @Override
    public void update(Object key, Object value) throws CacheException {
        this.put(key, value);
    }

    @Override
    public void put(Object key, Object value) throws CacheException {
        this.hashtable.put(key, value);
    }

    @Override
    public void remove(Object key) throws CacheException {
        this.hashtable.remove(key);
    }

    @Override
    public void clear() throws CacheException {
        this.hashtable.clear();
    }

    @Override
    public void destroy() throws CacheException {
    }

    @Override
    public void lock(Object key) throws CacheException {
    }

    @Override
    public void unlock(Object key) throws CacheException {
    }

    @Override
    public long nextTimestamp() {
        return Timestamper.next();
    }

    @Override
    public int getTimeout() {
        return 245760000;
    }

    @Override
    public long getSizeInMemory() {
        return -1L;
    }

    @Override
    public long getElementCountInMemory() {
        return this.hashtable.size();
    }

    @Override
    public long getElementCountOnDisk() {
        return 0L;
    }

    @Override
    public Map toMap() {
        return Collections.unmodifiableMap(this.hashtable);
    }

    public String toString() {
        return "HashtableCache(" + this.regionName + ')';
    }
}

