/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.injection;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jboss.maven.plugins.injection.process.InjectionDescriptor;
import org.jboss.maven.plugins.injection.process.InjectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInjectionMojo
extends AbstractMojo {
    protected MavenProject project;

    protected void prepare() throws MojoExecutionException {
    }

    protected abstract List<InjectionDescriptor> getInjectionDescriptors() throws MojoExecutionException;

    protected void finishUp() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.prepare();
        for (InjectionDescriptor descriptor : this.getInjectionDescriptors()) {
            String injectionValue = descriptor.getValue();
            for (InjectionTarget target : descriptor.getTargets()) {
                target.inject(injectionValue);
            }
        }
        this.finishUp();
    }

    protected final String resolveExpression(String expression) {
        return expression;
    }

    protected final ClassLoader buildProjectCompileClassLoader() throws MojoExecutionException {
        ArrayList<URL> classPathUrls = new ArrayList<URL>();
        for (String path : this.projectCompileClasspathElements()) {
            try {
                this.getLog().info((CharSequence)("Adding project compile classpath element : " + path));
                classPathUrls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Unable to build path URL [" + path + "]");
            }
        }
        return new URLClassLoader(classPathUrls.toArray(new URL[classPathUrls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected final List<String> projectCompileClasspathElements() throws MojoExecutionException {
        try {
            return this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Call to Project#getCompileClasspathElements required dependency resolution");
        }
    }
}

