/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHArguments;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Name;
import bsh.NameSpace;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.UtilEvalError;
import java.lang.reflect.InvocationTargetException;

class BSHMethodInvocation
extends SimpleNode {
    BSHMethodInvocation(int n) {
        super(n);
    }

    @Override
    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        NameSpace nameSpace = callStack.top();
        Name name = ((BSHAmbiguousName)this.jjtGetChild(0)).getName(nameSpace);
        Object[] objectArray = ((BSHArguments)this.jjtGetChild(1)).getArguments(callStack, interpreter);
        try {
            return name.invokeMethod(interpreter, objectArray, callStack, this);
        }
        catch (ReflectError reflectError) {
            throw new EvalError("Error in method invocation: " + reflectError.getMessage(), this, callStack);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "Method Invocation " + name;
            Throwable throwable = invocationTargetException.getTargetException();
            boolean bl = true;
            if (throwable instanceof EvalError) {
                bl = throwable instanceof TargetError ? ((TargetError)throwable).inNativeCode() : false;
            }
            throw new TargetError(string, throwable, this, callStack, bl);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
    }
}

