/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHBlock;
import bsh.BSHFormalParameters;
import bsh.BSHReturnType;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Node;
import bsh.Primitive;
import bsh.SimpleNode;
import bsh.UtilEvalError;

class BSHMethodDeclaration
extends SimpleNode {
    String name;
    BSHFormalParameters params;
    BSHBlock block;
    Object returnType;
    Modifiers modifiers;
    int numThrows = 0;

    BSHMethodDeclaration(int n) {
        super(n);
    }

    @Override
    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        if (this.block == null) {
            this.evalNodes(callStack, interpreter);
        }
        NameSpace nameSpace = callStack.top();
        BshMethod bshMethod = new BshMethod(this, nameSpace, this.modifiers);
        try {
            nameSpace.setMethod(this.name, bshMethod);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
        return Primitive.VOID;
    }

    private void evalNodes(CallStack callStack, Interpreter interpreter) throws EvalError {
        int n;
        Node node = this.jjtGetChild(0);
        int n2 = 1;
        if (node instanceof BSHReturnType) {
            this.returnType = ((BSHReturnType)node).getReturnType(callStack, interpreter);
            this.params = (BSHFormalParameters)this.jjtGetChild(1);
            this.block = (BSHBlock)this.jjtGetChild(2 + this.numThrows);
            ++n2;
        } else {
            this.params = (BSHFormalParameters)this.jjtGetChild(0);
            this.block = (BSHBlock)this.jjtGetChild(1 + this.numThrows);
        }
        for (n = n2; n < this.numThrows + n2; ++n) {
            ((BSHAmbiguousName)this.jjtGetChild(n)).toClass(callStack, interpreter);
        }
        this.params.eval(callStack, interpreter);
        if (interpreter.getStrictJava()) {
            for (n = 0; n < this.params.argTypes.length; ++n) {
                if (this.params.argTypes[n] != null) continue;
                throw new EvalError("(Strict Java Mode) Undeclared argument type, parameter: " + this.params.argNames[n] + " in method: " + this.name, this, null);
            }
            if (this.returnType == null) {
                throw new EvalError("(Strict Java Mode) Undeclared return type for method: " + this.name, this, null);
            }
        }
    }

    @Override
    public String toString() {
        return "MethodDeclaration: " + this.name;
    }
}

