/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHArguments;
import bsh.BSHArrayDimensions;
import bsh.BSHBlock;
import bsh.BSHPrimitiveType;
import bsh.CallStack;
import bsh.ClassIdentifier;
import bsh.ClassNameSpace;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.This;
import bsh.UtilEvalError;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

class BSHAllocationExpression
extends SimpleNode {
    BSHAllocationExpression(int n) {
        super(n);
    }

    @Override
    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
        SimpleNode simpleNode2 = (SimpleNode)this.jjtGetChild(1);
        if (simpleNode instanceof BSHAmbiguousName) {
            BSHAmbiguousName bSHAmbiguousName = (BSHAmbiguousName)simpleNode;
            if (simpleNode2 instanceof BSHArguments) {
                return this.objectAllocation(bSHAmbiguousName, (BSHArguments)simpleNode2, callStack, interpreter);
            }
            return this.objectArrayAllocation(bSHAmbiguousName, (BSHArrayDimensions)simpleNode2, callStack, interpreter);
        }
        return this.primitiveArrayAllocation((BSHPrimitiveType)simpleNode, (BSHArrayDimensions)simpleNode2, callStack, interpreter);
    }

    private Object objectAllocation(BSHAmbiguousName bSHAmbiguousName, BSHArguments bSHArguments, CallStack callStack, Interpreter interpreter) throws EvalError {
        boolean bl;
        NameSpace nameSpace = callStack.top();
        Object[] objectArray = bSHArguments.getArguments(callStack, interpreter);
        if (objectArray == null) {
            throw new EvalError("Null args in new.", this, callStack);
        }
        Object object = bSHAmbiguousName.toObject(callStack, interpreter, false);
        if (ClassNameSpace.isScriptedClass(object)) {
            ClassNameSpace classNameSpace = (ClassNameSpace)((This)object).getNameSpace();
            return classNameSpace.constructClassInstance(objectArray, interpreter, callStack, this);
        }
        object = bSHAmbiguousName.toObject(callStack, interpreter, true);
        Class clazz = null;
        if (!(object instanceof ClassIdentifier)) {
            throw new EvalError("Can't new: " + object, this, callStack);
        }
        clazz = ((ClassIdentifier)object).getTargetClass();
        boolean bl2 = bl = this.jjtGetNumChildren() > 2;
        if (bl) {
            BSHBlock bSHBlock = (BSHBlock)this.jjtGetChild(2);
            return this.constructWithBody(clazz, objectArray, bSHBlock, callStack, interpreter);
        }
        return this.constructObject(clazz, objectArray, callStack);
    }

    private Object constructObject(Class clazz, Object[] objectArray, CallStack callStack) throws EvalError {
        try {
            return Reflect.constructObject(clazz, objectArray);
        }
        catch (ReflectError reflectError) {
            throw new EvalError("Constructor error: " + reflectError.getMessage(), this, callStack);
        }
        catch (InvocationTargetException invocationTargetException) {
            Interpreter.debug("The constructor threw an exception:\n\t" + invocationTargetException.getTargetException());
            throw new TargetError("Object constructor", invocationTargetException.getTargetException(), this, callStack, true);
        }
    }

    private Object constructWithBody(Class clazz, Object[] objectArray, BSHBlock bSHBlock, CallStack callStack, Interpreter interpreter) throws EvalError {
        if (!clazz.isInterface()) {
            throw new EvalError("BeanShell cannot extend class types: " + clazz, this, callStack);
        }
        NameSpace nameSpace = callStack.top();
        NameSpace nameSpace2 = new NameSpace(nameSpace, "anonymous block object");
        callStack.push(nameSpace2);
        bSHBlock.eval(callStack, interpreter, true);
        callStack.pop();
        try {
            return nameSpace2.getThis(interpreter).getInterface(clazz);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
    }

    private Object objectArrayAllocation(BSHAmbiguousName bSHAmbiguousName, BSHArrayDimensions bSHArrayDimensions, CallStack callStack, Interpreter interpreter) throws EvalError {
        NameSpace nameSpace = callStack.top();
        Class clazz = bSHAmbiguousName.toClass(callStack, interpreter);
        if (clazz == null) {
            throw new EvalError("Class " + bSHAmbiguousName.getName(nameSpace) + " not found.", this, callStack);
        }
        return this.arrayAllocation(bSHArrayDimensions, clazz, callStack, interpreter);
    }

    private Object primitiveArrayAllocation(BSHPrimitiveType bSHPrimitiveType, BSHArrayDimensions bSHArrayDimensions, CallStack callStack, Interpreter interpreter) throws EvalError {
        Class clazz = bSHPrimitiveType.getType();
        return this.arrayAllocation(bSHArrayDimensions, clazz, callStack, interpreter);
    }

    private Object arrayAllocation(BSHArrayDimensions bSHArrayDimensions, Class clazz, CallStack callStack, Interpreter interpreter) throws EvalError {
        Object object = bSHArrayDimensions.eval(clazz, callStack, interpreter);
        if (object != Primitive.VOID) {
            return object;
        }
        return this.arrayNewInstance(clazz, bSHArrayDimensions, callStack);
    }

    private Object arrayNewInstance(Class clazz, BSHArrayDimensions bSHArrayDimensions, CallStack callStack) throws EvalError {
        if (bSHArrayDimensions.numUndefinedDims > 0) {
            Object object = Array.newInstance(clazz, new int[bSHArrayDimensions.numUndefinedDims]);
            clazz = object.getClass();
        }
        try {
            return Array.newInstance(clazz, bSHArrayDimensions.definedDimensions);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new TargetError(negativeArraySizeException, (SimpleNode)this, callStack);
        }
        catch (Exception exception) {
            throw new EvalError("Can't construct primitive array: " + exception.getMessage(), this, callStack);
        }
    }
}

