/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TimeZone;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.ImmutableType;
import org.hibernate.type.LiteralType;

public class TimeZoneType
extends ImmutableType
implements LiteralType {
    @Override
    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        String id = (String)Hibernate.STRING.nullSafeGet(rs, name);
        return id == null ? null : TimeZone.getTimeZone(id);
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        Hibernate.STRING.set(st, ((TimeZone)value).getID(), index);
    }

    @Override
    public int sqlType() {
        return Hibernate.STRING.sqlType();
    }

    @Override
    public String toString(Object value) throws HibernateException {
        return ((TimeZone)value).getID();
    }

    @Override
    public int compare(Object x, Object y, EntityMode entityMode) {
        return ((TimeZone)x).getID().compareTo(((TimeZone)y).getID());
    }

    @Override
    public Object fromStringValue(String xml) throws HibernateException {
        return TimeZone.getTimeZone(xml);
    }

    @Override
    public Class getReturnedClass() {
        return TimeZone.class;
    }

    @Override
    public String getName() {
        return "timezone";
    }

    @Override
    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return ((LiteralType)((Object)Hibernate.STRING)).objectToSQLString(((TimeZone)value).getID(), dialect);
    }
}

