/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.IdentifierType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.MutableType;

public class DateType
extends MutableType
implements IdentifierType,
LiteralType {
    private static final String DATE_FORMAT = "dd MMMM yyyy";

    @Override
    public Object get(ResultSet rs, String name) throws SQLException {
        return rs.getDate(name);
    }

    @Override
    public Class getReturnedClass() {
        return Date.class;
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        java.sql.Date sqlDate = value instanceof java.sql.Date ? (java.sql.Date)value : new java.sql.Date(((Date)value).getTime());
        st.setDate(index, sqlDate);
    }

    @Override
    public int sqlType() {
        return 91;
    }

    @Override
    public boolean isEqual(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Date xdate = (Date)x;
        Date ydate = (Date)y;
        if (xdate.getTime() == ydate.getTime()) {
            return true;
        }
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(xdate);
        calendar2.setTime(ydate);
        return Hibernate.CALENDAR_DATE.isEqual(calendar1, calendar2);
    }

    @Override
    public int getHashCode(Object x, EntityMode entityMode) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)x);
        return Hibernate.CALENDAR_DATE.getHashCode(calendar, entityMode);
    }

    @Override
    public String getName() {
        return "date";
    }

    @Override
    public String toString(Object val) {
        return new SimpleDateFormat(DATE_FORMAT).format((Date)val);
    }

    @Override
    public Object deepCopyNotNull(Object value) {
        return new java.sql.Date(((Date)value).getTime());
    }

    @Override
    public Object stringToObject(String xml) throws Exception {
        return DateFormat.getDateInstance().parse(xml);
    }

    @Override
    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return '\'' + new java.sql.Date(((Date)value).getTime()).toString() + '\'';
    }

    @Override
    public Object fromStringValue(String xml) throws HibernateException {
        try {
            return new SimpleDateFormat(DATE_FORMAT).parse(xml);
        }
        catch (ParseException pe) {
            throw new HibernateException("could not parse XML", pe);
        }
    }
}

