/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.collections.AST;
import java.util.Map;
import org.hibernate.hql.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.tree.RestrictableStatement;
import org.hibernate.hql.ast.tree.SqlFragment;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.hql.ast.util.JoinProcessor;
import org.hibernate.param.CollectionFilterKeyParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntheticAndFactory
implements HqlSqlTokenTypes {
    private static final Logger log = LoggerFactory.getLogger(SyntheticAndFactory.class);
    private HqlSqlWalker hqlSqlWalker;
    private AST thetaJoins;
    private AST filters;

    public SyntheticAndFactory(HqlSqlWalker hqlSqlWalker) {
        this.hqlSqlWalker = hqlSqlWalker;
    }

    private Node create(int tokenType, String text) {
        return (Node)ASTUtil.create(this.hqlSqlWalker.getASTFactory(), tokenType, text);
    }

    public void addWhereFragment(JoinFragment joinFragment, String whereFragment, QueryNode query, FromElement fromElement, HqlSqlWalker hqlSqlWalker) {
        AST where;
        if (whereFragment == null) {
            return;
        }
        if (!fromElement.useWhereFragment() && !joinFragment.hasThetaJoins()) {
            return;
        }
        if (StringHelper.isEmpty(whereFragment = whereFragment.trim())) {
            return;
        }
        if (whereFragment.startsWith("and")) {
            whereFragment = whereFragment.substring(4);
        }
        log.debug("Using unprocessed WHERE-fragment [{}]", (Object)whereFragment);
        SqlFragment fragment = (SqlFragment)this.create(136, whereFragment);
        fragment.setJoinFragment(joinFragment);
        fragment.setFromElement(fromElement);
        if (fromElement.getIndexCollectionSelectorParamSpec() != null) {
            fragment.addEmbeddedParameter(fromElement.getIndexCollectionSelectorParamSpec());
            fromElement.setIndexCollectionSelectorParamSpec(null);
        }
        if (hqlSqlWalker.isFilter() && whereFragment.indexOf(63) >= 0) {
            Type collectionFilterKeyType = hqlSqlWalker.getSessionFactoryHelper().requireQueryableCollection(hqlSqlWalker.getCollectionFilterRole()).getKeyType();
            CollectionFilterKeyParameterSpecification paramSpec = new CollectionFilterKeyParameterSpecification(hqlSqlWalker.getCollectionFilterRole(), collectionFilterKeyType, 0);
            fragment.addEmbeddedParameter(paramSpec);
        }
        JoinProcessor.processDynamicFilterParameters(whereFragment, fragment, hqlSqlWalker);
        log.debug("Using processed WHERE-fragment [{}]", (Object)fragment.getText());
        if (fragment.getFromElement().isFilter() || fragment.hasFilterCondition()) {
            if (this.filters == null) {
                where = query.getWhereClause();
                this.filters = this.create(140, "{filter conditions}");
                ASTUtil.insertChild(where, this.filters);
            }
            this.filters.addChild((AST)fragment);
        } else {
            if (this.thetaJoins == null) {
                where = query.getWhereClause();
                this.thetaJoins = this.create(139, "{theta joins}");
                if (this.filters == null) {
                    ASTUtil.insertChild(where, this.thetaJoins);
                } else {
                    ASTUtil.insertSibling(this.thetaJoins, this.filters);
                }
            }
            this.thetaJoins.addChild((AST)fragment);
        }
    }

    public void addDiscriminatorWhereFragment(RestrictableStatement statement, Queryable persister, Map enabledFilters, String alias) {
        String whereFragment = persister.filterFragment(alias, enabledFilters).trim();
        if ("".equals(whereFragment)) {
            return;
        }
        if (whereFragment.startsWith("and")) {
            whereFragment = whereFragment.substring(4);
        }
        whereFragment = StringHelper.replace(whereFragment, persister.generateFilterConditionAlias(alias) + ".", "");
        SqlFragment discrimNode = (SqlFragment)this.create(136, whereFragment);
        JoinProcessor.processDynamicFilterParameters(whereFragment, discrimNode, this.hqlSqlWalker);
        if (statement.getWhereClause().getNumberOfChildren() == 0) {
            statement.getWhereClause().setFirstChild((AST)discrimNode);
        } else {
            Node and = this.create(6, "{and}");
            AST currentFirstChild = statement.getWhereClause().getFirstChild();
            and.setFirstChild((AST)discrimNode);
            and.addChild(currentFirstChild);
            statement.getWhereClause().setFirstChild((AST)and);
        }
    }
}

