/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.lang.reflect.Modifier;
import org.hibernate.bytecode.BytecodeProvider;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.ProxyFactoryFactory;
import org.hibernate.bytecode.ReflectionOptimizer;
import org.hibernate.bytecode.javassist.AccessOptimizerAdapter;
import org.hibernate.bytecode.javassist.BulkAccessor;
import org.hibernate.bytecode.javassist.BulkAccessorException;
import org.hibernate.bytecode.javassist.FastClass;
import org.hibernate.bytecode.javassist.InstantiationOptimizerAdapter;
import org.hibernate.bytecode.javassist.JavassistClassTransformer;
import org.hibernate.bytecode.javassist.ProxyFactoryFactoryImpl;
import org.hibernate.bytecode.javassist.ReflectionOptimizerImpl;
import org.hibernate.bytecode.util.ClassFilter;
import org.hibernate.bytecode.util.FieldFilter;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytecodeProviderImpl
implements BytecodeProvider {
    private static final Logger log = LoggerFactory.getLogger(BytecodeProviderImpl.class);

    @Override
    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new ProxyFactoryFactoryImpl();
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer(Class clazz, String[] getterNames, String[] setterNames, Class[] types) {
        BulkAccessor bulkAccessor;
        FastClass fastClass;
        try {
            fastClass = FastClass.create(clazz);
            bulkAccessor = BulkAccessor.create(clazz, getterNames, setterNames, types);
            if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                if (fastClass == null) {
                    bulkAccessor = null;
                } else {
                    Object instance = fastClass.newInstance();
                    bulkAccessor.setPropertyValues(instance, bulkAccessor.getPropertyValues(instance));
                }
            }
        }
        catch (Throwable t) {
            int index;
            fastClass = null;
            bulkAccessor = null;
            String message = "reflection optimizer disabled for: " + clazz.getName() + " [" + StringHelper.unqualify(t.getClass().getName()) + ": " + t.getMessage();
            if (t instanceof BulkAccessorException && (index = ((BulkAccessorException)t).getIndex()) >= 0) {
                message = message + " (property " + setterNames[index] + ")";
            }
            log.debug(message);
        }
        if (fastClass != null && bulkAccessor != null) {
            return new ReflectionOptimizerImpl(new InstantiationOptimizerAdapter(fastClass), new AccessOptimizerAdapter(bulkAccessor, clazz));
        }
        return null;
    }

    @Override
    public ClassTransformer getTransformer(ClassFilter classFilter, FieldFilter fieldFilter) {
        return new JavassistClassTransformer(classFilter, fieldFilter);
    }
}

