/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.javac;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.javac.IsolatedClassLoader;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JavacCompiler
extends AbstractCompiler {
    private static final String WARNING_PREFIX = "warning: ";

    public JavacCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public List compile(CompilerConfiguration config) throws CompilerException {
        List messages;
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = JavacCompiler.getSourceFiles((CompilerConfiguration)config)).length == 0) {
            return Collections.EMPTY_LIST;
        }
        System.out.println("Compiling " + sourceFiles.length + " " + "source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        String[] args = JavacCompiler.buildCompilerArguments(config, sourceFiles);
        if (config.isFork()) {
            String executable = config.getExecutable();
            if (StringUtils.isEmpty((String)executable)) {
                executable = "javac";
            }
            messages = this.compileOutOfProcess(config.getWorkingDirectory(), executable, args);
        } else {
            messages = this.compileInProcess(args);
        }
        return messages;
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return JavacCompiler.buildCompilerArguments(config, JavacCompiler.getSourceFiles((CompilerConfiguration)config));
    }

    public static String[] buildCompilerArguments(CompilerConfiguration config, String[] sourceFiles) {
        List sourceLocations;
        ArrayList<String> args = new ArrayList<String>();
        File destinationDir = new File(config.getOutputLocation());
        args.add("-d");
        args.add(destinationDir.getAbsolutePath());
        List classpathEntries = config.getClasspathEntries();
        if (classpathEntries != null && !classpathEntries.isEmpty()) {
            args.add("-classpath");
            args.add(JavacCompiler.getPathString((List)classpathEntries));
        }
        if ((sourceLocations = config.getSourceLocations()) != null && !sourceLocations.isEmpty() && sourceFiles.length == 0) {
            args.add("-sourcepath");
            args.add(JavacCompiler.getPathString((List)sourceLocations));
        }
        for (int i = 0; i < sourceFiles.length; ++i) {
            args.add(sourceFiles[i]);
        }
        if (config.isOptimize()) {
            args.add("-O");
        }
        if (config.isDebug()) {
            args.add("-g");
        }
        if (config.isVerbose()) {
            args.add("-verbose");
        }
        if (config.isShowDeprecation()) {
            args.add("-deprecation");
            config.setShowWarnings(true);
        }
        if (!StringUtils.isEmpty((String)config.getMaxmem())) {
            args.add("-J-Xmx" + config.getMaxmem());
        }
        if (!StringUtils.isEmpty((String)config.getMeminitial())) {
            args.add("-J-Xms" + config.getMeminitial());
        }
        if (!config.isShowWarnings()) {
            args.add("-nowarn");
        }
        if (StringUtils.isEmpty((String)config.getTargetVersion())) {
            args.add("-target");
            args.add("1.1");
        } else {
            args.add("-target");
            args.add(config.getTargetVersion());
        }
        if (!JavacCompiler.suppressSource(config) && StringUtils.isEmpty((String)config.getSourceVersion())) {
            args.add("-source");
            args.add("1.3");
        } else if (!JavacCompiler.suppressSource(config)) {
            args.add("-source");
            args.add(config.getSourceVersion());
        }
        if (!JavacCompiler.suppressEncoding(config) && !StringUtils.isEmpty((String)config.getSourceEncoding())) {
            args.add("-encoding");
            args.add(config.getSourceEncoding());
        }
        for (Map.Entry entry : config.getCustomCompilerArguments().entrySet()) {
            String key = (String)entry.getKey();
            if (StringUtils.isEmpty((String)key)) continue;
            args.add(key);
            String value = (String)entry.getValue();
            if (StringUtils.isEmpty((String)value)) continue;
            args.add(value);
        }
        return args.toArray(new String[args.size()]);
    }

    private static boolean suppressSource(CompilerConfiguration config) {
        return "1.3".equals(config.getCompilerVersion());
    }

    private static boolean suppressEncoding(CompilerConfiguration config) {
        return "1.3".equals(config.getCompilerVersion());
    }

    List compileOutOfProcess(File workingDirectory, String executable, String[] args) throws CompilerException {
        List messages;
        int returnCode;
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(workingDirectory.getAbsolutePath());
        cli.setExecutable(executable);
        cli.addArguments(args);
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
            messages = JavacCompiler.parseModernStream(new BufferedReader(new StringReader(err.getOutput())));
        }
        catch (CommandLineException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        if (returnCode != 0 && messages.isEmpty()) {
            messages.add(new CompilerError("Failure executing javac,  but could not parse the error:" + EOL + err.getOutput(), true));
        }
        return messages;
    }

    List compileInProcess(String[] args) throws CompilerException {
        List messages;
        Integer ok;
        Class c;
        IsolatedClassLoader cl = new IsolatedClassLoader();
        File toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar");
        if (toolsJar.exists()) {
            try {
                cl.addURL(toolsJar.toURL());
            }
            catch (MalformedURLException e) {
                throw new CompilerException("Could not convert the file reference to tools.jar to a URL, path to tools.jar: '" + toolsJar.getAbsolutePath() + "'.");
            }
        }
        try {
            c = cl.loadClass("com.sun.tools.javac.Main");
        }
        catch (ClassNotFoundException e) {
            String message = "Unable to locate the Javac Compiler in:" + EOL + "  " + toolsJar + EOL + "Please ensure you are using JDK 1.4 or above and" + EOL + "not a JRE (the com.sun.tools.javac.Main class is required)." + EOL + "In most cases you can change the location of your Java" + EOL + "installation by setting the JAVA_HOME environment variable.";
            return Collections.singletonList(new CompilerError(message, true));
        }
        StringWriter out = new StringWriter();
        try {
            Method compile = c.getMethod("compile", String[].class, PrintWriter.class);
            ok = (Integer)compile.invoke(null, args, new PrintWriter(out));
            messages = JavacCompiler.parseModernStream(new BufferedReader(new StringReader(out.toString())));
        }
        catch (NoSuchMethodException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        if (ok != 0 && messages.isEmpty()) {
            messages.add(new CompilerError("Failure executing javac, but could not parse the error:" + EOL + out.toString(), true));
        }
        return messages;
    }

    protected static List parseModernStream(BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        while (true) {
            String line;
            StringBuffer buffer = new StringBuffer();
            do {
                if ((line = input.readLine()) == null) {
                    return errors;
                }
                if (buffer.length() == 0 && line.startsWith("error: ")) {
                    errors.add(new CompilerError(line, true));
                    continue;
                }
                if (buffer.length() == 0 && line.startsWith("Note: ")) continue;
                buffer.append(line);
                buffer.append(EOL);
            } while (!line.endsWith("^"));
            errors.add(JavacCompiler.parseModernError(buffer.toString()));
        }
    }

    public static CompilerError parseModernError(String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        boolean isError = true;
        try {
            int endcolumn;
            String file = tokens.nextToken();
            if (file.length() == 1) {
                file = new StringBuffer(file).append(":").append(tokens.nextToken()).toString();
            }
            int line = Integer.parseInt(tokens.nextToken());
            StringBuffer msgBuffer = new StringBuffer();
            String msg = tokens.nextToken(EOL).substring(2);
            boolean bl = isError = !msg.startsWith(WARNING_PREFIX);
            if (!isError) {
                msg = msg.substring(WARNING_PREFIX.length());
            }
            msgBuffer.append(msg);
            msgBuffer.append(EOL);
            String context = tokens.nextToken(EOL);
            String pointer = tokens.nextToken(EOL);
            if (tokens.hasMoreTokens()) {
                msgBuffer.append(context);
                msgBuffer.append(EOL);
                msgBuffer.append(pointer);
                msgBuffer.append(EOL);
                context = tokens.nextToken(EOL);
                try {
                    pointer = tokens.nextToken(EOL);
                }
                catch (NoSuchElementException e) {
                    pointer = context;
                    context = null;
                }
            }
            String message = msgBuffer.toString();
            int startcolumn = pointer.indexOf("^");
            int n = endcolumn = context == null ? startcolumn : context.indexOf(" ", startcolumn);
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerError(file, isError, line, startcolumn, line, endcolumn, message);
        }
        catch (NoSuchElementException e) {
            return new CompilerError("no more tokens - could not parse error message: " + error, isError);
        }
        catch (NumberFormatException e) {
            return new CompilerError("could not parse error message: " + error, isError);
        }
        catch (Exception e) {
            return new CompilerError("could not parse error message: " + error, isError);
        }
    }
}

