
/*
 * Mesa 3-D graphics library
 * Version:  4.0.1
 *
 * Copyright (C) 1999-2001  Brian Paul   All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


#include "glheader.h"
#include "glapi.h"
#include "glapioffsets.h"
#include "glapitable.h"
#include "glthread.h"
#include <stdarg.h>

static GLboolean WarnFlag = GL_FALSE;

void
_glapi_noop_enable_warnings(GLboolean enable)
{
   WarnFlag = enable;
}

static GLboolean
warn(void)
{
   if (WarnFlag || getenv("MESA_DEBUG") || getenv("LIBGL_DEBUG"))
      return GL_TRUE;
   else
      return GL_FALSE;
}

#if (defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L) || __GNUC__ >= 3
#define STRIP_FIRST(x, ...) (__VA_ARGS__)
#define DUMMY_ARG
#else
#define STRIP_FIRST
#define DUMMY_ARG int dummy,
#endif

static void
noop_warning(DUMMY_ARG const char *fmt, ...)
{
   va_list ap;
   if (warn()) {
      fprintf(stderr, "GL User Error: calling ");
      va_start(ap, fmt);
      vfprintf(stderr, fmt, ap);
      va_end(ap);
      fprintf(stderr, " without a current context\n");
   }
}


#define KEYWORD1 static
#define KEYWORD2
#define NAME(func)  NoOp##func

#define F 0

#define DISPATCH(func, args, msg)			\
   noop_warning STRIP_FIRST msg;

#define RETURN_DISPATCH(func, args, msg)		\
   noop_warning STRIP_FIRST msg;			\
   return 0

#define DISPATCH_TABLE_NAME __glapi_noop_table
#define UNUSED_TABLE_NAME __usused_noop_functions

#define TABLE_ENTRY(name) (void *) NoOp##name

static int NoOpUnused(void)
{
   if (warn()) {
      fprintf(stderr, "GL User Error: calling extension function without a current context\n");
   }
   return 0;
}

extern hidden void *DISPATCH_TABLE_NAME[];

#include "glapitemp.h"
